/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.actor;

import groovy.lang.Closure;
import groovy.time.Duration;
import groovyx.gpars.actor.ActorMessage;
import groovyx.gpars.actor.impl.SequentialProcessingActor;
import java.util.concurrent.TimeUnit;

public abstract class BlockingActor
extends SequentialProcessingActor {
    private static final String THE_ACTOR_HAS_NOT_BEEN_STARTED = "The actor hasn't been started.";
    private static final String THE_ACTOR_HAS_BEEN_STOPPED = "The actor has been stopped.";
    private static final long serialVersionUID = -6232655362494852540L;
    public static final String AN_ACTOR_CAN_ONLY_RECEIVE_ONE_MESSAGE_AT_A_TIME = "An actor can only receive one message at a time";

    private void enhanceReplies(ActorMessage message) {
        this.setSender(message == null ? null : message.getSender());
    }

    protected final Object receiveImpl() throws InterruptedException {
        this.checkStoppedFlags();
        ActorMessage message = this.takeMessage();
        return this.enhanceAndUnwrap(message);
    }

    protected final Object receiveImpl(long timeout, TimeUnit units) throws InterruptedException {
        this.checkStoppedFlags();
        ActorMessage message = this.takeMessage(timeout, units);
        return this.enhanceAndUnwrap(message);
    }

    private Object enhanceAndUnwrap(ActorMessage message) {
        this.enhanceReplies(message);
        if (message == null) {
            return null;
        }
        return message.getPayLoad();
    }

    private void checkStoppedFlags() {
        if (this.stopFlag == 0) {
            throw new IllegalStateException(THE_ACTOR_HAS_NOT_BEEN_STARTED);
        }
        if (this.stopFlag == 12) {
            throw new IllegalStateException(THE_ACTOR_HAS_BEEN_STOPPED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void receive(Closure handler) throws InterruptedException {
        handler.setResolveStrategy(1);
        handler.setDelegate((Object)this);
        int maxNumberOfParameters = handler.getMaximumNumberOfParameters();
        if (maxNumberOfParameters > 1) {
            throw new IllegalArgumentException(AN_ACTOR_CAN_ONLY_RECEIVE_ONE_MESSAGE_AT_A_TIME);
        }
        this.checkStopTerminate();
        ActorMessage message = this.takeMessage();
        this.enhanceReplies(message);
        try {
            if (maxNumberOfParameters == 0) {
                handler.call();
            } else {
                handler.call(message == null ? message : message.getPayLoad());
            }
        }
        finally {
            this.setSender(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void receive(long timeout, TimeUnit timeUnit, Closure handler) throws InterruptedException {
        handler.setResolveStrategy(1);
        handler.setDelegate((Object)this);
        int maxNumberOfParameters = handler.getMaximumNumberOfParameters();
        if (maxNumberOfParameters > 1) {
            throw new IllegalArgumentException(AN_ACTOR_CAN_ONLY_RECEIVE_ONE_MESSAGE_AT_A_TIME);
        }
        long stopTime = timeUnit.toMillis(timeout) + System.currentTimeMillis();
        if (this.stopFlag != 1) {
            throw new IllegalStateException(THE_ACTOR_HAS_NOT_BEEN_STARTED);
        }
        ActorMessage message = this.takeMessage(Math.max(stopTime - System.currentTimeMillis(), 0L), TimeUnit.MILLISECONDS);
        try {
            this.enhanceReplies(message);
            if (maxNumberOfParameters == 0) {
                handler.call();
            } else {
                handler.call(message == null ? message : message.getPayLoad());
            }
        }
        finally {
            this.setSender(null);
        }
    }

    protected final void receive(Duration duration, Closure handler) throws InterruptedException {
        this.receive(duration.toMilliseconds(), TimeUnit.MILLISECONDS, handler);
    }

    protected void handleStart() {
        super.handleStart();
        this.act();
    }
}

