/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.dataflow;

import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.MissingMethodException;
import groovyx.gpars.dataflow.DataflowVariable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.codehaus.groovy.runtime.InvokerInvocationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Dataflows
extends GroovyObjectSupport {
    private static final DataflowVariable<Object> DUMMY = new DataflowVariable();
    private final Object lock = new Object();
    private ConcurrentMap<Object, DataflowVariable<Object>> variables = null;
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int DEFAULT_CONCURRENCY_LEVEL = 16;

    public Dataflows(int initialCapacity, float loadFactor, int concurrencyLevel) {
        this.variables = new ConcurrentHashMap<Object, DataflowVariable<Object>>(initialCapacity, loadFactor, concurrencyLevel);
    }

    public Dataflows() {
        this.variables = new ConcurrentHashMap<Object, DataflowVariable<Object>>(16, 0.75f, 16);
    }

    public void setProperty(String property, Object newValue) {
        this.ensureToContainVariable(property).bind(newValue);
    }

    public Object getProperty(String property) {
        try {
            return this.ensureToContainVariable(property).getVal();
        }
        catch (InterruptedException e) {
            throw new InvokerInvocationException((Throwable)e);
        }
    }

    public Object invokeMethod(String name, Object args) {
        DataflowVariable<Object> df = this.ensureToContainVariable(name);
        if (args instanceof Object[] && ((Object[])args).length == 1 && ((Object[])args)[0] instanceof Closure) {
            df.whenBound((Closure)((Object[])args)[0]);
            return this;
        }
        throw new MissingMethodException(name, Dataflows.class, (Object[])args);
    }

    Object getAt(int index) throws InterruptedException {
        return this.ensureToContainVariable(index).getVal();
    }

    void putAt(Object index, Object value) {
        this.ensureToContainVariable(index).bind(value);
    }

    private DataflowVariable<Object> ensureToContainVariable(Object name) {
        DataflowVariable<Object> df = this.variables.putIfAbsent(name, DUMMY);
        if (df == null || df == DUMMY) {
            df = this.putNewUnderLock(name);
        }
        return df;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataflowVariable<Object> putNewUnderLock(Object name) {
        Object object = this.lock;
        synchronized (object) {
            DataflowVariable<Object> df = (DataflowVariable<Object>)this.variables.get(name);
            if (df == null || df == DUMMY) {
                df = new DataflowVariable<Object>();
                this.variables.put(name, df);
            }
            return df;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataflowVariable<Object> remove(Object name) {
        Object object = this.lock;
        synchronized (object) {
            DataflowVariable df = (DataflowVariable)this.variables.remove(name);
            if (df != null) {
                df.bindSafely(null);
            }
            return df;
        }
    }

    public boolean contains(Object name) {
        return this.variables.containsKey(name);
    }

    public Iterator<Map.Entry<Object, DataflowVariable<Object>>> iterator() {
        return this.variables.entrySet().iterator();
    }
}

