/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.dataflow.operator;

import groovy.lang.Closure;
import groovyx.gpars.dataflow.DataflowReadChannel;
import groovyx.gpars.dataflow.DataflowVariable;
import groovyx.gpars.dataflow.operator.DataflowOperator;
import groovyx.gpars.dataflow.operator.DataflowProcessorActor;
import groovyx.gpars.dataflow.operator.StopGently;
import groovyx.gpars.group.PGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class DataflowOperatorActor
extends DataflowProcessorActor {
    private Map values = new HashMap(10);

    DataflowOperatorActor(DataflowOperator owningOperator, PGroup group, List outputs, List inputs, Closure code) {
        super(owningOperator, group, outputs, inputs, code);
    }

    final void afterStart() {
        this.queryInputs(true);
    }

    private void queryInputs(boolean initialRun) {
        for (int i = 0; i < this.inputs.size(); ++i) {
            DataflowReadChannel input = (DataflowReadChannel)this.inputs.get(i);
            if (initialRun || !(input instanceof DataflowVariable)) {
                input.getValAsync(i, this);
                continue;
            }
            try {
                this.values.put(i, input.getVal());
                continue;
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("couldn't read the value of a DataflowVariable inside an operator.", e);
            }
        }
    }

    public final void onMessage(Object message) {
        if (message instanceof StopGently) {
            this.stoppingGently = true;
            return;
        }
        Map msg = (Map)message;
        Object result = msg.get("result");
        Object attachment = msg.get("attachment");
        if (this.checkPoison(result)) {
            return;
        }
        this.values.put(attachment, result);
        if (this.values.size() > this.inputs.size()) {
            throw new IllegalStateException("The DataflowOperatorActor is in an inconsistent state. values.size()=" + this.values.size() + ", inputs.size()=" + this.inputs.size());
        }
        if (this.values.size() == this.inputs.size()) {
            ArrayList arrivedMessages = new ArrayList(this.values.entrySet());
            Collections.sort(arrivedMessages, new Comparator<Map.Entry<Comparable, Object>>(){

                @Override
                public int compare(Map.Entry<Comparable, Object> o1, Map.Entry<Comparable, Object> o2) {
                    return o1.getKey().compareTo(o2.getKey());
                }
            });
            ArrayList arrivedValues = new ArrayList(arrivedMessages.size());
            for (Map.Entry entry : arrivedMessages) {
                arrivedValues.add(entry.getValue());
            }
            this.startTask(arrivedValues);
            this.values = new HashMap(this.values.size());
            if (this.stoppingGently) {
                this.stop();
            }
            if (!this.hasBeenStopped()) {
                this.queryInputs(false);
            }
        }
    }

    void startTask(List results) {
        try {
            this.code.call(results.toArray(new Object[results.size()]));
        }
        catch (Throwable e) {
            this.reportException(e);
        }
    }
}

