/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.dataflow.operator;

import groovy.lang.Closure;
import groovyx.gpars.dataflow.operator.DataflowOperator;
import groovyx.gpars.dataflow.operator.DataflowOperatorActor;
import groovyx.gpars.group.PGroup;
import groovyx.gpars.scheduler.Pool;
import java.util.List;
import java.util.concurrent.Semaphore;

final class ForkingDataflowOperatorActor
extends DataflowOperatorActor {
    private final Semaphore semaphore;
    private final Pool threadPool;

    ForkingDataflowOperatorActor(DataflowOperator owningOperator, PGroup group, List outputs, List inputs, Closure code, int maxForks) {
        super(owningOperator, group, outputs, inputs, code);
        this.semaphore = new Semaphore(maxForks);
        this.threadPool = group.getThreadPool();
    }

    void startTask(final List results) {
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Cannot obtain the semaphore to fork operator's body.", e);
        }
        this.threadPool.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    ForkingDataflowOperatorActor.super.startTask(results);
                }
                finally {
                    ForkingDataflowOperatorActor.this.semaphore.release();
                }
            }
        });
    }
}

