/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.dataflow.operator;

import groovy.lang.Closure;
import groovyx.gpars.dataflow.operator.DataflowSelector;
import groovyx.gpars.dataflow.operator.DataflowSelectorActor;
import groovyx.gpars.group.PGroup;
import groovyx.gpars.scheduler.Pool;
import java.util.List;
import java.util.concurrent.Semaphore;

final class ForkingDataflowSelectorActor
extends DataflowSelectorActor {
    private final Semaphore semaphore;
    private final Pool threadPool;

    ForkingDataflowSelectorActor(DataflowSelector owningOperator, PGroup group, List outputs, List inputs, Closure code, int maxForks) {
        super(owningOperator, group, outputs, inputs, code);
        this.semaphore = new Semaphore(maxForks);
        this.threadPool = group.getThreadPool();
    }

    void startTask(final int index, final Object result) {
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Cannot obtain the semaphore to fork operator's body.", e);
        }
        this.threadPool.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    ForkingDataflowSelectorActor.super.startTask(index, result);
                }
                finally {
                    ForkingDataflowSelectorActor.this.semaphore.release();
                }
            }
        });
    }
}

