/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.dataflow.operator;

import groovy.lang.Closure;
import groovyx.gpars.dataflow.Dataflow;
import groovyx.gpars.dataflow.DataflowReadChannel;
import groovyx.gpars.dataflow.DataflowWriteChannel;
import groovyx.gpars.group.DefaultPGroup;
import groovyx.gpars.group.PGroup;
import groovyx.gpars.scheduler.Pool;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Pipeline {
    private final PGroup group;
    private DataflowReadChannel output;
    private boolean complete = false;

    public Pipeline(DataflowReadChannel output) {
        this(Dataflow.retrieveCurrentDFPGroup(), output);
    }

    public Pipeline(Pool pool, DataflowReadChannel output) {
        this(new DefaultPGroup(pool), output);
        if (pool == null) {
            throw new IllegalArgumentException("A pipeline needs a thread pool to work with.");
        }
    }

    public Pipeline(PGroup group, DataflowReadChannel output) {
        if (output == null) {
            throw new IllegalArgumentException("Cannot build a pipeline around a null channel.");
        }
        if (group == null) {
            throw new IllegalArgumentException("A pipeline needs a PGroup instance to work with.");
        }
        this.group = group;
        this.output = output;
    }

    public PGroup getGroup() {
        return this.group;
    }

    public DataflowReadChannel getOutput() {
        return this.output;
    }

    public boolean isComplete() {
        return this.complete;
    }

    private void checkState() {
        if (this.complete) {
            throw new IllegalStateException("The pipeline has been closed already.");
        }
    }

    public <V> Pipeline chainWith(Closure<V> closure) {
        this.checkState();
        this.output = this.output.chainWith(this.group, closure);
        return this;
    }

    public <V> Pipeline or(Closure<V> closure) {
        return this.chainWith(closure);
    }

    public Pipeline filter(Closure<Boolean> closure) {
        this.checkState();
        this.output = this.output.filter(this.group, closure);
        return this;
    }

    public <V> void into(DataflowWriteChannel<V> target) {
        this.checkState();
        this.output.into(target);
        this.complete = true;
    }

    public <V> void or(DataflowWriteChannel<V> target) {
        this.into(target);
    }

    public <V> void split(DataflowWriteChannel<V> target1, DataflowWriteChannel<V> target2) {
        this.checkState();
        this.output.split(target1, target2);
        this.complete = true;
    }

    public <V> void split(List<DataflowWriteChannel<V>> targets) {
        this.checkState();
        this.output.split(targets);
        this.complete = true;
    }

    public <V> Pipeline tap(DataflowWriteChannel<V> target) {
        this.checkState();
        this.output = this.output.tap(this.group, target);
        return this;
    }

    Pipeline merge(DataflowReadChannel<Object> other, Closure closure) {
        this.checkState();
        this.output = this.output.merge(this.group, other, closure);
        return this;
    }

    Pipeline merge(List<DataflowReadChannel<Object>> others, Closure closure) {
        this.checkState();
        this.output = this.output.merge(this.group, others, closure);
        return this;
    }

    public <T> void binaryChoice(DataflowWriteChannel<T> trueBranch, DataflowWriteChannel<T> falseBranch, Closure<Boolean> code) {
        this.checkState();
        this.output.binaryChoice(this.group, trueBranch, falseBranch, code);
        this.complete = true;
    }

    public <T> void choice(List<DataflowWriteChannel<T>> outputs, Closure<Integer> code) {
        this.checkState();
        this.output.choice(this.group, outputs, code);
        this.complete = true;
    }

    public void separate(List<DataflowWriteChannel<?>> outputs, Closure<List<Object>> code) {
        this.checkState();
        this.output.separate(this.group, outputs, code);
        this.complete = true;
    }
}

