/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.forkjoin;

import groovy.lang.Closure;
import groovyx.gpars.forkjoin.AbstractForkJoinWorker;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FJWorker<T>
extends AbstractForkJoinWorker<T> {
    private final Closure code;
    private final T[] args;
    public static final Object[] EMPTY_OBJECTS = new Object[0];

    FJWorker(Object ... args) {
        int size = args.length;
        assert (size > 0);
        this.args = size > 1 ? Arrays.copyOfRange(args, 0, size - 1) : EMPTY_OBJECTS;
        this.code = (Closure)((Closure)args[size - 1]).clone();
        this.code.setDelegate((Object)this);
        this.code.setResolveStrategy(1);
    }

    void forkOffChild(Object ... childArgs) {
        if (childArgs.length != this.args.length) {
            throw new IllegalArgumentException("The forkOffChild() method requires " + this.args.length + " arguments, but received " + childArgs.length + " parameters.");
        }
        Object[] params = new Object[childArgs.length + 1];
        System.arraycopy(childArgs, 0, params, 0, childArgs.length);
        params[params.length - 1] = this.code;
        this.forkOffChild(new FJWorker<T>(params));
    }

    T runChildDirectly(Object ... childArgs) {
        if (childArgs.length != this.args.length) {
            throw new IllegalArgumentException("The runChildDirectly() method requires " + this.args.length + " arguments, but received " + childArgs.length + " parameters.");
        }
        Object[] params = new Object[childArgs.length + 1];
        System.arraycopy(childArgs, 0, params, 0, childArgs.length);
        params[params.length - 1] = this.code;
        return new FJWorker<T>(params).compute();
    }

    @Override
    protected T computeTask() {
        return (T)this.code.call((Object[])this.args);
    }
}

