/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.scheduler;

import groovyx.gpars.scheduler.Pool;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class Scheduler
implements Pool {
    private final BlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();
    private final AtomicInteger threadCount = new AtomicInteger();
    private volatile long lastTaskPoke = -10L;
    private volatile long schedulerTime;
    private volatile boolean terminating;
    static final RuntimeException TERMINATE = new RuntimeException("terminate");
    private static final long POKE_INTERVAL = 10L;

    public Scheduler() {
        this(0);
    }

    public Scheduler(int coreSize) {
        new WatchdogThread().start();
        for (int i = 0; i != coreSize; ++i) {
            this.startNewThread();
        }
    }

    public void execute(Runnable task) {
        if (this.terminating) {
            throw new RuntimeException("Scheduler is shutting down");
        }
        try {
            this.queue.put(task);
            if (this.threadCount.get() == 0) {
                this.startNewThread();
            }
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
    }

    public Runnable loop(final Runnable operation) {
        return new Runnable(){

            public void run() {
                operation.run();
                if (!Scheduler.this.terminating) {
                    Scheduler.this.execute(this);
                }
            }
        };
    }

    private void startNewThread() {
        this.threadCount.incrementAndGet();
        new WorkerThread().start();
    }

    public void resize(int poolSize) {
        throw new UnsupportedOperationException();
    }

    public void resetDefaultSize() {
        throw new UnsupportedOperationException();
    }

    public int getPoolSize() {
        return this.threadCount.get();
    }

    public void shutdown() {
        this.terminating = true;
        int count = this.threadCount.get();
        for (int i = 0; i != count; ++i) {
            try {
                this.queue.put(new Runnable(){

                    public void run() {
                        throw TERMINATE;
                    }
                });
                continue;
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private class WatchdogThread
    extends Thread {
        private static final long SLEEP_INTERVAL = 50L;

        private WatchdogThread() {
            this.setDaemon(true);
        }

        public void run() {
            while (!Scheduler.this.terminating) {
                try {
                    Scheduler.this.schedulerTime++;
                    if (Scheduler.this.schedulerTime > Scheduler.this.lastTaskPoke + 10L) {
                        Scheduler.this.startNewThread();
                    }
                    Thread.sleep(50L);
                }
                catch (InterruptedException ignore) {
                    break;
                }
            }
        }
    }

    private class WorkerThread
    extends Thread {
        private WorkerThread() {
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (true) {
                Runnable task;
                try {
                    if (Scheduler.this.terminating) break;
                    task = (Runnable)Scheduler.this.queue.poll(10L, TimeUnit.SECONDS);
                    if (task == null) {
                        Scheduler.this.threadCount.decrementAndGet();
                        return;
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                    break;
                }
                catch (Throwable throwable) {
                    Scheduler.this.threadCount.decrementAndGet();
                    throw throwable;
                }
                {
                    Scheduler.this.lastTaskPoke = Scheduler.this.schedulerTime;
                    try {
                        task.run();
                    }
                    catch (Throwable t) {
                        if (TERMINATE == t) continue;
                        t.printStackTrace();
                    }
                    continue;
                }
                break;
            }
            Scheduler.this.threadCount.decrementAndGet();
        }
    }
}

