/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.control;

import groovy.lang.GroovyRuntimeException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;

public class SourceExtensionHandler {
    public static Set<String> getRegisteredExtensions(ClassLoader loader) {
        LinkedHashSet<String> extensions = new LinkedHashSet<String>();
        extensions.add("groovy");
        URL service = null;
        try {
            Enumeration<URL> globalServices = loader.getResources("META-INF/services/org.codehaus.groovy.source.Extensions");
            while (globalServices.hasMoreElements()) {
                service = globalServices.nextElement();
                BufferedReader svcIn = new BufferedReader(new InputStreamReader(service.openStream()));
                String extension = svcIn.readLine();
                while (extension != null) {
                    if (!(extension = extension.trim()).startsWith("#") && extension.length() > 0) {
                        extensions.add(extension);
                    }
                    extension = svcIn.readLine();
                }
            }
        }
        catch (IOException ex) {
            throw new GroovyRuntimeException("IO Exception attempting to load source extension registerers. Exception: " + ex.toString() + (service == null ? "" : service.toExternalForm()));
        }
        return extensions;
    }
}

