/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import groovy.lang.GroovyClassLoader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.SimpleMessage;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformationClass;

public class ASTTransformationCollectorCodeVisitor
extends ClassCodeVisitorSupport {
    private SourceUnit source;
    private ClassNode classNode;
    private GroovyClassLoader transformLoader;

    public ASTTransformationCollectorCodeVisitor(SourceUnit source, GroovyClassLoader transformLoader) {
        this.source = source;
        this.transformLoader = transformLoader;
    }

    @Override
    protected SourceUnit getSourceUnit() {
        return this.source;
    }

    @Override
    public void visitClass(ClassNode klassNode) {
        ClassNode oldClass = this.classNode;
        this.classNode = klassNode;
        super.visitClass(this.classNode);
        this.classNode = oldClass;
    }

    @Override
    public void visitAnnotations(AnnotatedNode node) {
        super.visitAnnotations(node);
        for (AnnotationNode annotation : node.getAnnotations()) {
            Annotation transformClassAnnotation = ASTTransformationCollectorCodeVisitor.getTransformClassAnnotation(annotation.getClassNode());
            if (transformClassAnnotation == null) continue;
            this.addTransformsToClassNode(annotation, transformClassAnnotation);
        }
    }

    private void addTransformsToClassNode(AnnotationNode annotation, Annotation transformClassAnnotation) {
        List<String> transformClassNames = this.getTransformClassNames(annotation, transformClassAnnotation);
        if (transformClassNames.isEmpty()) {
            this.source.getErrorCollector().addError(new SimpleMessage("@GroovyASTTransformationClass in " + annotation.getClassNode().getName() + " does not specify any transform class names/classes", this.source));
        }
        for (String transformClass : transformClassNames) {
            try {
                Class klass = this.transformLoader.loadClass(transformClass, false, true, false);
                this.verifyAndAddTransform(annotation, klass);
            }
            catch (ClassNotFoundException e) {
                this.source.getErrorCollector().addErrorAndContinue(new SimpleMessage("Could not find class for Transformation Processor " + transformClass + " declared by " + annotation.getClassNode().getName(), this.source));
            }
        }
    }

    private void verifyAndAddTransform(AnnotationNode annotation, Class klass) {
        this.verifyClass(annotation, klass);
        this.verifyCompilePhase(annotation, klass);
        this.addTransform(annotation, klass);
    }

    private void verifyCompilePhase(AnnotationNode annotation, Class klass) {
        CompilePhase specifiedCompilePhase;
        GroovyASTTransformation transformationClass = klass.getAnnotation(GroovyASTTransformation.class);
        if (transformationClass != null && (specifiedCompilePhase = transformationClass.phase()).getPhaseNumber() < CompilePhase.SEMANTIC_ANALYSIS.getPhaseNumber()) {
            this.source.getErrorCollector().addError(new SimpleMessage(annotation.getClassNode().getName() + " is defined to be run in compile phase " + (Object)((Object)specifiedCompilePhase) + ". Local AST transformations must run in " + (Object)((Object)CompilePhase.SEMANTIC_ANALYSIS) + " or later!", this.source));
        }
    }

    private void verifyClass(AnnotationNode annotation, Class klass) {
        if (!ASTTransformation.class.isAssignableFrom(klass)) {
            this.source.getErrorCollector().addError(new SimpleMessage("Not an ASTTransformation: " + klass.getName() + " declared by " + annotation.getClassNode().getName(), this.source));
        }
    }

    private void addTransform(AnnotationNode annotation, Class klass) {
        this.classNode.addTransform(klass, annotation);
    }

    private static Annotation getTransformClassAnnotation(ClassNode annotatedType) {
        if (!annotatedType.isResolved()) {
            return null;
        }
        for (Annotation ann : annotatedType.getTypeClass().getAnnotations()) {
            if (!ann.annotationType().getName().equals(GroovyASTTransformationClass.class.getName())) continue;
            return ann;
        }
        return null;
    }

    private List<String> getTransformClassNames(AnnotationNode annotation, Annotation transformClassAnnotation) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            Class[] classes;
            Method valueMethod = transformClassAnnotation.getClass().getMethod("value", new Class[0]);
            String[] names = (String[])valueMethod.invoke((Object)transformClassAnnotation, new Object[0]);
            result.addAll(Arrays.asList(names));
            Method classesMethod = transformClassAnnotation.getClass().getMethod("classes", new Class[0]);
            for (Class klass : classes = (Class[])classesMethod.invoke((Object)transformClassAnnotation, new Object[0])) {
                result.add(klass.getName());
            }
            if (names.length > 0 && classes.length > 0) {
                this.source.getErrorCollector().addError(new SimpleMessage("@GroovyASTTransformationClass in " + annotation.getClassNode().getName() + " should specify transforms only by class names or by classes and not by both", this.source));
            }
        }
        catch (Exception e) {
            this.source.addException(e);
        }
        return result;
    }
}

