/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.actor;

import groovy.lang.Closure;
import groovyx.gpars.actor.Actor;
import groovyx.gpars.actor.ActorMessage;
import groovyx.gpars.actor.ActorTimerTask;
import groovyx.gpars.actor.impl.ActorReplyException;
import groovyx.gpars.actor.impl.MessageStream;
import groovyx.gpars.group.PGroup;
import groovyx.gpars.util.AsyncMessagingCore;

public abstract class AbstractLoopingActor
extends Actor {
    private static final long serialVersionUID = -7638132628355085829L;
    private volatile boolean stoppedFlag = true;
    private volatile boolean terminatedFlag = true;
    volatile boolean terminatingFlag = true;
    private ActorTimerTask currentTimerTask = null;
    private int timeoutCounter = 0;
    private MessageStream currentSender;
    private AsyncMessagingCore core;

    final AsyncMessagingCore getCore() {
        return this.core;
    }

    protected final void initialize(final Closure code) {
        this.core = new AsyncMessagingCore(this.parallelGroup.getThreadPool()){

            protected void registerError(Throwable e) {
                if (e instanceof InterruptedException) {
                    AbstractLoopingActor.this.handleInterrupt((InterruptedException)e);
                } else {
                    AbstractLoopingActor.this.handleException(e);
                }
                AbstractLoopingActor.this.terminate();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void handleMessage(Object message) {
                if (message == Actor.START_MESSAGE) {
                    AbstractLoopingActor.this.handleStart();
                } else {
                    if (message == Actor.TIMEOUT_MESSAGE) {
                        ActorTimerTask localTimerTask = AbstractLoopingActor.this.currentTimerTask;
                        if (localTimerTask != null) {
                            AbstractLoopingActor.this.cancelCurrentTimeoutTask();
                            if (AbstractLoopingActor.this.timeoutCounter != localTimerTask.getId()) {
                                return;
                            }
                        } else {
                            return;
                        }
                        AbstractLoopingActor.this.handleTimeout();
                    } else if (AbstractLoopingActor.this.currentTimerTask != null) {
                        AbstractLoopingActor.this.cancelCurrentTimeoutTask();
                    }
                    AbstractLoopingActor.this.timeoutCounter = (AbstractLoopingActor.this.timeoutCounter + 1) % Integer.MAX_VALUE;
                    if (AbstractLoopingActor.this.terminatingFlag || message == Actor.STOP_MESSAGE) {
                        if (!AbstractLoopingActor.this.terminatedFlag) {
                            AbstractLoopingActor.this.handleTermination();
                            AbstractLoopingActor.this.terminatedFlag = true;
                            AbstractLoopingActor.this.getJoinLatch().bindUnique(null);
                        }
                    } else {
                        ActorMessage actorMessage = (ActorMessage)message;
                        try {
                            AbstractLoopingActor.this.runEnhancedWithoutRepliesOnMessages(actorMessage, code, actorMessage.getPayLoad());
                        }
                        finally {
                            AbstractLoopingActor.this.currentSender = null;
                        }
                    }
                }
            }

            protected boolean continueProcessingMessages() {
                return AbstractLoopingActor.this.isActive();
            }

            protected void threadAssigned() {
                Actor.registerCurrentActorWithThread(AbstractLoopingActor.this);
                AbstractLoopingActor.this.currentThread = Thread.currentThread();
            }

            protected void threadUnassigned() {
                Actor.deregisterCurrentActorWithThread();
                AbstractLoopingActor.this.currentThread = null;
            }
        };
    }

    public final boolean isFair() {
        return this.core.isFair();
    }

    public final void makeFair() {
        this.core.makeFair();
    }

    protected final void setTimeout(long timeout) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("Actor timeout must be a non-negative value");
        }
        this.currentTimerTask = new ActorTimerTask(this, this.timeoutCounter);
        timer.schedule(this.currentTimerTask, timeout);
    }

    private void cancelCurrentTimeoutTask() {
        assert (this.currentTimerTask != null);
        this.currentTimerTask.cancel();
        this.currentTimerTask = null;
    }

    public Actor silentStart() {
        return this.doStart();
    }

    public Actor start() {
        this.doStart();
        this.send(START_MESSAGE);
        return this;
    }

    private Actor doStart() {
        if (!this.hasBeenStopped()) {
            throw new IllegalStateException("Actor has already been started.");
        }
        this.stoppedFlag = false;
        this.terminatedFlag = false;
        this.terminatingFlag = false;
        return this;
    }

    public final Actor stop() {
        if (!this.hasBeenStopped()) {
            this.stoppedFlag = true;
            this.send(STOP_MESSAGE);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Actor terminate() {
        AbstractLoopingActor abstractLoopingActor = this;
        synchronized (abstractLoopingActor) {
            if (!this.isActive()) {
                return this;
            }
            this.stop();
            this.terminatingFlag = true;
        }
        if (this.isActorThread()) {
            this.terminatedFlag = true;
            this.handleTermination();
            this.getJoinLatch().bindUnique(null);
        }
        Thread.yield();
        if (!this.isActorThread() && this.currentThread != null) {
            try {
                this.currentThread.interrupt();
            }
            catch (Exception e) {
                this.send(TERMINATE_MESSAGE);
            }
        } else {
            this.send(TERMINATE_MESSAGE);
        }
        return this;
    }

    public final boolean isActive() {
        return !this.terminatedFlag;
    }

    protected final boolean hasBeenStopped() {
        return this.stoppedFlag;
    }

    protected ActorMessage sweepNextMessage() {
        return (ActorMessage)this.core.sweepNextMessage();
    }

    public MessageStream send(Object message) {
        this.core.store(this.createActorMessage(message));
        return this;
    }

    public void setParallelGroup(PGroup group) {
        super.setParallelGroup(group);
        this.core.attachToThreadPool(group.getThreadPool());
    }

    protected final MessageStream getSender() {
        return this.currentSender;
    }

    protected final void reply(Object message) {
        if (this.currentSender == null) {
            throw new ActorReplyException("Cannot send replies. No sender has been registered.");
        }
        this.currentSender.send(message);
    }

    protected final void replyIfExists(Object message) {
        if (this.currentSender == null) {
            return;
        }
        try {
            this.currentSender.send(message);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void runEnhancedWithoutRepliesOnMessages(ActorMessage message, Closure code, Object arguments) {
        assert (message != null);
        this.currentSender = message.getSender();
        code.call(arguments);
    }
}

