/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.dataflow.stream;

import groovy.lang.Closure;
import groovyx.gpars.actor.impl.MessageStream;
import groovyx.gpars.dataflow.DataCallback;
import groovyx.gpars.dataflow.Dataflow;
import groovyx.gpars.dataflow.DataflowReadChannel;
import groovyx.gpars.dataflow.DataflowVariable;
import groovyx.gpars.dataflow.expression.DataflowExpression;
import groovyx.gpars.dataflow.stream.FList;
import groovyx.gpars.dataflow.stream.FListIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StreamCore<T>
implements FList<T> {
    protected final DataflowVariable<T> first;
    protected final AtomicReference<StreamCore<T>> rest = new AtomicReference();
    protected final Collection<MessageStream> wheneverBoundListeners;

    protected StreamCore(DataflowVariable<T> first) {
        this.first = first;
        this.wheneverBoundListeners = new CopyOnWriteArrayList<MessageStream>();
    }

    protected StreamCore(DataflowVariable<T> first, Closure toBeApplied) {
        this(first);
        this.apply(toBeApplied);
    }

    protected StreamCore(DataflowVariable<T> first, Collection<MessageStream> wheneverBoundListeners) {
        this.first = first;
        this.wheneverBoundListeners = wheneverBoundListeners;
        this.hookWheneverBoundListeners(first);
    }

    public static <T> T eos() {
        return null;
    }

    private static <T> T eval(Object valueOrDataflowVariable) {
        if (valueOrDataflowVariable instanceof DataflowVariable) {
            try {
                return ((DataflowReadChannel)valueOrDataflowVariable).getVal();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return (T)valueOrDataflowVariable;
    }

    public final StreamCore<T> generate(T seed, Closure generator, Closure condition) {
        this.generateNext(seed, this, generator, condition);
        return this;
    }

    private void generateNext(T value, StreamCore<T> stream, Closure generator, Closure condition) {
        T recurValue = value;
        StreamCore<T> recurStream = stream;
        while (true) {
            boolean addValue;
            if (!(addValue = ((Boolean)condition.call(new Object[]{recurValue})).booleanValue())) {
                recurStream.leftShift(StreamCore.<T>eos());
                return;
            }
            recurStream = recurStream.leftShift(recurValue);
            recurValue = StreamCore.eval(generator.call(new Object[]{recurValue}));
        }
    }

    public final StreamCore<T> apply(Closure closure) {
        closure.call(new Object[]{this});
        return this;
    }

    public final StreamCore<T> leftShift(DataflowReadChannel<T> ref) {
        ref.getValAsync(new MessageStream(){

            public MessageStream send(Object message) {
                StreamCore.this.first.bind(message);
                return null;
            }
        });
        return (StreamCore)this.getRest();
    }

    public final StreamCore<T> leftShift(T value) {
        this.bind(value);
        return (StreamCore)this.getRest();
    }

    private void bind(T value) {
        this.first.bind(value);
    }

    final DataflowVariable<T> getFirstDFV() {
        return this.first;
    }

    @Override
    public final T getFirst() {
        try {
            return this.first.getVal();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public abstract FList<T> getRest();

    @Override
    public final boolean isEmpty() {
        return this.getFirst() == StreamCore.eos();
    }

    @Override
    public final FList<T> filter(Closure filterClosure) {
        StreamCore<T> newStream = this.createNewStream();
        this.filter(this, filterClosure, newStream);
        return newStream;
    }

    private void filter(StreamCore<T> rest, Closure filterClosure, StreamCore<T> result) {
        StreamCore recurRest = rest;
        StreamCore<T> recurResult = result;
        while (true) {
            if (recurRest.isEmpty()) {
                recurResult.leftShift(StreamCore.<T>eos());
                return;
            }
            boolean include = (Boolean)StreamCore.eval(filterClosure.call(new Object[]{recurRest.getFirst()}));
            if (include) {
                recurResult = recurResult.leftShift(recurRest.getFirst());
            }
            recurRest = (StreamCore)recurRest.getRest();
        }
    }

    @Override
    public final FList<Object> map(Closure mapClosure) {
        StreamCore<Object> newStream = this.createNewStream();
        this.map(this, mapClosure, newStream);
        return newStream;
    }

    private void map(FList<T> rest, Closure mapClosure, StreamCore<Object> result) {
        FList<T> recurRest = rest;
        StreamCore<Object> recurResult = result;
        while (true) {
            if (recurRest.isEmpty()) {
                recurResult.leftShift(StreamCore.<T>eos());
                return;
            }
            Object mapped = mapClosure.call(new Object[]{recurRest.getFirst()});
            recurResult = recurResult.leftShift(StreamCore.eval(mapped));
            recurRest = recurRest.getRest();
        }
    }

    @Override
    public final T reduce(Closure reduceClosure) {
        if (this.isEmpty()) {
            return null;
        }
        return this.reduce(this.getFirst(), this.getRest(), reduceClosure);
    }

    @Override
    public final T reduce(T seed, Closure reduceClosure) {
        return this.reduce(seed, this, reduceClosure);
    }

    private T reduce(T current, FList<T> rest, Closure reduceClosure) {
        T recurCurrent = current;
        FList<T> recurRest = rest;
        while (!recurRest.isEmpty()) {
            Object aggregate = reduceClosure.call(new Object[]{recurCurrent, recurRest.getFirst()});
            recurCurrent = StreamCore.eval(aggregate);
            recurRest = recurRest.getRest();
        }
        return recurCurrent;
    }

    @Override
    public final Iterator<T> iterator() {
        return new FListIterator(this);
    }

    @Override
    public String appendingString() {
        if (!this.first.isBound()) {
            return ", ?";
        }
        if (this.isEmpty()) {
            return "";
        }
        return ", " + this.getFirst() + this.getRest().appendingString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FList stream = (FList)obj;
        if (this.isEmpty()) {
            return stream.isEmpty();
        }
        if (!this.getFirst().equals(stream.getFirst())) {
            return false;
        }
        return this.getRest().equals(stream.getRest());
    }

    public int hashCode() {
        int result = this.first.hashCode();
        result = 31 * result + this.rest.hashCode();
        return result;
    }

    protected abstract StreamCore<T> createNewStream();

    public final void wheneverBound(Closure closure) {
        this.wheneverBoundListeners.add(new DataCallback(closure, Dataflow.retrieveCurrentDFPGroup()));
        this.first.whenBound(closure);
    }

    public final void wheneverBound(MessageStream stream) {
        this.wheneverBoundListeners.add(stream);
        this.first.whenBound(stream);
    }

    private DataflowExpression<T> hookWheneverBoundListeners(DataflowExpression<T> expr) {
        for (MessageStream listener : this.wheneverBoundListeners) {
            expr.whenBound(listener);
        }
        return expr;
    }

    public void incrementParties() {
    }

    public void decrementParties() {
    }
}

