/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.remote;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.UUID;

public class BroadcastDiscovery {
    private static InetAddress group;
    private static final int PORT = 4239;
    private static final long MAGIC = 597173137L;
    private final UUID uid;
    private final InetSocketAddress address;
    private Thread sendThread;
    private Thread receiveThread;
    private volatile boolean stopped;
    private MulticastSocket socket;

    public BroadcastDiscovery(UUID uid, InetSocketAddress address) {
        this.uid = uid;
        this.address = address;
    }

    public void start() {
        try {
            this.socket = new MulticastSocket(4239);
            this.socket.joinGroup(group);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DataOutputStream stream = new DataOutputStream(out);
            stream.writeLong(597173137L);
            stream.writeLong(this.uid.getMostSignificantBits());
            stream.writeLong(this.uid.getLeastSignificantBits());
            stream.writeInt(this.address.getPort());
            byte[] addrBytes = this.address.getAddress().getAddress();
            stream.writeInt(addrBytes.length);
            stream.write(addrBytes);
            stream.close();
            final byte[] bytes = out.toByteArray();
            this.sendThread = new Thread(){

                public void run() {
                    while (!BroadcastDiscovery.this.stopped) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ignore) {
                            // empty catch block
                        }
                        try {
                            DatagramPacket packet = new DatagramPacket(bytes, bytes.length, group, 4239);
                            BroadcastDiscovery.this.socket.send(packet);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            };
            this.sendThread.start();
            this.receiveThread = new Thread(){

                public void run() {
                    byte[] buf = new byte[36];
                    byte[] addrBuf4 = new byte[4];
                    byte[] addrBuf6 = new byte[6];
                    while (!BroadcastDiscovery.this.stopped) {
                        DatagramPacket packet = new DatagramPacket(buf, buf.length);
                        try {
                            BroadcastDiscovery.this.socket.receive(packet);
                            DataInputStream in = new DataInputStream(new ByteArrayInputStream(buf));
                            if (in.readLong() != 597173137L) continue;
                            UUID uuid = new UUID(in.readLong(), in.readLong());
                            int port = in.readInt();
                            int addrLen = in.readInt();
                            if (addrLen == 4) {
                                in.read(addrBuf4);
                                BroadcastDiscovery.this.onDiscovery(uuid, new InetSocketAddress(InetAddress.getByAddress(addrBuf4), port));
                                continue;
                            }
                            in.read(addrBuf6);
                            BroadcastDiscovery.this.onDiscovery(uuid, new InetSocketAddress(InetAddress.getByAddress(addrBuf6), port));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            };
            this.receiveThread.start();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void stop() {
        try {
            this.stopped = true;
            if (this.sendThread != null) {
                this.sendThread.join();
            }
            if (this.receiveThread != null) {
                this.receiveThread.join();
            }
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected void onDiscovery(UUID uuid, SocketAddress address) {
    }

    static {
        try {
            group = InetAddress.getByName("230.0.0.239");
        }
        catch (UnknownHostException ignored) {
            group = null;
        }
    }
}

