/****************************************************************/
/*                                                              */
/* symbol.c                                                     */
/*                                                              */
/* This file contains the symbol table entry and dump routines. */
/* It also contains static symbol table entries for predefined  */
/* symbols.                                                     */
/*                                                              */
/****************************************************************/


/*
** Must include debug.h first!
*/

#include "debug.h"

#include "common.h"

#ifdef DEBUGSYM
#define PathLogging
/*#define TestStmtCoverage*/
#define LogFuncCalls
#define DEBUG
#endif

//  Turn off RatC tracing in this module because it produces
// so much output.

#undef  DEBUG

#include "ratc.h"

#include "symbol.h"
#include "hlaparse.h"
#include "asm.h"




void DumpFields( struct SymNode *Type, struct SymNode *Value, int comma );




/*
** Predefined symbol table entries.
**
** SymNode contains the following (though check inside symbol.h to be sure).
**
**
**	struct	SymNode		*Next;
**	struct	SymNode		*hashList
**	char				*Name;
**	char				*TrueName;
**	int					NameLen;
**	struct	SymNode		*Type;
**	int					NameLen;
**	enum	PrimType	pType;
**	enum	ClassType	SymClass;
**  enum	ParmClass	pClass;
**	int					ObjectSize;
**	unsigned			MaxObjectSize;
**	int					Offset;
**	char				*StaticName;
**	int					LexLevel;
**  int					IsExternal;
**  int					IsReferenced;
**	int					Arity;
**	int					*Dimensions;
**	int					NumElements;
**	struct	SymNode		*Fields;
**	struct	SymNode		*Base;
**	int					FieldCnt;
**	struct	SymNode		*CurField;
**	int					CurIndex;
**	union
**	{
**		char					StartOfValues;
**		unsigned	char		bytes[16];
**		unsigned	short		words[8];
**		unsigned	long		dwords[4];
**		long					intval;
**		long		unsigned	unsval;
**		long		unsigned	boolval;			
**		long		unsigned	charval;
**		long		unsigned	qwordval[2];
**		long		unsigned	lwordval[4];			 		
**		struct		flt80		fltval;			
**		char					*strval;
**		unsigned	char		csetval[ CSetSizeInBytes ]; 		
**		struct		SymNode		*ArrayOfValues;	
**		struct		SymNode		*FieldValues;	
**		struct		SymNode		*PtrToValue;
**		struct		MacroType	MacroData;
**		struct
**		{
**			char				*returns;
**			char				*use;
**			struct	SymNode		*parms;
**			struct	SymNode		*Locals;
**			struct	SymNode		*Forward;
**			struct	SymNode		*BaseClass;
**					unsigned	ParmSize;
**			enum	CallSeq		cs;
**		} proc;
**	};
**
*/


#define _nxt NULL
#define _hash NULL
#define _typ NULL
#define _ofs 0
#define _stnam NULL
#define _lex -1
#define _x 0,NULL    /* Note that this fills in IsExternal and IsReferenced */
#define _arity 0
#define _dims NULL
#define _numel 0
#define _flds NULL
#define _base NULL
#define	_fldcnt 0
#define	_cf	NULL
#define	_ci	0
#define _pc		0



struct SymNode thunk_ste =
	{
					_nxt, _hash,		
		"Thunk",		
		"Thunk",
		6,
					_typ,		
		tThunk, 
		cType,		
					_pc,		
		8, 8,			
					_ofs,		_stnam,		_lex,		_x,		_arity,		
					_dims, 		_numel, 	_flds,		_base,
					_fldcnt,
					_cf,		_ci,
		0
	};






struct	SymNode pointer_ste	=	
	{
		&thunk_ste, _hash,		
		"pointer",		
		"pointer",
		8,
					_typ,		
		tPointer, 
		cType,
					_pc,		
		4, 4,		
					_ofs,		_stnam,		_lex,		_x,		_arity,		
					_dims, 		_numel, 	_flds,		_base,
					_fldcnt,
					_cf,		_ci,
		0
	};


struct  SymNode int8_ste	=	
	{
		&pointer_ste, _hash,		
		"int8",		
		"int8",
		5,		
					_typ,		
		tInt8, 
		cType,		
					_pc,		
		1,	1,		
					_ofs,		_stnam,		_lex,		_x,		_arity,		
					_dims, 		_numel, 	_flds,		_base,
					_fldcnt,
					_cf,		_ci,
		0
	};
	
struct  SymNode int16_ste	=	
	{
		&int8_ste, _hash,		
		"int16",		
		"int16",
		6,
					_typ,		
		tInt16, 
		cType,		
					_pc,		
		2,	2,			
					_ofs,		_stnam,		_lex,		_x,		_arity,		
					_dims, 		_numel, 	_flds,		_base,
					_fldcnt,
					_cf,		_ci,
		0
	};
	
struct  SymNode int32_ste	=	
	{
		&int16_ste, _hash,		
		"int32",		
		"int32",
		6,
					_typ,		
		tInt32, 
		cType,		
					_pc,		
		4,	4,			
					_ofs,		_stnam,		_lex,		_x,		_arity,		
					_dims, 		_numel, 	_flds,		_base,
					_fldcnt,
					_cf,		_ci,
		0
	};
	
struct  SymNode int64_ste	=	
	{
		&int32_ste, _hash,		
		"int64",		
		"int64",
		6,
					_typ,		
		tInt64, 
		cType,		
					_pc,		
		8,	8,			
					_ofs,		_stnam,		_lex,		_x,		_arity,		
					_dims, 		_numel, 	_flds,		_base,
					_fldcnt,
					_cf,		_ci,
		0
	};
	
struct  SymNode int128_ste	=	
	{
		&int64_ste, _hash,		
		"int128",		
		"int128",
		7,
					_typ,		
		tInt128, 
		cType,		
					_pc,		
		16,	16,			
					_ofs,		_stnam,		_lex,		_x,		_arity,		
					_dims, 		_numel, 	_flds,		_base,
					_fldcnt,
					_cf,		_ci,
		0
	};
	


struct	SymNode uns8_ste=	
	{
		&int128_ste, _hash,		
		"uns8",		
		"uns8",
		5,
					_typ,		
		tUns8, 
		cType,		
					_pc,		
		1,	1,			
					_ofs,		_stnam,		_lex,		_x,		_arity,		
					_dims, 		_numel, 	_flds,		_base,
					_fldcnt,
					_cf,		_ci,
		0
	};

struct	SymNode uns16_ste=	
	{
		&uns8_ste, _hash,		
		"uns16",		
		"uns16",
		6,
					_typ,		
		tUns16, 
		cType,		
					_pc,		
		2,	2,			
					_ofs,		_stnam,		_lex,		_x,		_arity,		
					_dims, 		_numel, 	_flds,		_base,
					_fldcnt,
					_cf,		_ci,
		0
	};
	

struct	SymNode uns32_ste=	
	{
		&uns16_ste, _hash,		
		"uns32",		
		"uns32",
		6,
					_typ,		
		tUns32, 
		cType,		
					_pc,		
		4,	4,			
					_ofs,		_stnam,		_lex,		_x,		_arity,		
					_dims, 		_numel, 	_flds,		_base,
					_fldcnt,
					_cf,		_ci,
		0
	};



struct	SymNode uns64_ste=	
	{
		&uns32_ste, _hash,		
		"uns64",		
		"uns64",
		6,
					_typ,		
		tUns64, 
		cType,		
					_pc,		
		8,	8,			
					_ofs,		_stnam,		_lex,		_x,		_arity,		
					_dims, 		_numel, 	_flds,		_base,
					_fldcnt,
					_cf,		_ci,
		0
	};



struct	SymNode uns128_ste=	
	{
		&uns64_ste, _hash,		
		"uns128",		
		"uns128",
		7,
					_typ,		
		tUns128, 
		cType,		
					_pc,		
		16,	16,			
					_ofs,		_stnam,		_lex,		_x,		_arity,		
					_dims, 		_numel, 	_flds,		_base,
					_fldcnt,
					_cf,		_ci,
		0
	};



struct  SymNode real32_ste	=	
	{
		&uns128_ste, _hash,		
		"real32",		
		"real32",
		7,
					_typ,		
		tReal32, 
		cType,		
					_pc,		
		4,	4,			
					_ofs,		_stnam,		_lex,		_x,		_arity,		
					_dims, 		_numel, 	_flds,		_base,
					_fldcnt,
					_cf,		_ci,
		0
	};

	
struct  SymNode real64_ste	=	
	{
		&real32_ste, _hash,		
		"real64",		
		"real64",
		7,
					_typ,		
		tReal64, 
		cType,		
					_pc,		
		8,	8,			
					_ofs,		_stnam,		_lex,		_x,		_arity,		
					_dims, 		_numel, 	_flds,		_base,
					_fldcnt,
					_cf,		_ci,
		0
	};

	
struct  SymNode real80_ste	=	
	{
		&real64_ste, _hash,		
		"real80",		
		"real80",
		7,
					_typ,		
		tReal80, 
		cType,		
					_pc,		
		10,	10,			
					_ofs,		_stnam,		_lex,		_x,		_arity,		
					_dims, 		_numel, 	_flds,		_base,
					_fldcnt,
					_cf,		_ci,
		0
	};



	
int real128_32_dims[1] = {4};
int real128_64_dims[1] = {2};

struct  SymNode real128_32_ste	=	
	{
		NULL, _hash,		
		"single",		
		"single",
		7,
		&real32_ste,		
		tArray, 
		cType,		
					_pc,		
		16,	16,
		0,			
					_stnam,		_lex,		_x,			
		1,		// Arity
		&real128_32_dims[0],
		4,		//Numelements	
					_flds,
					_base,
					_fldcnt,
					_cf,		_ci,
		0
	};
	
struct  SymNode real128_64_ste	=	
	{
		&real128_32_ste, _hash,		
		"double",		
		"double",
		7,
		&real64_ste,		
		tArray, 
		cType,		
					_pc,		
		16,	16,
		0,			
					_stnam,		_lex,		_x,			
		1,		// Arity
		&real128_64_dims[0],
		2,		//Numelements	
					_flds,		_base,
					_fldcnt,
					_cf,		_ci,
		0
	};
	


struct  SymNode real128_ste	=	
	{
		&real80_ste, _hash,		
		"real128",		
		"real128",
		8,
					_typ,		
		tUnion, 
		cType,		
					_pc,		



















		16,	16,			
					_ofs,		_stnam,		_lex,		_x,		_arity,		
					_dims, 		_numel, 	
		&real128_64_ste, 	// Fields		
		_base,
		2,					//FieldCnt
					_cf,		_ci,
		0
	};


	
	


struct  SymNode wchar_ste	=	
	{
		&real128_ste, _hash,		
		"wchar",		
		"wchar",
		6,
					_typ,		
		tWChar, 
		cType,		
					_pc,		
		2,	2,			
					_ofs,		_stnam,		_lex,		_x,		_arity,		
					_dims, 		_numel, 	_flds,		_base,
					_fldcnt,
					_cf,		_ci,
		0
	};


	
	


struct  SymNode char_ste	=	
	{
		&wchar_ste, _hash,		
		"char",		
		"char",
		5,
					_typ,		
		tChar, 
		cType,		
					_pc,		
		1,	1,			
					_ofs,		_stnam,		_lex,		_x,		_arity,		
					_dims, 		_numel, 	_flds,		_base,
					_fldcnt,
					_cf,		_ci,
		0
	};

	
struct  SymNode boolean_ste	=	
	{
		&char_ste, _hash,		
		"boolean",		
		"boolean",
		8,
					_typ,		
		tBoolean, 
		cType,		
					_pc,		
		1,	1,			
					_ofs,		_stnam,		_lex,		_x,		_arity,		
					_dims, 		_numel, 	_flds,		_base,
					_fldcnt,
					_cf,		_ci,
		0
	};
	
struct	SymNode	wstring_ste	=	
	{
		&boolean_ste, _hash,		
		"wstring",		
		"wstring",
		8,
					_typ,		
		tWString, 
		cType,		
					_pc,		
		4,	4,			
					_ofs,		_stnam,		_lex,		_x,		_arity,		
					_dims, 		_numel, 	_flds,		_base,
					_fldcnt,
					_cf,		_ci,
		0
	};
	
struct	SymNode	string_ste	=	
	{
		&wstring_ste, _hash,		
		"string",		
		"string",
		7,
					_typ,		
		tString, 
		cType,		
					_pc,		
		4,	4,			
					_ofs,		_stnam,		_lex,		_x,		_arity,		
					_dims, 		_numel, 	_flds,		_base,
					_fldcnt,
					_cf,		_ci,
		0
	};
	
struct	SymNode	zstring_ste	=	
	{
		&string_ste, _hash,		
		"zstring",		
		"zstring",
		8,
					_typ,		
		tZString, 
		cType,		
					_pc,		
		4,	4,			
					_ofs,		_stnam,		_lex,		_x,		_arity,		
					_dims, 		_numel, 	_flds,		_base,
					_fldcnt,
					_cf,		_ci,
		0
	};
	
struct	SymNode	cset_ste	=	
	{
		&zstring_ste, _hash,		
		"cset",		
		"cset",
		5,
					_typ,		
		tCset, 
		cType,		
					_pc,		
		CSetSizeInBytes,	CSetSizeInBytes,			
					_ofs,		_stnam,		_lex,		_x,		_arity,		
					_dims, 		_numel, 	_flds,		_base,
					_fldcnt,
					_cf,		_ci,
		0
	};
	
struct	SymNode regex_ste	=	
	{
		&cset_ste, _hash,		
		"regex",		
		"regex",
		6,
					_typ,		
		tRegex, 
		cType,		
					_pc,		
		4,	4,			
					_ofs,		_stnam,		_lex,		_x,		_arity,		
					_dims, 		_numel, 	_flds,		_base,
					_fldcnt,
					_cf,		_ci,
		0
	};
	
struct	SymNode text_ste	=	
	{
		&regex_ste, _hash,		
		"text",		
		"text",
		5,
					_typ,		
		tText, 
		cType,		
					_pc,		
		4,	4,			
					_ofs,		_stnam,		_lex,		_x,		_arity,		
					_dims, 		_numel, 	_flds,		_base,
					_fldcnt,
					_cf,		_ci,
		0
	};


struct	SymNode byte_ste	=	
	{
		&text_ste, _hash,		
		"byte",		
		"byte",
		5,
					_typ,		
		tByte, 
		cType,		
					_pc,		
		1,	1,			
					_ofs,		_stnam,		_lex,		_x,		_arity,		
					_dims, 		_numel, 	_flds,		_base,
					_fldcnt,
					_cf,		_ci,
		0
	};

struct	SymNode word_ste	=	
	{
		&byte_ste, _hash,		
		"word",		
		"word",
		5,
					_typ,		
		tWord, 
		cType,		
					_pc,		
		2,	2,			
					_ofs,		_stnam,		_lex,		_x,		_arity,		
					_dims, 		_numel, 	_flds,		_base,
					_fldcnt,
					_cf,		_ci,
		0
	};

struct	SymNode qword_ste	=	
	{
		&word_ste, _hash,		
		"qword",		
		"qword",
		6,
					_typ,		
		tQWord, 
		cType,		
					_pc,		
		8,	8,			
					_ofs,		_stnam,		_lex,		_x,		_arity,		
					_dims, 		_numel, 	_flds,		_base,
					_fldcnt,
					_cf,		_ci,
		0
	};

struct	SymNode tbyte_ste	=	
	{
		&qword_ste, _hash,		
		"tbyte",		
		"tbyte",
		6,
					_typ,		
		tTByte, 
		cType,		
					_pc,		
		10,	10,			
					_ofs,		_stnam,		_lex,		_x,		_arity,		
					_dims, 		_numel, 	_flds,		_base,
					_fldcnt,
					_cf,		_ci,
		0
	};

struct	SymNode lword_ste	=	
	{
		&tbyte_ste, _hash,		
		"lword",		
		"lword",
		6,
					_typ,		
		tLWord, 
		cType,		
					_pc,		
		16,	16,			
					_ofs,		_stnam,		_lex,		_x,		_arity,		
					_dims, 		_numel, 	_flds,		_base,
					_fldcnt,
					_cf,		_ci,
		0
	};

struct	SymNode dword_ste	=	
	{
		&lword_ste, _hash,		
		"dword",		
		"dword",
		6,
					_typ,		
		tDWord, 
		cType,		
					_pc,		
		4,	4,			
					_ofs,		_stnam,		_lex,		_x,		_arity,		
					_dims, 		_numel, 	_flds,		_base,
					_fldcnt,
					_cf,		_ci,
		0
	};

struct  SymNode false_ste	=	
	{
		&dword_ste, _hash,		
		"false",		
		"false",
		6,
					&boolean_ste,		
		tBoolean, 
		cConstant,		
					_pc,		
		1,	1,			
					_ofs,		_stnam,		-1,		_x,		_arity,		
					_dims, 		_numel, 	_flds,		_base,
					_fldcnt,
					_cf,		_ci,
		0
	};
	
struct  SymNode true_ste	=	
	{
		&false_ste, _hash,		
		"true",		
		"true",
		5,
					&boolean_ste,		
		tBoolean, 
		cConstant,		
					_pc,		
		1,	1,			
					_ofs,		_stnam,		-1,		_x,		_arity,		
					_dims, 		_numel, 	_flds,		_base,
					_fldcnt,
					_cf,		_ci,
		1
	};



/*
** The following is a default #for loop control variable
** to use if there is an error parsing the #for statement
*/

	
struct  SymNode forctrlvar_ste	=	
	{
		&false_ste, _hash,		
		" default for ctrl var ",		
		" default for ctrl var ",
		0,
					&int32_ste,		
		tInt32, 
		cValue,		
					_pc,		
		4,	4,			
					_ofs,		_stnam,		-1,		_x,		_arity,		
					_dims, 		_numel, 	_flds,		_base,
					_fldcnt,
					_cf,		_ci,
		0
	};



/*
** This entry is used to denote an error during compilation.
*/

struct  SymNode error_ste	=	
	{
				NULL,  _hash,		
		" error ",		
		" error ",
		0,
					&boolean_ste,		
		tError, 
		cConstant,		
					_pc,		
		1,	1,			
					_ofs,		_stnam,		_lex,		_x,		_arity,		
					_dims, 		_numel, 	
		NULL,		
		NULL,
		0,
					_cf,		_ci,
		1
	};




/*
** The following symbol table entries are provided for internal use
** only.  Users cannot directly declare objects of these types.
*/



struct	SymNode static_ste	=	
	{
					_nxt, _hash,		
		"static",		
		"static",
		7,
					_typ,		
		tPointer, 
		cType,		
					_pc,		
		4,	4,			
					_ofs,		_stnam,		_lex,		_x,		_arity,		
					_dims, 		_numel, 	_flds,		_base,
					_fldcnt,
					_cf,		_ci,
		0
	};


struct SymNode pgmID_ste =
	{
					_nxt, _hash,		
		"PgmId",		
		"PgmId",
		0,
					_typ,		
		tProgram, 
		cProgram,		
					_pc,		
		0,	0,			
					_ofs,		_stnam,		_lex,		_x,		_arity,		
					_dims, 		_numel, 	_flds,		_base,
					_fldcnt,
					_cf,		_ci,
		0
	};


struct SymNode procID_ste =
	{
					_nxt, _hash,		
		"ProcID",		
		"ProcID",
		0,
					_typ,		
		tProc, 
		cProc,		
					_pc,		
		0,	0,			
					_ofs,		_stnam,		_lex,		_x,		_arity,		
					_dims, 		_numel, 	_flds,		_base,
					_fldcnt,
					_cf,		_ci,
		0
	};



struct SymNode iterID_ste =
	{
					_nxt, _hash,		
		"IterID",		
		"IterID",
		0,
					_typ,		
		tIterator, 
		cIterator,		
					_pc,		
		0,	0,			
					_ofs,		_stnam,		_lex,		_x,		_arity,		
					_dims, 		_numel, 	_flds,		_base,
					_fldcnt,
					_cf,		_ci,
		0
	};



struct SymNode classprocID_ste =
	{
					_nxt, _hash,		
		"ClassProcID",		
		"ClassProcID",
		0,
					_typ,		
		tClassProc, 
		cClassProc,		
					_pc,		
		0,	0,			
					_ofs,		_stnam,		_lex,		_x,		_arity,		
					_dims, 		_numel, 	_flds,		_base,
					_fldcnt,
					_cf,		_ci,
		0
	};





struct SymNode classiterID_ste =
	{
					_nxt, _hash,		
		"ClassIterID",		
		"ClassIterID",
		0,
					_typ,		
		tClassIter, 
		cClassIter,		
					_pc,		
		0,	0,			
					_ofs,		_stnam,		_lex,		_x,		_arity,		
					_dims, 		_numel, 	_flds,		_base,
					_fldcnt,
					_cf,		_ci,
		0
	};



struct SymNode methodID_ste =
	{
					_nxt, _hash,		
		"MethodID",		
		"MethodID",
		0,
					_typ,		
		tMethod, 
		cMethod,		
					_pc,		
		0,	0,			
					_ofs,		_stnam,		_lex,		_x,		_arity,		
					_dims, 		_numel, 	_flds,		_base,
					_fldcnt,
					_cf,		_ci,
		0
	};



struct SymNode namespace_ste =
	{
					_nxt, _hash,		
		"Namespace",		
		"Namespace",
		0,
					_typ,		
		tNamespace, 
		cNamespace,		
					_pc,		
		0,	0,			
					_ofs,		_stnam,		_lex,		_x,		_arity,		
					_dims, 		_numel, 	_flds,		_base,
					_fldcnt,
					_cf,		_ci,
		0
	};



struct SymNode proctype_ste =
	{
					_nxt, _hash,		
		"ProcPtr",		
		"ProcPtr",
		0,
					_typ,		
		tProcptr, 
		cType,		
					_pc,		
		4,	4,			
					_ofs,		_stnam,		_lex,		_x,		_arity,		
					_dims, 		_numel, 	_flds,		_base,
					_fldcnt,
					_cf,		_ci,
		0
	};

struct SymNode dummyProc2_ste =
	{
					_nxt, _hash,		
		"dummyProc",		
		"dummyProc",
		0,
					_typ,		
		tProc, 
		cProc,		

					_pc,		
		4,	4,			
					_ofs,		_stnam,		_lex,		_x,		_arity,		
					_dims, 		_numel, 	_flds,		_base,
					_fldcnt,
					_cf,		_ci,
		0
	};
	
struct SymNode dummyProc_ste =
	{
					_nxt, _hash,		
		"dummyProc",		
		"dummyProc",
		0,
					_typ,		
		tProc, 
		cProc,		
					_pc,		
		4,	4,			
					_ofs,		_stnam,		_lex,		_x,		_arity,		
					_dims, 		_numel, 	_flds,		_base,
					_fldcnt,
					_cf,		_ci,
		0
	};



struct SymNode dummyVar_ste =
	{
					_nxt, _hash,		
		"dummyVar",		
		"dummyVar",
		0,
		&dword_ste,		
		tDWord, 
		cStatic,		
					_pc,		
		4,	4,			
					_ofs,		
		"dummyVar",		
		0,		
					_x,		_arity,		
					_dims, 		_numel, 	_flds,		_base,
					_fldcnt,
					_cf,		_ci,
		0
	};



struct SymNode dummyType_ste =
	{
					_nxt, _hash,		
		"union",		
		"union",
		0,
		NULL,		
		tVariant, 
		cType,		
					_pc,		
		0,	0,			
					_ofs,		
		"dummyType",		
		0,		
					_x,		_arity,		
					_dims, 		_numel, 	_flds,		_base,
					_fldcnt,
					_cf,		_ci,
		0
	};



struct SymNode variant_ste =
	{
					_nxt, _hash,		
		"variant",		
		"variant",
		0,
					_typ,		
		tVariant, 
		cParm,		
					_pc,		
		4,	4,			
					_ofs,		_stnam,		_lex,		_x,		_arity,		
					_dims, 		_numel, 	_flds,		_base,
					_fldcnt,
					_cf,		_ci,
		0
	};







/* 
** special address for undefined symbols 
*/

struct	SymNode UndefinedType = 
	{
					_nxt, _hash,		
		" UNDEF ",		
		" UNDEF ",
		0,
					_typ,		
		tBoolean, 
		cConstant,		
					_pc,		
		1,	1,			
					_ofs,		_stnam,		_lex,		_x,		_arity,		
					_dims, 		_numel, 	_flds,		_base,
					_fldcnt,
					_cf,		_ci,
		0
	};




struct  SymNode dummy_ste	=	
	{
					&false_ste, _hash,		
		" dummy ",		
		" dummy ",
		0,
					&boolean_ste,		
		tBoolean, 
		cConstant,		
					_pc,		
		1,	1,			
					_ofs,		_stnam,		_lex,		_x,		_arity,		
					_dims, 		_numel, 	_flds,		_base,
					_fldcnt,
					_cf,		_ci,
		1
	};







 /*
 ** This is a dummy symbol table entry used to
 ** *temporarily* mark the end of a list of fields
 ** in a record or union.
 */
 
struct  SymNode dummyField_ste	=	
	{
					NULL, _hash,		
		" dummyfield ",		
		" dummyfield ",
		0,
					&boolean_ste,		
		tBoolean, 
		cConstant,		
					_pc,		
		0,	0,			
					_ofs,		_stnam,		_lex,		_x,		_arity,		
					_dims, 		_numel, 	_flds,		_base,
					_fldcnt,
					_cf,		_ci,
		0
	};





static void PrintItem
( 
	enum	ClassType	TheClass, 
	struct	SymNode		*TheType, 
	struct	SymNode		TheValue,
	int					NumElements,
	int					Arity,
	int 				*Dimensions
);



// strcpylc- This function does three things:
//
//	(1) copies the src string to the destination string,
//	(2) converts upper case to lower case (and "_" to $7f),
//	(3) computes the hash value for the identifier.
//	(4) returns the length of the string (plus one, to include
//		the zero terminating byte).
//
//	Not a good design from a software engineering perspective,
//	but this is an assembly routine designed to compute this
//  as rapidly as possible (so it does all of the above concurrently).

extern int strcpylc( char *dest, char *src, int *hash );






/********************************************/
/*                                          */
/* GetBaseType                              */
/*                                          */
/* This function determines the base type   */
/* of an object.  If the object's type is   */
/* an isomorphism or an array, the base     */
/* type is returned; otherwise the original */
/* type is returned.                        */
/*                                          */
/********************************************/

struct SymNode*

GetBaseType( struct SymNode *typ )
_begin( GetBaseType )

	assert( typ != NULL );
	_forever

		_breakif( typ->Type == NULL );
		_breakif( typ->pType == tPointer && typ->Type->pType == tArray );

		typ = typ->Type;

	_endfor
	return typ;

_end( GetBaseType )







/********************************************************************/
/*                                                                  */
/* InsertSym-                                                       */
/*                                                                  */
/* Inserts a new (at this lex level, anyway) symbol into the symbol */
/* table. Used for consts, vals, types, and vars.                   */
/*                                                                  */
/********************************************************************/


struct SymNode *
InsertSym
(
	char			 *Name,
	struct	SymNode  *TheType,
	enum	PrimType pType,
	int				 TheClass,
	int				 Arity,
	int				 *Dimensions,
	int				 NumElements,
	union	YYSTYPE  *TheValue,
	unsigned		 ObjectSize,
	int				 CurOffset,
	char			 *StaticName,
	struct	SymNode	 *Base,
	struct	SymNode	 *Fields,
	int				 FieldCnt
)
_begin( InsertSym )

	struct SymNode	*NewEntry;
	struct SymNode	*lastHash;
	char			*lcName;
	int				hash;
	int				length;
	
	
	assert( Name != NULL );
	
	NewEntry = malloc2( sizeofSymNode );
	
	length = strlen( Name ) + 1;
	lcName = malloc2( length );
	strcpylc( lcName, Name, &hash );

	/*
	** Okay, set up the other fields for this symbol table entry.
	*/

	NewEntry->Next 			= SymbolTable;
	NewEntry->h.hashList	= NULL;
	NewEntry->Name 			= lcName;
	NewEntry->TrueName 		= Name;
	NewEntry->NameLen		= length;
	NewEntry->Type 			= TheType;
	NewEntry->pType			= pType;
	NewEntry->SymClass		= TheClass;
	NewEntry->pClass		= none_pc;
	NewEntry->LexLevel		= CurLexLevel;
	NewEntry->Arity			= Arity;
	NewEntry->Dimensions	= Dimensions;
	NewEntry->NumElements	= NumElements;
	NewEntry->ObjectSize	= ObjectSize;
	NewEntry->MaxObjectSize	= ObjectSize;  // Caller has to fill this in!
	NewEntry->Offset		= CurOffset;
	NewEntry->StaticName	= StaticName;
	NewEntry->Base			= Base;
	NewEntry->Fields		= Fields;
	NewEntry->FieldCnt		= FieldCnt;
	NewEntry->IsExternal	= 0;
	NewEntry->IsReferenced	= NULL;
	NewEntry->CurField		= NULL;			// Caller has to fill this in!
	NewEntry->CurIndex		= 0;			// Caller has to fill this in!

	_if( TheValue != NULL )
	
		memcpy
		( 
			&NewEntry->u.StartOfValues, 
			&TheValue->v.u.StartOfValues, 
			sizeof( union ValuesSize ) 
		);
		
	_endif
	
	 
	SymbolTable = NewEntry;
 
	// If we're inserting symbols into a namespace, add this
	// symbol to the hash table.
	
	_if( currentNS != NULL )
	
		lastHash = currentNS->u.hashTable[ hash ];
		_if( lastHash != NULL )
		
			// Insert new symbol at the front of the hash list.
		
			NewEntry->h.hashList = lastHash;
			currentNS->u.hashTable[ hash ] = NewEntry;			
		
		_else
		
			// Create a new hash list using this symbol:
			
			currentNS->u.hashTable[ hash ] = NewEntry;
			
		_endif

	_endif
	_return SymbolTable;

	
_end( InsertSym )



/***********************************************************************/
/*                                                                     */
/* SetSym-                                                             */
/*                                                                     */
/* Used to change the value of an existing symbol in the symbol table. */
/* This is used for Val objects.                                       */
/*                                                                     */
/***********************************************************************/

void
SetSym
(
	struct	SymNode	 *Name,
	struct	SymNode  *TheType,
	enum	PrimType pType,
	int				 Arity,
	int				 *Dimensions,
	int				 NumElements,
	union	YYSTYPE  *TheValue,
	unsigned		 ObjectSize,
	int				 CurOffset,
	char			 *StaticName,
	struct	SymNode	 *Base,

	struct	SymNode	 *Fields,
	int				 FieldCnt,
	struct	SymNode	 *CurField,
	int				 CurIndex
)
_begin( SetSym )

	assert( Name != NULL );
	
	/*
	** Okay, the value and the symbol are two different objects.
	** Now make sure that we are actually redefining a Val object.
	*/
	
	_if( Name->SymClass != cValue )

		yyerror( "Attempt to redefine a non-value identifier" );

	_else

		/*
		** First, clean up the current object.
		** If it's a string, we need to free the memory allocated
		** to the string data; if it's an array, we need to free
		** the storage allocated for the array;  if it's an array
		** of strings, we need to free the storage associated with
		** each string in the array as well as the array of pointers
		** to each string.
		*/

		FreeValue( YYS Name );


		/*
		** Okay, set up the other fields for this symbol table entry.
		*/

		Name->Type 			= TheType;
		Name->pType			= pType;
		Name->SymClass		= cValue;
		Name->pClass		= none_pc;
		Name->LexLevel		= CurLexLevel;
		Name->Arity			= Arity;
		Name->Dimensions	= Dimensions;
		Name->NumElements	= NumElements;
		Name->ObjectSize	= ObjectSize;
		Name->MaxObjectSize	= ObjectSize;  // If different, caller must set.
		Name->Offset		= CurOffset;
		Name->StaticName	= StaticName;
		Name->Base			= Base;
		Name->Fields		= Fields;
		Name->FieldCnt		= FieldCnt;
		Name->CurField		= CurField;
		Name->CurIndex		= CurIndex;
		_if( TheValue != NULL )
		
			memcpy
			( 
				&Name->u.StartOfValues, 
				&TheValue->v.u.StartOfValues, 
				sizeof( union ValuesSize ) 
			);
			
		_endif

	_endif


_end( SetSym )



/****************************************************/
/*                                                  */
/* ClrObject-                                       */
/*                                                  */
/* The "object" parameter specifies an object type. */
/* This function returns a pointer to an instance   */
/* of that object.                                  */
/*                                                  */
/* If the object is a record, this function will    */
/* allocate (non-static) storage for each field and */
/* clear out each field as well.                    */
/*                                                  */
/* If the object is a string, this function will    */
/* allocate storage for an empty string.            */
/*                                                  */
/* All other types are simply initialized with the  */
/* value zero.                                      */
/*                                                  */
/****************************************************/

static void
ClrObject( struct SymNode *ClrThis )
_begin( ClrObject )

	assert( ClrThis != NULL );

	/*
	** Create a zero'd scalar object, record, array,
	** or an empty string.
	*/

	_if( IsStr( ClrThis->pType ))

		ClrThis->u.strval = hlastrdup( "" );

	_elseif( ClrThis->pType == tRecord )

		struct	SymNode		*CurField;
		struct	SymNode		*FieldData;

		
		_if( IsConstant( ClrThis->SymClass ))
		
			FreeValue( YYS ClrThis );
			
		_endif
		
		/*
		** Create storage for all the fields in this record
		** and initialize them as appropriate.  Note that
		** the field list contains the fields in a backwards
		** order whereas the FieldData array contains them
		** in the proper order (which is why we can't merge
		** the union and record code together).
		*/
		
		CurField = ClrThis->Fields;
		FieldData = malloc2( ClrThis->FieldCnt * sizeofSymNode );
		_for( int i = ClrThis->FieldCnt - 1, i >= 0 , --i )
		
			memcpy( &FieldData[i], CurField, sizeofSymNode );
			ClrObject( &FieldData[i] );
			CurField = CurField->Next;
			
		_endfor
		ClrThis->u.FieldValues = FieldData;



	_elseif( ClrThis->pType == tUnion )

		struct	SymNode		*CurField;
		struct	SymNode		*FieldData;

		
		_if( IsConstant( ClrThis->SymClass ))
		
			FreeValue( YYS ClrThis );
			
		_endif
		
		/*
		** Create storage for all the fields in this union

		** and initialize them as appropriate.  Unlike records,
		** both the field list and the FieldData array arrange
		** the fields in the reverse order.
		*/
		
		CurField = ClrThis->Fields;
		FieldData = malloc2( ClrThis->FieldCnt * sizeofSymNode );
		_for( int i=0, i < ClrThis->FieldCnt, ++i )
		
			memcpy( &FieldData[i], CurField, sizeofSymNode );
			ClrObject( &FieldData[i] );
			CurField = CurField->Next;
			
		_endfor
		ClrThis->u.FieldValues = FieldData;


	_elseif( ClrThis->pType == tArray )

		/*
		** Create storage for all the elements of this array
		** and initialize them all to appropriate values.
		*/

		struct	SymNode	*ArrayData;

		ArrayData = malloc2( ClrThis->NumElements * sizeofSymNode );
		memcpy( ArrayData, ClrThis->Type, sizeofSymNode );
		ClrObject( ArrayData );
		ArrayData[0].Type = ClrThis->Type;
		ArrayData[0].pType = ClrThis->Type->pType;

		_for( int i=1, i < ClrThis->NumElements, ++i )

			DeepCopy( &ArrayData[ i ], ArrayData );

		_endfor
		ClrThis->u.ArrayOfValues = ArrayData;			

	_else

		memset( &ClrThis->u.StartOfValues, '\0', sizeof( union ValuesSize ));

	_endif
				
_end( ClrObject )



/*********************************************************************/
/*                                                                   */
/* ClrNewSym-                                                        */
/*                                                                   */
/* Just like InsertSym except this one doesn't get passed a value to */
/* assign to the symbol.  Instead, this procedure zeros out the      */
/* symbol's value.                                                   */
/*                                                                   */
/*********************************************************************/

void
ClrNewSym
(
	char			 *Name,
	struct	SymNode  *TheType,
	enum	PrimType pType,
	int				 TheClass,
	int				 Arity,
	int				 *Dimensions,
	int				 NumElements,
	unsigned		 ObjectSize,
	int				 CurOffset,
	char			 *StaticName,
	struct	SymNode	 *Base,
	struct	SymNode	 *Fields,
	int				 FieldCnt,
	struct	SymNode	 *CurField,
	int				 CurIndex
)
_begin( ClrNewSym )

	struct	SymNode	*NewEntry;
	struct	SymNode	*lastHash;
	char			*LCName;
	int				length;
	int				hash;
	
	assert( Name != NULL );
	
	NewEntry 	= malloc2( sizeofSymNode );
	length		= strlen( Name ) + 1; 
	LCName		= malloc2( length );
	strcpylc( LCName, Name, &hash );
	
	/*
	** Okay, set up the other fields for this symbol table entry.
	*/

	NewEntry->Next 			= SymbolTable;
	NewEntry->h.hashList	= NULL;
	NewEntry->Name 			= LCName;
	NewEntry->TrueName 		= Name;
	NewEntry->NameLen		= length;
	NewEntry->Type 			= TheType;
	NewEntry->pType			= pType;
	NewEntry->SymClass		= TheClass;
	NewEntry->pClass		= none_pc;
	NewEntry->LexLevel		= CurLexLevel;
	NewEntry->Arity			= Arity;
	NewEntry->Dimensions	= Dimensions;
	NewEntry->NumElements	= NumElements;
	NewEntry->ObjectSize	= ObjectSize;
	NewEntry->MaxObjectSize	= ObjectSize;  // Caller must set if different.
	NewEntry->Offset		= CurOffset;
	NewEntry->StaticName	= StaticName;
	NewEntry->Base			= Base;
	NewEntry->Fields		= Fields;
	NewEntry->FieldCnt		= FieldCnt;
	NewEntry->IsExternal	= 0;
	NewEntry->IsReferenced	= NULL;
	NewEntry->CurField		= CurField;
	NewEntry->CurIndex		= CurIndex;

	ClrObject( NewEntry );
		
	
		
	SymbolTable = NewEntry;
 
	// If we're inserting symbols into a namespace, add this
	// symbol to the hash table.
	
	_if( currentNS != NULL )

		lastHash = currentNS->u.hashTable[ hash ];
		_if( lastHash != NULL )
		
			// Insert new symbol at the front of the hash list.
		
			NewEntry->h.hashList = lastHash;
			currentNS->u.hashTable[ hash ] = NewEntry;			
		
		_else
		
			// Create a new hash list using this symbol:
			
			currentNS->u.hashTable[ hash ] = NewEntry;
			
		_endif
		
	_endif
		
	
_end( ClrNewSym )





void
ClrSym
(
	struct	SymNode	 *Name,
	struct	SymNode  *TheType,
	enum	PrimType pType,
	int				 Arity,
	int				 *Dimensions,
	int				 NumElements,
	unsigned		 ObjectSize,
	int				 CurOffset,
	char			 *StaticName,
	struct	SymNode	 *Base,
	struct	SymNode	 *Fields,
	int				 FieldCnt,
	struct	SymNode	 *CurField,
	int				 CurIndex
)
_begin( ClrSym )

	assert( Name != NULL );
	/*
	** Okay, the value and the symbol are two different objects.
	** Now make sure that we are actually redefining a Val object.
	*/
	
	_if( Name->SymClass != cValue )

		yyerror( "Attempt to redefine a non-value identifier" );

	_else

		/*
		** First, clean up the current object.
		** If it's a string, we need to free the memory allocated
		** to the string data; if it's an array, we need to free
		** the storage allocated for the array;  if it's an array
		** of strings, we need to free the storage associated with
		** each string in the array as well as the array of pointers
		** to each string.
		*/
		
		FreeValue( YYS Name );


		/*
		** Okay, set up the other fields for this symbol table entry.
		*/

		Name->Type 			= TheType;
		Name->pType			= pType;
		Name->SymClass		= cValue;
		Name->pClass		= none_pc;
		Name->LexLevel		= CurLexLevel;
		Name->Arity			= Arity;
		Name->Dimensions	= Dimensions;
		Name->NumElements	= NumElements;
		Name->ObjectSize	= ObjectSize;
		Name->MaxObjectSize	= ObjectSize;  //Caller must set if different
		Name->Offset		= CurOffset;
		Name->StaticName	= StaticName;
		Name->Base			= Base;
		Name->Fields		= Fields;
		Name->FieldCnt		= FieldCnt;
		Name->CurField		= CurField;
		Name->CurIndex		= CurIndex;
		ClrObject( Name );

	_endif


_end( ClrSym )





	 


/************************************************************/
/*                                                          */
/* InsertProc-                                              */
/*                                                          */
/* Inserts a procedure identifier into the symbol table.    */
/* Primarily, this function exists to avoid passing so many */
/* parameters to InsertSym.                                 */
/*                                                          */
/************************************************************/


void
InsertProc
(
	char	*Name,
	char	*StaticName
)
_begin( InsertProc )

	struct SymNode *lastHash;
	struct SymNode *NewEntry;
	char			*lcName;
	int				hash;
	int				length;
	
	
	assert( Name != NULL );
	
	length = strlen( Name ) + 1;
	lcName = malloc2( length );
	strcpylc( lcName, Name, &hash );
	
	NewEntry 				= malloc2( sizeofSymNode );

	NewEntry->Next 			= SymbolTable;
	NewEntry->h.hashList	= NULL;
	NewEntry->Name 			= lcName;
	NewEntry->TrueName 		= hlastrdup2( Name );
	NewEntry->NameLen		= length;
	NewEntry->Type 			= &procID_ste;
	NewEntry->pType			= tProc;
	NewEntry->SymClass		= cProc;
	NewEntry->pClass		= none_pc;
	NewEntry->LexLevel		= CurLexLevel;
	NewEntry->IsExternal	= 0;
	NewEntry->IsReferenced	= NULL;
	NewEntry->Arity			= 0;
	NewEntry->Dimensions	= NULL;
	NewEntry->NumElements	= 0;
	NewEntry->ObjectSize	= 0;
	NewEntry->MaxObjectSize	= 0;
	NewEntry->Offset		= 0;
	NewEntry->StaticName	= StaticName;
	NewEntry->Fields		= NULL;
	NewEntry->FieldCnt		= 0;
	NewEntry->CurField		= NULL;
	NewEntry->CurIndex		= 0;
	NewEntry->u.proc.Locals	= NULL;
	NewEntry->u.proc.returns	= "";
	NewEntry->u.proc.BaseClass= NULL;
	NewEntry->u.proc.ParmSize = 0;

	memset( &NewEntry->u.StartOfValues, 0, sizeof( union ValuesSize ));

	
	
	SymbolTable = NewEntry;
 
	// If we're inserting symbols into a namespace, add this
	// symbol to the hash table.

	_if( currentNS != NULL )
	
		lastHash = currentNS->u.hashTable[ hash ];
		_if( lastHash != NULL )					   
		
			// Insert new symbol at the front of the hash list.
		
			NewEntry->h.hashList = lastHash;
			currentNS->u.hashTable[ hash ] = NewEntry;			
		
		_else
		
			// Create a new hash list using this symbol:
			
			currentNS->u.hashTable[ hash ] = NewEntry;
			
		_endif

	_endif
		

_end( InsertProc )




/********************************************************************/
/*                                                                	*/
/* MacroLookup-                                                   	*/
/*                                                                	*/
/* Searches through all the active macros' formal parameter lists 	*/
/* to see if the symbol passed as a parameter matches a parameter 	*/
/* name.  								                          	*/
/*																  	*/
/* src-			True name (upper and lower case) of symbol to find.	*/
/* lcSrc-		Name in lower case form.						  	*/
/*                                                                	*/
/********************************************************************/

struct SymNode *SearchNextb
(
	struct SymNode	*s, 
	char 			*n, 
	int 			len, 
	struct SymNode	*NameSpace
)
{
	struct SymNode	*cur;
	
	cur = s;
	_do
	
		cur = SearchNext( cur, n, len );
		_breakif( cur == NULL );
		_breakif
		(
					(
							cur->SymClass != cTerminator 
						&&	cur->SymClass != cKeyword
					)
				||	cur->u.MacroData.NameSpace == NameSpace 
		);
		cur = cur->Next;
		
	_until( cur == NULL)
	_return cur;
}


static struct SymNode*
MacroLookup
( 
	char			*src, 
	char			*lcSrc, 
	struct SymNode	*ActList, 
	struct SymNode	*NameSpace,
	int				hash 
)
_begin( MacroLookup )

	struct SymNode	*cur;
	int				MPindex;
	char			msg[ 256 ];


	/*
	** For each active macro (from the most recently activated down
	** the the first activated macro), search through its list of
	** formal parameters, locals, and macros to see if the current 
	** symbol matches one of the local symbols.
	*/

	_while( ActList != NULL )


		/*
		** Point "cur" at the first symbol in the current active
		** macro's lists of local objects.
		*/

		cur =
			_ifx
			( 
				ActList->u.MacroData.Terminator != NULL,
				ActList->u.MacroData.Terminator,
				_ifx
				(
					ActList->u.MacroData.Locals != NULL,
					ActList->u.MacroData.Locals,
					ActList->u.MacroData.Parameters
				)
			);

		 
		/*
		** For each macro, local symbol, or parameter in the 
		** current active macro, see if that symbol matches 
		** the current string.
		*/

		cur = SearchNextb( cur, lcSrc, strlen( lcSrc ) + 1, NameSpace );
		
		/*
		** If we had a match, cur will not be NULL.
		*/

		_if( cur != NULL )

			/*
			** Enforce type neutrality.  That is, the name must
			** match using both a case insensitive comparison and
			** a case sensitive comparison.
			*/

			_if( _strne( src, cur->TrueName))
		
				sprintf
				( 
					msg, 
					"Mispelled identifier: '%s',\n"
					"perhaps you meant '%s'", 
					src,
					cur->TrueName
				);
				yyerror( msg );

			_endif
			_return cur;
			
		_else

			/*
			** If there was no match with this particular macro's
			** list of local symbols, see if this macro has a parent
			** and try the parent's list.
			*/

			_if
			( 
					ActList->u.MacroData.Parent != NULL
				&&	ActList->u.MacroData.Parent->u.MacroData.Text == NULL
			)

				/*
				** Note: we have to trick MacroLookup (recursive call below)
				** into thinking that it is okay to access locals and
				** parameters in the parent's symbol list.  Temporarily
				** setting the Text field to a non-NULL value (which we
				** must restore when we're done) will accomplish
				** this.
				*/
				
						char	*SaveText;
				struct	SymNode	*SaveNext;

				SaveText = ActList->u.MacroData.Parent->u.MacroData.Text;
				ActList->u.MacroData.Parent->u.MacroData.Text = 
					ActList->u.MacroData.Text;
				
				/*
				** Set the Parent's Next field to NULL to prevent searching
				** beyond the parent's local symbol list (see the IF statement
				** above for the NULL test).
				*/

				SaveNext = ActList->u.MacroData.Parent->Next;
				ActList->u.MacroData.Parent->Next = NULL;

				/*
				** Okay, search for the symbol in the parent's local list.
				*/

				cur = 
					MacroLookup
					( 
						src, 
						lcSrc, 
						ActList->u.MacroData.Parent,
						NameSpace,
						hash 
					);

				/*
				** Restore the parent's text pointer to NULL.
				*/

				ActList->u.MacroData.Parent->Next = SaveNext;
				ActList->u.MacroData.Parent->u.MacroData.Text = SaveText;

				/*
				** If we found the symbol, we're done.
				*/



				_returnif( cur != NULL ) cur;

			_endif

		_endif

		/*
		** If we didn't match the current symbol, try the next
		** macro object in the Active Macro List.
		*/

		ActList = ActList->Next;

	_endwhile
	_return NULL;

_end( MacroLookup )





/***********************************************************************/
/*                                                                     */
/* lookup-                                                             */
/*                                                                     */
/* Looks up a symbol in the symbol table.  Returns NULL if the symbol  */
/* is not present in the table, returns a pointer to the symbol table  */
/* entry if it finds the symbol.  Does a case insensitive search, but  */
/* then compares the actual identifier against the true name to ensure */
/* case neutrality.  Reports an error if the user attempts to look up  */
/* a symbol and finds it doing a case insensitive search but the case  */
/* sensitive comparison fails.                                         */
/*                                                                     */
/***********************************************************************/

struct SymNode*
SearchNexta(struct SymNode	*s, char *n, int len )
{
	_here;
	_return SearchNext( s, n, len );
}

struct SymNode	*SearchHasha(struct SymNode	*s, char *n, int len)
{
	
	_here;
	_return SearchHash( s, n, len );
}

static struct SymNode*
rawlookup( char *src, int doCaseTest, char *lcName, int length, int hash )
_begin( rawlookup )

	struct SymNode	*cur;
	char			msg[256];

	_here;
	assert( src != NULL );
	assert( lcName != NULL );
	

	_here;
	
	/*
	** Okay, we didn't find the symbol in the list of active macro
	** parameters, so do a linear search (yuck!) for the symbol in 
	** the standard table.  *UNLESS* we're in a namespace, then
	** do a hashed lookup.
	*/

	_if( currentNS == NULL )

		// We're not processing a namespace, so just do a straight
		// linear search.

		cur = SearchNexta( SymbolTable, lcName, length );
		
	_elseif( inClass || inUnion || inRecord )

		// Special case when processing records, unions, or classes
		// within a namespace. Do a global lookup first and see if the
		// symbol exists, then do a local lookup if it does. This speeds
		// up the case where we're entering brand new symbols into a
		// class or union, without creating performance problems associated
		// with always doing a linear search (particularly for w.hhf).

		cur = SearchHasha( currentNS->u.hashTable[ hash ], lcName, length );
		_if( cur != NULL )

			cur = SearchNexta( SymbolTable, lcName, length );

		_endif

	_else
	
	
		// We're processing stuff in a namespace, do a hashed
		// lookup to speed things up a bit.  Note that
		// currentNS points at a hash table containing 256
		// entries.
		
		cur = SearchHasha( currentNS->u.hashTable[ hash ], lcName, length );

	_endif

	/*
	** Enforce type neutrality.  That is, the name must
	** match using both a case insensitive comparison and
	** a case sensitive comparison.  Note that we should
	** only produce an error if the two symbols are at
	** the same lex level (i.e., local symbols can be spelled
	** differently than global symbols).
	*/

	_if( cur != NULL )

		// Okay, we've found the symbol in the symbol table.
		// Now let's check to see if the case is the same
		// for both identifiers:

		_if( _strne( src, cur->TrueName ))

			_if( doCaseTest )
		
				// The case is not the same and we're checking for this.  

				sprintf
				( 
					msg, 
					"Mispelled identifier: '%s',\n"
					"perhaps you meant '%s'", 
					src,
					cur->TrueName

				);

				yyerror( msg );

			_endif

		_endif

		
	_else
	
		/*
		** If we didn't find the symbol, the reason might be that
		** we searching through the limited symbol table of a
		** class procedure or method.  If this is the case then
		** ThisPtr will contain a non-NULL value.  In that event,
		** we need to make a recursive call to see if this symbol
		** is a field of the current procedure's class.
		*/

		_if( ThisPtr != NULL )

			struct SymNode *SaveSN;

			SaveSN = SymbolTable;
			SymbolTable = ThisPtr;
			ThisPtr = NULL;
			cur = lookup( src, doCaseTest );
			_if( cur != NULL && _strne( src, cur->TrueName ))
			
				sprintf
				( 
					msg, 
					"Mispelled identifier: '%s',\n"
					"perhaps you meant '%s'", 
					src,
					cur->TrueName
				);
				yyerror( msg );
				
			_endif

			ThisPtr = SymbolTable;
			SymbolTable = SaveSN;
		
		
		/*
		** Another reason we may have choked:
		** We were searching through the field list of a record
		** and couldn't find the symbol in that fieldlist (e.g.,
		** one of the field's type is a user-defined type outside
		** the fieldlist).
		*/
			
		_elseif( RecGlobal != NULL )
		
			struct SymNode *saveSym;
			struct SymNode *saveRecNS;
			struct SymNode *saveRecGlobal;
			struct SymNode *saveCurNS;

			saveSym = SymbolTable;
			saveRecGlobal = RecGlobal;
			saveRecNS = RecNS;
			saveCurNS = currentNS;

			SymbolTable = RecGlobal;
			currentNS = RecNS;
			RecGlobal = NULL;
			RecNS = NULL;

			cur = lookup( src, doCaseTest );
			_if( cur != NULL && _strne( src, cur->TrueName ))
			
				sprintf
				( 
					msg, 
					"Mispelled identifier: '%s',\n"
					"perhaps you meant '%s'", 
					src,
					cur->TrueName
				);
				yyerror( msg );
				
			_endif
			
			SymbolTable = saveSym;
			RecGlobal = saveRecGlobal;
			RecNS = saveRecNS;
			currentNS = saveCurNS;

		_elseif( ProcGlobal != NULL )
		
			struct SymNode *saveSym;
			struct SymNode *saveProcNS;
			struct SymNode *saveProcGlobal;
			struct SymNode *saveCurNS;

			saveSym = SymbolTable;
			saveProcGlobal = ProcGlobal;
			saveProcNS = ProcNS;
			saveCurNS = currentNS;

			SymbolTable = ProcGlobal;
			currentNS = ProcNS;
			ProcGlobal = NULL;
			ProcNS = NULL;

			cur = lookup( src, doCaseTest );
			_if( cur != NULL && _strne( src, cur->TrueName ))
			
				sprintf
				( 
					msg, 
					"Mispelled identifier: '%s',\n"
					"perhaps you meant '%s'", 
					src,
					cur->TrueName
				);
				yyerror( msg );
				
			_endif
			
			SymbolTable = saveSym;
			ProcGlobal = saveProcGlobal;
			ProcNS = saveProcNS;
			currentNS = saveCurNS;

		_endif
		
	_endif
	_return cur;

_end( rawlookup )



struct SymNode*
lookup( char *src, int doCaseTest )
_begin( lookup )

	struct SymNode	*cur;
	char			msg[256];
	char			lcName[256];
	int				length;
	int				hash;

	_here;
	assert( src != NULL );
	
	length = strcpylc( lcName, src, &hash ) + 1;
	/*
	** Before searching for the symbol in the symbol table,
	** check to see if this symbol matches a formal macro parameter.
	** If so, use the active macro parameter definition rather than
	** the standard symbol table entry.
	*/

	cur = MacroLookup( src, lcName, ActiveMacros, NULL, hash );

	_if( cur == NULL ) 
	
		cur = rawlookup( src, doCaseTest, lcName, length, hash );
		
	_endif
	_return cur;

_end( lookup )



struct SymNode*
NSlookup( char *src, int doCaseTest, struct SymNode *NameSpace )
_begin( NSlookup )

	struct SymNode	*cur;
	char			msg[256];
	char			lcName[256];
	int				length;
	int				hash;

	_here;
	assert( src != NULL );
	
	length = strcpylc( lcName, src, &hash ) + 1;
	
	/*
	** Unlike lookup, we don't process macro names here.
	** This is because we're currently processing a portion
	** of a namespace identifier and we don't want to expand
	** components of the namespace ID.
	*/
	
	cur = MacroLookup( src, lcName, ActiveMacros, NameSpace, hash );

	_returnif( cur == NULL ) rawlookup( src, doCaseTest, lcName, length, hash );
	_return cur;

_end( NSlookup )



/***************************************************/
/*                                                 */
/* lookupin                                        */
/*                                                 */
/* Looks up a symbol in the specified symbol table */
/* rather than searching through the standard      */
/* symbol table.                                   */
/*                                                 */
/***************************************************/


struct SymNode*
lookupin( char *src, struct SymNode *table )
_begin( lookupin )

	struct	SymNode	*SaveSymTable;
	struct	SymNode	*result;
	struct	SymNode *saveCurNS;


	SaveSymTable = SymbolTable;
	SymbolTable = table;
	saveCurNS = currentNS;
	currentNS = NULL;
	result = lookup( src, 1 );
	SymbolTable = SaveSymTable;
	currentNS = saveCurNS;
	_return result;

_end( lookupin )












/********************************************************************************************************/
/*                                                                                                      */
/* ClassifyLookup-                                                                                      */
/*                                                                                                      */
/* Looks up a symbol in the symbol table.  Returns NULL if the symbol                                   */
/* is not present in the table, returns a pointer to the symbol table                                   */
/* entry if it finds the symbol.  Does a case insensitive search, but                                   */
/* then compares the actual identifier against the true name to ensure                                  */
/* case neutrality.  Reports an error if the user attempts to look up                                   */
/* a symbol and finds it doing a case insensitive search but the case                                   */
/* sensitive comparison fails.                                                                          */
/*                                                                                                      */
/* This particular function handles record and class identifiers                                        */
/* (i.e., those with interior periods) as well as standard IDs.                                         */
/*                                                                                                      */
/********************************************************************************************************/




struct SymNode*
ClassifyLookup( char *src, struct SymNode *table )
_begin( ClassifyLookup )

	char			*dotPosn;
	struct	SymNode	*rtnResult;
	char			LeftID[ 256 ];


	_here;
	assert( src != NULL );

	/*
	** See if this name contains any periods.  If it does,
	** extract the identifier before the first period:
	*/

	dotPosn = strchr( src, '.' );
	_if( dotPosn == NULL )

		rtnResult = lookupin( src, table );
		/*
		** If we didn't find the symbol, and we're currently
		** in a namespace, search the global symbol table.
		*/
		
		_if( rtnResult == NULL && NSGlobal != NULL )
		
			rtnResult = lookupin( src, NSGlobal );
			
		_endif

	_else

		/*
		** Okay, we've got a dotted name.  Look up the identifier
		** to the left of the dotted name.  If it is defined and
		** it's a record, union, or class object, then recursively
		** call ClassifyLookup to look up the rest of the symbol.
		**
		** Note: we need a special case to handle the "THIS" prefix.
		** Alas, the recursive nature of this code won't handle
		** interior "this" IDs properly (they're illegal and
		** this should generate an error), but we will return an
		** undefined ID if this occurs, so that's not too bad.
		*/

		strncpy( LeftID, src, dotPosn-src );
		LeftID[ dotPosn-src ] = '\0';
		_if( stricmp( LeftID, "this" ) == 0 )
		
			rtnResult = ThisPtr;

		

		_else // It's not "this"
		
			rtnResult = lookupin( LeftID, table );

		_endif
		_if( rtnResult != NULL )

			/*
			** First, check to see if this is a TEXT object.
			** If so, reconstruct the ID using the text expansion
			** and look the whole symbol up again.
			*/



			_if( rtnResult->pType == tText )

				strcpy( LeftID, rtnResult->u.strval );
				strcat( LeftID, dotPosn );
				rtnResult = ClassifyLookup( LeftID, table );

			_elseif( rtnResult->Fields != NULL )

				rtnResult = ClassifyLookup( dotPosn+1, rtnResult->Fields );

			_else

				rtnResult = NULL;

			_endif

		_endif
		

	_endif
	_if( rtnResult != NULL && rtnResult->IsReferenced != NULL)
	
		rtnResult->IsReferenced->ForceRef = 1;
		
	_endif
	_return rtnResult;
	
_end( ClassifyLookup )








/**********************************************************************/
/* *************************************************************      */
/* *  ************  Symbol Table Output routines  **************	  */
/* *************************************************************      */
/**********************************************************************/



/******************************************************************/
/*                                                                */
/* PrintIndent-                                                   */
/*                                                                */
/* Prints a set of spaces corresponding to one indentation in the */
/* symbol table output.  The symbol table output routines indent  */
/* names that belong to procedures, records, classes, and other   */
/* container objects.                                             */
/*                                                                */
/******************************************************************/

static void
PrintIndent( int indent )
_begin( PrintIndent )

	_while( indent-- > 0 )

		fprintf( MsgOut, "    " );

	_endwhile

_end( PrintIndent )


/*************************************************************/
/*                                                           */
/* PrintDimensions-                                          */
/*                                                           */
/* For array objects, PrintDimensions prints out the bracket */
/* list of bounds for each of the array's dimensions.        */
/*                                                           */
/*************************************************************/

static void
PrintDimensions
(
	int	Arity,
	int	*Dimensions
)
_begin( PrintDimensions )

	assert( Dimensions != NULL );
	assert( Arity > 0 );
	
	fprintf( MsgOut, "[" );
	_for( int i=0, i < Arity-1, ++i )

		fprintf( MsgOut, "%d,", Dimensions[i] );

	_endfor
	fprintf( MsgOut, "%d] ", Dimensions[ Arity - 1 ] );

_end( PrintDimensions )






/*************************************************************/
/*                                                           */
/* PrintSize-                                                */
/*                                                           */
/* Prints the size of an object, in bytes.  If the object is */
/* a variable, it also prints its offset.  If the object is  */
/* a static variable, this code also prints its mapped name. */
/*                                                           */
/*************************************************************/
	   
static void
PrintSize
( 
	struct	SymNode	*Sym 
)
_begin( PrintSize )

	fprintf
	( 
		MsgOut,
		"(%d bytes", 
		Sym->ObjectSize
	);
	_if( Sym->SymClass == cVar )

		fprintf( MsgOut, ", ofs:%d", Sym->Offset );

	_elseif( Sym->SymClass == cParm )

		_if( Sym->StaticName == NULL )

			fprintf( MsgOut, ", ofs:%d", Sym->Offset );

		_else

			fprintf( MsgOut, ", reg:%s", Sym->StaticName );

		_endif

	_elseif( Sym->StaticName != NULL )
			
		fprintf
		( 
			MsgOut, 
			", ID='%s' ref:%d", 
			Sym->StaticName, 
			_ifx( Sym->IsReferenced != NULL, Sym->IsReferenced->ForceRef, 0 ) 
		);

	_endif
	fprintf( MsgOut, ") ");

_end( PrintSize )



/**************************************************************/
/*                                                            */
/* PrintValues-                                               */
/*                                                            */
/* Prints the value(s) associated with a symbol table object. */
/*                                                            */
/**************************************************************/

void
PrintValues
( 
	struct	SymNode		*Value
)
_begin( PrintValues )

		assert( Value != NULL );

		_switch( Value->pType )

			_case( tBoolean )

				fprintf
				( 
					MsgOut,
					"%s", 
					_ifx( Value->u.boolval, "true", "false" )
				);
				
			_endcase
			 
			_case( tEnum )
			_case( tUns8 )
			_case( tUns16 )
			_case( tUns32 )
			
				fprintf
				( 
					MsgOut,
					"%lu", 
					Value->u.unsval
				);

			_endcase
			
			_case( tUns64 )
			_case( tUns128 )
			{
				char buf[128];
				
				UnsToStr( buf, &Value->u.lwordval[0] );
				fprintf( MsgOut, "%s", buf );
				
			}
			_endcase
			
			 
			_case( tByte )
			
				fprintf
				( 
					MsgOut,
					"$%02x", 
					Value->u.unsval & 0xff
				);

			_endcase
			 
			_case( tWord )
			
				fprintf
				( 
					MsgOut,
					"$%04x", 
					Value->u.unsval & 0xffff
				);

			_endcase
			 
			_case( tDWord )
			
				fprintf
				( 
					MsgOut,
					"$%04x_%04x", 
					(Value->u.lwordval[0] >> 16) & 0xffff,
					Value->u.lwordval[0] & 0xffff
				);

			_endcase
			
			
			_case( tQWord )
				
				fprintf
				( 
					MsgOut, 
					"$%04x_%04x_%04x_%04x", 
					(Value->u.lwordval[1] >> 16) & 0xffff,
					Value->u.lwordval[1] & 0xffff,
					(Value->u.lwordval[0] >> 16) & 0xffff,
					Value->u.lwordval[0] & 0xffff
				);
				
			_endcase
			
			_case( tTByte )
				
				fprintf
				( 
					MsgOut, 
					"$%04x_%04x_%04x_%04x_%04x", 
					Value->u.lwordval[2] & 0xFFFF,
					(Value->u.lwordval[1] >> 16) & 0xffff,
					Value->u.lwordval[1] & 0xffff,
					(Value->u.lwordval[0] >> 16) & 0xffff,
					Value->u.lwordval[0] & 0xffff
				);
				
			_endcase
			
			_case( tLWord )
				
				fprintf
				( 
					MsgOut, 
					"$%04x_%04x_%04x_%04x_%04x_%04x_%04x_%04x", 
					(Value->u.lwordval[3] >> 16) & 0xffff,
					Value->u.lwordval[3] & 0xffff,
					(Value->u.lwordval[2] >> 16) & 0xffff,
					Value->u.lwordval[2] & 0xffff,
					(Value->u.lwordval[1] >> 16) & 0xffff,
					Value->u.lwordval[1] & 0xffff,
					(Value->u.lwordval[0] >> 16) & 0xffff,
					Value->u.lwordval[0] & 0xffff
				);
				
			_endcase
			
			 
			_case( tInt8 )
			_case( tInt16 )
			_case( tInt32 )
			
				fprintf
				( 
					MsgOut,
					"%ld", 
					Value->u.intval
				);

			_endcase
			 
			_case( tInt64 )
			_case( tInt128 )
			{
				char buf[128];
				
				IntToStr( buf, &Value->u.lwordval[0] );
				fprintf( MsgOut, "%s", buf );
				
			}
			_endcase
			
			 
			_case( tChar ) 
			_case( tWChar ) 
			
				/*
				** If it's a printable character, then print it.
				** If it's not a printable character, print it using
				** hexadecimal notation.
				*/
				
				_if( Value->u.charval >= 0x20 && Value->u.unsval <= 0x7f )
				
					fprintf
					( 
						MsgOut,
						"'%c'", 
						Value->u.charval
					);

				_else

					fprintf
					( 
						MsgOut,
						"#$%02x", 
						Value->u.charval
					);

				_endif


			_endcase
			 
			_case( tReal32 )
			
				fprintf
				( 
					MsgOut,
					"%e", 
					(double) *((float *) &Value->u.fltval)
				);
				
			_endcase
			
			_case( tReal64 ) 
			
				fprintf
				( 
					MsgOut,
					"%e", 
					*((double *) &Value->u.fltval)
				);
				
			_endcase
			
			_case( tReal80 )
			{
				char buf[128];
			
				e80Str( buf, Value->u.fltval );
				fprintf( MsgOut, "%s", buf );


			}
			_endcase
			 
			_case( tString )
			_case( tZString )
			_case( tText )
			{
				char *s = Value->u.strval;
				
				assert( s != NULL );
				
				fprintf( MsgOut, "\"" );
				_while( *s != '\0' )
				
					_if( *s != '"' )
					
						/*
						** if the character is printable, go ahead and
						** print it, if not, print it in hexadecimal
						** notation.
						*/
						
						_if( isgraph( *s ) || *s == ' ' )
						
							fprintf
							( 
								MsgOut,
								"%c", 
								*s
							);

						_elseif( *(s+1) != '\0' )

							/*
							** If this is not the last character, put
							** quotes around the hex representation.
							*/
							
							fprintf
							( 
								MsgOut,
								"\"#$%02x\"", 
								*s
							);
							
						_else

							/*
							** If this is the last character, do not put
							** the terminating quotation mark.
							*/
							
							fprintf
							( 
								MsgOut,
								"\"#$%02x", 
								*s
							);
							
						_endif
						
					_else
						
						/*
						** Print quotes as a pair of quotes.
						*/
						
						fprintf( MsgOut, "\"\"" );
						
					_endif
					++s;
				
				_endwhile
				
				/*
				** If the last character was printable, or this is
				** the empty string, close the string by printing
				** a quote.
				*/
				
				_if( s == Value->u.strval	|| isgraph( *(s-1) ) || *(s-1) == ' ' )
				
					fprintf( MsgOut, "\"" );
					
				_endif
			}
			_endcase

			 
			_case( tWString )
			{
				unsigned short *s = (unsigned short *) Value->u.strval;
				
				assert( s != NULL );
				
				fprintf( MsgOut, "\"" );
				_while( *s != 0 )
				
					_if( *s != '"' )
					
						/*
						** if the character is printable, go ahead and
						** print it, if not, print it in hexadecimal
						** notation.
						*/
						
						_if( *s >= 0x20 && *s < 0x7f )
						
							fprintf
							( 
								MsgOut,
								"%c", 
								*s
							);

						_elseif( *(s+1) != '\0' )

							/*
							** If this is not the last character, put
							** quotes around the hex representation.
							*/
							
							fprintf
							( 
								MsgOut,
								"\"#$%02x\"", 
								*s
							);
							
						_else

							/*
							** If this is the last character, do not put
							** the terminating quotation mark.
							*/
							
							fprintf
							( 
								MsgOut,
								"\"#$%02x", 
								*s
							);
							
						_endif
						
					_else
						
						/*
						** Print quotes as a pair of quotes.
						*/
						
						fprintf( MsgOut, "\"\"" );
						
					_endif
					++s;
				
				_endwhile
				
				/*
				** If the last character was printable, or this is
				** the empty string, close the string by printing
				** a quote.
				*/
				
				_if
				( 
						s == (unsigned short *) Value->u.strval	
					||	( *(s-1) >= 0x20 && *(s-1) < 0x7f ) 
				)
				
					fprintf( MsgOut, "\"" );
					
				_endif
			}
			_endcase



			_case( tPointer )

				fprintf( MsgOut, "%s", Value->u.strval );

			_endcase


			_case( tRegex )

				dumpRegex( Value->u.rx );
				fprintf( MsgOut, "\n" ); 

			_endcase				

			 
			_case( tCset )
			{
				char ch = 0;
				char cscopy[ CSetSizeInBytes ];
				int	 inStr = 0;
				int	 First = 1;

				memcpy
				( 
					cscopy, 
					Value->u.csetval, 
					CSetSizeInBytes 
				);

				fprintf( MsgOut, "{" );
				
				/*
				** For each byte in the array of bytes making up the cset:
				*/
				
				_for( int i=0, i < CSetSizeInBytes, ++i )

					/*
					** For each bit in the byte.
					*/
					
					_for( int j=0, j < 8, ++j )

						/*
						** Is char(i) in the set?
						*/
						
						_if( cscopy[ i ] & 1 )

							/*
							** Is this a control character or a printable
							** char?
							*/
							
							_if( isgraph( ch ) || ch == ' ' )
							
								/*
								** If it's printable, determine if this is
								** the first thing in the set, if so,
								** precede the entry with a comma.  In either
								** case, begin the string with an apostrophe
								*/
								 
								_if( !inStr )
								
									fprintf
									( 
										MsgOut, 
										"%s\"", 
										_ifx( First,"", "," )
									);
									inStr = 1;
									First = 0;


								_endif
								fprintf( MsgOut, "%c", ch );

							_else

								/*
								** Non-printing character here.  If we're
								** currently processing a string, then
								** first terminate that string with an
								** apostrophe. If this is not the first
								** object we're printing, precede it by
								** a comma.  Finally, print the object
								** in hexadecimal notation.
								*/
								
								_if( inStr )

									fprintf( MsgOut, "\"" );
									inStr = 0;

								_endif
								fprintf
								( 
									MsgOut, 
									"%s#$%x", 
									_ifx( First,"","," ),ch 
								);
								First = 0;

							_endif
							
						_endif
						++ch;
						cscopy[i] >>= 1;

					_endfor

				_endfor
				
				/*
				** At the end of the cset, if we're inside some character
				** string, print the terminating apostrophe.
				*/
				
				_if( inStr )

					fprintf( MsgOut, "\"" );

				_endif
				fprintf( MsgOut, "}" );
			}						
			_endcase

			_case( tArray )

				/*
				** Print the elements of an array by making a
				** recursive call to this PrintValues function
				** for each element of the array.  This code
				** prints the last element as a special case
				** to ease the placement of commas in the array list.
				*/
				
				fprintf( MsgOut, "[" );
				_for( int i=0, i < Value->NumElements-1, ++i )

					PrintValues
					( 
						&Value->u.ArrayOfValues[i]
					);
					fprintf( MsgOut, "," );
					
				_endfor

				_if( Value->NumElements >= 1 )

					PrintValues
					( 
						&Value->u.ArrayOfValues[ Value->NumElements - 1 ] 
					);

				_endif
				fprintf( MsgOut, "]" );
				 
			_endcase

			_case( tRecord )

				/*
				** Print the fields of a record by making a
				** recursive call to this PrintValues function
				** for each field of the record.  Note that
				** DumpFields requires that we print the last
				** field (first item in list) ourselves.
				*/

				assert( Value != NULL );
				assert( Value->TrueName != NULL );
				assert( Value->Fields != NULL );
				
				fprintf( MsgOut, "%s:[", Value->TrueName );
				DumpFields
				( 
					Value->Fields, 
					Value->u.FieldValues,
					0 
				);
				
				fprintf( MsgOut, "]" );
				
			_endcase


			_case( tUnion )
			{
				struct	SymNode		*field;

				/*
				** Print the single data object associated with
				** the union constant.
				*/

				assert( Value != NULL );
				assert( Value->Type != NULL );
				assert( Value->CurField != NULL );				
				assert( Value->u.FieldValues != NULL );
				fprintf
				( 
					MsgOut, 
					"%s.%s:[", 
					Value->Type->TrueName, 
					Value->CurField->TrueName 
				);
				PrintValues( &Value->u.FieldValues[ Value->CurIndex] );
				fprintf( MsgOut, "]" );
				
				
			}
			_endcase

			_default

				fprintf( MsgOut, "Unknown value!" );

		_endswitch
		
_end( PrintValues )


/****************************************************************/
/*                                                              */
/* DumpFields-                                                  */
/*                                                              */
/* This (recursive) function prints the fields of a record in   */
/* reverse order.  Its prints them this way because they are    */
/* stored in the symbol table in reverse order (and reversing   */
/* them twice prints them in the correct order).                */
/*                                                              */
/* Type is a pointer to the last field in the record.           */
/* Value is a pointer to the last data object for               */
/* the record.                                                  */
/*                                                              */
/****************************************************************/

void
DumpFields( struct SymNode *Type, struct SymNode *Value, int comma )
_begin( DumpFields )

	int		fldToPrt;
	struct	SymNode	*s;
	struct	SymNode	*v;

	_returnif( Type == NULL );

	// Anonymous records are a real kludge.  Handle them specially here:
	
	_if( Value->pType == tAnonUnion )
	
		// The Value->CurIndex field contains the anon union field
		// whose data we're supposed to print.  The Value->CurField
		// field points at the field entry for this item.
		//
		// Point s at the value for this field.
		
		fldToPrt = Value->CurIndex;
		v = Value;
		s = Value + fldToPrt;
				
		// Okay, scan beyond the end of the anon union fields:
		
		++Value;
		Type = Type->Next;
		_while( Value->pType != tAnonUnion )
		
			++Value;
			Type = Type->Next;
			assert( Type != NULL );
			
		_endwhile
		
		// Dump the preceding fields first:
		
		DumpFields( Type->Next, &Value[1], 1 );
		
		// Dump the selected union field:
		
		fprintf( MsgOut, "union.%s[", v->CurField->TrueName );
		PrintValues( s );
		fprintf( MsgOut, "]" );
		
		// If this is not the last item in the list, print
		// a comma after the value.
		
		_if( comma )
		
			fprintf( MsgOut, "," );		
			
		_endif
	
	_else	// Just a regular record field, print it:
		
		
		// Print preceding fields in the record first.
		
		DumpFields( Type->Next, &Value[1], 1 );
		
		// Now print the current value:
		
		PrintValues
		( 
			Value 
		);
		
		// If this is not the last item in the list, print
		// a comma after the value.
		
		_if( comma )
		
			fprintf( MsgOut, "," );
			
		_endif
		
	_endif

_end( DumpFields )







/*****************************/
/*                           */
/* DumpSym-                  */
/*                           */
/* Displays the symbol table */
/*                           */
/*****************************/

#define notgraphic(c) (!isgraph(c) && (c) != ' ')


void
DumpSym
( 
	struct SymNode *SymbolTable, 
	int indent 
)
_begin( DumpSym )

	
	// Dump the symbol table:

	_while( SymbolTable != NULL )

		/*
		** Handle the built-in symbol table entries in a special manner.
		** (Don't bother printing them at all unless debugging the code).
		*/

		_if
		( 
				(
						IsPrimitive( SymbolTable->pType) 
					||	SymbolTable->pType == tPointer
					||	SymbolTable->pType == tThunk
					||	SymbolTable->pType == tRegex
				)
			&&	SymbolTable->Type == NULL 
			&&	SymbolTable->pType != tEnum
		)

			#ifdef DontPrintPrimitiveItems
				fprintf
				(
					MsgOut, 
					"%-10s:<primitive>(%2d)\n", 
					SymbolTable->Name,
					SymbolTable->SymClass 
				);
			#endif

		_else
		
			// Kludge to unindent anonrecord and anonunion fields:
			
			_if
			( 
					(
							SymbolTable->pType == tAnonUnion
						||	SymbolTable->pType == tAnonRec
					)							
				&&	*(SymbolTable->TrueName) != 'E' )
			
				--indent;
				
			_endif
		
			PrintIndent( indent );
			fprintf
			( 
				MsgOut,
				"%-15s <%d,", 
				SymbolTable->TrueName,
				SymbolTable->LexLevel
			);
			_switch( SymbolTable->SymClass )
			
				_case( cConstant )
				
					fprintf( MsgOut, "cons" );
					
				_endcase
				
				_case( cValue )
				
					fprintf( MsgOut, "val " );
					
				_endcase
				
				_case( cType )
				
					fprintf( MsgOut, "type" );
					
				_endcase
				
				_case( cVar )
				
					fprintf( MsgOut, "var " );
					
				_endcase
				
				_case( cParm )

					_switch( SymbolTable->pClass )

						_case( valp_pc )

							fprintf( MsgOut, "valp" );

						_endcase

						_case( refp_pc )

							fprintf( MsgOut, "refp" );

						_endcase

						_case( vrp_pc )

							fprintf( MsgOut, "vrp " );

						_endcase


						_case( result_pc )

							fprintf( MsgOut, "resp" );

						_endcase

						_case( name_pc )

							fprintf( MsgOut, "namp" );

						_endcase

						_case( lazy_pc )

							fprintf( MsgOut, "lazp" );

						_endcase
						
						_case( none_pc )
						
							fprintf( MsgOut, "none" );

						_default

							fprintf( MsgOut, "prm?" );

					_endswitch
					
				_endcase
				

				_case( cStatic )
				
					fprintf( MsgOut, "stat" );
					
				_endcase
				
				_case( cMacro )
				
					fprintf( MsgOut, "macr" );
					
				_endcase
				
				_case( cRegex )
				
					fprintf( MsgOut, "regx" );
					
				_endcase
				
				_case( cKeyword )
				
					fprintf( MsgOut, "keyw" );
					
				_endcase
					
				
				_case( cTerminator )
				
					fprintf( MsgOut, "term" );
					
				_endcase
				
				_case( cProgram )
				
					fprintf( MsgOut, "prgm" );
					
				_endcase
				
				_case( cProc )
				
					fprintf( MsgOut, "proc" );
					
				_endcase

				_case( cIterator )
				
					fprintf( MsgOut, "iter" );
					
				_endcase

				_case( cClassProc )
				
					fprintf( MsgOut, "clpr" );
					
				_endcase

				_case( cClassIter )
				
					fprintf( MsgOut, "clit" );
					
				_endcase

				_case( cMethod )
				
					fprintf( MsgOut, "mthd" );
					
				_endcase

				_case( cNamespace )

					fprintf( MsgOut, "name " );

				_endcase

				_case( cSegment )

					fprintf( MsgOut, "seg " );

				_endcase

				_case( cLabel )

					fprintf( MsgOut, "labl" );

				_endcase
				
				_default
				
					fprintf( MsgOut, "????" );
					
			_endswitch
			fprintf( MsgOut, ">:" );
			_switch( SymbolTable->pType )


				_case( tBoolean ) 
				_case( tEnum )
				_case( tUns8 )
				_case( tUns16 )
				_case( tUns32 )
				_case( tUns64 )
				_case( tUns128 )
				_case( tByte )
				_case( tWord )
				_case( tDWord )
				_case( tQWord )
				_case( tTByte )
				_case( tLWord )
				_case( tInt8 )
				_case( tInt16 )
				_case( tInt32 )
				_case( tInt64 )
				_case( tInt128 )
				_case( tReal32 )
				_case( tReal64 ) 
				_case( tReal80 )
				_case( tChar ) 
				_case( tWChar ) 
				_case( tString )
				_case( tZString )
				_case( tWString )
				_case( tText )
				_case( tCset )

					fprintf
					( 
						MsgOut,
						"%s, ",
						_ifx
						(
							SymbolTable->Type == NULL,
							"enum",
							SymbolTable->Type->TrueName
						)
					);
					PrintSize( SymbolTable );
					_if
					( 
							SymbolTable->SymClass == cValue 
						||	SymbolTable->SymClass == cConstant
					)
						fprintf( MsgOut, " =" );
						PrintValues
						( 
							SymbolTable
						);

					_endif

				_endcase

				_case( tArray )

					fprintf( MsgOut, "%s", SymbolTable->Type->TrueName );
					PrintDimensions
					( 
						SymbolTable->Arity, 
						SymbolTable->Dimensions 
					);
					PrintSize( SymbolTable );
					_if
					( 
							SymbolTable->SymClass == cValue 
						||	SymbolTable->SymClass == cConstant
					)
						fprintf( MsgOut, " =" );
						PrintValues
						( 
							SymbolTable
						);

					_endif

				_endcase

				_case( tRecord )

					fprintf( MsgOut, "Record " );
					PrintSize( SymbolTable );
					_if
					( 
							SymbolTable->SymClass == cValue 
						||	SymbolTable->SymClass == cConstant
					)

						assert( SymbolTable->Type != NULL );
						assert( SymbolTable->Fields != NULL );

						/*
						** If this item has a base record, print its
						** name too.
						*/

						_if( SymbolTable->Base != NULL )

							fprintf
							( 
								MsgOut,
								"(%s) ", 
								SymbolTable->Base->TrueName 
							);

						_endif
						
						fprintf
						( 
							MsgOut,
							"= %s:[", 
							SymbolTable->Type->TrueName 
						);

						
						/*
						** Print all but the last field:
						*/

						DumpFields
						( 
							SymbolTable->Fields, 

							SymbolTable->u.FieldValues,
							0 
						);
						
						fprintf( MsgOut, "]" );
						

					_else

						_if( SymbolTable->Base != NULL )

							fprintf
							( 
								MsgOut,
								"(%s) ", 
								SymbolTable->Base->TrueName 
							);

						_endif
						fprintf( MsgOut, "\n" );
						PrintIndent( indent+1 );
						fprintf
						( 
							MsgOut, 
							"--------------------------------\n" 
						);
						DumpSym( SymbolTable->Fields, indent+1 );
						PrintIndent( indent );
						fprintf
						( 
							MsgOut,
							"------------------------------------" 
						);

					_endif

				_endcase

				_case( tUnion )

					fprintf( MsgOut, "Union " );
					PrintSize( SymbolTable );
					_if
					( 
							SymbolTable->SymClass == cValue 
						||	SymbolTable->SymClass == cConstant
					)
						fprintf( MsgOut, " = " );
						PrintValues
						( 
							SymbolTable
						);

					_else

						fprintf( MsgOut, "\n" );
						PrintIndent( indent+1 );
						fprintf
						( 
							MsgOut,
							"--------------------------------\n" 
						);
						DumpSym( SymbolTable->Fields, indent+1 );
						PrintIndent( indent );
						fprintf
						( 
							MsgOut, 
							"------------------------------------" 
						);
						
					_endif

				_endcase

				_case( tPointer )

					_if( SymbolTable->SymClass == cConstant )

						fprintf
						(
							MsgOut,
							"ptr to %s ",
							_ifx
							(
								SymbolTable->u.strval == NULL,
								"<Undefined>",
								SymbolTable->u.strval
							)
						);

					_else

						fprintf
						( 
							MsgOut,
							"ptr to %s ", 
							_ifx
							(
								SymbolTable->Base == NULL,
								"<Undefined>",
								SymbolTable->Base->TrueName
							)
						);

					_endif
					PrintSize( SymbolTable );

				_endcase

				
				_case( tThunk )

					fprintf( MsgOut, "Thunk, " );
					PrintSize( SymbolTable );

				_endcase


				_case( tClass )

					fprintf( MsgOut, "Class" );

					/*
					** If this item has a base class, print its
					** name too.
					*/

					_if( SymbolTable->Type != NULL )

						fprintf
						( 
							MsgOut, 
							"(%s) ", 
							SymbolTable->Type->TrueName 
						);
						
					_endif
					PrintSize( SymbolTable );
					fprintf( MsgOut, "\n" );
					PrintIndent( indent+1 );
					fprintf( MsgOut, "--------------------------------\n" );
					DumpSym( SymbolTable->Fields, indent+1 );
					PrintIndent( indent );
					fprintf( MsgOut, "------------------------------------" );

				_endcase

				_case( tProcptr )
				{
					struct SymNode *s;
					struct SymNode *restore;
					char   *TheType = "ProcPtr";

					_if( SymbolTable->Type != NULL )

						/*
						** If this is not a "base" procedure
						** type (i.e., the user has declared a named type
						** and has defined an object using that name)
						** then just print the type name.
						*/
						
						fprintf
						( 
							MsgOut, 
							"%s, ", 
							SymbolTable->Type->TrueName 
						);
						PrintSize( SymbolTable );

					_else

						/*
						** If this is a base procedure type (i.e., a type
						** definition or a direct variable declaration)
						** then print the parameters for this procedure type.
						*/

						restore = SymbolTable;
						s = SymbolTable->u.proc.parms;

						/*
						** Must NULL terminate the entry that points at
						** the current symbol table entry.
						*/

						_while( s != NULL && s->Next != SymbolTable )

							s = s->Next;

						_endwhile
						_if( s != NULL )

							s->Next = NULL;

						_endif

						_if( SymbolTable->u.proc.parms != NULL )

							fprintf( MsgOut, "%s, ", TheType );
							PrintSize( SymbolTable );
							fprintf
							( 
								MsgOut, 
								" parms:%d\n", 
								SymbolTable->u.proc.ParmSize 
							);
							PrintIndent( indent+1 );
							fprintf
							( 
								MsgOut,
								"--------------------------------\n" 
							);
							DumpSym( SymbolTable->u.proc.parms, indent+1 );
							PrintIndent( indent );
							fprintf
							( 
								MsgOut,
								"------------------------------------" 
							);

						_endif
						SymbolTable = restore;

					_endif

				}
				_endcase

				_case( tProc )
				{
					struct SymNode *s;
					struct SymNode *restore = SymbolTable;

					s =	_ifx
						( 
							SymbolTable->u.proc.Locals != NULL,
							SymbolTable->u.proc.Locals,
							SymbolTable->u.proc.parms
						);
					/*
					** Must NULL terminate the entry that points at
					** the current symbol table entry.
					*/

					_while( s != NULL && s->Next != SymbolTable )

						s = s->Next;

					_endwhile
					_if( s != NULL )

						s->Next = NULL;

					_endif

					_if( SymbolTable->u.proc.Locals != NULL )

						fprintf( MsgOut, "Procedure type" );
						_if( SymbolTable->StaticName != NULL )

							fprintf
							( 
								MsgOut, 
								" (ID=%s)", SymbolTable->StaticName 
							);

						_endif
						fprintf
						( 
							MsgOut, 
							" parms:%d\n", 
							SymbolTable->u.proc.ParmSize 
						);
						PrintIndent( indent+1 );
						fprintf
						( 
							MsgOut, 
							"--------------------------------\n" 
						);
						DumpSym( SymbolTable->u.proc.Locals, indent+1 );
						PrintIndent( indent );
						fprintf
						( 
							MsgOut,
							"------------------------------------" 
						);

					_endif
					SymbolTable = restore;

				}
				_endcase

				_case( tIterator )
				{
					struct SymNode *s;
					struct SymNode *restore = SymbolTable;

					s =	_ifx
						( 
							SymbolTable->u.proc.Locals != NULL,
							SymbolTable->u.proc.Locals,
							SymbolTable->u.proc.parms
						);
					/*
					** Must NULL terminate the entry that points at
					** the current symbol table entry.
					*/

					_while( s != NULL && s->Next != SymbolTable )

						s = s->Next;

					_endwhile
					_if( s != NULL )

						s->Next = NULL;

					_endif

					_if( SymbolTable->u.proc.Locals != NULL )

						fprintf( MsgOut, "Iterator type" );
						_if( SymbolTable->StaticName != NULL )

							fprintf
							( 
								MsgOut, 
								" (ID=%s)", SymbolTable->StaticName 
							);

						_endif
						fprintf
						( 
							MsgOut, 
							" parms:%d\n", 
							SymbolTable->u.proc.ParmSize 
						);
						PrintIndent( indent+1 );
						fprintf
						( 
							MsgOut, 
							"--------------------------------\n" 
						);
						DumpSym( SymbolTable->u.proc.Locals, indent+1 );
						PrintIndent( indent );
						fprintf
						( 
							MsgOut,
							"------------------------------------" 
						);

					_endif
					SymbolTable = restore;

				}
				_endcase

				_case( tClassProc )
				{
					struct SymNode *s = SymbolTable->u.proc.Locals;
					struct SymNode *restore = SymbolTable;

					/*
					** Must NULL terminate the entry that points at
					** the current symbol table entry.
					*/

					_while( s != NULL && s->Next != SymbolTable )

						s = s->Next;

					_endwhile
					_if( s != NULL )

						s->Next = NULL;

					_endif

					_if( SymbolTable->u.proc.Locals != NULL )

						fprintf( MsgOut, "Class Procedure type" );
						_if( SymbolTable->StaticName != NULL )

							fprintf
							( 
								MsgOut, 
								" (ID=%s)", 
								SymbolTable->StaticName 
							);

						_endif
						fprintf
						( 
							MsgOut, 
							" parms:%d\n", 
							SymbolTable->u.proc.ParmSize 
						);
						PrintIndent( indent+1 );
						fprintf
						( 
							MsgOut,
							"--------------------------------\n" 
						);
						DumpSym( SymbolTable->u.proc.Locals, indent+1 );
						PrintIndent( indent );
						fprintf
						( 
							MsgOut, 
							"------------------------------------" 
						);

					_endif
					SymbolTable = restore;

				}
				_endcase


				_case( tClassIter )
				{
					struct SymNode *s = SymbolTable->u.proc.Locals;
					struct SymNode *restore = SymbolTable;

					/*
					** Must NULL terminate the entry that points at
					** the current symbol table entry.
					*/

					_while( s != NULL && s->Next != SymbolTable )

						s = s->Next;

					_endwhile
					_if( s != NULL )

						s->Next = NULL;

					_endif

					_if( SymbolTable->u.proc.Locals != NULL )

						fprintf( MsgOut, "Class Iterator type" );
						_if( SymbolTable->StaticName != NULL )

							fprintf
							( 
								MsgOut, 
								" (ID=%s ofs=%d)", 
								SymbolTable->StaticName,
								SymbolTable->Offset
							);

						_endif
						fprintf
						( 
							MsgOut, 
							" parms:%d\n", 
							SymbolTable->u.proc.ParmSize 
						);
						PrintIndent( indent+1 );
						fprintf
						( 
							MsgOut,
							"--------------------------------\n" 
						);
						DumpSym( SymbolTable->u.proc.Locals, indent+1 );
						PrintIndent( indent );
						fprintf
						( 
							MsgOut, 
							"------------------------------------" 
						);

					_endif
					SymbolTable = restore;

				}
				_endcase

				_case( tMethod )
				{
					struct SymNode *s = SymbolTable->u.proc.Locals;
					struct SymNode *restore = SymbolTable;

					/*
					** Must NULL terminate the entry that points at
					** the current symbol table entry.
					*/

					_while( s != NULL && s->Next != SymbolTable )

						s = s->Next;

					_endwhile
					_if( s != NULL )

						s->Next = NULL;

					_endif

					_if( SymbolTable->u.proc.Locals != NULL )

						fprintf( MsgOut, "Method type" );
						_if( SymbolTable->StaticName != NULL )

							fprintf
							( 
								MsgOut, 
								" (ID=%s ofs=%d)", 
								SymbolTable->StaticName,
								SymbolTable->Offset
							);

						_endif
						fprintf
						( 
							MsgOut, 
							" parms:%d\n", 
							SymbolTable->u.proc.ParmSize 
						);
						PrintIndent( indent+1 );
						fprintf
						( 
							MsgOut,
							"--------------------------------\n" 
						);
						DumpSym( SymbolTable->u.proc.Locals, indent+1 );
						PrintIndent( indent );
						fprintf
						( 
							MsgOut,
							"------------------------------------" 
						);

					_endif
					SymbolTable = restore;

				}
				_endcase

				_case( tNamespace )
				{
					struct SymNode *restore = SymbolTable;

					_if( SymbolTable->Fields != NULL )

						fprintf( MsgOut, "Name Space\n" );
						PrintIndent( indent+1 );
						fprintf
						( 
							MsgOut,
							"--------------------------------\n" 
						);
						DumpSym( SymbolTable->Fields, indent+1 );
						PrintIndent( indent );
						fprintf
						( 
							MsgOut,
							"------------------------------------" 
						);

					_endif
					SymbolTable = restore;

				}
				_endcase

				_case( tSegment )
				{
					fprintf
					( 
						MsgOut, 
						"Segment( %s, \"%s\" )\n",
						SymbolTable->StaticName,
						SymbolTable->u.strval 
					);
				}
				_endcase

				_case( tAnonRec )

					fprintf( MsgOut, "Anon Rec, " );
					PrintSize( SymbolTable );
					_if( *(SymbolTable->TrueName) == 'E' )
					
						++indent;
						
					_endif

				_endcase


				_case( tAnonUnion )

					fprintf( MsgOut, "Anon Union, " );
					PrintSize( SymbolTable );
					_if( *(SymbolTable->TrueName) == 'E' )
					
						++indent;
						
					_endif

				_endcase





				_case( tProgram )

					fprintf( MsgOut, "Program Identifier" );

				_endcase


				_case( tLabel )

					fprintf
					( 
						MsgOut,
						"Statement Label = %s", 
						SymbolTable->StaticName 
					);
					_if( SymbolTable->Type == NULL )

						fprintf( MsgOut, " (undefined)" );

					_endif

				_endcase


				_case( tRegexMac )
				{
					struct SymNode *s = SymbolTable->u.MacroData.Locals;
					
					_here;
					_if( s == NULL )
					
						s = SymbolTable->u.MacroData.Parameters;
						
					_endif

					fprintf( MsgOut, "Regex identifier\n" );
					_if( s != NULL )

						PrintIndent( indent+1 );
						fprintf
						( 
							MsgOut,
							"--------------------------------\n" 
						);
						DumpSym
						( 
							s, 
							indent+1 
						);

						
					_endif

					PrintIndent( indent );
					fprintf
					( 
						MsgOut,
						"------------------------------------" 
					);
					fprintf
					(
						MsgOut,
						"%s\n^^^^^^^^^regex body ^^^^^^^^\n"
						"------------------------------------", 
						SymbolTable->u.MacroData.Text
					);
				}
				_endcase

				_case( tRegex )
				{
					struct SymNode *s = SymbolTable->u.MacroData.Locals;
					
					_here;
					_if( s == NULL )
					
						s = SymbolTable->u.MacroData.Parameters;
						
					_endif

					fprintf( MsgOut, "regex\n" );
					_if( s != NULL )

						PrintIndent( indent+1 );
						fprintf
						( 
							MsgOut,
							"--------------------------------\n" 
						);
						DumpSym
						( 
							s, 
							indent+1 
						);

						
					_endif

					PrintIndent( indent );
					fprintf
					( 
						MsgOut,
						"------------------------------------\n " 
					);	
					PrintIndent( indent );						
					dumpRegex( SymbolTable->u.rx );
					fprintf( MsgOut, "\n" );
					PrintIndent( indent );
					fprintf
					( 
						MsgOut,
						"------------------------------------\n " 
					);	
				}
				_endcase




				_case( tMacro )
				{
					struct SymNode *s = SymbolTable->u.MacroData.Terminator;
					
					_here;
					_if( s == NULL )
					
						s = SymbolTable->u.MacroData.Locals;
						_if( s == NULL )
						
							s = SymbolTable->u.MacroData.Parameters;
							
						_endif
						
					_endif

					fprintf( MsgOut, "Macro identifier\n" );
					_if( s != NULL )

						PrintIndent( indent+1 );
						fprintf
						( 
							MsgOut,
							"--------------------------------\n" 
						);
						DumpSym( s, indent+1 );

						
					_endif

					PrintIndent( indent );
					fprintf
					( 
						MsgOut,
						"------------------------------------" 
					);
					fprintf
					(
						MsgOut,
						"%s\n^^^^^^^^^macro body ^^^^^^^^\n"
						"------------------------------------", 
						SymbolTable->u.MacroData.Text
					);
				}
				_endcase
				
				_default

					fprintf( MsgOut, "Unknown type!" );

			_endswitch
			fprintf( MsgOut, "\n" );

		_endif
		SymbolTable = SymbolTable -> Next;

	_endwhile

_end( DumpSym )



// dumpRegex-
//
//	Disassembles and displays a regular expression data structure.

void
printRepetition( struct regexListType *r2p )
_begin( printRepetition )

	_if( !(r2p->minCnt == 1 && r2p->maxCnt == 1) )
	
		_if( r2p->minCnt == 0 && r2p->maxCnt == 0x7fffffff )
		
			fprintf( MsgOut, "*" );
			
		_elseif( r2p->minCnt == 1 && r2p->maxCnt == 0x7fffffff )
		
			fprintf( MsgOut, "+" );

		_elseif( r2p->maxCnt == 0x7fffffff )
		
			fprintf( MsgOut, ":[%d,*]", r2p->minCnt );
			
		_elseif( r2p->minCnt == r2p->maxCnt )
		
			fprintf( MsgOut, ":[%d]", r2p->minCnt );
			
		_else
		
			fprintf( MsgOut, ":[%d,%d]", r2p->minCnt, r2p->maxCnt );
			
		_endif
		
	_endif
				
_end( printRepetition )

void 
dumpRegex( struct regexListType *r2p )
_begin( dumpRegex )

	struct SymNode	*s;
	int				cnt;
	
	_if( r2p == NULL )
		
		fprintf( MsgOut, "<no regex body>\n" );
		
	_endif
	_while( r2p != NULL )
	
	
		_switch( r2p->nodeType )
		
			_case( nt_StartOfRegex )
			
				fprintf( MsgOut, "<start>" );
				
			_endcase
			
			_case( nt_iChar )
			_case( nt_iString )
			
				fprintf( MsgOut, "!" );
				PrintValues( &r2p->v );
				printRepetition( r2p );					
				
			_endcase
			
			_case( nt_notiChar )
			
				fprintf( MsgOut, "!-" );
				PrintValues( &r2p->v );
				printRepetition( r2p );					
				
			_endcase
			
			_case( nt_notiString )
			
				fprintf( MsgOut, "!-" );
				PrintValues( &r2p->v );
				
			_endcase
			
			_case( nt_notCset )
			_case( nt_notChar )
			
				fprintf( MsgOut, "-" );
				PrintValues( &r2p->v );
				printRepetition( r2p );					
				
			_endcase
			
			_case( nt_notString )
			
				fprintf( MsgOut, "-" );
				PrintValues( &r2p->v );
				
			_endcase
				
				
			_case( nt_matchWord )
			
				fprintf( MsgOut, "@matchWord( " );
				PrintValues( &r2p->v );
				fprintf( MsgOut, " )" );
				printRepetition( r2p );					
				
			_endcase
			
			_case( nt_matchiWord )
			
				fprintf( MsgOut, "@matchiWord( " );
				PrintValues( &r2p->v );
				fprintf( MsgOut, " )" );
				printRepetition( r2p );					
				
			_endcase
			
			_case( nt_ws )
			
				fprintf( MsgOut, "@ws" );
				printRepetition( r2p );					
				
			_endcase
			
			_case( nt_AnyChar )
			
				_if( r2p->lazy )
				
					fprintf( MsgOut, "@arb" );
					
				_else
				
					fprintf( MsgOut, "." );
				
				_endif
				printRepetition( r2p );					
				
			_endcase
			
			_case( nt_Cset )
			_case( nt_Char )
			_case( nt_String )
				
				PrintValues( &r2p->v );
				printRepetition( r2p );					
			
			_endcase
			
			_case( nt_List )
			
				PrintValues( &r2p->v );
			
			_endcase
			
			_case( nt_Alternative )
			
				dumpRegex( r2p->alt[0] );
				fprintf( MsgOut, " | " );
				dumpRegex( r2p->alt[1] );
			
			_endcase
			
			_case( nt_Subexpr )
			
				fprintf( MsgOut, "( " );
				dumpRegex( r2p->subexpr );
				fprintf( MsgOut, " )" );
				printRepetition( r2p );					
			
			_endcase
			
			_case( nt_match )
			
				fprintf( MsgOut, "@match( " );
				dumpRegex( r2p->subexpr );
				fprintf( MsgOut, " )" );
				printRepetition( r2p );					
			
			_endcase
			
			_case( nt_match2 )
			
				fprintf( MsgOut, "@match2( " );
				dumpRegex( r2p->subexpr );
				fprintf( MsgOut, " )" );
				printRepetition( r2p );					
			
			_endcase
			
			_case( nt_ExtractStr )
			
				fprintf( MsgOut, "< " );
				dumpRegex( r2p->subexpr );
				fprintf( MsgOut, " >:%s", r2p->id->TrueName );
				
			_endcase
			
			_case( nt_Regex )
			
				fprintf( MsgOut, "%s(",r2p->v.TrueName );
				s = r2p->v.u.MacroData.Parameters;
				_while( s != NULL )
				
					fprintf( MsgOut, "%s", s->u.strval );
					s = s->Next;
					_if( s != NULL )
					
						fprintf( MsgOut, ", " );
						
					_endif
					
				_endwhile
				fprintf( MsgOut, ")" );
				
			_endcase
			
			_case( nt_Regex2 )
			
				fprintf( MsgOut, "%s",r2p->v.TrueName );
				_if( r2p->id != NULL )
				
					fprintf( MsgOut, ":%s", r2p->id->TrueName );
					
				_endif
				
			_endcase
			
			_case( nt_EOS )
			
				fprintf( MsgOut, "@eos" );
				
			_endcase
			
			
			 		
			_case( nt_reg ) 	
			
				fprintf( MsgOut, "@reg" );
				
			_endcase
			
			_case( nt_reg8 ) 	
			
				fprintf( MsgOut, "@reg8" );
				
			_endcase
			
			_case( nt_reg16 ) 	
			
				fprintf( MsgOut, "@reg16" );
				
			_endcase
			
			_case( nt_reg32 ) 	
			
				fprintf( MsgOut, "@reg32" );
				
			_endcase
			
			_case( nt_regfpu ) 	
			
				fprintf( MsgOut, "@regfpu" );
				
			_endcase
			
			_case( nt_regmmx ) 	
			
				fprintf( MsgOut, "@regmmx" );
				
			_endcase
			
			_case( nt_regxmm ) 	
			
				fprintf( MsgOut, "@regxmm" );
				
			_endcase
			
			_case( nt_matchid )  
			
				fprintf( MsgOut, "@matchID" );
				
			_endcase
			
			_case( nt_matchInt ) 
			
				fprintf( MsgOut, "@matchIntConst" );
				
			_endcase
			
			_case( nt_matchReal )
			
				fprintf( MsgOut, "@matchRealConst" );
				
			_endcase
			
			_case( nt_matchNum ) 
			
				fprintf( MsgOut, "@matchNumericConst" );
				
			_endcase
			
			_case( nt_matchStr ) 
			
				fprintf( MsgOut, "@matchstrconst" );
				
			_endcase
			
			_case( nt_peekChar )
			_case( nt_peekStr )
			_case( nt_peekCset )
			
				fprintf( MsgOut, " / " );
				PrintValues( &r2p->v );
				printRepetition( r2p );
				
			_endcase					
			
			_case( nt_peekiChar )
			_case( nt_peekiStr )
			
				fprintf( MsgOut, " / !" );
				PrintValues( &r2p->v );
				printRepetition( r2p );
				
			_endcase
			
			_case( nt_pos )
			
				fprintf( MsgOut, "@pos(%d)", r2p->minCnt );
				
			_endcase					
			
			_case( nt_tab )
			
				fprintf( MsgOut, "@tab(%d)", r2p->minCnt );
				
			_endcase					
			
			_case( nt_at )
			
				fprintf( MsgOut, "@at:" );
				_if( r2p->id != NULL )
				
					fprintf( MsgOut, "%s", r2p->id->TrueName );
					
				_endif
				
			_endcase					
			
			_case( nt_matchAdrs )
			_case( nt_matchExpr )
			_case( nt_Balanced )

				fprintf( MsgOut, "Have to modify dumpRegx to handle this type\n" );
	
			_endcase 
			
			
			_default
			
				fprintf
				( 
					MsgOut, 
					"Unhandled regex node type (%d)\n", 
					r2p->nodeType 
				);
				
		_endswitch
		r2p = r2p->concat;
		_if( r2p != NULL )
		
			fprintf( MsgOut, ", " );
			
		_endif
			
	_endwhile
	
_end( dumpRegex )



