
#include "Str.h"

#include "set_error.h"

#include <iostream.h>

#pragma implementation

ostream & operator<< (ostream & o, const Str & s) {
	o << ((const char *)s);
	if (o.fail()) {
		set_error("BOstream << Str ","stream output failed");
	}
	return o;
}

istream & operator>> (istream & i, Str & s) {
	static char linebuf[1024];
	
	linebuf[1023] = (char)0;
	
	i.getline(linebuf, 1024);

	s = Str(linebuf);
	
	if (i.fail()) {
		set_error("istream >> Str ","stream input failed");
	}
	return i;
}


#include "Bstream.h"

BOstream & operator<< (BOstream & o, const Str & s) {
	o << s.length();
	o.write((const char *)s, (int)s.length());
	if (o.fail()) {
		set_error("BOstream << Str ","stream output failed");
	}
	return o;
}

BIstream & operator>> (BIstream & i, Str & s) {
	unsigned long l;
	i >> l;
	if (i.fail()) {
		s.fail = -1;
		add_error("BIstream >> Str ","stream input failed");
		return i;
	}
	s = Str(l);
	i.read((char *)s, l);
	if (i.fail()) {
		s.fail = -1;
		set_error("BIstream >> Str ","stream input failed");
	}
	s.fail = 0;
	return i;
}


