
#ifndef NibStr_h
#define NibStr_h

#include <Str.h>

class BIstream;
class BOstream;

class NibStr : public Str {

protected:

	bool	even;	// true => length % 2 == 0 

public:

	inline NibStr(void) : Str(), even(true) {};
	inline NibStr(int nibs) : Str((nibs+1)>>1), even((nibs & 1)? false : true) { };
	inline NibStr(const NibStr & rv) : Str(rv), even(rv.even) {};
	inline NibStr(unsigned long long value, int nibs) : Str((nibs+1)>>1),
										even((nibs & 1)? false : true) {
		poke (0, value, nibs);
	};
	inline ~NibStr(void) {};
	
	inline const NibStr & operator= (const NibStr & rv) {
		Str::operator= (rv);
		even = rv.even;
		return *this;
	}; 
	
	inline unsigned long length(void) const {
		unsigned long tmp = len * 2;
		return (even)? tmp : tmp - 1;
	};
	
	void poke (unsigned long offset, unsigned long long val, int nibs);
	unsigned long long peek( unsigned long offset, int nibs) const ;
	
	NibStr operator+ (const NibStr & rv) const;
	
	NibStr operator+= (const NibStr & rv);

	void clear (void) {
		Str::clear();
		even = true;
	};

	void insert(unsigned long offset, const NibStr & replacement);

	friend BOstream & operator<< (BOstream & out, const NibStr & n);
	friend BIstream & operator>> (BIstream & in, NibStr & n);
};

BOstream & operator<< (BOstream & out, const NibStr & n);

BIstream & operator>> (BIstream & in, NibStr & n);

#endif NibStr_h


