
#include <Bstream.h>

#include <set_error.h>

#pragma implementation

#include "object.h"

BOstream & operator<< (BOstream & out, const Symbol & sym) {
	out << sym.isfloat;
	if (sym.isfloat) {
		out << sym.fvalue;
	} else {
		out << sym.ivalue;
	}
	out << sym.name;
	out << sym.numerical;
	
	return out;
}

BIstream & operator>> (BIstream & in, Symbol & sym) {
	
	in >> sym.isfloat;
	if (sym.isfloat) {
		in >> sym.fvalue;
	} else {
		in >> sym.ivalue;
	}
	
	in >> sym.name;
	in >> sym.numerical;
	
	sym.resolved = true;
	sym.accessed = false;
	
	return in;
}

BOstream & operator<< (BOstream & out, const Reloc & r) {
	out << r.offset;
	return out;
}

BIstream & operator>> (BIstream & in, Reloc & r) {
	in >> r.offset;
	return in;
}

BOstream & operator<< (BOstream & out, const Import & i) {
	out << i.offset;
	out << i.nibsize;
	out << i.name;
	out << i.reloc_demand;
	return out;
}

BIstream & operator>> (BIstream & in, Import & i) {
	in >> i.offset;
	in >> i.nibsize;
	in >> i.name;
	in >> i.reloc_demand;
	return in;
}

BOstream & operator<< (BOstream & out, const ObjectFile & of) {

	out << (unsigned long) 0x434c4c44;

	out << of.name;
	out << of.relocs;
	out << of.imports;
	out << of.exports;
	
	out << of.shared;
	
	out << of.body;

	return out;
}

BIstream & operator>> (BIstream & in, ObjectFile & of) {
	
	of.fail = -1;
	
	unsigned long magic;
	in >> magic;
	if (in.fail() || magic != 0x434c4c44) {
		set_error("BIstream >> ObjectFile ","invalid data from stream");
		return in;
	}
	
	in >> of.name;
	if (of.name.fail) {
		add_error("BIstream >> ObjectFile ","invalid data from stream");
		return in;
	}
	
	in >> of.relocs;
	in >> of.imports;
	in >> of.exports;
	
	in >> of.shared;
	
	in >> of.body;
		
	of.used = false;
	
	if (in.fail()) {
		set_error("BIstream >> ObjectFile ","invalid data from stream");
		return in;
	}
	
	of.fail = 0;
	
	return in;
}

