/* $Id: saturn.h,v 1.29 1995/06/30 21:39:55 alex Exp $ */

/* Definitions of target machine for GNU compiler.  Saturn version.
   This port, done by Alex T. Ramos <ramos@engr.latech.edu> in 1994,
   is the first 4-bit port of GNU CC.

   Copyright (C) 1987, 1988, 1992 Free Software Foundation, Inc.

This file is part of GNU CC.

GNU CC is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU CC; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#define CPP_PREDEFINES "-Dsaturn -Asystem(hp48) -Acpu(saturn) -Amachine(hp48)"
#define TARGET_VERSION fprintf (stderr, " (saturn-hp-hp48, CLASS assembler)");

/* Run-time compilation parameters selecting different hardware subsets.  */

extern int target_flags;

#define TARGET_REGPARM			(target_flags & 8)

#define TARGET_SWITCHES						\
{   {"reg-parms", 8},		 {"stack-parms", -8},		\
    { "", 8} } 

extern  char	*saturn_add_unroll;

#define TARGET_OPTIONS \
{ { "unroll-adds-above-", &saturn_add_unroll } }


/* Target machine storage layout */

/* Define this if most significant bit is lowest numbered
   in instructions that operate on numbered bit-fields. */
#define BITS_BIG_ENDIAN 0

/* Define this if most significant byte of a word is the lowest numbered.  */
#define BYTES_BIG_ENDIAN 0

/* Define this if most significant word of a multiword number is numbered.  */
#define WORDS_BIG_ENDIAN 0

#define BITS_PER_WORD 64	/* width of a machine register */
#define BITS_PER_UNIT 4		/* width of a memory location */
#define BITS_PER_FLOAT_BYTE 8
#define Rmode 	      TImode
#define Pmode 	      PDImode
#define FUNCTION_MODE QImode
#define CASE_VECTOR_MODE PDImode


#define MAX_FIXED_MODE_SIZE 64

#define CHAR_TYPE_SIZE	8	/* HImode */
#define SHORT_TYPE_SIZE 16
#define INT_TYPE_SIZE 	32
#define POINTER_SIZE 	32	/* PDImode - 20 bits used */
#define LONG_TYPE_SIZE 	32	/* DImode */
#define LONG_LONG_TYPE_SIZE 64	/* TImode */

/* Width of a word, in units (bytes).  */
#define UNITS_PER_WORD 16


/* Allocation boundary (in *bits*) for storing pointers in memory.  */
#define POINTER_BOUNDARY 4

/* Allocation boundary (in *bits*) for storing arguments in argument list.  */
#define PARM_BOUNDARY 64   /* not 4, because of bug in expr.c line 2234 */
/* expr.c:2234:
         int offset = partial % (PARM_BOUNDARY / BITS_PER_WORD); */


/* Allocation boundary (in *bits*) for the code of a function.  */
#define FUNCTION_BOUNDARY 4

/* Alignment of field after `int : 0' in a structure.  */
#define EMPTY_FIELD_BOUNDARY 4

/* Every structure's size must be a multiple of this.  */
#define STRUCTURE_SIZE_BOUNDARY 4

/* A bitfield declared as `int' forces `int' alignment for the struct.  */
#define PCC_BITFIELD_TYPE_MATTERS 1

/* No data type wants to be aligned rounder than this.  */
#define BIGGEST_ALIGNMENT 4

/* Define this if move instructions will actually fail to work
   when given unaligned data.  */
#define STRICT_ALIGNMENT 0

/* Standard register usage.  */

/* Number of actual hardware registers.
   The hardware registers are assigned numbers for the compiler
   from 0 to just below FIRST_PSEUDO_REGISTER.
   All registers that the compiler knows about must be given numbers,
   even those that are not normally considered general registers.  */
#define FIRST_PSEUDO_REGISTER 17

#define REG_D0	0
#define REG_D1	1
#define REG_A	2
#define	REG_B	3
#define REG_C	4
#define REG_D	5
#define REG_R0	6
#define REG_R1	7
#define REG_R2	8
#define REG_R3	9
#define REG_R4	10
#define REG_HS	11

#define FRAME_POINTER_REGNUM 	REG_D1
#define ARG_POINTER_REGNUM   	FRAME_POINTER_REGNUM
#define STACK_POINTER_REGNUM 	REG_R1	
#define STRUCT_VALUE_REGNUM  	REG_D
#define STATIC_CHAIN_REGNUM  	REG_D0
#define FUNCTION_RETURN_REGNUM	REG_C 

#define N_REG_PARMS		5
#define PARM_ALLOC_ORDER	{ REG_B, REG_R0, REG_R2, REG_R3, REG_R4 }
extern  int			parm_alloc_order[N_REG_PARMS];

/* 1 for registers that have pervasive standard uses
   and are not available for the register allocator.  */   
#define FIXED_REGISTERS {0,0, 0,0,0,0, 0,0,0,0,0, 0,0,0,0,0,0}

/* 1 for registers not available across function calls.
   These must include the FIXED_REGISTERS and also any
   registers that can be used without being saved.
   The latter must include the registers where values are returned
   and the register where structure-value addresses are passed.
   Aside from that, you can include as many other registers as you like.  */
	                /*   d0-d1   a - d    r0 - r4     hs0-hs5   */
#define CALL_USED_REGISTERS { 1,1,  1,1,1,1, 1,1,1,1,1, 1,1,1,1,1,1 }
	        
#define REG_ALLOC_ORDER { 6,7,8,9,10,  5,4,2,3, 0,1, 11,12,13,14,15,16 }

/* Return number of consecutive hard regs needed starting at reg REGNO
   to hold something of mode MODE.
   This is ordinarily the length in words of a value of mode MODE
   but can be less for certain modes in special long registers. */
#define HARD_REGNO_NREGS(REGNO, MODE)   \
 ((GET_MODE_SIZE (MODE) + UNITS_PER_WORD - 1) / UNITS_PER_WORD)

/* Value is 1 if hard register REGNO can hold a value of machine-mode MODE. */
#define HARD_REGNO_MODE_OK(REGNO, MODE)  (REGNO>1 || MODE==PDImode)

/* Value is 1 if it is a good idea to tie two pseudo registers
   when one has mode MODE1 and one has mode MODE2.
   If HARD_REGNO_MODE_OK could produce different values for MODE1 and MODE2,
   for any hard reg, then this must be 0 for correct output.  */
#define MODES_TIEABLE_P(MODE1, MODE2) ((MODE1)==(MODE2) && (MODE1)==PDImode)

/* Value should be nonzero if functions must have frame pointers.
   Zero means the frame pointer need not be set up (and parms
   may be accessed via the stack pointer) in functions that seem suitable.
   This is computed in `reload', in reload1.c.
   
   On the saturn, accesses through the frame pointer (D1) are cheaper
   than ones through the stack pointer, so there's nothing to gain by
   omitting the frame pointer. */

#define FRAME_POINTER_REQUIRED 1
#define INITIAL_FRAME_POINTER_OFFSET(DEPTH) { }


/* Define the classes of registers for register constraints in the
   machine description.  Also define ranges of constants.

   One of the classes must always be named ALL_REGS and include all hard regs.
   If there is more than one class, another class must be named NO_REGS
   and contain no registers.

   The name GENERAL_REGS must be the name of a class (or an alias for
   another name such as ALL_REGS).  This is the class of registers
   that is allowed by "g" or "r" in a register constraint.
   Also, registers outside this class are allocated only when
   instructions express preferences for them.

   The classes must be numbered in nondecreasing order; that is,
   a larger-numbered class must never be contained completely
   in a smaller-numbered class.

   For any two classes, it is very desirable that there be another
   class that represents their union.  */
   
enum reg_class { 
    NO_REGS, 
    AREG, BREG, CREG, DREG,
    ACREG,		/* a & c */
    DnREG,		/* D0 and D1 */
    RnREG,		/* R0 thru R4 */
    HS_TOP_REG,		/* top of hardware stack */
    HSREGS,		/* Hardware Stack registers: hs0-hs5 */
    PTR_REGS,		/* address registers: D0, D1. */
    T_REGS,		/* registers A, B, and C */
    GENERAL_REGS, ALL_REGS, LIM_REG_CLASSES 
};

#define SMALL_REGISTER_CLASSES
#define N_REG_CLASSES (int) LIM_REG_CLASSES

/* Determine which register classes are very likely used by spill registers.
   local-alloc.c won't allocate pseudos that have these classes as their
   preferred class unless they are "preferred or nothing".  */
#define CLASS_LIKELY_SPILLED_P(CLASS) (reg_class_size[(int)CLASS]<=3)

/* Give names of register classes as strings for dump file.   */

#define REG_CLASS_NAMES \
  {"NO_REGS", "AREG", "BREG", "CREG", "DREG", "ACREG", "DnREG", \
   "RnREG", "HS_TOP_REG", "HSREGS", "PTR_REGS", "T_REGS", \
   "GENERAL_REGS", "ALL_REGS" }

/* Define which registers fit in which classes.
   This is an initializer for a vector of HARD_REG_SET
   of length N_REG_CLASSES.  */

#define REG_CLASS_CONTENTS 					\
{	     0, 						\
  0x4,0x8,0x10,0x20,	/* AREG, BREG, CREG, DREG */		\
          0x14,		/* ACREGS = a,c */			\
           0x3,    	/* DnREG */				\
         0x7c0,    	/* RnREG */				\
	 0x800,		/* HS_TOP_REG */			\
       0x1f800,		/* HSREGS */				\
	   0x3,		/* memory addressing registers */ 	\
          0x1c,		/* a, b, c */				\
	 0x7ff,		/* GENERAL_REGS */			\
         0x7ff }

/* The same information, inverted:
   Return the class number of the smallest class containing
   reg number REGNO.  This could be a conditional expression
   or could index an array.  */

#define REGNO_REG_CLASS(REGNO)  \
  ( (REGNO)<=1?DnREG : \
    (REGNO)==2?AREG  : (REGNO)==3?BREG : \
    (REGNO)==4?CREG  : (REGNO)==5?DREG : \
    (REGNO)<=10?RnREG : (REGNO)==11?HS_TOP_REG :\
    (REGNO)<=16?HSREGS : NO_REGS )


#define INDEX_REG_CLASS NO_REGS
#define BASE_REG_CLASS 	PTR_REGS

/* Get reg_class from a letter such as appears in the machine description.  */

#define REG_CLASS_FROM_LETTER(C)  	\
	(C)=='R' ? RnREG :	  	\
	(C)=='D' ? DnREG : 		\
	(C)=='q' ? ACREG :		\
	(C)=='a' ? AREG : (C)=='b'? BREG :(C)=='c'? CREG :(C)=='d'? DREG : \
	(C)=='t' ? T_REGS : \
	NO_REGS

/* The letters I, J, K, L and M in a register constraint string
   can be used to stand for particular ranges of immediate operands.
   This macro defines what the ranges are.
   C is the letter, and VALUE is a constant value.
   Return 1 if VALUE is in the range specified by C.  */

#define CONST_OK_FOR_LETTER_P(VALUE, C)  	\
    (C) == 'I' ? VALUE>=1 && VALUE<=16 : 	\
    (C) == 'J' ? VALUE>=-16 && VALUE<=-1 : 	\
    (C) == 'K' ? VALUE>=0 && VALUE<=0xFFFFF : 0

/* Similar, but for floating constants, and defining letters G and H.
   Here VALUE is the CONST_DOUBLE rtx itself.  */

#define CONST_DOUBLE_OK_FOR_LETTER_P(VALUE, C) 1

/* Given an rtx X being reloaded into a reg required to be
   in class CLASS, return the class of reg to actually use.
   In general this is just CLASS; but on some machines
   in some cases it is preferable to use a more restrictive class.  */

/* i386: Put float CONST_DOUBLE in the constant pool instead of fp regs.
   QImode must go into class Q_REGS.
   Narrow ALL_REGS to GENERAL_REGS.  This supports allowing movsf and
   movdf to do mem-to-mem moves through integer regs. */

#define PREFERRED_RELOAD_CLASS(X,CLASS) preferred_reload_class(X,CLASS)

#define SECONDARY_RELOAD_CLASS(CLASS,MODE,X) \
				    secondary_reload_class(CLASS,MODE,X)

#define REGISTER_MOVE_COST(FROM,TO)	register_move_cost(FROM,TO)
#define MEMORY_MOVE_COST(M)		10 /* very expensive */

/* Return the maximum number of consecutive registers
   needed to represent mode MODE in a register of class CLASS.  */
#define CLASS_MAX_NREGS(CLASS, MODE)	\
 ((GET_MODE_SIZE (MODE) + UNITS_PER_WORD - 1) / UNITS_PER_WORD)

/* Stack layout; function entry, exit and calling.  */

/* Define this if pushing a word on the stack
   makes the stack pointer a smaller address.  */
#define STACK_GROWS_DOWNWARD

/* Define this if the nominal address of the stack frame
   is at the high-address end of the local variables;
   that is, each additional local variable allocated
   goes at a more negative offset in the frame.  */
#define FRAME_GROWS_DOWNWARD

/* Offset within stack frame to start allocating local variables at.
   If FRAME_GROWS_DOWNWARD, this is the offset to the END of the
   first local allocated.  Otherwise, it is the offset to the BEGINNING
   of the first local allocated.  */
#define STARTING_FRAME_OFFSET     0

/* Offset of first parameter from the argument pointer register value.  */
#define FIRST_PARM_OFFSET(FNDECL) 10

/* Value is 1 if returning from a function call automatically
   pops the arguments described by the number-of-args field in the call.
   FUNTYPE is the data type of the function (as a tree),
   or for a library call it is an identifier node for the subroutine name.

   On the Vax, the RET insn always pops all the args for any function.
   On the saturn, RET doesn't pop anything.  */

#define RETURN_POPS_ARGS(ARGS...) 0

/* Define how to find the value returned by a function.
   VALTYPE is the data type of the value (as a tree).
   If the precise function being called is known, FUNC is its FUNCTION_DECL;
   otherwise, FUNC is 0.  */

#define FUNCTION_VALUE(VALTYPE, FUNC)  	\
  	gen_rtx (REG, TYPE_MODE (VALTYPE), FUNCTION_RETURN_REGNUM)

#define LIBCALL_VALUE(MODE)		\
	gen_rtx (REG, MODE, FUNCTION_RETURN_REGNUM)

#define FUNCTION_VALUE_REGNO_P(N) ((N) == FUNCTION_RETURN_REGNUM)

/* Define this if PCC uses the nonreentrant convention for returning
   structure and union values.  */
#define PCC_STATIC_STRUCT_RETURN

/* Define where to put the arguments to a function. */

#define FUNCTION_ARG_REGNO_P(N) 			function_arg_regno_p(N)
#define CUMULATIVE_ARGS 				int
#define INIT_CUMULATIVE_ARGS(CUM,FNTYPE,x)		((CUM) = 0)
#define FUNCTION_ARG_ADVANCE(CUM, MODE, TYPE, NAMED)    ((CUM)++)

#define FUNCTION_ARG(CUM, MODE, TYPE, NAMED)				\
  (TARGET_REGPARM ? ((CUM)<N_REG_PARMS ? gen_rtx (REG, (MODE), 		\
   parm_alloc_order[CUM]) : 0) : 0)


/* This macro generates the assembly code for function entry.
   FILE is a stdio stream to output the code to.
   SIZE is an int: how many units of temporary storage to allocate.
   Refer to the array `regs_ever_live' to determine which registers
   to save; `regs_ever_live[I]' is nonzero if register number I
   is ever used in the function.  This macro is responsible for
   knowing which registers should not be saved even if used.  */

#define FUNCTION_PROLOGUE(FILE, SIZE) function_prologue(FILE, SIZE);
#define FUNCTION_EPILOGUE(FILE, SIZE) function_epilogue(FILE, SIZE);

/* Output assembler code to FILE to increment profiler label # LABELNO
   for profiling a function entry.  */
#define FUNCTION_PROFILER(FILE, LABELNO)  fatal ("profiling not supported");

/* EXIT_IGNORE_STACK should be nonzero if, when returning from a function,
   the stack pointer does not matter.  The value is tested only in
   functions that have frame pointers.
   No definition is equivalent to always zero.  */
#define EXIT_IGNORE_STACK 1

/* If the memory address ADDR is relative to the frame pointer,
   correct it to be relative to the stack pointer instead.
   This is for when we don't use a frame pointer.
   ADDR should be a variable name.  */
#define FIX_FRAME_POINTER_ADDRESS(ADDR,DEPTH) {}



/* Addressing modes, and classification of registers for them.  */

/* Macros to check register numbers against specific register classes.  */

/* These assume that REGNO is a hard or pseudo reg number.
   They give nonzero only if REGNO is a hard reg of the suitable class
   or a pseudo reg currently allocated to a suitable hard reg.
   Since they use reg_renumber, they are safe only once reg_renumber
   has been allocated, which happens in local-alloc.c.  */

/* atr */
#define GP_REG_P(REGNO) (TEST_HARD_REG_BIT(reg_class_contents[PTR_REGS],REGNO))

/* mips.h */
#define GP_REG_OR_PSEUDO_STRICT_P(regno) \
   GP_REG_P((regno < FIRST_PSEUDO_REGISTER) ? regno : reg_renumber[regno])

#define GP_REG_OR_PSEUDO_NONSTRICT_P(regno) \
   (((regno) >= FIRST_PSEUDO_REGISTER) || (GP_REG_P (regno)))

#define REGNO_OK_FOR_INDEX_P(regno) 0
#define REGNO_OK_FOR_BASE_P(regno)  GP_REG_OR_PSEUDO_STRICT_P(regno)


/* Maximum number of registers that can appear in a valid memory address.  */

#define MAX_REGS_PER_ADDRESS 1

/* 1 if X is an rtx for a constant that is a valid address.  */

#define CONSTANT_ADDRESS_P(X)   \
  (GET_CODE (X) == LABEL_REF || GET_CODE (X) == SYMBOL_REF		\
   || GET_CODE (X) == CONST_INT || GET_CODE (X) == CONST		\
   || GET_CODE (X) == HIGH)

/* Nonzero if the constant value X is a legitimate general operand.
   It is given that X satisfies CONSTANT_P or is a CONST_DOUBLE.  */

#define LEGITIMATE_CONSTANT_P(X) \
    (GET_CODE (X) != CONST_DOUBLE)

/* The macros REG_OK_FOR..._P assume that the arg is a REG rtx
   and check its validity for a certain class.
   We have two alternate definitions for each of them.
   The usual definition accepts all pseudo regs; the other rejects
   them unless they have been allocated suitable hard regs.
   The symbol REG_OK_STRICT causes the latter definition to be used.

   Most source files want to accept pseudo regs in the hope that
   they will get allocated to the class that the insn wants them to be in.
   Source files for reload pass need to be strict.
   After reload, it makes no difference, since pseudo regs have
   been eliminated by then.  */

#ifndef REG_OK_STRICT   /* mips.h */
#define REG_OK_STRICT_P 0
#define REG_OK_FOR_INDEX_P(X) 0
#define REG_OK_FOR_BASE_P(X)  GP_REG_OR_PSEUDO_NONSTRICT_P (REGNO (X))
#else
#define REG_OK_STRICT_P 1
#define REG_OK_FOR_INDEX_P(X) 0
#define REG_OK_FOR_BASE_P(X)  REGNO_OK_FOR_BASE_P  (REGNO (X))
#endif

 

/* GO_IF_LEGITIMATE_ADDRESS recognizes an RTL expression
   that is a valid memory address for an instruction.
   The MODE argument is the machine mode for the MEM expression
   that wants to use this address. */

#define BASE_P(X) (REG_P(X) && REG_OK_FOR_BASE_P(X))

#define GO_IF_LEGITIMATE_ADDRESS(MODE, X, ADDR)	\
{						\
      if (BASE_P(X))				\
          goto ADDR;				\
      if (GET_CODE (X) == PLUS 			\
	  && REG_P (XEXP (X,0)) 		\
	  && REGNO (XEXP (X,0)) == REG_D1	\
	  && CONSTANT_P (XEXP (X,1)))		\
	  goto ADDR;				\
      if (REG_P (X)		 		\
	  && REGNO (X) == STACK_POINTER_REGNUM)	\
	  goto ADDR;				\
}

#define ADDRESS_COST(ADDR) 4

#define LEGITIMIZE_ADDRESS(X,OLDX,MODE,WIN) { }

#define NO_FUNCTION_CSE

/* Go to LABEL if ADDR (a legitimate address expression)
   has an effect that depends on the machine mode it is used for. */
#define GO_IF_MODE_DEPENDENT_ADDRESS(ADDR,LABEL)

/* Define this if the case instruction expects the table
   to contain offsets from the address of the table.
   Do not define this if the table should contain absolute addresses.  */
/* #define CASE_VECTOR_PC_RELATIVE */

/* Specify the tree operation to be used to convert reals to integers.  */
#define IMPLICIT_FIX_EXPR FIX_ROUND_EXPR

/* This is the kind of divide that is easiest to do in the general case.  */
#define EASY_DIV_EXPR TRUNC_DIV_EXPR

/* Define this as 1 if `char' should by default be signed; else as 0.  */
#define DEFAULT_SIGNED_CHAR 0

/* This flag, if defined, says the same insns that convert to a signed fixnum
   also convert validly to an unsigned one.  */
#define FIXUNS_TRUNC_LIKE_FIX_TRUNC

/* Max number of bytes we can move from memory to memory
   in one reasonably fast instruction.  */
#define MOVE_MAX 16

/* Define this if zero-extension is slow (more than one real instruction).  */
#define SLOW_ZERO_EXTEND

/* Nonzero if access to memory by bytes is slow and undesirable.  */
#define SLOW_BYTE_ACCESS 0

/* Define if shifts truncate the shift count
   which implies one can omit a sign-extension or zero-extension
   of a shift count.  */
/* #define SHIFT_COUNT_TRUNCATED */

/* Value is 1 if truncating an integer of INPREC bits to OUTPREC bits
   is done just by pretending it is already truncated.  */
#define TRULY_NOOP_TRUNCATION(OUTPREC, INPREC) 1


/* Compute the cost of computing a constant rtl expression RTX
   whose rtx-code is CODE.  The body of this macro is a portion
   of a switch statement.  If the code is computed here,
   return it with a return statement.  Otherwise, break from the switch.  */

#define CONST_COSTS(RTX,CODE,OUTER_CODE)

/*
 * We can use the BSD C library routines for the gnulib calls that are
 * still generated, since that's what they boil down to anyways.
 */

/* #define UDIVSI3_LIBCALL "*udiv" */
/* #define UMODSI3_LIBCALL "*urem" */


/* Tell final.c how to eliminate redundant test instructions.  */

/* Here we define machine-dependent flags and fields in cc_status
   (see `conditions.h').  No extra ones are needed for the vax.  */

/* Store in cc_status the expressions
   that the condition codes will describe
   after execution of an instruction whose pattern is EXP.
   Do not alter them if the instruction would not alter the cc's.  */

#define NOTICE_UPDATE_CC(EXP, INSN) \
	CC_STATUS_INIT;


/* Control the assembler format that we output.  */

/* Output the name of the file we are compiling.  */
#define ASM_OUTPUT_SOURCE_FILENAME(STREAM, NAME) \
  do {	fprintf (STREAM, "\t.file\t");			\
	output_quoted_string (STREAM, NAME);		\
	fprintf (STREAM, "\n");				\
  } while (0)

extern	char *saturn_md_version;
extern  char *saturn_c_version;

/* Output at beginning of assembler file.  */
#define ASM_FILE_START(FILE)   {					     \
    gen_initialize_version_info ();					     \
    fprintf (FILE, ";; Generated by xgcc for saturn processor.\n"	     \
		   ";; $Id: saturn.h,v 1.29 1995/06/30 21:39:55 alex Exp $\n"\
	           ";; %s\n;; %s\n\n", saturn_md_version, saturn_c_version); \
    fputs("\txref ___prologue\n\txref ___epilogue\n", FILE);		     \
    fputs("\txref ___extendti\n\txref ___extenddi\n", FILE);		     \
    fputs("\txref ___extendsi\n", FILE);				     \
}


#define ASM_IDENTIFY_GCC(FILE)
#define ASM_IDENTIFY_LANGUAGE(FILE)


/* Output to assembler file text saying following lines
   may contain character constants, extra white space, comments, etc.  */

#define ASM_APP_ON ""

/* Output to assembler file text saying following lines
   no longer contain unusual constructs.  */

#define ASM_APP_OFF ""

/* Output before read-only data.  */
#define TEXT_SECTION_ASM_OP ""

/* Output before writable data.  */
#define DATA_SECTION_ASM_OP "\t;; begin writeable data segment"

/* How to refer to registers in assembler output.
   This sequence is indexed by compiler's hard-register-number (see above).  */

#define REGISTER_NAMES \
{"d0", "d1", "a", "b", "c", "d", "r0", "r1", "r2", "r3", "r4", \
 "rstk", "stk[1]", "stk[2]", "stk[3]", "stk[4]", "stk[5]" }

/* This is BSD, so it wants DBX format.  */

/* #define DBX_DEBUGGING_INFO */

/* How to renumber registers for dbx and gdb.
   Vax needs no change in the numeration.  */

#define DBX_REGISTER_NUMBER(REGNO) (REGNO)

/* Do not break .stabs pseudos into continuations.  */

#define DBX_CONTIN_LENGTH 0

/* This is the char to use for continuation (in case we need to turn
   continuation back on).  */

#define DBX_CONTIN_CHAR '?'

/* Don't use the `xsfoo;' construct in DBX output; this system
   doesn't support it.  */

#define DBX_NO_XREFS

/* This is how to output the definition of a user-level label named NAME,
   such as the label on a static function or variable NAME.  */

#define ASM_OUTPUT_ASCII(FILE,STRING,LEN) \
	saturn_output_ascii(FILE, STRING, LEN);

#define ASM_OUTPUT_EXTERNAL(FILE, DECL, NAME)	\
{						\
	fprintf (FILE, "\txref ");		\
	assemble_name (FILE, NAME);		\
	fprintf (FILE, "\n");			\
}

#define ASM_OUTPUT_EXTERNAL_LIBCALL(STREAM, SYMREF)	\
{							\
	fprintf (STREAM, "\txref ");			\
	assemble_name (STREAM, XSTR (SYMREF, 0));	\
	fprintf (STREAM, "\n");				\
}

#define ASM_OUTPUT_LABEL(FILE,NAME)	\
  do { assemble_name (FILE, NAME); fputs ("\n", FILE); } while (0)

/* This is how to output a command to make the user-level label named NAME
   defined for reference from other files.  */

#define ASM_GLOBALIZE_LABEL(FILE,NAME)	\
  do { fputs ("\txdef\t", FILE); assemble_name (FILE, NAME); \
       fputs ("\n", FILE);} while (0)

/* This is how to output a reference to a user-level label named NAME.  */

#define ASM_OUTPUT_LABELREF(FILE,NAME)	\
    fprintf (FILE, "_%s", NAME)

#define ASM_OUTPUT_INTERNAL_LABEL(FILE,PREFIX,NUM)     \
    fprintf (FILE, "@%s%d\n", PREFIX, NUM)

#define ASM_GENERATE_INTERNAL_LABEL(LABEL,PREFIX,NUM)	\
    sprintf (LABEL, "*@%s%d", PREFIX, NUM)

/* This is how to output an assembler line defining a `float' constant.  */

#define ASM_OUTPUT_FLOAT(FILE,VALUE)			\
do							\
  {							\
    int i;						\
    long e;						\
    unsigned char data[12];				\
							\
    fprintf (FILE, "\tdcr.16\t$");			\
    fprintf (FILE, "%d", ((VALUE).sign > 0) ? 0 : 9);	\
    for (i = 0; i < 3; i++)				\
      (VALUE).mant /= 10;				\
    for (i = 0; i < 12; i++)				\
      {							\
        data [11 - i] = (VALUE).mant % 10;		\
        (VALUE).mant /= 10;				\
      }							\
    for (i = 0; i < 12; i++)				\
      fprintf (FILE, "%d", data[i]);			\
    e = (VALUE).exp;					\
    if ((VALUE).esign < 0)				\
      e = 1000 - e;					\
    for (i = 0; i < 3; i++)				\
      {							\
	data[2 - i] = e % 10;				\
        e /= 10;					\
      }							\
    for (i = 0; i < 3; i++)				\
      fprintf (FILE, "%d", data[i]);			\
    fprintf (FILE, "\n");				\
  } while (0)

#define ASM_OUTPUT_DOUBLE(FILE,VALUE)			\
  ASM_OUTPUT_FLOAT (FILE, VALUE)

#define ASM_OUTPUT_LONG_DOUBLE(FILE,VALUE)		\
do							\
  {							\
    int i;						\
    long e;						\
    unsigned char data[15];				\
							\
    fprintf (FILE, "\tdcr.16\t$0");			\
    for (i = 0; i < 15; i++)				\
      {							\
        data [14 - i] = (VALUE).mant % 10;		\
        (VALUE).mant /= 10;				\
      }							\
    for (i = 0; i < 15; i++)				\
      fprintf (FILE, "%d", data[i]);			\
    fprintf (FILE, "\n\tdcr.16\t$");			\
    fprintf (FILE, "%d", ((VALUE).sign > 0) ? 0 : 9);	\
    fprintf (FILE, "0000000000");			\
    e = (VALUE).exp;					\
    if ((VALUE).esign < 0)				\
      e = 100000 - e;					\
    for (i = 0; i < 5; i++)				\
      {							\
	data[4 - i] = e % 10;				\
        e /= 10;					\
      }							\
    for (i = 0; i < 5; i++)				\
      fprintf (FILE, "%d", data[i]);			\
    fprintf (FILE, "\n");				\
  } while (0)

/*
 * This gets called when size == 8 UNITS, i.e. long ...
 *
 * Must check if we get a SYMBOL_REF of mode PDImode, and
 * output that as dcr.ao symbol instead dcr.8 ...
 */
#define ASM_OUTPUT_DOUBLE_INT(FILE,VALUE) 		\
{							\
	int size = 8;					\
	if (GET_MODE (VALUE) == PDImode)		\
	  {						\
	    if (GET_CODE (VALUE) == SYMBOL_REF)		\
	      fputs ("\tdcr.ao\t", FILE);		\
	    else					\
	      fputs ("\tdcr.5\t", FILE);		\
	    size = 5;					\
	  }						\
	else						\
	  fputs ("\tdcr.8\t", FILE);			\
	saturn_output_addr_const (FILE, VALUE, size);	\
	fputc ('\n', FILE);				\
}						  

/*
 * This gets called when size == 16 UNITS, i.e. long long ...
 */
#define ASM_OUTPUT_QUADRUPLE_INT(FILE,VALUE) 			\
{								\
	fputs ("\tdcr.16\t", FILE);				\
	saturn_output_addr_const (FILE, VALUE, 16);		\
	fputc ('\n', FILE);					\
}						  

/* Likewise for `char' and `short' constants.  */

/*
 * This gets called when size == 4 UNITS, i.e. short ...
 */
#define ASM_OUTPUT_INT(FILE,VALUE)  		\
( fprintf (FILE, "\tdcr.4\t"),			\
  saturn_output_addr_const (FILE, VALUE, 4),	\
  fprintf (FILE, "\n"))

/*
 * This gets called when size == 2 UNITS, i.e. char ...
 */
#define ASM_OUTPUT_SHORT(FILE,VALUE)  		\
( fprintf (FILE, "\tdcr.2\t"),			\
  saturn_output_addr_const (FILE, VALUE, 2),	\
  fprintf (FILE, "\n"))

/*
 * This gets called when size == 1 UNIT, i.e. nibble ...
 */
#define ASM_OUTPUT_CHAR(FILE,VALUE)  		\
( fprintf (FILE, "\tdcr.1\t"),			\
  saturn_output_addr_const (FILE, VALUE, 1),	\
  fprintf (FILE, "\n"))

/* This is how to output an assembler line for a numeric constant byte.  */

#define ASM_OUTPUT_BYTE(FILE,VALUE)  \
  fprintf (FILE, "\tdcr.b\t$%x\n", (VALUE))

/* This is how to output an insn to push a register on the stack.
   It need not be very fast code.  */
#define ASM_OUTPUT_REG_PUSH(FILE,REGNO)  abort()

/* This is how to output an insn to pop a register from the stack.
   It need not be very fast code.  */
#define ASM_OUTPUT_REG_POP(FILE,REGNO)  abort()

/* This is how to output an element of a case-vector that is absolute.
   (The Vax does not use such vectors,
   but we must define this macro anyway.)  */

#define ASM_OUTPUT_ADDR_VEC_ELT(FILE, VALUE)  \
  fprintf (FILE, "\t.data .L%d{32}\n", VALUE)

/* This is how to output an element of a case-vector that is relative.  */

#define ASM_OUTPUT_ADDR_DIFF_ELT(FILE, VALUE, REL)  \
  fprintf (FILE, "\t.data .L%d-.L%d{32}\n", VALUE, REL)

/* This is how to output an assembler line
   that says to advance the location counter
   to a multiple of 2**LOG bytes.  */

#define ASM_OUTPUT_ALIGN(FILE,LOG)  \
  if (LOG!=0) fprintf (FILE, "\talign\t%d\n", (LOG)); else 0

/* This is how to output an assembler line
   that says to advance the location counter by SIZE bytes.  */

#define ASM_OUTPUT_SKIP(FILE,SIZE) \
	fprintf(FILE, "\t;; hmm... front-end says 'skip %d'. Ignore.\n", SIZE);
	


/* This says how to output an assembler line
   to define a global common symbol.  */

#define ASM_OUTPUT_COMMON(FILE, NAME, SIZE, ROUNDED)	\
{							\
    int i;						\
    ASM_GLOBALIZE_LABEL (FILE, NAME);			\
    assemble_name (FILE, NAME);				\
    while (SIZE >= 16)					\
      {							\
        fprintf(FILE, "\n\tdcr.%d\t0", 16);		\
	SIZE -= 16;					\
      }							\
    if (SIZE > 0)					\
      fprintf(FILE, "\n\tdcr.%d\t0\n", SIZE);		\
    else						\
      fprintf(FILE, "\n");				\
}

/* This says how to output an assembler line
   to define a local common symbol.  */

#define ASM_OUTPUT_LOCAL(FILE, NAME, SIZE, ROUNDED)	\
{							\
    int i;						\
    assemble_name (FILE, NAME);			      	\
    while (SIZE >= 16)					\
      {							\
        fprintf(FILE, "\n\tdcr.%d\t0", 16);		\
	SIZE -= 16;					\
      }							\
    if (SIZE > 0)					\
      fprintf(FILE, "\n\tdcr.%d\t0\n", SIZE);		\
    else						\
      fprintf(FILE, "\n");				\
}

/* Store in OUTPUT a string (made with alloca) containing
   an assembler-name for a local static variable named NAME.
   LABELNO is an integer which is different for each call.  */

#define ASM_FORMAT_PRIVATE_NAME(OUTPUT, NAME, LABELNO)	\
( (OUTPUT) = (char *) alloca (strlen ((NAME)) + 10),	\
  sprintf ((OUTPUT), "%s.%d", (NAME), (LABELNO)))

/* Define the parentheses used to group arithmetic operations
   in assembler code.  */

#define ASM_OPEN_PAREN "("
#define ASM_CLOSE_PAREN ")"

/* Define results of standard character escape sequences.  */
#define TARGET_BELL 007
#define TARGET_BS 010
#define TARGET_TAB 011
#define TARGET_NEWLINE 012
#define TARGET_VT 013
#define TARGET_FF 014
#define TARGET_CR 015

#define PRINT_OPERAND(FILE, X, CODE) \
	saturn_print_operand(FILE, X, CODE)

#define PRINT_OPERAND_ADDRESS(FILE, ADDR) 	/* aka output_address() */ \
	saturn_print_operand_address (FILE, ADDR)

/* These are stubs, and have yet to bee written. */

#define TRAMPOLINE_SIZE 26
#define TRAMPOLINE_TEMPLATE(FILE)
#define INITIALIZE_TRAMPOLINE(TRAMP,FNADDR,CXT)

#define MACHINE_DEPENDENT_REORG(INSN) fake_indexed_addressing(INSN)

/* Functions defined in saturn.c */
	extern char *cmp_set();
	extern char *cmp_jmp();
	extern void  saturn_output_addr_const();
	extern void  fake_indexed_addressing();
	extern char *expand_inline_add();
	extern char *output_shift_insn();
	extern char *output_clr_insn();
	extern void  saturn_output_ascii();


/* **************** Floating point stuff (place holders) **************** */


#define TARGET_FLOAT_FORMAT	UNKNOWN_FLOAT_FORMAT
#ifndef HOST_FLOAT_FORMAT
#define HOST_FLOAT_FORMAT	IEEE_FLOAT_FORMAT
#endif


#define REAL_H_INCLUDED
#include "machmode.h"

#define UNKNOWN_FLOAT_FORMAT	0
#define IEEE_FLOAT_FORMAT	1
#define VAX_FLOAT_FORMAT	2
#define IBM_FLOAT_FORMAT	3


#undef REAL_INFINITY

#define FLOAT_TYPE_SIZE  	64
#define DOUBLE_TYPE_SIZE 	64
#define LONG_DOUBLE_TYPE_SIZE 	128

struct saturn_real {
  char               sign;
  unsigned long long mant;
  char               esign;
  unsigned short     exp;
};

#define REAL_VALUE_TYPE		struct saturn_real
#define REAL_IS_NOT_DOUBLE	1
#define EXTERNAL_REAL_EMULATION	1

extern REAL_VALUE_TYPE dconst0;
extern REAL_VALUE_TYPE dconst1;
extern REAL_VALUE_TYPE dconst2;
extern REAL_VALUE_TYPE dconstm1;

union real_extract
{
  REAL_VALUE_TYPE d;
  HOST_WIDE_INT   i[sizeof (REAL_VALUE_TYPE) / sizeof (HOST_WIDE_INT)];
};

#define CONST_DOUBLE_LOW(r)	XWINT (r, 2)
#define CONST_DOUBLE_HIGH(r)	XWINT (r, 3)
#define CONST_DOUBLE_CHAIN(r)	XEXP (r, 1)
#define CONST_DOUBLE_MEM(r)	XEXP (r, 0)

REAL_VALUE_TYPE real_value_from_int_cst ();

/* Given a CONST_DOUBLE in FROM, store into TO the value it represents. */

#define REAL_VALUE_FROM_CONST_DOUBLE(TO, FROM)				\
do									\
  {									\
    union real_extract u;						\
    bcopy ((char *) &CONST_DOUBLE_LOW ((FROM)), (char *)&u, sizeof u);	\
    TO = u.d;								\
  } while (0)

/* Return a CONST_DOUBLE with value R and mode M. */

#define CONST_DOUBLE_FROM_REAL_VALUE(R, M) immed_real_const_1 (R, M)
extern struct rtx_def *immed_real_const_1	PROTO ((REAL_VALUE_TYPE,
							enum machine_mode));

extern void saturn_real_arith	PROTO ((REAL_VALUE_TYPE *, int,
					REAL_VALUE_TYPE *, REAL_VALUE_TYPE *));

extern REAL_VALUE_TYPE saturn_real_atof		PROTO ((char *,
							enum machine_mode));
extern REAL_VALUE_TYPE saturn_real_truncate	PROTO ((enum machine_mode,
						 	REAL_VALUE_TYPE));
extern REAL_VALUE_TYPE saturn_real_negate	PROTO ((REAL_VALUE_TYPE));
extern REAL_VALUE_TYPE saturn_real_ldexp	PROTO ((REAL_VALUE_TYPE, int));

extern REAL_VALUE_TYPE saturn_real_from_float	PROTO ((HOST_WIDE_INT));
extern REAL_VALUE_TYPE saturn_real_from_double	PROTO ((HOST_WIDE_INT *));

extern long saturn_real_to_float	PROTO ((REAL_VALUE_TYPE));
extern void saturn_real_to_double	PROTO ((REAL_VALUE_TYPE, long *));
extern void saturn_real_to_decimal	PROTO ((REAL_VALUE_TYPE, char *));

extern void saturn_real_to_int		PROTO ((HOST_WIDE_INT *,
						HOST_WIDE_INT *,
						REAL_VALUE_TYPE));
extern void saturn_real_from_int	PROTO ((REAL_VALUE_TYPE *,
					 	HOST_WIDE_INT,
						HOST_WIDE_INT));
extern void saturn_real_from_uint	PROTO ((REAL_VALUE_TYPE *,
						unsigned HOST_WIDE_INT,
						unsigned HOST_WIDE_INT));

extern int saturn_real_cmp		PROTO ((REAL_VALUE_TYPE,
						REAL_VALUE_TYPE));

extern int saturn_significand_size	PROTO ((enum machine_mode));


#define REAL_ARITHMETIC(VALUE,CODE,D1,D2) \
  saturn_real_arith (&VALUE, CODE, &D1, &D2)

#define REAL_VALUE_TO_INT		saturn_real_to_int

/* Here the cast to HOST_WIDE_INT sign-extends arguments such as ~0. */
#define REAL_VALUE_FROM_INT(D, LO, HI) \
  saturn_real_from_int (&D, (HOST_WIDE_INT)(LO), (HOST_WIDE_INT)(HI))

#define REAL_VALUE_FROM_UNSIGNED_INT(D, LO, HI) \
  saturn_real_from_uint (&D, LO, HI)

#define REAL_VALUE_FROM_TARGET_SINGLE	saturn_real_from_float
#define REAL_VALUE_FROM_TARGET_DOUBLE	saturn_real_from_double

#define REAL_VALUE_TO_DECIMAL(R, FMT, S) saturn_real_to_decimal (R, S)
#define REAL_VALUE_TO_TARGET_SINGLE(R, L) ((L) = saturn_real_to_float (R))
#define REAL_VALUE_TO_TARGET_DOUBLE	saturn_real_to_double

#define REAL_VALUE_ATOF			saturn_real_atof
#define REAL_VALUE_TRUNCATE		saturn_real_truncate
#define REAL_VALUES_EQUAL(X,Y)		(saturn_real_cmp ((X), (Y)) == 0)	
#define REAL_VALUES_LESS(X,Y)		(saturn_real_cmp ((X), (Y)) < 0)	
#define REAL_VALUE_NEGATIVE(X)		((X).sign == 9)
#define REAL_VALUE_NEGATE		saturn_real_negate
#define REAL_VALUE_LDEXP		saturn_real_ldexp

#define real_value_truncate		saturn_real_truncate
#define significand_size		saturn_significand_size

#define REAL_VALUE_ISINF(X)		(0)
#define REAL_VALUE_ISNAN(X)		(0)

/*
 * UNFINISHED STUFF ...
 */

#define REAL_VALUE_FIX(X)		(int)(0)
#define REAL_VALUE_UNSIGNED_FIX(X)	(unsigned)(0)
#define REAL_VALUE_RNDZINT(X)		(X)
#define REAL_VALUE_UNSIGNED_RNDZINT(X)  (X)
#define CHECK_FLOAT_VALUE(mode, d, overflow) {}

