;; $Id: saturn.md,v 1.1.1.7 1995/07/11 22:17:26 alex Exp $

;; Machine description for GNU compiler.  
;; Saturn version.

;; This port, done by Alex T. Ramos <ramos@engr.latech.edu> in 1994,
;; is the first 4-bit port of GNU CC.

;; Copyright (C) 1987, 1988, 1992 Free Software Foundation, Inc.

;; This file is part of GNU CC.

;; GNU CC is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 1, or (at your option)
;; any later version.

;; GNU CC is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU CC; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.


;;
;; extra addition insns
;;    must be placed before standard additions
;;    addpdi3_const must be placed before addI
;;

(define_insn "add1"
  [(set (match_operand 0 "register_operand" "=td,td")
	(plus (match_operand 1 "register_operand" "%0,0")
	      (match_operand 2 "immediate_one_operand" "I,J")))]
  ""
  "@
   inc.%m0 %0
   dec.%m0 %0")

(define_insn "addpdi3_const"
  [(set (match_operand:PDI 0 "register_operand" "=D,t,d")
	(plus:PDI (match_operand:PDI 1 "register_operand" "%0,0,0")
		  (match_operand:PDI 2 "immediate_operand" "i,IJ,IJ")))]
  ""
  "* return expand_inline_add(operands[0], operands[2]);")

(define_insn "addI"
  [(set (match_operand 0 "register_operand" "=td,td")
	(plus (match_operand 1 "register_operand" "%0,0")
	      (match_operand 2 "immediate_nib_p1_operand" "I,J")))]
  ""
  "@
   add.%m0 #%2,%0
   sub.%m0 #%n2,%0")


(define_split
  [(set (match_operand 0 "register_operand" "")
	(match_operand 1 "immediate_nib_p1_operand" ""))]
  ""
  [(set (match_dup 0)
	(const_int 0))
   (set (match_dup 0)
	(plus (match_dup 0) (match_dup 1)))]
  "")

;;
;; standard addition insns
;;

(define_insn "addhi3"
  [(set (match_operand:HI 0 "register_operand" "=t,c,d")
	(plus:HI (match_operand:HI 1 "register_operand" "%0,0,0")
		 (match_operand:HI 2 "register_operand" "t,d,c")))]
  ""
  "add.b %2,%0")


(define_insn "addsi3"
  [(set (match_operand:SI 0 "register_operand" "=t,c,d")
	(plus:SI (match_operand:SI 1 "register_operand" "%0,0,0")
		 (match_operand:SI 2 "register_operand" "t,d,c")))]
  ""
  "add.a %2,%0")


(define_insn "addpdi3"
  [(set (match_operand:PDI 0 "register_operand" "=t,c,d")
	(plus:PDI (match_operand:PDI 1 "register_operand" "%0,0,0")
		  (match_operand:PDI 2 "register_operand" "t,d,c")))]
  ""
  "add.a %2,%0")
 

(define_insn "adddi3"
  [(set (match_operand:DI 0 "register_operand" "=t,c,d")
	(plus:DI (match_operand:DI 1 "register_operand" "%0,0,0")
		 (match_operand:DI 2 "register_operand" "t,d,c")))]
  ""
  "add.wp %2,%0")


(define_insn "addti3"
  [(set (match_operand:TI 0 "register_operand" "=t,c,d")
	(plus:TI (match_operand:TI 1 "register_operand" "%0,0,0")
		 (match_operand:TI 2 "register_operand" "t,d,c")))]
  ""
  "add.w %2,%0")


;;
;; standard subtraction insns
;;

(define_insn "subhi3"
  [(set (match_operand:HI 0 "register_operand" "=t,c,d")
	(minus:HI (match_operand:HI 1 "register_operand" "%0,0,0")
		  (match_operand:HI 2 "register_operand" "t,d,c")))]
  ""
  "sub.b %2,%0")


(define_insn "subsi3"
  [(set (match_operand:SI 0 "register_operand" "=t,c,d")
	(minus:SI (match_operand:SI 1 "register_operand" "%0,0,0")
		  (match_operand:SI 2 "register_operand" "t,d,c")))]
  ""
  "sub.a %2,%0")


(define_insn "subdi3"
  [(set (match_operand:DI 0 "register_operand" "=t,c,d")
	(minus:DI (match_operand:DI 1 "register_operand" "%0,0,0")
		  (match_operand:DI 2 "register_operand" "t,d,c")))]
  ""
  "sub.wp %2,%0")


(define_insn "subti3"
  [(set (match_operand:TI 0 "register_operand" "=t,c,d")
	(minus:TI (match_operand:TI 1 "register_operand" "%0,0,0")
		  (match_operand:TI 2 "register_operand" "t,d,c")))]
  ""
  "sub.w %2,%0")








;;
;; extra move insn
;;     define before standard move insns
;;

(define_insn "clr"
  [(set (match_operand 0 "register_operand" "=t,d")
	(const_int 0))]
  ""
  "clr.%m0 %0")		; clr does not care about high bits








;     /* If IN_P is non-zero, the reload register will be the output in
;	 operand 0.  If IN_P is zero, the reload register will be the input
;	 in operand 1.  Outputs should have an initial "=", which we must
;	 skip.  */ (reload.c)

(define_expand "reload_inqi"
  [(set (match_operand:QI 0 "register_operand" "=r")
	(match_operand:QI 1 "general_operand" "g"))
   (clobber (match_operand:QI 2 "register_operand" "=&q"))]
  ""
  "{
	emit_move_insn (operands[2], operands[1]);
	emit_move_insn (operands[0], operands[2]);
	DONE;
  }")

(define_expand "reload_outqi"
  [(set (match_operand:QI 0 "general_operand" "=g")
	(match_operand:QI 1 "register_operand" "r"))
   (clobber (match_operand:QI 2 "register_operand" "=&q"))]
  ""
  "{
	emit_move_insn (operands[2], operands[1]);
	emit_move_insn (operands[0], operands[2]);
	DONE;
  }")

(define_insn "movqi"
  [(set (match_operand:QI 0 "general_operand" "=Rtm,q,c,d,q")
	(match_operand:QI 1 "general_operand" "q,Rtm,d,c,i"))]
  ""
  "move.1 #0,p\;move.2 %P1,%0\;move.1 #7,p")







(define_expand "reload_inhi"
  [(set (match_operand:HI 0 "register_operand" "=r")
	(match_operand:HI 1 "general_operand" "g"))
   (clobber (match_operand:HI 2 "register_operand" "=&q"))]
  ""
  "{
	emit_move_insn (operands[2], operands[1]);
	emit_move_insn (operands[0], operands[2]);
	DONE;
  }")

(define_expand "reload_outhi"
  [(set (match_operand:HI 0 "general_operand" "=g")
	(match_operand:HI 1 "register_operand" "r"))
   (clobber (match_operand:HI 2 "register_operand" "=&q"))]
  ""
  "{
	emit_move_insn (operands[2], operands[1]);
	emit_move_insn (operands[0], operands[2]);
	DONE;
  }")

(define_insn "movhi"
  [(set (match_operand:HI 0 "general_operand" "=Rtm,q,c,d,q")
	(match_operand:HI 1 "general_operand" "q,Rtm,d,c,i"))]
  ""
  "@
    move.b %1,%0
    move.b %1,%0
    move.b %1,%0
    move.b %1,%0
    move.1 #0,p\;move.2 #%D1,%0\;move.1 #7,p")









(define_expand "reload_insi"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(match_operand:SI 1 "general_operand" "g"))
   (clobber (match_operand:SI 2 "register_operand" "=&q"))]
  ""
  "{
	emit_move_insn (operands[2], operands[1]);
	emit_move_insn (operands[0], operands[2]);
	DONE;
  }")

(define_expand "reload_outsi"
  [(set (match_operand:SI 0 "general_operand" "=g")
	(match_operand:SI 1 "register_operand" "r"))
   (clobber (match_operand:SI 2 "register_operand" "=&q"))]
  ""
  "{
	emit_move_insn (operands[2], operands[1]);
	emit_move_insn (operands[0], operands[2]);
	DONE;
  }")

(define_insn "movsi"
  [(set (match_operand:SI 0 "general_operand" "=q,m,bRDq,q,c,d,q")
	(match_operand:SI 1 "general_operand" "m,q,q,bRDq,d,c,i"))]
  ""
  "@
   move.a %1,%0
   move.1 #3,p\;move.wp %1,%0\;move.1 #7,p
   move.a %1,%0
   move.a %1,%0
   move.a %1,%0
   move.a %1,%0
   move.1 #0,p\;move.4 #%C1,%0\;move.1 #7,p")








(define_expand "reload_inpdi"
  [(set (match_operand:PDI 0 "register_operand" "=r")
	(match_operand:PDI 1 "general_operand" "g"))
   (clobber (match_operand:PDI 2 "register_operand" "=&q"))]
  ""
  "{
	emit_move_insn (operands[2], operands[1]);
	emit_move_insn (operands[0], operands[2]);
	DONE;
  }")

(define_expand "reload_outpdi"
  [(set (match_operand:PDI 0 "general_operand" "=g")
	(match_operand:PDI 1 "register_operand" "r"))
   (clobber (match_operand:PDI 2 "register_operand" "=&q"))]
  ""
  "{
	emit_move_insn (operands[2], operands[1]);
	emit_move_insn (operands[0], operands[2]);
	DONE;
  }")

(define_insn "movpdi"
  [(set (match_operand:PDI 0 "general_operand" "=DRtm,q,c,d,D,D,q,q")
	(match_operand:PDI 1 "general_operand" "q,Rtm,d,c,n,i,D,i"))]
  ""
  "@
   move.a %1,%0
   move.a %1,%0
   move.a %1,%0
   move.a %1,%0
   move.a #%A1,%0
   move.ao #%A1,%0
   exg.a %1,%0\;move.a %0,%1  ; optimize me
   move.1 #0,p\;move.ao #%A1,%0\;move.1 #7,p")








(define_expand "reload_indi"
  [(set (match_operand:DI 0 "register_operand" "=r")
	(match_operand:DI 1 "general_operand" "g"))
   (clobber (match_operand:DI 2 "register_operand" "=&q"))]
  ""
  "{
	emit_move_insn (operands[2], operands[1]);
	emit_move_insn (operands[0], operands[2]);
	DONE;
  }")

(define_expand "reload_outdi"
  [(set (match_operand:DI 0 "general_operand" "=g")
	(match_operand:DI 1 "register_operand" "r"))
   (clobber (match_operand:DI 2 "register_operand" "=&q"))]
  ""
  "{
	emit_move_insn (operands[2], operands[1]);
	emit_move_insn (operands[0], operands[2]);
	DONE;
  }")

(define_insn "movdi"
  [(set (match_operand:DI 0 "general_operand" "=bRqm,q,cd,q")
	(match_operand:DI 1 "general_operand" "q,bRqm,cd,i"))]
  ""
  "@
   move.wp %1,%0      
   move.wp %1,%0      
   move.wp %1,%0      
   move.1 #0,p\;move.8 #%B1,%0\;move.1 #7,p")

(define_insn "movdi_strict"
  [(set (strict_low_part (match_operand:DI 0 "general_operand" "=bRqm,q,cd,q"))
	(match_operand:DI 1 "general_operand" "q,bRqm,cd,i"))]
  ""
  "@
   move.wp %1,%0      
   move.wp %1,%0      
   move.wp %1,%0      
   move.1 #0,p\;move.8 #%B1,%0\;move.1 #7,p")









(define_expand "reload_inti"
  [(set (match_operand:TI 0 "register_operand" "=r")
	(match_operand:TI 1 "general_operand" "g"))
   (clobber (match_operand:TI 2 "register_operand" "=&q"))]
  ""
  "{
	emit_move_insn (operands[2], operands[1]);
	emit_move_insn (operands[0], operands[2]);
	DONE;
  }")

(define_expand "reload_outti"
  [(set (match_operand:TI 0 "general_operand" "=g")
	(match_operand:TI 1 "register_operand" "r"))
   (clobber (match_operand:TI 2 "register_operand" "=&q"))]
  ""
  "{
	emit_move_insn (operands[2], operands[1]);
	emit_move_insn (operands[0], operands[2]);
	DONE;
  }")

(define_insn "movti"
  [(set (match_operand:TI 0 "general_operand" "=q,bRqm,q,c,d")
	(match_operand:TI 1 "general_operand" "n,q,bRqm,d,c"))]
  ""
  "@
   move.1 #0,p\;move.16 #%1,%0\;move.1 #7,p
   move.w %1,%0
   move.w %1,%0
   move.w %1,%0
   move.w %1,%0")






;;
;; comparison instructions
;;

(define_insn "tsthi"
  [(set (cc0)
	(match_operand:HI 0 "register_operand" "t,d"))]
  ""
  "*
    extern rtx cmp_op0, cmp_op1;
    cmp_op0=operands[0]; cmp_op1=0;
    return \"\";
")

(define_insn "cmphi"
  [(set (cc0)
	(compare (match_operand:HI 0 "register_operand" "t,c,d")
	         (match_operand:HI 1 "register_operand" "t,d,c")))]
  ""
  "*
    extern rtx cmp_op0, cmp_op1;
    cmp_op0=operands[0]; cmp_op1=operands[1];
    return \"\";
")


(define_insn "tstsi"
  [(set (cc0)
	(match_operand:SI 0 "register_operand" "t,d"))]
  ""
  "*
    extern rtx cmp_op0, cmp_op1;
    cmp_op0=operands[0]; cmp_op1=0;
    return \"\";
")

(define_insn "cmpsi"
  [(set (cc0)
	(compare (match_operand:SI 0 "register_operand" "t,c,d")
	         (match_operand:SI 1 "register_operand" "t,d,c")))]
  ""
  "*
    extern rtx cmp_op0, cmp_op1;
    cmp_op0=operands[0]; cmp_op1=operands[1];
    return \"\";
")


(define_insn "tstpdi"
  [(set (cc0)
	(match_operand:PDI 0 "register_operand" "t,d"))]
  ""
  "*
    extern rtx cmp_op0, cmp_op1;
    cmp_op0=operands[0]; cmp_op1=0;
    return \"\";
")

(define_insn "cmppdi"
  [(set (cc0)
	(compare (match_operand:PDI 0 "register_operand" "t,c,d")
	         (match_operand:PDI 1 "register_operand" "t,d,c")))]
  ""
  "*
    extern rtx cmp_op0, cmp_op1;
    cmp_op0=operands[0]; cmp_op1=operands[1];
    return \"\";
")



(define_insn "tstdi"
  [(set (cc0)
	(match_operand:DI 0 "register_operand" "t,d"))]
  ""
  "*
    extern rtx cmp_op0, cmp_op1;
    cmp_op0=operands[0]; cmp_op1=0;
    return \"\";
")

(define_insn "cmpdi"
  [(set (cc0)
	(compare (match_operand:DI 0 "register_operand" "t,c,d")
	         (match_operand:DI 1 "register_operand" "t,d,c")))]
  ""
  "*
    extern rtx cmp_op0, cmp_op1;
    cmp_op0=operands[0]; cmp_op1=operands[1];
    return \"\";
")



(define_insn "tstti"
  [(set (cc0)
	(match_operand:TI 0 "register_operand" "t,d"))]
  ""
  "*
    extern rtx cmp_op0, cmp_op1;
    cmp_op0=operands[0]; cmp_op1=0;
    return \"\";
")

(define_insn "cmpti"
  [(set (cc0)
	(compare (match_operand:TI 0 "register_operand" "t,c,d")
	         (match_operand:TI 1 "register_operand" "t,d,c")))]
  ""
  "*
    extern rtx cmp_op0, cmp_op1;
    cmp_op0=operands[0]; cmp_op1=operands[1];
    return \"\";
")



(define_insn "nop"
  [(const_int 0)]
  ""
  "")

(define_expand "initialize_version_info"
  [(match_operand 0 "" "")]
  ""
  "saturn_md_version = \"$Id: saturn.md,v 1.1.1.7 1995/07/11 22:17:26 alex Exp $\";
   DONE;")

(define_expand "call"
  [(call (match_operand 0 "memory_operand" "m")
 	 (match_operand 1 "immediate_operand" "i"))]
  ""
  "")

(define_insn "call_direct"
  [(call (mem (match_operand 0 "immediate_operand" "i"))
	 (match_operand 1 "immediate_operand" "i"))]
  ""
  "jsr %A0")

(define_insn "call_indirect"
  [(call (mem (match_operand 0 "register_operand" "a"))
	 (match_operand 1 "immediate_operand" "i"))]
  ""
  "move.a pc,c\;add.a #12,c\;push\;jmp %0 ; call-indirect %0")

(define_expand "call_value"
  [(set (match_operand 0 "register_operand" "=c")
        (call (match_operand 1 "" "")
              (match_operand 2 "" "")))]
  ""
  "")

(define_insn ""
  [(set (match_operand 0 "register_operand" "=c")
	(call (mem (match_operand 1 "immediate_operand" "i"))
	      (match_operand 2 "immediate_operand" "i")))]
  ""
  "jsr %A1")

(define_insn ""
  [(set (match_operand 0 "register_operand" "=c")
	(call (mem (match_operand 1 "register_operand" "a"))
	      (match_operand 2 "immediate_operand" "i")))]
  ""
  "move.a pc, c\;add.a #12,c\;push\;jmp %1 ; call-value-indirect %1")

(define_insn "jump"
  [(set (pc)
	(label_ref (match_operand 0 "" "")))]
  ""
  "jmp %0")

(define_insn "indirect_jump"
  [(set (pc)
        (match_operand 0 "register_operand" "q"))]
  ""
  "jmp %0")

(define_insn "tablejump"
  [(set (pc)
        (match_operand 0 "register_operand" "q"))
   (use (label_ref (match_operand 1 "" "")))]
  ""
  "jmp %0")


;;
;; Conditional jump insn patterns.
;;

(define_expand "beq"
  [(set (pc)
	(if_then_else (eq (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "")

(define_expand "bne"
  [(set (pc)
	(if_then_else (ne (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "")

(define_expand "bgt"
  [(set (pc)
	(if_then_else (gt (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "")

(define_expand "bgtu"
  [(set (pc)
	(if_then_else (gtu (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "")

(define_expand "blt"
  [(set (pc)
	(if_then_else (lt (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "")

(define_expand "bltu"
  [(set (pc)
	(if_then_else (ltu (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "")

(define_expand "bge"
  [(set (pc)
	(if_then_else (ge (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "")

(define_expand "bgeu"
  [(set (pc)
	(if_then_else (geu (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "")

(define_expand "ble"
  [(set (pc)
	(if_then_else (le (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "")

(define_expand "bleu"
  [(set (pc)
	(if_then_else (leu (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "")



(define_insn "cond_branch"
  [(set (pc)
	(if_then_else (match_operator 0 "comparison_operator"
				      [(cc0) (const_int 0)])
		      (label_ref (match_operand 1 "" ""))
		      (pc)))]
  ""
  "* return cmp_jmp(operands[0], operands[1], 0); ")

(define_insn "reverse_cond_branch"
  [(set (pc)
	(if_then_else (match_operator 0 "comparison_operator"
				      [(cc0) (const_int 0)])
		      (pc)
		      (label_ref (match_operand 1 "" ""))))]
  ""
  "* return cmp_jmp(operands[0], operands[1], 1); ")



(define_insn "extendpdidi2"
  [(set (match_operand:DI 0 "register_operand" "=t")
	(sign_extend:DI (match_operand:PDI 1 "register_operand" "t")))]
  ""
  "*
	if (REG_P(operands[0]) && REG_P(operands[1])
	    && REGNO(operands[0]) == REGNO(operands[1]))
		return \"; sign-extend %1 PDI -> DI\";
	else
		return \"move.a %1,%0 ; sign_extend PDI -> DI\";
   ")


(define_insn "truncdipdi2"
  [(set (match_operand:PDI 0 "general_operand" "=DRtm,q,c,d")
         (truncate:PDI
         (match_operand:DI 1 "general_operand" "q,DRtm,d,c")))]
  ""
  "*
	if (REG_P(operands[0]) && REG_P(operands[1])
	    && REGNO(operands[0]) == REGNO(operands[1]))
		return \"; truncate %1 DI -> PDI\";
	else
		return \"move.a %1,%0 ; truncate DI -> PDI\";
   ")



(define_insn "andhi3"
  [(set (match_operand:HI 0 "register_operand" "=t,d,c")
	(and:HI (match_operand:HI 1 "register_operand" "%0,0,0")
		(match_operand:HI 2 "register_operand" "t,c,d")))]
  ""
  "and.b %2,%0")

(define_insn "andsi3"
  [(set (match_operand:SI 0 "register_operand" "=t,d,c")
	(and:SI (match_operand:SI 1 "register_operand" "%0,0,0")
		(match_operand:SI 2 "register_operand" "t,c,d")))]
  ""
  "and.a %2,%0")

(define_insn "andpdi3"
  [(set (match_operand:PDI 0 "register_operand" "=t,d,c")
	(and:PDI (match_operand:PDI 1 "register_operand" "%0,0,0")
		 (match_operand:PDI 2 "register_operand" "t,c,d")))]
  ""
  "and.a %2,%0")


(define_insn "anddi3"
  [(set (match_operand:DI 0 "register_operand" "=t,c,d")
	(and:DI (match_operand:DI 1 "register_operand" "%0,0,0")
		(match_operand:DI 2 "register_operand" "t,d,c")))]
  ""
  "and.wp %2,%0")

(define_insn "andti3"
  [(set (match_operand:TI 0 "register_operand"        "=t,d,c")
	(and:TI (match_operand:TI 1 "register_operand" "%0,0,0")
		(match_operand:TI 2 "register_operand"  "t,c,d")))]
  ""
  "and.w %2,%0")




(define_insn "iorhi3"
  [(set (match_operand:HI 0 "register_operand" "=t,d,c")
	(ior:HI (match_operand:HI 1 "register_operand" "%0,0,0")
		(match_operand:HI 2 "register_operand" "t,c,d")))]
  ""
  "or.b %2,%0")

(define_insn "iorsi3"
  [(set (match_operand:SI 0 "register_operand" "=t,d,c")
	(ior:SI (match_operand:SI 1 "register_operand" "%0,0,0")
		(match_operand:SI 2 "register_operand" "t,c,d")))]
  ""
  "or.a %2,%0")

(define_insn "iorpdi3"  ;; hmm... do we ever OR pointers?!
  [(set (match_operand:PDI 0 "register_operand" "=ab,*c,d")
	(ior:PDI (match_operand:PDI 1 "register_operand" "%0,0,0")
		 (match_operand:PDI 2 "register_operand" "ab*c,ab*cd,*cd")))]
  ""
  "or.a %2,%0")

(define_insn "iordi3"
  [(set (match_operand:DI 0 "register_operand" "=t,c,d")
	(ior:DI (match_operand:DI 1 "register_operand" "%0,0,0")
		(match_operand:DI 2 "register_operand" "t,d,c")))]
  ""
  "or.wp %2,%0")

(define_insn "iorti3"
  [(set (match_operand:TI 0 "register_operand" "=t,d,c")
	(ior:TI (match_operand:TI 1 "register_operand" "%0,0,0")
		(match_operand:TI 2 "register_operand" "t,c,d")))]
  ""
  "or.w %2,%0")


(define_insn "lshrti3"
  [(set (match_operand:TI 0 "register_operand" "=t,d,a")
	(lshiftrt:TI (match_operand:TI 1 "register_operand" "0,0,0")
		     (match_operand:HI 2 "nonmemory_operand" "n,n,c")))]
  ""
  "*return output_shift_insn (operands, 'l', 'r');")

(define_insn "ashrti3"
  [(set (match_operand:TI 0 "register_operand" "=t,d,a")
	(ashiftrt:TI (match_operand:TI 1 "register_operand" "0,0,0")
		     (match_operand:HI 2 "nonmemory_operand" "n,n,c")))]
  ""
  "*return output_shift_insn (operands, 'a', 'r');")

(define_insn "ashlti3"
  [(set (match_operand:TI 0 "register_operand" "=t,d,a")
	(ashift:TI (match_operand:TI 1 "register_operand" "0,0,0")
		   (match_operand:HI 2 "nonmemory_operand" "n,n,c")))]
  ""
  "*return output_shift_insn (operands, 'a', 'l');")

(define_insn "lshrdi3"
  [(set (match_operand:DI 0 "register_operand" "=t,d,a")
	(lshiftrt:DI (match_operand:DI 1 "register_operand" "0,0,0")
		     (match_operand:HI 2 "nonmemory_operand" "n,n,c")))]
  ""
  "*return output_shift_insn (operands, 'l', 'r');")

(define_insn "ashrdi3"
  [(set (match_operand:DI 0 "register_operand" "=t,d,a")
	(ashiftrt:DI (match_operand:DI 1 "register_operand" "0,0,0")
		     (match_operand:HI 2 "nonmemory_operand" "n,n,c")))]
  ""
  "*return output_shift_insn (operands, 'a', 'r');")

(define_insn "ashldi3"
  [(set (match_operand:DI 0 "register_operand" "=t,d,a")
	(ashift:DI (match_operand:DI 1 "register_operand" "0,0,0")
		   (match_operand:HI 2 "nonmemory_operand" "n,n,c")))]
  ""
  "*return output_shift_insn (operands, 'a', 'l');")


;
; SIGN-extend instructions
;

(define_insn "extendhiti2"
  [(set (match_operand:TI 0 "register_operand" "=a")
        (sign_extend:TI (match_operand:HI 1 "register_operand" "c")))]
  ""
  "move.1 #3,p\;jsr ___extenditi")

(define_insn "extendditi2"
  [(set (match_operand:TI 0 "register_operand" "=a")
        (sign_extend:TI (match_operand:DI 1 "register_operand" "c")))]
  ""
  "jsr ___extendti")

(define_insn "extendsidi2"
  [(set (match_operand:DI 0 "register_operand" "=a")
	(sign_extend:DI (match_operand:SI 1 "register_operand" "c")))]
  ""
  "move.1 #3,p\;jsr ___extenddi")

(define_insn "extendqidi2"
  [(set (match_operand:DI 0 "register_operand" "=a")
	(sign_extend:DI (match_operand:QI 1 "register_operand" "c")))]
  ""
  "move.1 #0,p\;jsr ___extenddi")

(define_insn "extendhidi2"
  [(set (match_operand:DI 0 "register_operand" "=a")
	(sign_extend:DI (match_operand:HI 1 "register_operand" "c")))]
  ""
  "move.1 #1,p\;jsr ___extenddi")

(define_insn "extendhisi2"
  [(set (match_operand:SI 0 "register_operand" "=a")
	(sign_extend:SI (match_operand:HI 1 "register_operand" "c")))]
  ""
  "move.1 #1,p\;jsr ___extendsi")


;
; ZERO-extend instructions
;

(define_insn "zero_extendsidi2"
  [(set (match_operand:DI 0 "register_operand" "=q,b,c,d")
	(zero_extend:DI (match_operand:SI 1 "register_operand" "b,q,d,c")))]
  ""
  "clr.wp %0\;move.1 #3,p\;move.wp %1,%0\;move.1 #7,p")

(define_insn "zero_extendhisi2"
  [(set (match_operand:SI 0 "register_operand" "=q,b,c,d")
	(zero_extend:SI (match_operand:HI 1 "register_operand" "b,q,d,c")))]
  ""
  "clr.a %0\;move.b %1,%0")

(define_insn "zero_extendhidi2"
  [(set (match_operand:DI 0 "register_operand" "=q,b,c,d")
	(zero_extend:DI (match_operand:HI 1 "register_operand" "b,q,d,c")))]
  ""
  "clr.wp %0\;move.b %1,%0")

(define_insn "zero_extendhiti2"
  [(set (match_operand:TI 0 "register_operand" "=q,b,c,d")
        (zero_extend:TI (match_operand:HI 1 "register_operand" "b,q,d,c")))]
  ""
  "clr.w %0\;move.b %1,%0")

(define_insn "zero_extendditi2"
  [(set (match_operand:TI 0 "register_operand" "=q,b,c,d")
        (zero_extend:TI (match_operand:DI 1 "register_operand" "b,q,d,c")))]
  ""
  "clr.w %0\;move.wp %1,%0")

(define_insn "zero_extendqidi2"
  [(set (match_operand:DI 0 "register_operand" "=q,b,c,d")
	(zero_extend:DI (match_operand:QI 1 "register_operand" "b,q,d,c")))]
  ""
  "clr.wp %0\;move.1 #0,p\;move.p %1,%0\;move.1 #7,p")


(define_insn "negti2"
  [(set (match_operand:TI 0 "register_operand" "=t,d")
	(neg:DI (match_operand:TI 1 "register_operand" "0,0")))]
  ""
  "neg.w %0")

(define_insn "negdi2"
  [(set (match_operand:DI 0 "register_operand" "=t,d")
	(neg:DI (match_operand:DI 1 "register_operand" "0,0")))]
  ""
  "neg.wp %0")

(define_insn "negsi2"
  [(set (match_operand:SI 0 "register_operand" "=t,d")
	(neg:SI (match_operand:SI 1 "register_operand" "0,0")))]
  ""
  "neg.a %0")

(define_insn "neghi2"
  [(set (match_operand:HI 0 "register_operand" "=t,d")
	(neg:HI (match_operand:HI 1 "general_operand" "0,0")))]
  ""
  "neg.b %0")


(define_insn "one_cmplti2"
  [(set (match_operand:TI 0 "register_operand" "=t,d")
	(not:TI (match_operand:TI 1 "register_operand" "0,0")))]
  ""
  "not.w %0")

(define_insn "one_cmpldi2"
  [(set (match_operand:DI 0 "register_operand" "=t,d")
	(not:DI (match_operand:DI 1 "register_operand" "0,0")))]
  ""
  "not.wp %0")

(define_insn "one_cmplsi2"
  [(set (match_operand:SI 0 "register_operand" "=t,d")
	(not:SI (match_operand:SI 1 "register_operand" "0,0")))]
  ""
  "not.a %0")

(define_insn "one_cmplhi2"
  [(set (match_operand:HI 0 "register_operand" "=t,d")
	(not:HI (match_operand:HI 1 "register_operand" "0,0")))]
  ""
  "not.b %0")

;;
;;
;; Floating point stuff, incomplete.
;;
;;


(define_expand "reload_indf"
  [(set (match_operand:DF 0 "register_operand" "=r")
	(match_operand:DF 1 "general_operand" "g"))
   (clobber (match_operand:DF 2 "register_operand" "=&q"))]
  ""
  "{
     emit_move_insn (operands[2], operands[1]);
     emit_move_insn (operands[0], operands[2]);
     DONE;
   }")

(define_expand "reload_outdf"
  [(set (match_operand:DF 0 "general_operand" "=g")
	(match_operand:DF 1 "register_operand" "r"))
   (clobber (match_operand:DF 2 "register_operand" "=&q"))]
  ""
  "{
     emit_move_insn (operands[2], operands[1]);
     emit_move_insn (operands[0], operands[2]);
     DONE;
   }")

(define_insn "movdf"
  [(set (match_operand:DF 0 "general_operand" "=q,bRqm,q,c,d")
	(match_operand:DF 1 "general_operand" "n,q,bRqm,d,c"))]
  ""
  "@
    move.1 #0,p\;move.16 #%1,%0\;move.1 #7,p
    move.w %1,%0
    move.w %1,%0
    move.w %1,%0
    move.w %1,%0")

(define_insn "negdf2"
  [(set (match_operand:DF 0 "register_operand" "=t,d")
	(neg (match_operand:DF 1 "register_operand" "0,0")))]
  ""
  "setdec\;not.s %0\;sethex")


(define_expand "reload_intf"
  [(set (match_operand:TF 0 "register_operand" "=r")
	(match_operand:TF 1 "general_operand" "g"))
   (clobber (match_operand:TF 2 "register_operand" "=&q"))]
  ""
  "{
     emit_move_insn (operands[2], operands[1]);
     emit_move_insn (operands[0], operands[2]);
     DONE;
   }")

(define_expand "reload_outtf"
  [(set (match_operand:TF 0 "general_operand" "=g")
	(match_operand:TF 1 "register_operand" "r"))
   (clobber (match_operand:TF 2 "register_operand" "=&q"))]
  ""
  "{
     emit_move_insn (operands[2], operands[1]);
     emit_move_insn (operands[0], operands[2]);
     DONE;
   }")

(define_insn "movtf"
  [(set (match_operand:TF 0 "general_operand" "=q,bRqm,q,c,d")
	(match_operand:TF 1 "general_operand" "n,q,bRqm,d,c"))]
  ""
  "@
    move.1 #0,p\;move.16 #%1,%0\;move.1 #7,p
    move.w %1,%0
    move.w %1,%0
    move.w %1,%0
    move.w %1,%0")


(define_insn "cmpdf"
  [(set (cc0)
	(compare (match_operand:DF 0 "register_operand" "a")
		 (match_operand:DF 1 "register_operand" "c")))
   (clobber (reg:DF 2))
   (clobber (reg:DF 3))
   (clobber (reg:DF 4))
   (clobber (reg:DF 5))]
  ""
  "*
    extern rtx cmp_op0, cmp_op1;
    cmp_op0 = operands[0]; cmp_op1 = operands[1];
    output_lib_cmp (insn, cmp_op0, cmp_op1);
    return \"; compare float %0, %1\";
  ")

(define_insn "cmptf"
  [(set (cc0)
	(compare (match_operand:TF 0 "register_operand" "a")
		 (match_operand:TF 1 "register_operand" "c")))
   (clobber (reg:TF 2))
   (clobber (reg:TF 3))
   (clobber (reg:TF 4))
   (clobber (reg:TF 5))]
  ""
  "*
    extern rtx cmp_op0, cmp_op1;
    cmp_op0 = operands[0]; cmp_op1 = operands[1];
    output_lib_cmp (insn, cmp_op0, cmp_op1);
    return \"; compare double %0, %1\";
  ")

