#include <hp48/lcd.h>

#define YMIN -1.10
#define YMAX  1.10
#define XMIN -2.85
#define XMAX  1.65

#define BREAKOUT 4
#define MAXITER 64

int
msetlev (float cx, float cy)
{
  int i;
  float x, y;
  float x2, y2;

  x = cx;
  y = cy;
  for (i = 1; i < MAXITER; i++)
    { 
      x2 = x * x;
      y2 = y * y;
      if ((x2 + y2) >= BREAKOUT)
	break;
      y = 2 * x * y + cy;
      x = x2 - y2 + cx;
    }
  return i;
}


int
main (int argc, char **argv)
{
  eint 	x, y;
  int   l;
  float cx, cy;
  float deltax, deltay;

  deltay = (YMAX - YMIN) / (float)LCD_HEIGHT;
  deltax = (XMAX - XMIN) / (float)LCD_WIDTH;

  initscr ();
  clrscr ();

  cy = YMIN;
  for (y = 0; y < LCD_HEIGHT; y++)
    {
      cx = XMIN;
      for (x = 0; x < LCD_WIDTH; x++)
        {
	  setpixel (x, y);
          l = msetlev (cx, cy);
          if ((l < MAXITER) && (l & 0x01))
	    clrpixel (x, y);
          cx += deltax;
        }
      cy += deltay;
    }

  exitscr ();
  return 0;
}

