/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.wrapper;

import java.io.File;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PathAssembler {
    public static final String GRADLE_USER_HOME_STRING = "GRADLE_USER_HOME";
    public static final String PROJECT_STRING = "PROJECT";
    private File gradleUserHome;

    public PathAssembler() {
    }

    public PathAssembler(File gradleUserHome) {
        this.gradleUserHome = gradleUserHome;
    }

    public File gradleHome(String distBase, String distPath, URI distUrl) {
        return new File(this.getBaseDir(distBase), distPath + "/" + this.getDistHome(distUrl));
    }

    public File distZip(String zipBase, String zipPath, URI distUrl) {
        return new File(this.getBaseDir(zipBase), zipPath + "/" + this.getDistName(distUrl));
    }

    private String getDistHome(URI distUrl) {
        String name = this.getDistName(distUrl);
        Matcher matcher = Pattern.compile("(\\p{Alpha}+-\\d+\\.\\d+.*?)(-\\p{Alpha}+)?\\.zip").matcher(name);
        if (!matcher.matches()) {
            throw new RuntimeException(String.format("Cannot determine Gradle version from distribution URL '%s'.", distUrl));
        }
        return matcher.group(1);
    }

    private String getDistName(URI distUrl) {
        String path = distUrl.getPath();
        int p = path.lastIndexOf("/");
        if (p < 0) {
            return path;
        }
        return path.substring(p + 1);
    }

    private File getBaseDir(String base) {
        if (base.equals(GRADLE_USER_HOME_STRING)) {
            return this.gradleUserHome;
        }
        if (base.equals(PROJECT_STRING)) {
            return new File(System.getProperty("user.dir"));
        }
        throw new RuntimeException("Base: " + base + " is unknown");
    }
}

