/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.tree.TreePath;
import org.isqlviewer.core.model.BookmarkTreeModel;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.sql.JDBCUtilities;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringUtilities;

public class SQLBookmark
implements Transferable,
Cloneable,
Comparable {
    private Vector params = new Vector();
    private String path = null;
    private String sql = null;
    private String name = null;
    private long lastUsedTime = 0L;
    private long creationTime = 0L;
    private long useCount = 0L;
    private boolean favorite = false;

    public SQLBookmark(String name, String SQL) {
        this(null, name, SQL);
    }

    public SQLBookmark(String name) {
        this(null, name, "");
    }

    public SQLBookmark(Date created, String name) {
        this(created, name, "");
    }

    public SQLBookmark(Date created, String name, String SQL) {
        this.creationTime = created == null ? System.currentTimeMillis() : created.getTime();
        this.setName(name);
        this.setSQL(SQL);
    }

    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{BasicUtilities.bookmarkFlavour, DataFlavor.stringFlavor};
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return BasicUtilities.bookmarkFlavour.equals(flavor) || DataFlavor.stringFlavor.equals(flavor);
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (BasicUtilities.bookmarkFlavour.equals(flavor)) {
            return this;
        }
        if (DataFlavor.stringFlavor.equals(flavor)) {
            return this.getSQL();
        }
        throw new UnsupportedFlavorException(flavor);
    }

    public int compareTo(Object o) {
        if (o instanceof SQLBookmark) {
            SQLBookmark other = (SQLBookmark)o;
            String remote = other.getPath().concat(other.getName());
            String local = this.getPath().concat(this.getName());
            return local.compareToIgnoreCase(remote);
        }
        return -1;
    }

    public Object clone() {
        SQLBookmark copy = new SQLBookmark(this.getName());
        copy.setLastAccessTime(this.lastUsedTime);
        copy.setPath(this.path);
        copy.setSQL(this.sql);
        Iterator itr = this.parameterIterator();
        while (itr.hasNext()) {
            Parameter next = (Parameter)itr.next();
            copy.addParameter((Parameter)next.clone());
        }
        return copy;
    }

    public boolean equals(Object o) {
        if (o instanceof SQLBookmark) {
            SQLBookmark other = (SQLBookmark)o;
            return this.compareTo(other) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("SQLBookmark[count=\"");
        buff.append(Long.toString(this.useCount));
        buff.append("\" ");
        buff.append("last=\"");
        buff.append(Long.toString(this.lastUsedTime));
        buff.append("\" created=\"");
        buff.append(Long.toString(this.creationTime));
        buff.append("\" name=\"");
        buff.append(this.name);
        buff.append("\" favorite=\"");
        buff.append(Boolean.toString(this.favorite));
        buff.append("\" paramcount=\"");
        buff.append(Integer.toString(this.parameterCount()));
        buff.append("\" sql=\"");
        buff.append(this.sql);
        buff.append("\" ]");
        return buff.toString();
    }

    public String getSQL() {
        return this.sql;
    }

    public String getPath() {
        return this.path == null ? "/" : this.path;
    }

    public String getName() {
        return this.name;
    }

    public TreePath toTreePath() {
        return BookmarkTreeModel.getTreePath(this.getPath()).pathByAddingChild(this);
    }

    public void updateLastAcessTime() {
        this.lastUsedTime = System.currentTimeMillis();
    }

    public void updateUseCount() {
        ++this.useCount;
    }

    public Date getLastAccessTime() {
        return new Date(this.lastUsedTime);
    }

    public Date getCreationDate() {
        return new Date(this.creationTime);
    }

    public long getUseCount() {
        return this.useCount < 0L ? 0L : this.useCount;
    }

    public void setSQL(String SQL) {
        this.sql = SQL == null ? "" : "".concat(SQL);
    }

    public void setPath(String path) {
        this.path = path == null ? "/" : "".concat(path);
    }

    public void setName(String name) {
        if (name == null || name.trim().length() < 1) {
            throw new IllegalArgumentException(BasicUtilities.getString("Illegal_Bookmark_Name"));
        }
        this.name = new String(name);
    }

    public void setLastAccessTime(long date) {
        this.lastUsedTime = date;
    }

    public void setUseCount(long count) {
        this.useCount = Math.max(0L, count);
    }

    public boolean addParameter(Parameter parameter) {
        if (parameter == null) {
            return false;
        }
        return this.params.add(parameter);
    }

    public boolean addAll(Collection parameters) {
        if (parameters == null) {
            return false;
        }
        boolean added = false;
        Iterator itr = parameters.iterator();
        while (itr.hasNext()) {
            Object next = itr.next();
            if (!(next instanceof Parameter)) continue;
            added = true;
            this.params.add(next);
        }
        return added;
    }

    public void clearParameters() {
        this.params.clear();
    }

    public boolean contains(Parameter parameter) {
        if (parameter == null) {
            return false;
        }
        return this.params.contains(parameter);
    }

    public Parameter getParameter(int index) {
        if (index < 0 || index >= this.params.size()) {
            return null;
        }
        return (Parameter)this.params.get(index);
    }

    public int indexOf(Parameter parameter) {
        if (parameter == null) {
            return -1;
        }
        return this.params.indexOf(parameter);
    }

    public boolean hasParameters() {
        return !this.params.isEmpty();
    }

    public Iterator parameterIterator() {
        return this.params.iterator();
    }

    public Parameter remove(int index) {
        if (this.params.isEmpty() || index < 0 || index >= this.params.size()) {
            return null;
        }
        return (Parameter)this.params.remove(index);
    }

    public boolean remove(Parameter parameter) {
        if (parameter == null) {
            return false;
        }
        return this.params.remove(parameter);
    }

    public boolean removeAll(Collection parameters) {
        if (parameters == null) {
            return false;
        }
        return this.params.removeAll(parameters);
    }

    public Parameter set(int index, Parameter param) {
        return this.params.set(index, param);
    }

    public int parameterCount() {
        return this.params.size();
    }

    public PreparedStatement toPreparedStatement(DatabaseConnection cnx) throws SQLException, ParseException {
        return this.toPreparedStatement(cnx, 1003, 1007);
    }

    public PreparedStatement toPreparedStatement(DatabaseConnection cnx, int type, int concurrency) throws SQLException, ParseException {
        if (cnx == null || cnx.isClosed()) {
            throw new IllegalStateException(BasicUtilities.getString("Connection_Unavailable"));
        }
        PreparedStatement stmt = cnx.createPreparedStatement(this.getSQL(), type, concurrency);
        Iterator itr = this.parameterIterator();
        Object[] objs = new Object[this.params.size()];
        int[] types = new int[this.params.size()];
        int idx = 0;
        while (itr.hasNext()) {
            int sqltype;
            Parameter next = (Parameter)itr.next();
            types[idx] = sqltype = next.getSQLType();
            objs[idx] = StringUtilities.processString(next.getValue(), sqltype, next.getOptions());
            ++idx;
        }
        JDBCUtilities.configurePreparedStatement(stmt, objs, types, false);
        return stmt;
    }

    public static class Parameter
    implements Transferable,
    Cloneable {
        private int type = 1111;
        private String pvalue = null;
        private String options = null;

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (BasicUtilities.BOOKMARK_PARAMETER_FLAVOR.equals(flavor)) {
                return this;
            }
            if (DataFlavor.stringFlavor.equals(flavor)) {
                return this.toString();
            }
            throw new UnsupportedFlavorException(flavor);
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{BasicUtilities.BOOKMARK_PARAMETER_FLAVOR, DataFlavor.stringFlavor};
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return BasicUtilities.BOOKMARK_PARAMETER_FLAVOR.equals(flavor);
        }

        public boolean equals(Object arg0) {
            return super.equals(arg0);
        }

        public int hashCode() {
            return super.hashCode();
        }

        public String toString() {
            return super.toString();
        }

        public Object clone() {
            Parameter clone = new Parameter();
            clone.options = this.options;
            clone.pvalue = this.pvalue;
            clone.type = this.type;
            return clone;
        }

        public String getOptions() {
            return this.options;
        }

        public void setOptions(String options) {
            this.options = options == null ? "" : "".concat(options);
        }

        public String getValue() {
            return this.pvalue;
        }

        public void setValue(String value) {
            this.pvalue = value == null ? "" : value;
        }

        public int getSQLType() {
            return this.type;
        }

        public void setSQLType(int type) {
            this.type = type;
        }

        public Object processOptions() throws ParseException {
            return this.processOptions(this.getValue());
        }

        public Object processOptions(String value) throws ParseException {
            return StringUtilities.processString(value, this.getSQLType(), this.getOptions());
        }
    }
}

