/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.sql.DriverPool;
import org.isqlviewer.util.Base64Decoder;
import org.isqlviewer.util.Base64Encoder;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringUtilities;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ServiceDefinition
implements Transferable,
Cloneable {
    public static final String REMOTE_URL = "url";
    public static final String REMOTE_VERSION = "version";
    public static final String REMOTE_SYNC_TYPE = "sync-type";
    public static final String REMOTE_RESOURCES = "local-resources";
    private static final String TAG_ROOT = "isql-service";
    private static final String TAG_AUTH = "authorization";
    private static final String TAG_EXTP = "extended-properties";
    private static final String TAG_JDBC = "jdbc-properties";
    private static final String TAG_RSRC = "resources";
    private static final String TAG_PROP = "property";
    private static final String TAG_JAR = "jar";
    private static final String TAG_CFG = "config";
    private static final String TAG_REMOTE = "remote-config";
    private static final String ATTRIB_SECURE = "secure";
    private static final String ATTRIB_SCHEMA = "preferred-schema";
    private static final String ATTRIB_NAME = "name";
    private static final String ATTRIB_VALUE = "value";
    private static final String ATTRIB_DRVR = "driver";
    private static final String ATTRIB_USER = "user";
    private static final String ATTRIB_PASS = "password";
    private static final String ATTRIB_HREF = "href";
    private static final String ATTRIB_URL = "url";
    private static final byte[] xorKey = new byte[]{1, 8, 16, 24, 2, 10, 18, 26, 4, 12, 20, 28, 6, 14, 22, 30, 8, 16, 24, 32, 10, 18, 26, 34};
    private ArrayList resourceList = null;
    private String serviceName = null;
    private String driverClass = null;
    private String serviceURL = null;
    private String serviceUser = null;
    private String servicePass = null;
    private String preferredSchema = null;
    private Properties extProps = null;
    private Properties jdbcProps = null;
    private HashMap remoteProps = null;
    private boolean isSecure = false;
    private boolean isSynced = false;
    private ClassLoader classLoader = null;
    private DatabaseConnection cnx = null;
    private static final FilenameFilter filter = new ServiceFileFilter();
    private static final Charset charset = Charset.forName("UTF8");

    public static FilenameFilter getFileNameFilter() {
        return filter;
    }

    public ServiceDefinition(Properties jdbcDefaults, boolean issecure) {
        this.jdbcProps = jdbcDefaults;
        this.setSecurityEnabled(issecure);
    }

    private ServiceDefinition() {
    }

    private ServiceDefinition(ServiceDefinition copy) {
        this.resourceList = copy.resourceList != null ? (ArrayList)copy.resourceList.clone() : null;
        this.extProps = copy.extProps != null ? (Properties)copy.extProps.clone() : null;
        this.serviceName = copy.serviceName != null ? new String(copy.serviceName) : null;
        this.driverClass = copy.driverClass != null ? new String(copy.driverClass) : null;
        this.serviceURL = copy.serviceURL != null ? new String(copy.serviceURL) : null;
        this.serviceUser = copy.serviceUser != null ? new String(copy.serviceUser) : null;
        this.servicePass = copy.servicePass != null ? new String(copy.servicePass) : null;
        this.preferredSchema = copy.preferredSchema != null ? new String(copy.preferredSchema) : null;
        this.isSecure = copy.isSecure;
    }

    public void store(OutputStream os) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(os, charset);
        PrintWriter pw = new PrintWriter((Writer)writer, false);
        pw.println("<?xml version=\"1.0\" encoding=\"" + charset.name() + "\" standalone='yes' ?>");
        this.printRootTag(pw);
        pw.flush();
        pw.close();
        writer.close();
        pw = null;
        writer = null;
    }

    public void close() {
        if (this.cnx != null) {
            DriverPool.deregisterDriver(this.cnx.getDriver());
            this.cnx.disconnect();
            this.cnx = null;
        }
        this.classLoader = null;
        System.runFinalization();
    }

    public DatabaseConnection createConnection() throws ClassNotFoundException, SQLException {
        if (this.needsRemoteUpdate()) {
            try {
                this.synchronize();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (this.cnx == null) {
            Properties props;
            DriverPool.registerDriver(this.driverClass, this.getClassLoader());
            Properties properties = props = this.extProps == null ? new Properties() : this.extProps;
            if (!props.containsKey(ATTRIB_USER) && this.serviceUser != null) {
                props.setProperty(ATTRIB_USER, this.serviceUser);
            }
            if (!props.containsKey(ATTRIB_PASS) && this.servicePass != null) {
                props.setProperty(ATTRIB_PASS, this.servicePass);
            }
            this.cnx = new DatabaseConnection(this.serviceURL.trim(), props);
            this.cnx.configureOptions(this.jdbcProps);
            this.cnx.setPreferredSchema(this.preferredSchema);
            this.cnx.setConnectionName(this.getName());
        }
        return this.cnx;
    }

    public boolean isPromptRequired() {
        return this.serviceUser == null && this.servicePass == null;
    }

    public URL[] getResourceURLs() {
        URL[] urlrc = new URL[this.resourceList == null ? 0 : this.resourceList.size()];
        for (int i = 0; i < urlrc.length; ++i) {
            urlrc[i] = (URL)this.resourceList.get(i);
        }
        return urlrc;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public Properties getProperties() {
        return this.extProps;
    }

    public Properties getPreferences() {
        return this.jdbcProps;
    }

    public ArrayList getResourceList() {
        return this.resourceList;
    }

    public String getName() {
        return this.serviceName;
    }

    public String getURL() {
        return this.serviceURL;
    }

    public String getUserName() {
        return this.serviceUser;
    }

    public void setDriverClass(String driverClass) {
        this.driverClass = driverClass;
    }

    public void setProperties(Properties properties) {
        this.extProps = properties;
    }

    public void setPreferences(Properties properties) {
        this.jdbcProps = properties;
    }

    public void setResourceList(ArrayList resources) {
        this.resourceList = resources;
        this.classLoader = null;
    }

    public void setName(String name) {
        this.serviceName = name;
    }

    public Object getRemoteConfig(String property) {
        if (this.isRemote()) {
            return this.remoteProps.get(property);
        }
        return null;
    }

    public void setSecurityEnabled(boolean flag) {
        this.isSecure = flag;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public void setPassword(String servicePass) {
        this.servicePass = servicePass;
    }

    public void setPreferredSchema(String schema) {
        this.preferredSchema = schema != null && schema.trim().length() == 0 ? null : schema;
    }

    public String getPreferredSchema() {
        return this.preferredSchema;
    }

    public void setURL(String url) {
        this.serviceURL = url;
    }

    public void setUserName(String username) {
        this.serviceUser = username;
    }

    public void setRemoteProperty(String property, Object value) {
        if (property == null | !this.isRemote() || value == null) {
            return;
        }
        if (property.equalsIgnoreCase(REMOTE_RESOURCES) && !(value instanceof ArrayList)) {
            throw new IllegalArgumentException(value.getClass().toString());
        }
        this.remoteProps.put(property, value);
    }

    public void setRemoteEnabled(boolean f, String url) {
        if (url == null) {
            url = "";
        }
        if (f) {
            if (this.remoteProps == null) {
                this.remoteProps = new HashMap();
            }
            this.remoteProps.put("url", url);
            this.remoteProps.put(REMOTE_VERSION, "0");
        } else {
            this.remoteProps.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(InputStream is) throws IOException {
        XMLReader reader = null;
        SystemConfig sysConfig = SystemConfig.getInstance();
        try {
            reader = sysConfig.getXMLReader();
            reader.setContentHandler(new ServiceParser(this, false));
            reader.parse(new InputSource(is));
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Throwable t) {
            BasicUtilities.HandleException(t, "ServiceDefinition::load(InputStream, SystemConfig)");
        }
        finally {
            reader = null;
            this.isSynced = false;
        }
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            ArrayList lst;
            URL[] cp = this.getResourceURLs();
            if (this.isRemote() && (lst = (ArrayList)this.remoteProps.get(REMOTE_RESOURCES)) != null) {
                lst.addAll(Arrays.asList(cp));
                cp = lst.toArray(new URL[0]);
            }
            this.classLoader = cp.length == 0 ? SystemConfig.getInstance().getRuntimeClassLoader() : new URLClassLoader(cp, SystemConfig.getInstance().getRuntimeClassLoader());
        }
        return this.classLoader;
    }

    public void localize() {
        if (!this.isRemote()) {
            return;
        }
        this.remoteProps.put(REMOTE_VERSION, "-1");
        try {
            this.synchronize();
            ArrayList lst = (ArrayList)this.remoteProps.get(REMOTE_RESOURCES);
            if (lst != null) {
                if (this.resourceList != null) {
                    this.resourceList.addAll(lst);
                } else {
                    this.resourceList = new ArrayList(lst);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.remoteProps.clear();
        this.remoteProps = null;
    }

    public Object clone() {
        return new ServiceDefinition(this);
    }

    public boolean isRemote() {
        return this.remoteProps != null && !this.remoteProps.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        ByteArrayOutputStream out = new ByteArrayOutputStream(64);
        try {
            ServiceDefinition serviceDefinition = this;
            synchronized (serviceDefinition) {
                this.store(out);
            }
        }
        catch (Throwable t) {
            BasicUtilities.HandleException(t);
        }
        String txt = out.toString();
        out.reset();
        out = null;
        return txt;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ServiceDefinition) {
            ServiceDefinition other = (ServiceDefinition)obj;
            return other.hashCode() == this.hashCode();
        }
        return false;
    }

    public boolean synchronize() throws IOException {
        if (this.isRemote() && this.needsRemoteUpdate()) {
            this.remoteSync();
            this.isSynced = true;
            return this.isSynced;
        }
        this.isSynced = true;
        return false;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{BasicUtilities.serviceFlavour, DataFlavor.javaFileListFlavor, DataFlavor.stringFlavor};
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return BasicUtilities.serviceFlavour.equals(flavor) || DataFlavor.javaFileListFlavor.equals(flavor) || DataFlavor.stringFlavor.equals(flavor);
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (BasicUtilities.serviceFlavour.equals(flavor)) {
            return this;
        }
        if (flavor.isFlavorJavaFileListType()) {
            ArrayList<File> lst = new ArrayList<File>(1);
            lst.add(new File(this.getName().concat(".service")));
            return lst;
        }
        if (DataFlavor.stringFlavor.equals(flavor)) {
            return this.toString();
        }
        throw new UnsupportedFlavorException(flavor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean needsRemoteUpdate() {
        if (this.isRemote() && !this.isSynced) {
            URLConnection conn = null;
            long version = -1L;
            try {
                String v = (String)this.remoteProps.get(REMOTE_VERSION);
                version = Long.parseLong(v);
            }
            catch (Throwable t) {
                this.remoteProps.put(REMOTE_VERSION, Long.toString(version));
            }
            try {
                String uri = (String)this.remoteProps.get("url");
                URL url = new URL(uri);
                conn = url.openConnection();
                boolean bl = conn.getLastModified() != version;
                return bl;
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t);
                boolean bl = false;
                return bl;
            }
            finally {
                conn = null;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remoteSync() throws IOException {
        SystemConfig sysConfig = SystemConfig.getInstance();
        String uri = (String)this.remoteProps.get("url");
        URL url = new URL(uri);
        URLConnection conn = url.openConnection();
        String oldName = new String(this.serviceName == null ? "" : this.serviceName);
        InputStream is = conn.getInputStream();
        XMLReader reader = null;
        try {
            reader = sysConfig.getXMLReader();
            reader.setContentHandler(new ServiceParser(this, true));
            reader.parse(new InputSource(is));
        }
        catch (Throwable t) {
            BasicUtilities.HandleException(t, "ServiceDefinition::remoteUpdate()");
        }
        finally {
            reader = null;
        }
        this.remoteProps.put(REMOTE_VERSION, Long.toString(conn.getLastModified()));
        this.setName(oldName);
    }

    private String encryptString(String Word) {
        if (Word == null) {
            return "";
        }
        if (Word.length() < xorKey.length) {
            int pad = xorKey.length - Word.length();
            byte[] padkey = new byte[pad];
            for (int i = 0; i < pad; ++i) {
                padkey[i] = xorKey[i];
            }
            Word = Word.concat(new String(padkey));
        }
        byte[] pass = Word.getBytes();
        byte[] xorStr = new byte[pass.length];
        int j = 0;
        for (int i = 0; i < pass.length; ++i) {
            if (j >= xorKey.length) {
                j = 0;
            }
            xorStr[i] = (byte)(xorKey[j++] ^ pass[i]);
        }
        String str = new String(xorStr);
        return str.trim();
    }

    private void printRootTag(PrintWriter ps) {
        ps.print("<");
        ps.print(TAG_ROOT);
        ps.print(" ");
        ps.print(ATTRIB_SECURE);
        ps.print("=\"");
        ps.print(this.isSecure);
        ps.print("\" ");
        ps.print(ATTRIB_NAME);
        ps.print("=\"");
        ps.print(StringUtilities.encodeXMLEntities(this.serviceName).trim());
        ps.println("\" >");
        this.printRemoteTag(ps);
        this.printAuthTag(ps);
        this.printConfig(ps);
        ps.print("</");
        ps.print(TAG_ROOT);
        ps.println(">");
    }

    private void printAuthTag(PrintWriter ps) {
        if (this.serviceUser != null) {
            String pass;
            ps.print("\t<");
            ps.print(TAG_AUTH);
            ps.print(" ");
            ps.print(ATTRIB_USER);
            ps.print("=\"");
            ps.print(StringUtilities.encodeXMLEntities(this.serviceUser).trim());
            ps.print("\" ");
            ps.print(ATTRIB_PASS);
            String string = pass = this.servicePass == null ? "" : this.servicePass;
            if (pass.trim().length() >= 1) {
                if (this.isSecure) {
                    pass = this.encryptString(pass);
                    Base64Encoder codec = new Base64Encoder(pass);
                    pass = codec.processString();
                } else {
                    Base64Encoder codec = new Base64Encoder(pass);
                    pass = codec.processString();
                }
            }
            ps.print("=\"");
            ps.print(pass.trim());
            ps.println("\" />");
        }
    }

    private void printConfig(PrintWriter ps) {
        String val;
        String key;
        Iterator<Object> itr;
        ps.print("\t<");
        ps.print(TAG_CFG);
        ps.print(" ");
        if (this.preferredSchema != null) {
            ps.print(ATTRIB_SCHEMA);
            ps.print("=\"");
            ps.print(StringUtilities.encodeXMLEntities(this.preferredSchema).trim());
            ps.print("\" ");
        }
        ps.print(ATTRIB_DRVR);
        ps.print("=\"");
        ps.print(StringUtilities.encodeXMLEntities(this.driverClass).trim());
        ps.print("\" ");
        ps.print("url");
        ps.print("=\"");
        ps.print(StringUtilities.encodeXMLEntities(this.serviceURL).trim());
        ps.println("\" >");
        if (this.extProps != null && !this.extProps.isEmpty()) {
            ps.print("\t\t<");
            ps.print(TAG_EXTP);
            ps.println(">");
            itr = this.extProps.keySet().iterator();
            while (itr.hasNext()) {
                key = (String)itr.next();
                val = this.extProps.getProperty(key, "");
                ps.print("\t\t\t<");
                ps.print(TAG_PROP);
                ps.print(" ");
                ps.print(ATTRIB_NAME);
                ps.print("=\"");
                ps.print(StringUtilities.encodeXMLEntities(key).trim());
                ps.print("\" ");
                ps.print(ATTRIB_VALUE);
                ps.print("=\"");
                ps.print(StringUtilities.encodeXMLEntities(val).trim());
                ps.println("\" />");
            }
            ps.print("\t\t</");
            ps.print(TAG_EXTP);
            ps.println(">");
        }
        if (this.jdbcProps != null && !this.jdbcProps.isEmpty()) {
            ps.print("\t\t<");
            ps.print(TAG_JDBC);
            ps.println(">");
            itr = this.jdbcProps.keySet().iterator();
            while (itr.hasNext()) {
                key = (String)itr.next();
                val = this.jdbcProps.getProperty(key, "");
                ps.print("\t\t\t<");
                ps.print(TAG_PROP);
                ps.print(" ");
                ps.print(ATTRIB_NAME);
                ps.print("=\"");
                ps.print(StringUtilities.encodeXMLEntities(key).trim());
                ps.print("\" ");
                ps.print(ATTRIB_VALUE);
                ps.print("=\"");
                ps.print(StringUtilities.encodeXMLEntities(val).trim());
                ps.println("\" />");
            }
            ps.print("\t\t</");
            ps.print(TAG_JDBC);
            ps.println(">");
        }
        if (this.resourceList != null && !this.resourceList.isEmpty()) {
            ps.print("\t\t<");
            ps.print(TAG_RSRC);
            ps.println(">");
            itr = this.resourceList.iterator();
            while (itr.hasNext()) {
                URL url = (URL)itr.next();
                if (url == null) continue;
                ps.print("\t\t\t<");
                ps.print(TAG_JAR);
                ps.print(" ");
                ps.print(ATTRIB_HREF);
                ps.print("=\"");
                ps.print(StringUtilities.encodeXMLEntities(url.toExternalForm()).trim());
                ps.println("\" />");
            }
            ps.print("\t\t</");
            ps.print(TAG_RSRC);
            ps.println(">");
        }
        ps.print("\t</");
        ps.print(TAG_CFG);
        ps.println(">");
    }

    private void printRemoteTag(PrintWriter ps) {
        if (!this.isRemote()) {
            return;
        }
        Object o = null;
        ps.print("\t<");
        ps.print(TAG_REMOTE);
        ps.print(" ");
        ps.print(REMOTE_VERSION);
        ps.print("=\"");
        o = this.remoteProps.get(REMOTE_VERSION);
        ps.print(o == null ? "0" : o);
        ps.print("\" ");
        ps.print("url");
        ps.print("=\"");
        o = this.remoteProps.get("url");
        ps.print(StringUtilities.encodeXMLEntities(o.toString()).trim());
        ps.println("\" >");
        o = this.remoteProps.get(REMOTE_RESOURCES);
        if (o != null && o instanceof Collection) {
            Collection c = (Collection)o;
            Iterator itr = c.iterator();
            if (!c.isEmpty()) {
                ps.print("\t\t<");
                ps.print(REMOTE_RESOURCES);
                ps.println(" >");
                while (itr.hasNext()) {
                    URL url = (URL)itr.next();
                    if (url == null) continue;
                    ps.print("\t\t\t<");
                    ps.print(TAG_JAR);
                    ps.print(" ");
                    ps.print(ATTRIB_HREF);
                    ps.print("=\"");
                    ps.print(StringUtilities.encodeXMLEntities(url.toExternalForm()).trim());
                    ps.println("\" />");
                }
                ps.print("\t\t</");
                ps.print(REMOTE_RESOURCES);
                ps.println(" >");
            }
        }
        Iterator itr = this.remoteProps.keySet().iterator();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            if (key.equals(REMOTE_VERSION) || key.equals("url") || key.equals(REMOTE_RESOURCES)) continue;
            String val = (String)this.remoteProps.get(key);
            ps.print("\t\t<");
            ps.print(TAG_PROP);
            ps.print(" ");
            ps.print(ATTRIB_NAME);
            ps.print("=\"");
            ps.print(StringUtilities.encodeXMLEntities(key).trim());
            ps.print("\" ");
            ps.print(ATTRIB_VALUE);
            ps.print("=\"");
            ps.print(StringUtilities.encodeXMLEntities(val).trim());
            ps.println("\" />");
        }
        ps.print("\t</");
        ps.print(TAG_REMOTE);
        ps.println(">");
    }

    private static String decryptString(String str) {
        if (str == null) {
            return "";
        }
        byte[] bytes = str.getBytes();
        byte[] xorStr = new byte[bytes.length];
        int j = 0;
        for (int i = 0; i < bytes.length; ++i) {
            if (j >= xorKey.length) {
                j = 0;
            }
            xorStr[i] = (byte)(bytes[i] ^ xorKey[j++]);
        }
        String newStr = new String(xorStr);
        newStr.replace('\u0000', ' ');
        return newStr.trim();
    }

    private static class ServiceParser
    extends DefaultHandler {
        private ArrayList tagStack = new ArrayList();
        private boolean ignoreRemoteTag = false;
        private ServiceDefinition reference = null;

        public ServiceParser(ServiceDefinition service, boolean ignoreRemote) {
            this.reference = service;
            this.ignoreRemoteTag = ignoreRemote;
        }

        public void endElement(String ln, String ns, String name) {
            try {
                this.tagStack.remove(this.tagStack.size() - 1);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }

        public void startElement(String ln, String ns, String name, Attributes attr) throws SAXException {
            this.tagStack.add(name);
            String parentTag = null;
            try {
                parentTag = (String)this.tagStack.get(this.tagStack.size() - 2);
            }
            catch (Throwable t) {
                parentTag = ServiceDefinition.TAG_ROOT;
            }
            if (name.equalsIgnoreCase(ServiceDefinition.TAG_ROOT)) {
                if (attr.getIndex(ServiceDefinition.ATTRIB_NAME) < 0) {
                    throw new SAXException("name attribute missing from root tag");
                }
                if (!this.ignoreRemoteTag) {
                    this.reference.serviceName = attr.getValue(ServiceDefinition.ATTRIB_NAME);
                }
                try {
                    this.reference.isSecure = Boolean.valueOf(attr.getValue(ServiceDefinition.ATTRIB_SECURE));
                }
                catch (Throwable t) {
                    // empty catch block
                }
                return;
            }
            if (name.equalsIgnoreCase(ServiceDefinition.TAG_REMOTE)) {
                if (this.ignoreRemoteTag || !parentTag.equals(ServiceDefinition.TAG_ROOT)) {
                    return;
                }
                if (attr.getIndex("url") >= 0) {
                    this.reference.remoteProps = new HashMap();
                    this.reference.remoteProps.put("url", attr.getValue("url"));
                    int i = attr.getIndex(ServiceDefinition.REMOTE_VERSION);
                    if (i >= 0) {
                        this.reference.remoteProps.put(ServiceDefinition.REMOTE_VERSION, attr.getValue(i));
                    } else {
                        this.reference.remoteProps.put(ServiceDefinition.REMOTE_VERSION, "0");
                    }
                }
                return;
            }
            if (name.equalsIgnoreCase(ServiceDefinition.TAG_JDBC)) {
                if (!parentTag.equals(ServiceDefinition.TAG_CFG)) {
                    return;
                }
                this.reference.jdbcProps = new Properties();
                return;
            }
            if (name.equalsIgnoreCase(ServiceDefinition.TAG_RSRC)) {
                if (!parentTag.equals(ServiceDefinition.TAG_CFG)) {
                    return;
                }
                this.reference.resourceList = new ArrayList();
                return;
            }
            if (name.equalsIgnoreCase(ServiceDefinition.TAG_EXTP)) {
                if (!parentTag.equals(ServiceDefinition.TAG_CFG)) {
                    return;
                }
                this.reference.extProps = new Properties();
                return;
            }
            if (name.equalsIgnoreCase(ServiceDefinition.TAG_AUTH)) {
                String realpass;
                if (!parentTag.equals(ServiceDefinition.TAG_ROOT)) {
                    return;
                }
                if (attr.getIndex(ServiceDefinition.ATTRIB_USER) < 0) {
                    throw new SAXException("user attribute missing from authorization tag");
                }
                this.reference.servicePass = attr.getValue(ServiceDefinition.ATTRIB_PASS) == null ? "" : attr.getValue(ServiceDefinition.ATTRIB_PASS);
                String string = realpass = this.reference.servicePass == null ? "" : new String(this.reference.servicePass);
                if (realpass.trim().length() >= 1) {
                    try {
                        Base64Decoder codec = new Base64Decoder(realpass);
                        realpass = this.reference.isSecure ? ServiceDefinition.decryptString(codec.processString()) : codec.processString();
                    }
                    catch (Throwable t) {
                        System.out.println(BasicUtilities.getString("Password_Warning"));
                        realpass = this.reference.servicePass == null ? "" : new String(this.reference.servicePass);
                    }
                }
                this.reference.servicePass = new String(realpass);
                this.reference.serviceUser = attr.getValue(ServiceDefinition.ATTRIB_USER);
                return;
            }
            if (name.equalsIgnoreCase(ServiceDefinition.REMOTE_RESOURCES)) {
                if (this.ignoreRemoteTag || !parentTag.equals(ServiceDefinition.TAG_REMOTE)) {
                    return;
                }
                ArrayList lst = new ArrayList();
                this.reference.remoteProps.put(ServiceDefinition.REMOTE_RESOURCES, lst);
            }
            if (name.equalsIgnoreCase(ServiceDefinition.TAG_CFG)) {
                if (!parentTag.equals(ServiceDefinition.TAG_ROOT)) {
                    return;
                }
                if (attr.getIndex(ServiceDefinition.ATTRIB_DRVR) < 0) {
                    throw new SAXException("driver attribute missing from config tag");
                }
                if (attr.getIndex("url") < 0) {
                    throw new SAXException("url attribute missing from config tag");
                }
                if (attr.getIndex(ServiceDefinition.ATTRIB_SCHEMA) >= 0) {
                    this.reference.setPreferredSchema(attr.getValue(ServiceDefinition.ATTRIB_SCHEMA));
                } else {
                    this.reference.preferredSchema = null;
                }
                this.reference.serviceURL = attr.getValue("url");
                this.reference.driverClass = attr.getValue(ServiceDefinition.ATTRIB_DRVR);
                return;
            }
            if (name.equalsIgnoreCase(ServiceDefinition.TAG_PROP)) {
                String prop;
                if (attr.getIndex(ServiceDefinition.ATTRIB_NAME) < 0) {
                    throw new SAXException("name attribute missing from property tag");
                }
                Map<Object, Object> m = null;
                if (parentTag.equals(ServiceDefinition.TAG_EXTP)) {
                    m = this.reference.extProps;
                } else if (parentTag.equals(ServiceDefinition.TAG_JDBC)) {
                    m = this.reference.jdbcProps;
                } else if (parentTag.equals(ServiceDefinition.TAG_REMOTE)) {
                    if (this.ignoreRemoteTag) {
                        return;
                    }
                    m = this.reference.remoteProps;
                }
                String string = prop = attr.getValue(ServiceDefinition.ATTRIB_NAME) == null ? "" : attr.getValue(ServiceDefinition.ATTRIB_NAME);
                if (m != null && prop.trim().length() >= 1) {
                    String value = attr.getValue(ServiceDefinition.ATTRIB_VALUE) == null ? "" : attr.getValue(ServiceDefinition.ATTRIB_VALUE);
                    m.put(prop, value);
                }
                return;
            }
            if (name.equalsIgnoreCase(ServiceDefinition.TAG_JAR)) {
                if (!parentTag.equals(ServiceDefinition.TAG_RSRC) && !parentTag.equals(ServiceDefinition.REMOTE_RESOURCES)) {
                    return;
                }
                if (attr.getIndex(ServiceDefinition.ATTRIB_HREF) < 0) {
                    throw new SAXException("href attribute missing from resource tag");
                }
                try {
                    URL url = new URL(attr.getValue(ServiceDefinition.ATTRIB_HREF));
                    if (parentTag.equals(ServiceDefinition.TAG_RSRC)) {
                        if (this.reference.resourceList == null) {
                            this.reference.resourceList = new ArrayList();
                        }
                        this.reference.resourceList.add(url);
                    } else {
                        if (this.ignoreRemoteTag) {
                            return;
                        }
                        ArrayList<URL> lst = (ArrayList<URL>)this.reference.remoteProps.get(ServiceDefinition.REMOTE_RESOURCES);
                        if (lst == null) {
                            lst = new ArrayList<URL>();
                            this.reference.remoteProps.put(ServiceDefinition.REMOTE_RESOURCES, lst);
                        }
                        lst.add(url);
                    }
                }
                catch (Throwable t) {
                    BasicUtilities.HandleException(t);
                    System.out.println("Warning :: " + attr.getValue(ServiceDefinition.ATTRIB_HREF) + " could not be interpeted as a URL");
                }
                return;
            }
        }
    }

    private static class ServiceFileFilter
    implements FilenameFilter {
        private ServiceFileFilter() {
        }

        public boolean accept(File dir, String name) {
            boolean f = name.endsWith(".service");
            return f;
        }
    }
}

