/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core.jetfire;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.table.TableModel;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.core.jetfire.AbstractImportPlugin;
import org.isqlviewer.core.jetfire.ImportConfig;
import org.isqlviewer.core.jetfire.ImportProcessor;
import org.isqlviewer.sql.JDBCUtilities;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringUtilities;

public class MapperPlugin
extends AbstractImportPlugin {
    private DefaultComboBoxModel mdlColumns = new DefaultComboBoxModel();
    private JComboBox jcbColumns = new JComboBox(this.mdlColumns);
    private JComboBox jcbTypes = new JComboBox();
    private JTextField txtIOptions = new JTextField();
    private HashMap nativeTypes = null;
    private static final String KEY_SQL_TYPE = "sqltype";
    private static final String KEY_SELECTED = "selection";
    private static final String KEY_COLUMN_REF = "column-ref";
    private static final String KEY_OPTIONS = "options";

    public boolean canChangeSelection() {
        return true;
    }

    public void handleDataModelChange(TableModel model) {
        int i;
        int count = model.getColumnCount();
        String[] columns = new String[count];
        for (i = 0; i < count; ++i) {
            columns[i] = model.getColumnName(i);
        }
        Arrays.sort(columns, String.CASE_INSENSITIVE_ORDER);
        for (i = 0; i < count; ++i) {
            this.mdlColumns.addElement(columns[i]);
        }
        if (count >= 1) {
            this.jcbColumns.setSelectedIndex(0);
        }
    }

    public ImportConfig.Entry createEntry() {
        ImportConfig.Entry entry = new ImportConfig.Entry(this);
        Object item = this.jcbColumns.getSelectedItem();
        if (item != null) {
            entry.put(KEY_COLUMN_REF, item);
        } else {
            entry.put(KEY_COLUMN_REF, "null");
        }
        item = this.jcbTypes.getSelectedItem();
        if (item != null) {
            entry.put(KEY_SELECTED, item);
            if (!this.nativeTypes.isEmpty()) {
                entry.put(KEY_SQL_TYPE, this.nativeTypes.get(item));
            } else {
                entry.put(KEY_SQL_TYPE, new Integer(JDBCUtilities.getTypeforName((String)item)));
            }
        } else {
            entry.put(KEY_SQL_TYPE, new Integer(12));
        }
        entry.setProperty(KEY_OPTIONS, this.txtIOptions.getText());
        return entry;
    }

    public void setEntry(ImportConfig.Entry entry) {
        this.jcbColumns.setSelectedItem(entry.get(KEY_COLUMN_REF));
        this.jcbTypes.setSelectedItem(entry.get(KEY_SELECTED));
        this.txtIOptions.setText(entry.getProperty(KEY_OPTIONS, ""));
    }

    public void handleColumnSelectionChange(String newColumn, String oldColumn) {
    }

    public void handleTableSelectionChange(String oldTable, String newTable) {
    }

    public void installEditor(Container container) {
        this.nativeTypes = JDBCUtilities.getNativeTypeMap(this.connection.getDatabaseInformation());
        if (this.nativeTypes.isEmpty()) {
            this.jcbTypes = new JComboBox<String>(JDBCUtilities.getSQLTypes(true));
        } else {
            Object[] types = this.nativeTypes.keySet().toArray();
            Arrays.sort(types, String.CASE_INSENSITIVE_ORDER);
            this.jcbTypes = new JComboBox<Object>(types);
        }
        container.setLayout(new GridBagLayout());
        MapperPlugin.constrain(0, 0, 1, 3, 0.0, 0.0, 10, 0);
        container.add(Box.createHorizontalStrut(16), UI_CONSTRAINT);
        MapperPlugin.constrain(1, 0, 1, 1, 0.0, 0.0, 13, 0);
        container.add((Component)new JLabel(BasicUtilities.getString("Import_Source_Column")), UI_CONSTRAINT);
        MapperPlugin.constrain(2, 0, 1, 1, 1.0, 0.0, 10, 2);
        container.add((Component)this.jcbColumns, UI_CONSTRAINT);
        MapperPlugin.constrain(1, 1, 1, 1, 0.0, 0.0, 13, 0);
        container.add((Component)new JLabel(BasicUtilities.getString("Import_SQL_Type")), UI_CONSTRAINT);
        MapperPlugin.constrain(2, 1, 1, 1, 1.0, 0.0, 10, 2);
        container.add((Component)this.jcbTypes, UI_CONSTRAINT);
        MapperPlugin.constrain(1, 2, 1, 1, 0.0, 0.0, 10, 0);
        container.add((Component)new JLabel(BasicUtilities.getString("Import_Type_Options")), UI_CONSTRAINT);
        MapperPlugin.constrain(2, 2, 1, 1, 1.0, 0.0, 10, 2);
        container.add((Component)this.txtIOptions, UI_CONSTRAINT);
        MapperPlugin.constrain(3, 0, 1, 3, 0.0, 0.0, 10, 0);
        container.add(Box.createHorizontalStrut(16), UI_CONSTRAINT);
        MapperPlugin.constrain(0, 3, 4, 1, 1.0, 1.0, 10, 3);
        container.add(Box.createVerticalGlue(), UI_CONSTRAINT);
    }

    public ImportProcessor createProcessor() {
        return new StaticMapperProcessor();
    }

    public String getDescription() {
        return BasicUtilities.getString("Import_Map_Data");
    }

    private static class StaticMapperProcessor
    implements ImportProcessor {
        private int sqltype = 1111;
        private String options = "";
        private String preferredColumn = "";

        private StaticMapperProcessor() {
        }

        public boolean canSkip() {
            return false;
        }

        public int prepareImport(int row, int index, Map values, PreparedStatement ps, int type) throws SQLException {
            Object data = values.get(this.preferredColumn);
            try {
                if (this.options.length() >= 1) {
                    String str = data == null ? "" : data.toString();
                    Object convertedValue = StringUtilities.processString(str, this.sqltype, this.options);
                    if (convertedValue == null) {
                        convertedValue = data;
                    }
                    JDBCUtilities.configurePreparedStatement(ps, index, convertedValue, type, false);
                } else {
                    SimpleDateFormat sdf = new SimpleDateFormat("");
                    SystemConfig config = SystemConfig.getInstance();
                    String fmt = config.getFormatForSQLType(this.sqltype);
                    if (fmt != null) {
                        sdf.applyLocalizedPattern(fmt);
                    }
                    Object convertedValue = JDBCUtilities.convertValue(data, this.sqltype, sdf);
                    JDBCUtilities.configurePreparedStatement(ps, index, convertedValue, this.sqltype, false);
                }
            }
            catch (ParseException pe) {
                BasicUtilities.HandleException(pe);
                throw new SQLException(pe.getMessage());
            }
            return 0;
        }

        public void setEntry(ImportConfig.Entry entry) {
            this.preferredColumn = entry.getProperty(MapperPlugin.KEY_COLUMN_REF, "");
            String str = entry.get(MapperPlugin.KEY_SQL_TYPE).toString();
            this.sqltype = Integer.parseInt(str);
            this.options = entry.getProperty(MapperPlugin.KEY_OPTIONS, "");
        }
    }
}

