/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core.model;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.core.model.EnhancedTableModel;
import org.isqlviewer.sql.ByteArrayBlob;
import org.isqlviewer.sql.ByteArrayClob;
import org.isqlviewer.sql.JDBCUtilities;
import org.isqlviewer.sql.ResultSetViewer;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringUtilities;
import org.isqlviewer.util.UserPreferences;

public class ResultSetTableModel
extends EnhancedTableModel {
    private Random seed = new Random(System.currentTimeMillis());
    private boolean isShowingMetaData = false;
    private boolean allowMetaCopy = true;
    private EnhancedTableModel metaData = new EnhancedTableModel();
    private ResultSet rs = null;
    private ArrayList primaryKeys = null;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Blob;
    static /* synthetic */ Class class$java$sql$Clob;
    static /* synthetic */ Class class$java$sql$Ref;
    static /* synthetic */ Class class$java$sql$Array;
    static /* synthetic */ Class class$java$lang$Void;

    public ResultSetTableModel() {
        this(null, null, true);
    }

    public ResultSetTableModel(ResultSet set) {
        this(set, null, true);
    }

    public ResultSetTableModel(ResultSet set, ResultSetViewer rsv, boolean copyMetaData) {
        if (set != null) {
            this.setData(set, rsv);
        }
        this.allowMetaCopy = copyMetaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void showMetaData() {
        if (!this.isShowingMetaData) {
            ResultSetTableModel resultSetTableModel = this;
            synchronized (resultSetTableModel) {
                this.isShowingMetaData = true;
            }
            this.fireTableStructureChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void showResultSetData() {
        if (this.isShowingMetaData) {
            ResultSetTableModel resultSetTableModel = this;
            synchronized (resultSetTableModel) {
                this.isShowingMetaData = false;
            }
            this.fireTableStructureChanged();
        }
    }

    public boolean isShowingMetadata() {
        return this.isShowingMetaData;
    }

    public Object getResultSetValue(int row, int col) {
        return super.getValueAt(row, col);
    }

    public Object getMetaDataValue(int row, int col) {
        return this.metaData.getValueAt(row, col);
    }

    public String getMetaColumnName(int column) {
        return this.metaData.getColumnName(column);
    }

    public int getMetaColumnCount() {
        return this.metaData.getColumnCount();
    }

    public Class getMetaColumnClass(int column) {
        return this.metaData.getColumnClass(column);
    }

    public int getMetaRowCount() {
        return this.metaData.getRowCount();
    }

    public String getResultSetColumnName(int column) {
        return super.getColumnName(column);
    }

    public int getResultSetColumnCount() {
        return super.getColumnCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setData(ResultSet set, ResultSetViewer rsv) {
        String msg;
        this.clearAllData();
        ResultSetMetaData rsmd = null;
        try {
            rsmd = set.getMetaData();
        }
        catch (SQLException sqle) {
            throw new RuntimeException(sqle);
        }
        this.rs = null;
        int cc = -1;
        try {
            cc = rsmd.getColumnCount();
        }
        catch (SQLException sqle) {
            throw new RuntimeException(sqle);
        }
        if (JDBCUtilities.isUpdatable(set)) {
            this.rs = set;
        }
        if (this.allowMetaCopy) {
            this.copyMetaDataStore(rsmd);
        }
        String[] cols = new String[cc];
        for (int i = 1; i <= cols.length; ++i) {
            try {
                cols[i - 1] = rsmd.getColumnLabel(i);
                continue;
            }
            catch (Throwable t) {
                try {
                    cols[i - 1] = rsmd.getColumnName(i);
                    continue;
                }
                catch (SQLException sqle) {
                    throw new RuntimeException(sqle);
                }
            }
        }
        this.setColumns(cols);
        UserPreferences prefs = SystemConfig.getInstance().getPreferences();
        boolean ascii2native = prefs.getBoolean("general.ascii2native-enabled");
        int maxrows = 0;
        try {
            Statement stmt = set.getStatement();
            if (stmt != null) {
                maxrows = stmt.getMaxRows();
            }
        }
        catch (Throwable t) {
            ResultSetTableModel.traceError(t, "ResultSet::getStatement()");
        }
        try {
            if (!set.isBeforeFirst()) {
                if (set.getType() != 1003) {
                    set.beforeFirst();
                } else {
                    msg = BasicUtilities.getString("JDBC_Cursor_Off", Integer.toString(set.getRow()));
                    System.err.println(msg);
                }
            }
        }
        catch (SQLException sqle) {
            throw new RuntimeException(sqle);
        }
        block22: while (true) {
            try {
                while (set.next()) {
                    if (maxrows >= 1 && this.getRowCount() >= maxrows) {
                        msg = BasicUtilities.getString("JDBC_MaxRows_Warning", Integer.toString(maxrows));
                        System.err.println(msg);
                        break block22;
                    }
                    ArrayList newRow = this.extractCurrentRow(set, ascii2native);
                    ArrayList arrayList = this.dataStore;
                    synchronized (arrayList) {
                        this.dataStore.add(newRow);
                    }
                    if (rsv != null) {
                        try {
                            SQLWarning warnings = set.getWarnings();
                            if (warnings != null) {
                                rsv.recieveResultsetWarnings(set, warnings);
                            }
                        }
                        catch (Throwable t) {
                            ResultSetTableModel.traceError(t, "ResultSet::getWarnings()");
                        }
                    }
                    try {
                        set.clearWarnings();
                        continue block22;
                    }
                    catch (Throwable t) {
                        ResultSetTableModel.traceError(t, "ResultSet::clearWarnings()");
                    }
                }
                break;
            }
            catch (SQLException sqle) {
                throw new RuntimeException(sqle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyPrimaryKeys(Collection keys) {
        ArrayList arrayList = this.primaryKeys = this.primaryKeys == null ? new ArrayList() : this.primaryKeys;
        if (keys == null) {
            this.primaryKeys.clear();
            this.primaryKeys = null;
        } else {
            Iterator itr = keys.iterator();
            while (itr.hasNext()) {
                String next = (String)itr.next();
                ArrayList arrayList2 = this.primaryKeys;
                synchronized (arrayList2) {
                    this.primaryKeys.add(next.toUpperCase());
                }
            }
        }
    }

    public boolean isPrimaryKey(String column) {
        if (this.primaryKeys != null) {
            return this.primaryKeys.contains(column.toUpperCase());
        }
        return false;
    }

    public ResultSet toResultSet() {
        return this.rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableEditing() {
        if (this.rs != null) {
            try {
                this.rs.close();
            }
            catch (Throwable throwable) {
            }
            finally {
                this.rs = null;
            }
        }
    }

    public EnhancedTableModel getMetadataAsModel() {
        return (EnhancedTableModel)this.metaData.clone();
    }

    public int applyFilter(String text) {
        if (this.isShowingMetaData) {
            int r = this.metaData.applyFilter(text);
            this.fireTableDataChanged();
            return r;
        }
        return super.applyFilter(text);
    }

    public void clearFilter() {
        if (this.isShowingMetaData) {
            this.metaData.clearFilter();
            this.fireTableDataChanged();
        } else {
            super.clearFilter();
        }
    }

    public void refreshRow(int rowIndex) throws SQLException {
        if (this.rs != null) {
            this.rs.cancelRowUpdates();
            UserPreferences prefs = SystemConfig.getInstance().getPreferences();
            boolean ascii2native = prefs.getBoolean("general.ascii2native-enabled");
            if (this.rs.absolute(rowIndex + 1)) {
                this.rs.refreshRow();
                ArrayList lst = this.extractCurrentRow(this.rs, ascii2native);
                this.dataStore.set(rowIndex, lst);
                this.fireTableRowsUpdated(rowIndex, rowIndex);
            } else {
                throw new SQLException("ResultSet::absolute(" + (rowIndex + 1) + ")");
            }
        }
    }

    public void createInsertRow() throws SQLException {
        if (this.rs != null) {
            ArrayList<Object> mdlRow = new ArrayList<Object>();
            this.rs.moveToInsertRow();
            ResultSetMetaData md = this.rs.getMetaData();
            int cc = md.getColumnCount();
            block18: for (int i = 1; i <= cc; ++i) {
                int type = md.getColumnType(i);
                if (md.isAutoIncrement(i)) {
                    mdlRow.add(null);
                    continue;
                }
                if (md.isNullable(i) == 1) {
                    this.rs.updateNull(i);
                    mdlRow.add(null);
                    continue;
                }
                switch (type) {
                    case -1: 
                    case 1: 
                    case 12: {
                        mdlRow.add("");
                        this.rs.updateString(i, "");
                        continue block18;
                    }
                    case 91: {
                        Date date = new Date(System.currentTimeMillis());
                        mdlRow.add(date);
                        this.rs.updateDate(i, date);
                        continue block18;
                    }
                    case 92: {
                        Time time = new Time(System.currentTimeMillis());
                        mdlRow.add(time);
                        this.rs.updateTime(i, time);
                        continue block18;
                    }
                    case 93: {
                        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
                        mdlRow.add(timestamp);
                        this.rs.updateTimestamp(i, timestamp);
                        continue block18;
                    }
                    case -6: {
                        Byte bite = new Byte((byte)this.seed.nextInt());
                        mdlRow.add(bite);
                        this.rs.updateByte(i, (byte)bite);
                        continue block18;
                    }
                    case 5: {
                        Short shrt = new Short((short)this.seed.nextInt());
                        mdlRow.add(shrt);
                        this.rs.updateShort(i, (short)shrt);
                        continue block18;
                    }
                    case 4: {
                        Integer integer = new Integer(this.seed.nextInt());
                        mdlRow.add(integer);
                        this.rs.updateInt(i, (int)integer);
                        continue block18;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        Double doub = new Double(this.seed.nextDouble());
                        mdlRow.add(doub);
                        this.rs.updateDouble(i, (double)doub);
                        continue block18;
                    }
                    case -5: {
                        Long lon = new Long(this.seed.nextLong());
                        mdlRow.add(lon);
                        this.rs.updateLong(i, (long)lon);
                        continue block18;
                    }
                    case 2: 
                    case 3: {
                        BigDecimal bigdec = new BigDecimal(this.seed.nextDouble());
                        mdlRow.add(bigdec);
                        this.rs.updateBigDecimal(i, bigdec);
                        continue block18;
                    }
                    case -7: 
                    case 16: {
                        this.rs.updateBoolean(i, (boolean)Boolean.FALSE);
                        continue block18;
                    }
                    case -4: 
                    case -3: {
                        byte[] bytes = new byte[]{};
                        mdlRow.add(bytes);
                        this.rs.updateBytes(i, bytes);
                        continue block18;
                    }
                    case 2004: {
                        ByteArrayBlob blob = new ByteArrayBlob(new byte[0]);
                        mdlRow.add(blob);
                        this.rs.updateBlob(i, (Blob)blob);
                        continue block18;
                    }
                    case 2005: {
                        try {
                            ByteArrayClob clob = new ByteArrayClob("");
                            mdlRow.add(clob);
                            this.rs.updateClob(i, (Clob)clob);
                            continue block18;
                        }
                        catch (IOException ioe) {
                            throw new SQLException(ioe.getMessage());
                        }
                    }
                    default: {
                        this.rs.updateObject(i, (Object)"");
                    }
                }
            }
            this.rs.insertRow();
            int newRow = this.getRowCount();
            this.addRow(mdlRow);
            this.fireTableRowsInserted(newRow, newRow);
            this.rs.beforeFirst();
        }
    }

    public boolean isCellEditable(int row, int column) {
        if (!this.isShowingMetaData) {
            try {
                if (this.rs == null) {
                    return false;
                }
                ResultSetMetaData md = this.rs.getMetaData();
                int concur = this.rs.getConcurrency();
                boolean canEdit = !md.isReadOnly(column + 1) && !md.isAutoIncrement(column + 1);
                return canEdit && concur == 1008;
            }
            catch (Throwable t) {
                return false;
            }
        }
        return false;
    }

    public void clearAll() {
        this.clearAllData();
        this.metaData.clearAllData();
        this.fireTableStructureChanged();
    }

    public void clear() {
        this.clearData();
        this.metaData.clearData();
        this.fireTableDataChanged();
    }

    public Class getColumnClass(int index) {
        if (this.isShowingMetaData) {
            return this.getMetaColumnClass(index);
        }
        return super.getColumnClass(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeRow(int rowIndex) {
        ArrayList lock = this.isShowingMetadata() ? this.metaData.dataStore : this.dataStore;
        try {
            if (this.rs != null && !this.isShowingMetadata()) {
                this.rs.absolute(rowIndex + 1);
                this.rs.deleteRow();
                this.rs.beforeFirst();
            }
            ArrayList arrayList = lock;
            synchronized (arrayList) {
                lock.remove(rowIndex);
            }
            this.fireTableRowsDeleted(rowIndex, rowIndex);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeColumn(int columnIndex) {
        ArrayList lock = this.isShowingMetadata() ? this.metaData.dataStore : this.dataStore;
        Iterator itr = lock.iterator();
        ArrayList arrayList = lock;
        synchronized (arrayList) {
            try {
                if (this.isShowingMetaData) {
                    this.metaData.columns.remove(columnIndex);
                } else {
                    this.columns.remove(columnIndex);
                }
            }
            catch (Throwable t) {
                return;
            }
            while (itr.hasNext()) {
                try {
                    ArrayList lst = (ArrayList)itr.next();
                    lst.remove(columnIndex);
                }
                catch (Throwable t) {}
            }
        }
        this.fireTableStructureChanged();
    }

    public int getColumnCount() {
        if (this.isShowingMetaData) {
            return this.getMetaColumnCount();
        }
        return this.getResultSetColumnCount();
    }

    public String getColumnName(int col) {
        if (this.isShowingMetaData) {
            return this.getMetaColumnName(col);
        }
        return this.getResultSetColumnName(col);
    }

    public int getRowCount() {
        if (this.isShowingMetaData) {
            return this.metaData.getRowCount();
        }
        return super.getRowCount();
    }

    public Object getValueAt(int row, int col) {
        if (this.isShowingMetaData) {
            return this.getMetaDataValue(row, col);
        }
        return this.getResultSetValue(row, col);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (!this.isShowingMetaData && this.rs != null) {
            block40: {
                if (!this.isCellEditable(rowIndex, columnIndex)) {
                    return;
                }
                int realColumn = columnIndex + 1;
                int realRow = rowIndex + 1 + this.pageOffset * this.pageSize;
                SimpleDateFormat sdf = new SimpleDateFormat("");
                try {
                    int type = this.rs.getMetaData().getColumnType(realColumn);
                    if (!this.rs.absolute(realRow)) break block40;
                    if (value == null) {
                        this.rs.updateNull(realColumn);
                    } else {
                        try {
                            String pattern = SystemConfig.getInstance().getFormatForSQLType(type);
                            if (pattern != null) {
                                sdf.applyPattern(pattern);
                                value = JDBCUtilities.convertValue(value, type, sdf);
                            } else {
                                value = JDBCUtilities.convertValue(value, type, null);
                            }
                        }
                        catch (ParseException pe) {
                            throw new IllegalArgumentException(pe.getMessage());
                        }
                        Object cnvValue = JDBCUtilities.convertValue(value, type, sdf);
                        switch (type) {
                            case 1: 
                            case 12: {
                                if (SystemConfig.getInstance().getPreferences().getBoolean("general.ascii2native-enabled")) {
                                    this.rs.updateString(realColumn, StringUtilities.encode((String)value, false, false));
                                    break;
                                }
                                this.rs.updateString(realColumn, (String)cnvValue);
                                break;
                            }
                            case -6: {
                                this.rs.updateByte(realColumn, (byte)((Byte)cnvValue));
                                break;
                            }
                            case 5: {
                                this.rs.updateShort(realColumn, (short)((Short)cnvValue));
                                break;
                            }
                            case 4: {
                                this.rs.updateInt(realColumn, (int)((Integer)cnvValue));
                                break;
                            }
                            case -5: {
                                this.rs.updateLong(realColumn, (long)((Long)cnvValue));
                                break;
                            }
                            case 6: 
                            case 8: {
                                this.rs.updateDouble(realColumn, (double)((Double)cnvValue));
                                break;
                            }
                            case 2: 
                            case 3: {
                                this.rs.updateBigDecimal(realColumn, (BigDecimal)cnvValue);
                                break;
                            }
                            case -7: 
                            case 16: {
                                this.rs.updateBoolean(realColumn, (boolean)((Boolean)cnvValue));
                                break;
                            }
                            case -4: 
                            case -3: {
                                ByteArrayBlob blob = (ByteArrayBlob)cnvValue;
                                this.rs.updateBinaryStream(realColumn, blob.getBinaryStream(), (int)blob.length());
                                break;
                            }
                            case -1: {
                                ByteArrayClob clob = (ByteArrayClob)cnvValue;
                                this.rs.updateCharacterStream(realColumn, clob.getCharacterStream(), (int)clob.length());
                                break;
                            }
                            case 2004: {
                                this.rs.updateBlob(realColumn, (Blob)cnvValue);
                                break;
                            }
                            case 2005: {
                                this.rs.updateClob(realColumn, (Clob)cnvValue);
                                break;
                            }
                            case 91: {
                                this.rs.updateDate(realColumn, (Date)cnvValue);
                                break;
                            }
                            case 92: {
                                this.rs.updateTime(realColumn, (Time)cnvValue);
                                break;
                            }
                            case 93: {
                                this.rs.updateTimestamp(realColumn, (Timestamp)cnvValue);
                                break;
                            }
                            default: {
                                this.rs.updateObject(realColumn, value);
                            }
                        }
                    }
                    this.rs.updateRow();
                }
                catch (RuntimeException rte) {
                    throw rte;
                }
                catch (SQLException se) {
                    String[] p = new String[]{se.getMessage() != null ? se.getMessage().trim() : "null", Integer.toString(se.getErrorCode()), se.getSQLState() == null ? "null" : se.getSQLState()};
                    throw new IllegalArgumentException(BasicUtilities.getString("SQL_Exception", p));
                }
                catch (Throwable t) {
                    String msg = "ResultSetTableModel::setValue(" + value + ", " + rowIndex + "," + columnIndex + ")";
                    BasicUtilities.HandleException(t, msg);
                }
                finally {
                    try {
                        this.rs.beforeFirst();
                    }
                    catch (Throwable t) {}
                }
            }
            super.setValueAt(value, rowIndex, columnIndex);
        } else {
            super.setValueAt(value, rowIndex, columnIndex);
        }
    }

    public boolean canSort(int column, boolean ascending) {
        if (this.isShowingMetaData) {
            return this.metaData.canSort(column, ascending);
        }
        return super.canSort(column, ascending) && this.rs == null;
    }

    public void sort(int column, boolean asc) {
        if (this.isShowingMetadata()) {
            this.metaData.sort(column, asc);
            this.fireTableRowsUpdated(0, this.getRowCount() - 1);
        } else {
            super.sort(column, asc);
        }
    }

    public int getIndexOfColumnName(String name) {
        if (this.isShowingMetadata()) {
            return this.metaData.getIndexOfColumnName(name);
        }
        return super.getIndexOfColumnName(name);
    }

    protected boolean isUnique(Object obj, int column) {
        ArrayList col = new ArrayList();
        Iterator itr = this.dataStore.iterator();
        while (itr.hasNext()) {
            ArrayList row = (ArrayList)itr.next();
            col.add(row.get(column));
        }
        boolean isUnique = col.contains(obj);
        col.clear();
        col = null;
        return isUnique;
    }

    protected static boolean isFirst(ResultSet resultSet) {
        try {
            return resultSet.isFirst();
        }
        catch (Throwable t) {
            return false;
        }
    }

    protected static void traceError(Throwable error, String msg) {
        PrintWriter err = DriverManager.getLogWriter();
        if (err != null) {
            BasicUtilities.HandleException(error, msg, true, err);
        }
    }

    protected ArrayList extractCurrentRow(ResultSet set, boolean ascii2native) throws SQLException {
        ArrayList<Object> row = new ArrayList<Object>();
        ResultSetMetaData rsmd = set.getMetaData();
        int cc = rsmd.getColumnCount();
        for (int i = 1; i <= cc; ++i) {
            int type = -1;
            try {
                type = rsmd.getColumnType(i);
            }
            catch (Throwable t) {
                type = 12;
            }
            try {
                switch (type) {
                    case 91: {
                        if (ResultSetTableModel.isFirst(set)) {
                            this.setClassforColumn(row.size(), class$java$sql$Date == null ? ResultSetTableModel.class$("java.sql.Date") : class$java$sql$Date);
                        }
                        row.add(set.getDate(i));
                        break;
                    }
                    case 93: {
                        if (ResultSetTableModel.isFirst(set)) {
                            this.setClassforColumn(row.size(), class$java$sql$Timestamp == null ? ResultSetTableModel.class$("java.sql.Timestamp") : class$java$sql$Timestamp);
                        }
                        row.add(set.getTimestamp(i));
                        break;
                    }
                    case 92: {
                        if (ResultSetTableModel.isFirst(set)) {
                            this.setClassforColumn(row.size(), class$java$sql$Time == null ? ResultSetTableModel.class$("java.sql.Time") : class$java$sql$Time);
                        }
                        row.add(set.getTime(i));
                        break;
                    }
                    case -6: {
                        row.add(new Byte(set.getByte(i)));
                        break;
                    }
                    case 5: {
                        row.add(new Short(set.getShort(i)));
                        break;
                    }
                    case 4: {
                        row.add(new Integer(set.getInt(i)));
                        break;
                    }
                    case 2: 
                    case 3: {
                        row.add(set.getBigDecimal(i));
                        break;
                    }
                    case 7: {
                        row.add(new Float(set.getFloat(i)));
                        break;
                    }
                    case 6: 
                    case 8: {
                        row.add(new Double(set.getDouble(i)));
                        break;
                    }
                    case -5: {
                        row.add(new Long(set.getLong(i)));
                        break;
                    }
                    case -7: 
                    case 16: {
                        row.add(new Boolean(set.getBoolean(i)));
                        break;
                    }
                    case -4: {
                        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                        InputStream sql = set.getBinaryStream(i);
                        BasicUtilities.copyStream(sql, buffer);
                        if (ResultSetTableModel.isFirst(set)) {
                            this.setClassforColumn(row.size(), class$java$sql$Blob == null ? ResultSetTableModel.class$("java.sql.Blob") : class$java$sql$Blob);
                        }
                        row.add(new ByteArrayBlob(buffer.toByteArray()));
                        break;
                    }
                    case -3: 
                    case -2: {
                        if (ResultSetTableModel.isFirst(set)) {
                            this.setClassforColumn(row.size(), class$java$sql$Blob == null ? ResultSetTableModel.class$("java.sql.Blob") : class$java$sql$Blob);
                        }
                        row.add(new ByteArrayBlob(set.getBytes(i)));
                        break;
                    }
                    case -1: {
                        try {
                            Reader rdr = set.getCharacterStream(i);
                            if (ResultSetTableModel.isFirst(set)) {
                                this.setClassforColumn(row.size(), class$java$sql$Clob == null ? ResultSetTableModel.class$("java.sql.Clob") : class$java$sql$Clob);
                            }
                            row.add(new ByteArrayClob(rdr));
                            break;
                        }
                        catch (IOException ioe) {
                            throw new SQLException(ioe.getMessage());
                        }
                    }
                    case 1: 
                    case 12: {
                        String str = set.getString(i);
                        if (ascii2native && str != null) {
                            str = StringUtilities.decode(str);
                        }
                        row.add(str);
                        break;
                    }
                    case 2004: {
                        if (ResultSetTableModel.isFirst(set)) {
                            this.setClassforColumn(row.size(), class$java$sql$Blob == null ? ResultSetTableModel.class$("java.sql.Blob") : class$java$sql$Blob);
                        }
                        row.add(set.getBlob(i));
                        break;
                    }
                    case 2005: {
                        if (ResultSetTableModel.isFirst(set)) {
                            this.setClassforColumn(row.size(), class$java$sql$Clob == null ? ResultSetTableModel.class$("java.sql.Clob") : class$java$sql$Clob);
                        }
                        row.add(set.getClob(i));
                        break;
                    }
                    case 2006: {
                        if (ResultSetTableModel.isFirst(set)) {
                            this.setClassforColumn(row.size(), class$java$sql$Ref == null ? ResultSetTableModel.class$("java.sql.Ref") : class$java$sql$Ref);
                        }
                        row.add(set.getRef(i));
                        break;
                    }
                    case 2003: {
                        if (ResultSetTableModel.isFirst(set)) {
                            this.setClassforColumn(row.size(), class$java$sql$Array == null ? ResultSetTableModel.class$("java.sql.Array") : class$java$sql$Array);
                        }
                        row.add(set.getArray(i));
                        break;
                    }
                    default: {
                        Object object = set.getObject(i);
                        row.add(object);
                        if (ResultSetTableModel.isFirst(set) && object != null) {
                            this.setClassforColumn(row.size(), object.getClass());
                        }
                        break;
                    }
                }
            }
            catch (SQLException sqle) {
                String[] p = new String[]{this.getColumnName(i), JDBCUtilities.getTypeforValue(type), sqle.getMessage()};
                String msg = BasicUtilities.getString("Resultset_Pull_Error", p);
                System.err.println(msg);
                throw sqle;
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            try {
                if (!set.wasNull()) continue;
                row.set(i - 1, null);
                continue;
            }
            catch (Throwable t) {
                ResultSetTableModel.traceError(t, "ResultSet::wasNull()");
            }
        }
        return row;
    }

    private void copyMetaDataStore(ResultSetMetaData rsmd) {
        if (rsmd != null) {
            try {
                int i;
                this.metaData.clearAllData();
                int cc = rsmd.getColumnCount();
                Class<?> c = rsmd.getClass();
                Method[] methods = c.getMethods();
                Class[] args = new Class[]{Integer.TYPE};
                Object[] p = new Object[1];
                for (i = 0; i < methods.length; ++i) {
                    Class primative;
                    Class<?> returns = methods[i].getReturnType();
                    String n = methods[i].getName();
                    if (!n.startsWith("get") && !n.startsWith("is") || !returns.isPrimitive() && !returns.getName().endsWith("String") || methods[i].getParameterTypes().length != 1 || methods[i].getParameterTypes()[0] != args[0] || (primative = BasicUtilities.getClassForPrimative(returns)) == (class$java$lang$Void == null ? ResultSetTableModel.class$("java.lang.Void") : class$java$lang$Void) || primative == null) continue;
                    this.metaData.columns.add(n);
                }
                for (int j = 1; j <= cc; ++j) {
                    p[0] = new Integer(j);
                    ArrayList<Object> row = new ArrayList<Object>(cc);
                    for (int i2 = 0; i2 < this.metaData.getColumnCount(); ++i2) {
                        try {
                            String method = this.metaData.getColumnName(i2);
                            Method m = c.getMethod(method, args);
                            row.add(m.invoke((Object)rsmd, p));
                            continue;
                        }
                        catch (Throwable t) {
                            row.add(BasicUtilities.getString("Not_Supported"));
                        }
                    }
                    this.metaData.addRow(row);
                }
                for (i = 0; i < this.metaData.getColumnCount(); ++i) {
                    String n = this.metaData.getColumnName(i);
                    if (!n.startsWith("get")) continue;
                    n = n.substring(3);
                    this.metaData.columns.set(i, n);
                }
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t, BasicUtilities.getString("ResultsetMetaData_Error"), true);
            }
        }
    }

    public int getTrueRowCount() {
        if (this.isShowingMetaData) {
            return this.metaData.getTrueRowCount();
        }
        return super.getTrueRowCount();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

