/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core.model;

import java.sql.SQLWarning;
import java.util.ArrayList;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.core.model.EnhancedTableModel;
import org.isqlviewer.util.BasicUtilities;

public class SQLWarningTableModel
extends EnhancedTableModel {
    private final String[] ColumnHeaders = new String[]{BasicUtilities.getString("SQL_Warning_Code"), BasicUtilities.getString("SQL_Warning_State")};
    private ArrayList lstMessages = new ArrayList();

    public SQLWarningTableModel() {
        this.setColumns(this.ColumnHeaders);
    }

    public String getWarningMessageForRow(int r) {
        try {
            return this.lstMessages.get(r).toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setData(SQLWarning warning, boolean append) {
        if (!append) {
            this.clearAllData();
        }
        if (warning == null) {
            return;
        }
        int maxchain = SystemConfig.getInstance().getPreferences().getInt("jdbc.max-warnings");
        ArrayList<String> r = new ArrayList<String>();
        String state = warning.getSQLState();
        String code = Integer.toString(warning.getErrorCode());
        r.add(code);
        r.add(state == null ? "" : state);
        this.addRow(r);
        this.addWarning(warning);
        SQLWarning next = null;
        int chainlength = 0;
        while ((next = warning.getNextWarning()) != null) {
            if (chainlength++ >= maxchain && maxchain != 0) {
                r = new ArrayList();
                state = next.getSQLState();
                code = Integer.toString(next.getErrorCode());
                r.add(code);
                r.add(state == null ? "" : state);
                this.addRow(r);
                this.addWarning(next);
                warning = next;
                continue;
            }
            System.out.println(BasicUtilities.getString("Warning_Chain_Notice", Integer.toString(maxchain)));
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addWarning(SQLWarning warning) {
        String msg = warning.getMessage();
        msg = msg == null ? "" : msg;
        ArrayList arrayList = this.lstMessages;
        synchronized (arrayList) {
            this.lstMessages.add(msg);
        }
    }
}

