/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.sql;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import org.isqlviewer.event.ProgressEvent;
import org.isqlviewer.event.ProgressListener;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.UserPreferences;

public final class BatchRunner
implements Runnable {
    private ArrayList batchCommands = new ArrayList();
    private FileReader batchReader;
    private File batchFile;
    private ProgressListener batchListener;
    private DatabaseConnection dbc;
    private String batchID = null;
    private boolean useTrans = true;
    private boolean overrideBatch = false;
    private NumberFormat nf = NumberFormat.getNumberInstance();

    public BatchRunner(File file, ProgressListener lstnr) {
        this.batchID = Long.toHexString(System.currentTimeMillis()).toUpperCase();
        this.setBatchListener(lstnr);
        this.batchFile = file;
        this.nf.setGroupingUsed(false);
        this.nf.setMaximumFractionDigits(32);
        this.nf.setMinimumFractionDigits(0);
        this.nf.setParseIntegerOnly(false);
    }

    public Object clone() {
        try {
            BatchRunner copy = new BatchRunner(this.batchFile, this.batchListener);
            copy.setStatements(this.batchCommands);
            copy.setBatchParams(this.useTrans, this.overrideBatch);
            copy.setConnection(this.dbc);
            copy.batchID = new String(this.batchID);
            return copy;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public boolean equals(Object o) {
        if (o instanceof BatchRunner) {
            BatchRunner x = (BatchRunner)o;
            return x.getBatchID().equalsIgnoreCase(this.batchID);
        }
        return false;
    }

    public File getBatchFile() {
        return this.batchFile;
    }

    public String getBatchID() {
        return this.batchID;
    }

    public void setConnection(DatabaseConnection cnx) {
        if (cnx != null) {
            this.dbc = cnx;
        }
    }

    public DatabaseConnection getConnection() {
        return this.dbc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadStatements(UserPreferences prefs) throws IOException {
        StreamTokenizer st = this.configureParser(prefs);
        StringBuffer buff = new StringBuffer("");
        BatchRunner batchRunner = this;
        synchronized (batchRunner) {
            char TokenType = '\u0000';
            boolean useEOL = prefs.getInt("batch.seperator-style") == 1;
            char StatementToken = prefs.get("batch.seperator-char").charAt(0);
            char quoteChar = '\u0000';
            switch (prefs.getInt("batch.literal-style")) {
                case 1: {
                    break;
                }
                case 2: {
                    quoteChar = '\'';
                    break;
                }
                case 3: {
                    quoteChar = prefs.get("batch.literal-char").charAt(0);
                    break;
                }
                default: {
                    quoteChar = '\"';
                }
            }
            while ((TokenType = st.nextToken()) != '\uffffffff') {
                char c = TokenType;
                if (TokenType == '\n') {
                    if (useEOL) {
                        this.batchCommands.add(buff.toString().trim());
                        buff.setLength(0);
                        continue;
                    }
                    buff.append('\n');
                    continue;
                }
                if (TokenType == '\ufffffffd') {
                    buff.append(st.sval.trim());
                    continue;
                }
                if (TokenType == '\ufffffffe') {
                    buff.append(this.nf.format(st.nval));
                    continue;
                }
                if (TokenType == StatementToken) {
                    if (!useEOL) {
                        this.batchCommands.add(buff.toString().trim());
                        buff.setLength(0);
                        continue;
                    }
                    buff.append(c);
                    continue;
                }
                if (TokenType == quoteChar && quoteChar != '\u0000') {
                    buff.append(quoteChar);
                    buff.append(st.sval);
                    buff.append(quoteChar);
                    continue;
                }
                if (!Character.isDefined(c)) continue;
                buff.append(c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatements(Collection stmts) {
        ArrayList arrayList = this.batchCommands;
        synchronized (arrayList) {
            this.batchCommands.clear();
        }
        if (stmts == null) {
            return;
        }
        arrayList = this.batchCommands;
        synchronized (arrayList) {
            this.batchCommands.addAll(stmts);
        }
    }

    public Collection getStatements() {
        return this.batchCommands;
    }

    public void setBatchParams(boolean useTransaction, boolean overrideSupport) {
        this.useTrans = useTransaction;
        this.overrideBatch = overrideSupport;
    }

    public void run() {
        try {
            this.executeBatch();
        }
        catch (Throwable t) {
            String msg = BasicUtilities.getString(DatabaseConnection.resourceBundle, "Unexpected_Batch_Error");
            BasicUtilities.HandleException(t, msg, true);
        }
    }

    public void setBatchListener(ProgressListener batchListener) {
        this.batchListener = batchListener;
    }

    private void doNotify(ProgressEvent event) {
        if (this.batchListener != null) {
            this.batchListener.progressUpdated(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeBatch() {
        ProgressEvent event = new ProgressEvent(this, 0, this.batchCommands.size());
        if (this.batchCommands.isEmpty() || this.dbc == null) {
            event.setProgress(event.getMaximum());
            this.doNotify(event);
            return;
        }
        try {
            this.dbc.initialize();
            boolean autoCommit = this.dbc.getAutoCommit();
            this.dbc.executeBatch(this.batchCommands, this.overrideBatch, this.useTrans, new ActionForwarder());
            this.dbc.setAutoCommit(autoCommit);
        }
        catch (Throwable t) {
            BasicUtilities.HandleException(t, null, this.dbc.getDebugOn());
        }
        finally {
            event.setProgress(event.getMaximum());
            this.doNotify(event);
        }
        System.runFinalization();
    }

    private StreamTokenizer configureParser(UserPreferences config) throws IOException {
        this.batchReader = new FileReader(this.batchFile);
        StreamTokenizer st = new StreamTokenizer(this.batchReader);
        st.lowerCaseMode(config.getBoolean("batch.lowercase-enable"));
        st.ordinaryChar(32);
        switch (config.getInt("batch.literal-style")) {
            case 1: {
                break;
            }
            case 2: {
                st.quoteChar(39);
                break;
            }
            case 3: {
                st.quoteChar(config.get("batch.literal-char").charAt(0));
                break;
            }
            default: {
                st.quoteChar(34);
            }
        }
        switch (config.getInt("batch.comment-style")) {
            case 1: {
                break;
            }
            case 2: {
                st.slashSlashComments(true);
                break;
            }
            case 3: {
                st.slashStarComments(true);
                break;
            }
            default: {
                st.commentChar(config.get("batch.comment-char").charAt(0));
            }
        }
        switch (config.getInt("batch.seperator-style")) {
            case 1: {
                st.eolIsSignificant(true);
                break;
            }
            default: {
                char c = config.get("batch.seperator-char").charAt(0);
                st.eolIsSignificant(false);
                st.ordinaryChar(c);
            }
        }
        return st;
    }

    private class ActionForwarder
    implements ProgressListener {
        private ActionForwarder() {
        }

        public void progressUpdated(ProgressEvent pe) {
            if (BatchRunner.this.batchListener != null) {
                ProgressEvent e = new ProgressEvent(BatchRunner.this, pe.getProgress(), pe.getMaximum());
                e.setNote(e.getNote());
                BatchRunner.this.batchListener.progressUpdated(e);
            }
        }
    }
}

