/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.sql;

import java.io.PrintWriter;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.util.BasicUtilities;

public final class DriverPool {
    private static final ArrayList driverSet = new ArrayList();

    private DriverPool() {
    }

    private static boolean isDriverAllReadyRegistered(Driver jdbcDriver) {
        int verCheckSum = jdbcDriver.getMajorVersion() * 10 + jdbcDriver.getMinorVersion();
        Iterator drivers = driverSet.iterator();
        while (drivers.hasNext()) {
            Driver driver = (Driver)drivers.next();
            int checkSum = driver.getMajorVersion() * 10 + driver.getMinorVersion();
            if (checkSum != verCheckSum || !driver.getClass().getName().equals(jdbcDriver.getClass().getName())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerDriver(String driverClass, ClassLoader cl) throws ClassNotFoundException {
        block7: {
            if (cl == null) {
                cl = Thread.currentThread().getContextClassLoader();
            }
            if (driverClass == null) {
                throw new IllegalArgumentException(BasicUtilities.getString(DatabaseConnection.resourceBundle, "DriverMgr_Register_Null"));
            }
            try {
                Driver jdbcDriver = (Driver)Class.forName(driverClass, false, cl).newInstance();
                if (DriverPool.isDriverAllReadyRegistered(jdbcDriver)) break block7;
                ArrayList arrayList = driverSet;
                synchronized (arrayList) {
                    driverSet.add(jdbcDriver);
                }
                String[] p = new String[]{driverClass, jdbcDriver.toString()};
                String msg = BasicUtilities.getString(DatabaseConnection.resourceBundle, "DriverMgr_Register", p);
                DriverManager.println(msg);
            }
            catch (Throwable t) {
                String msg = BasicUtilities.getString(DatabaseConnection.resourceBundle, "DriverMgr_Error", t.getMessage());
                DriverManager.println(msg);
                throw new ClassNotFoundException(driverClass);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deregisterDriver(Driver jdbcDriver) {
        if (jdbcDriver == null) {
            String msg = BasicUtilities.getString(DatabaseConnection.resourceBundle, "DriverMgr_Deregister_Null");
            DriverManager.println(msg);
            return;
        }
        try {
            String[] p = new String[]{jdbcDriver.getClass().getName(), jdbcDriver.toString()};
            String msg = BasicUtilities.getString(DatabaseConnection.resourceBundle, "DriverMgr_Deregister", p);
            DriverManager.println(msg);
            ArrayList arrayList = driverSet;
            synchronized (arrayList) {
                Driver di;
                int i = 0;
                for (i = 0; i < driverSet.size() && (di = (Driver)driverSet.get(i)) != jdbcDriver; ++i) {
                }
                if (i >= driverSet.size()) {
                    msg = BasicUtilities.getString(DatabaseConnection.resourceBundle, "DriverMgr_Deregister_Notfound", p);
                    DriverManager.println(msg);
                    return;
                }
                driverSet.remove(i);
            }
        }
        catch (Throwable t) {
            String msg = BasicUtilities.getString(DatabaseConnection.resourceBundle, "DriverMgr_Error", t.getMessage());
            DriverManager.println(msg);
        }
    }

    public static Driver getDriver(String jdbcURL) throws SQLException {
        Iterator drivers = driverSet.iterator();
        while (drivers.hasNext()) {
            Driver jdbcDriver = (Driver)drivers.next();
            try {
                if (!jdbcDriver.acceptsURL(jdbcURL)) continue;
                return jdbcDriver;
            }
            catch (SQLException sqle) {
                PrintWriter pw = DriverManager.getLogWriter();
                if (pw == null) continue;
                String msg = MessageFormat.format("acceptsURL({0})", jdbcURL);
                BasicUtilities.HandleException((Throwable)sqle, msg, true, pw);
            }
            catch (Throwable throwable) {
            }
        }
        return DriverManager.getDriver(jdbcURL);
    }
}

