/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.sql;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import org.isqlviewer.util.BasicUtilities;

public class FileClob
implements Clob {
    protected File file;
    protected StringBuffer clob = new StringBuffer("");

    public FileClob(File f) throws IOException {
        this.file = f;
        ByteArrayOutputStream bytes = new ByteArrayOutputStream((int)f.length());
        FileInputStream fis = new FileInputStream(this.file);
        BasicUtilities.copyStream(fis, bytes);
        this.clob.append(new String(bytes.toByteArray()));
        fis.close();
        fis = null;
        bytes.close();
        bytes = null;
    }

    public long length() {
        return this.file.length();
    }

    public void truncate(long len) {
        this.clob.setLength((int)len);
    }

    public InputStream getAsciiStream() throws SQLException {
        try {
            return new BufferedInputStream(new ByteArrayInputStream(this.clob.toString().getBytes()));
        }
        catch (Throwable t) {
            throw new SQLException(t.getMessage());
        }
    }

    public Reader getCharacterStream() throws SQLException {
        try {
            return new BufferedReader(new InputStreamReader(this.getAsciiStream()));
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        catch (Throwable t) {
            throw new SQLException(t.getMessage());
        }
    }

    public String getSubString(long pos, int length) throws SQLException {
        try {
            return this.clob.substring((int)pos, (int)pos + length);
        }
        catch (Throwable t) {
            throw new SQLException(t.getMessage());
        }
    }

    public long position(Clob searchstr, long start) throws SQLException {
        return this.position(searchstr.getSubString(0L, (int)searchstr.length()), start);
    }

    public long position(String searchstr, long start) {
        return this.clob.indexOf(searchstr, (int)start);
    }

    public OutputStream setAsciiStream(long pos) throws SQLException {
        try {
            ClobAdapterStream cas = new ClobAdapterStream();
            cas.setOffset(pos);
            return new PrintStream(cas, true);
        }
        catch (Throwable t) {
            throw new SQLException(t.getMessage());
        }
    }

    public Writer setCharacterStream(long pos) throws SQLException {
        try {
            ClobAdapterStream cas = new ClobAdapterStream();
            cas.setOffset(pos);
            return new PrintWriter(cas, true);
        }
        catch (Throwable t) {
            throw new SQLException(t.getMessage());
        }
    }

    public int setString(long pos, String str, int offset, int len) {
        this.clob.append(str.toCharArray(), offset, len);
        return len;
    }

    public int setString(long pos, String str) {
        return this.setString(pos, str, 0, str.length());
    }

    private class ClobAdapterStream
    extends OutputStream {
        private StringBuffer buf = new StringBuffer("");
        private long offset = -1L;

        private ClobAdapterStream() {
        }

        public void setOffset(long pos) {
            this.offset = pos;
            if (this.offset > (long)FileClob.this.clob.length()) {
                this.offset = -1L;
            }
        }

        public synchronized void write(int b) {
            char c = (char)(b &= 0xFF);
            this.buf.append(String.valueOf(c));
        }

        public synchronized void write(byte[] b, int off, int length) {
            this.buf.append(new String(b, off, length));
        }

        public synchronized void write(byte[] b) {
            this.buf.append(new String(b));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void flush() {
            StringBuffer stringBuffer = this.buf;
            synchronized (stringBuffer) {
                if (this.buf.length() > 0) {
                    if (this.offset < (long)FileClob.this.clob.length() && this.offset >= 0L) {
                        FileClob.this.clob.replace((int)this.offset, this.buf.length(), this.buf.toString());
                        this.offset += (long)this.buf.length();
                    } else {
                        FileClob.this.clob.append(this.buf.toString());
                        this.offset = FileClob.this.clob.length();
                    }
                }
                this.buf.setLength(0);
            }
        }

        public void close() {
            this.flush();
            this.buf.setLength(0);
        }
    }
}

