/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.IllegalComponentStateException;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.event.MouseInputAdapter;
import org.isqlviewer.swing.CompoundIcon;
import org.isqlviewer.util.BasicUtilities;

public class ITabbedPane
extends JTabbedPane {
    public static final int ACTION_TAB_CLICKED = 64768;
    public static final int ACTION_TAB_DBL_CLICKED = 64769;
    private static final String CLIENT_IS_LOCKED = "ITabbedPane.isLocked";
    protected int maxtabcount = -1;
    protected int oldestIndex = -1;
    private Hashtable iconCache;
    protected static final Icon LOCK_ICON = BasicUtilities.loadIconResource("Lock16");
    protected static final Icon CLOSE_ICON = BasicUtilities.loadIconResource("Close16");
    private transient Vector actionListeners;

    public ITabbedPane() {
        this(1, 5);
    }

    public ITabbedPane(int tabplacement) {
        this(tabplacement, 5);
    }

    public ITabbedPane(int TabPlacement, int MaxTabCount) {
        super(TabPlacement);
        this.maxtabcount = MaxTabCount;
        this.iconCache = new Hashtable(this.maxtabcount);
        MouseHandler ma = new MouseHandler();
        this.addMouseListener(ma);
        this.addMouseMotionListener(ma);
    }

    public void addTab(String s, Component c) {
        this.addTab(s, null, c, null);
    }

    public void addTab(String s, Icon icon, Component c) {
        this.addTab(s, new CompoundIcon(CLOSE_ICON, icon), c, null);
    }

    public void addTab(String s, Icon icon, Component c, String tip) {
        if (this.getTabCount() < this.maxtabcount) {
            if (c instanceof JComponent) {
                JComponent jc = (JComponent)c;
                jc.putClientProperty(CLIENT_IS_LOCKED, Boolean.FALSE);
            }
            super.addTab(s, new CompoundIcon(null, icon), c, tip);
            this.invalidate();
            this.repaint();
            this.fireStateChanged();
        } else {
            int tab = this.locateFirstUnlockedTab();
            if (tab >= 0 && tab < this.getTabCount()) {
                this.setTitleAt(tab, s);
                this.setIconAt(tab, new CompoundIcon(null, icon));
                this.setComponentAt(tab, c);
                this.setToolTipTextAt(tab, tip);
                this.invalidate();
                this.repaint();
                this.fireStateChanged();
            } else {
                throw new IllegalStateException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIconAt(int idx, Icon ico) {
        try {
            CompoundIcon icon = (CompoundIcon)this.getIconAt(idx);
            icon.setRightIcon(ico);
        }
        catch (Throwable throwable) {
        }
        finally {
            this.invalidate();
            this.repaint();
        }
    }

    public void removeTabAt(int i) {
        String title;
        String msg;
        int res;
        if (this.isTabLocked(i) && (res = JOptionPane.showConfirmDialog(this, msg = BasicUtilities.getString("LockedTab_Close_Warning"), title = BasicUtilities.getString("Warning"), 0)) == 1) {
            return;
        }
        this.iconCache.remove(this.getComponentAt(i));
        super.removeTabAt(i);
        this.invalidate();
        this.repaint();
        this.fireStateChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllTabs() {
        ITabbedPane iTabbedPane = this;
        synchronized (iTabbedPane) {
            for (int i = this.getTabCount() - 1; i >= 0; --i) {
                this.removeTabAt(i);
            }
        }
    }

    public boolean isEmpty() {
        return this.getTabCount() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUnlockedTabs() {
        ITabbedPane iTabbedPane = this;
        synchronized (iTabbedPane) {
            for (int i = this.getTabCount() - 1; i >= 0; --i) {
                if (this.isTabLocked(i)) continue;
                this.removeTabAt(i);
            }
        }
    }

    public String getSelectedToolTip() {
        int tab = this.getSelectedIndex();
        if (tab >= 0) {
            return this.getToolTipTextAt(tab);
        }
        return null;
    }

    public void setMaxTabCount(int newMax) {
        if (newMax < 1) {
            throw new IllegalArgumentException(Integer.toString(newMax));
        }
        if (newMax >= this.maxtabcount) {
            this.maxtabcount = newMax;
        } else {
            while (this.maxtabcount > newMax && this.getTabCount() > newMax) {
                this.removeTabAt(0);
            }
            this.maxtabcount = newMax;
        }
    }

    public void removeSelectedTab() {
        int tab = this.getSelectedIndex();
        if (tab >= 0) {
            this.removeTabAt(tab);
        }
    }

    public void lockSelectedTab() {
        int tab = this.getSelectedIndex();
        if (tab >= 0) {
            this.lockTab(tab);
        }
    }

    public void unlockSelectedTab() {
        int tab = this.getSelectedIndex();
        if (tab >= 0) {
            this.unlockTab(tab);
        }
    }

    public int getIndexOfTitle(String title) {
        if (title != null) {
            for (int i = 0; i < this.getTabCount(); ++i) {
                if (!title.equals(this.getTitleAt(i))) continue;
                return i;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClosableTab(int index, boolean closable) {
        if (index < 0 || index >= this.getTabCount()) {
            return;
        }
        try {
            CompoundIcon icon = (CompoundIcon)this.getIconAt(index);
            icon.setLeftIcon(closable ? CLOSE_ICON : null);
        }
        catch (Throwable throwable) {
        }
        finally {
            this.invalidate();
            this.repaint();
        }
    }

    public boolean isTabLocked(int i) {
        if (i >= 0) {
            Component c = this.getComponent(i);
            if (c instanceof JComponent) {
                JComponent jc = (JComponent)c;
                Boolean flag = (Boolean)jc.getClientProperty(CLIENT_IS_LOCKED);
                return flag == null ? false : flag;
            }
            return false;
        }
        throw new IllegalArgumentException(Integer.toString(i));
    }

    public void unlockTab(int i) {
        Component c;
        if (i >= 0 && this.isTabLocked(i) && (c = this.getComponent(i)) instanceof JComponent) {
            JComponent jc = (JComponent)c;
            jc.putClientProperty(CLIENT_IS_LOCKED, Boolean.FALSE);
            Icon icon = (Icon)this.iconCache.get(c);
            this.setIconAt(i, icon);
            this.validateTree();
            this.repaint();
        }
    }

    public void lockTab(int i) {
        if (i >= 0 && !this.isTabLocked(i)) {
            Component c = this.getComponent(i);
            if (c instanceof JComponent) {
                Icon cache;
                JComponent jc = (JComponent)c;
                jc.putClientProperty(CLIENT_IS_LOCKED, Boolean.TRUE);
                CompoundIcon icon = (CompoundIcon)this.getIconAt(i);
                if (icon != null && (cache = icon.getRightIcon()) != null) {
                    this.iconCache.put(jc, cache);
                }
                icon.setRightIcon(LOCK_ICON);
                this.validateTree();
                this.repaint();
            } else {
                String message = BasicUtilities.getString("Resultcontainer_Component_Error");
                throw new IllegalComponentStateException(message);
            }
        }
    }

    public void removeActionListener(ActionListener l) {
        if (this.actionListeners != null && this.actionListeners.contains(l)) {
            Vector v = (Vector)this.actionListeners.clone();
            v.removeElement(l);
            this.actionListeners = v;
        }
    }

    public void addActionListener(ActionListener l) {
        Vector v;
        Vector vector = v = this.actionListeners == null ? new Vector(2) : (Vector)this.actionListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.actionListeners = v;
        }
    }

    protected int locateFirstUnlockedTab() {
        if (this.oldestIndex >= this.getTabCount() || this.oldestIndex < 0) {
            this.oldestIndex = 0;
        }
        for (int i = this.oldestIndex; i < this.getTabCount(); ++i) {
            if (this.isTabLocked(i)) continue;
            this.oldestIndex = i + 1;
            return i;
        }
        this.oldestIndex = -1;
        return -1;
    }

    protected void fireActionPerformed(ActionEvent e) {
        if (this.actionListeners != null) {
            Vector listeners = this.actionListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                try {
                    ((ActionListener)listeners.elementAt(i)).actionPerformed(e);
                    continue;
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
    }

    private class MouseHandler
    extends MouseInputAdapter {
        private MouseHandler() {
        }

        public void mousePressed(MouseEvent e) {
            if (ITabbedPane.this.getSelectedIndex() < 0) {
                return;
            }
            if (e.getClickCount() == 2 && ITabbedPane.this.getSelectedIndex() >= 0) {
                ITabbedPane.this.fireActionPerformed(new ActionEvent(ITabbedPane.this, 64769, ITabbedPane.this.getSelectedToolTip(), e.getModifiers()));
            } else if (e.getClickCount() == 1) {
                int idx = ITabbedPane.this.getSelectedIndex();
                Rectangle r = ITabbedPane.this.getUI().getTabBounds(ITabbedPane.this, idx);
                if (!r.contains(e.getPoint())) {
                    return;
                }
                CompoundIcon ico = (CompoundIcon)ITabbedPane.this.getIconAt(idx);
                if (ico != null) {
                    if (ico.isOverIcon(e.getX(), e.getY())) {
                        ITabbedPane.this.removeSelectedTab();
                        ITabbedPane.this.setCursor(Cursor.getPredefinedCursor(0));
                        return;
                    }
                    ActionEvent evt = new ActionEvent(ITabbedPane.this, 64768, "", e.getModifiers());
                    ITabbedPane.this.fireActionPerformed(evt);
                } else {
                    ActionEvent evt = new ActionEvent(ITabbedPane.this, 64768, "", e.getModifiers());
                    ITabbedPane.this.fireActionPerformed(evt);
                }
            }
        }

        public void mouseMoved(MouseEvent e) {
            try {
                if (ITabbedPane.this.getTabCount() >= 1) {
                    int idx = ITabbedPane.this.getSelectedIndex();
                    Rectangle r = ITabbedPane.this.getUI().getTabBounds(ITabbedPane.this, idx);
                    if (!r.contains(e.getPoint())) {
                        if (ITabbedPane.this.getCursor().getType() != 0) {
                            ITabbedPane.this.setCursor(Cursor.getPredefinedCursor(0));
                        }
                        return;
                    }
                    CompoundIcon ico = (CompoundIcon)ITabbedPane.this.getIconAt(idx);
                    ITabbedPane.this.repaint(r);
                    if (ico != null && ico.isOverIcon(e.getX(), e.getY())) {
                        ITabbedPane.this.setCursor(Cursor.getPredefinedCursor(12));
                        return;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (ITabbedPane.this.getCursor().getType() != 0) {
                ITabbedPane.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }
}

