/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Window;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.core.model.EnhancedTableModel;
import org.isqlviewer.swing.ActionManager;
import org.isqlviewer.swing.ITableCellEditor;
import org.isqlviewer.swing.ITableCellRenderer;
import org.isqlviewer.swing.SortableHeaderRenderer;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.Sortable;
import org.isqlviewer.util.UserPreferences;

public class ITable
extends JTable {
    public static final int INPUT_EVENT_DOUBLE_CLICK = 511;
    public static final int INPUT_EVENT_COMMAND_CLICK = 767;
    public static final int INPUT_EVENT_HEADER_CLICK = 1023;
    public static final String CLIENT_PRINTING = "isPrinting";
    public static final String CLIENT_JPOPUP_MENU = "ITable.JPopupMenu";
    private static final String DELETE_ACTION = "DELETE_SELECTED";
    private static DragSource dndDragSource = DragSource.getDefaultDragSource();
    protected static SystemConfig config = SystemConfig.getInstance();
    protected SortableHeaderRenderer header = new SortableHeaderRenderer(this);
    protected ActionManager mgr = null;
    protected MouseInputAdapter mouseInputHandler = null;
    protected int defaultSortedColumn = -1;
    protected boolean selectionToggle = true;
    protected DnDSupport dndHandler = new DnDSupport(this);
    protected DragGestureRecognizer dndRecognizer = null;
    static /* synthetic */ Class class$java$awt$event$ActionListener;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$sql$Blob;
    static /* synthetic */ Class class$java$sql$Clob;
    static /* synthetic */ Class class$java$sql$Ref;
    static /* synthetic */ Class class$java$lang$Boolean;

    public ITable() {
        this((ActionManager)null);
    }

    public ITable(TableModel model) {
        this((ActionManager)null);
        this.setModel(model);
    }

    public ITable(ActionManager mgr) {
        super(0, 0);
        super.setDragEnabled(false);
        this.mgr = mgr;
        this.mouseInputHandler = new TableMouseAdapter(this);
        this.setRowSelectionAllowed(true);
        this.addMouseListener(this.mouseInputHandler);
        this.addMouseMotionListener(this.mouseInputHandler);
        this.getTableHeader().setDefaultRenderer(this.header);
        this.getTableHeader().addMouseListener(this.mouseInputHandler);
        this.putClientProperty(CLIENT_PRINTING, new Boolean(false));
        this.initDefaultRenderers();
        this.initDefaultEditors();
        this.setAutoResizeMode(0);
        InputMap im = this.getInputMap();
        ActionMap am = this.getActionMap();
        KeyStroke ks = BasicUtilities.createKeyStroke(67, BasicUtilities.CMD_MASK);
        im.put(ks, "HT.CELL.COPY");
        am.put("HT.CELL.COPY", new CellCopyAction(this));
    }

    public void refreshSorted() {
        Sortable mdl = null;
        if (this.getModel() instanceof Sortable) {
            mdl = (Sortable)((Object)this.getModel());
        }
        if (mdl == null) {
            return;
        }
        int column = this.header.getSortedColumn();
        if (column == -1) {
            return;
        }
        boolean direct = this.header.isAscending();
        if (mdl.canSort(column, direct)) {
            mdl.sort(column, direct);
        }
    }

    public EnhancedTableModel getSelectedSubModel() {
        int[] rows = null;
        rows = this.selectionToggle ? (this.getRowSelectionAllowed() ? this.getSelectedRows() : ITable.createIterativeArray(this.getRowCount())) : this.getSelectedRows();
        int[] columns = null;
        columns = this.selectionToggle ? (this.getColumnSelectionAllowed() ? this.getSelectedColumns() : ITable.createIterativeArray(this.getColumnCount())) : this.getSelectedRows();
        return ((EnhancedTableModel)this.getModel()).subModel(rows, columns);
    }

    public void setSelectionToggleEnabled(boolean f) {
        this.selectionToggle = f;
    }

    public void addActionListener(ActionListener al) {
        this.listenerList.add(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = ITable.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, al);
    }

    public void removeActionListener(ActionListener al) {
        this.listenerList.remove(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = ITable.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, al);
    }

    public void setValueAt(Object aValue, int row, int column) {
        try {
            super.setValueAt(aValue, row, column);
        }
        catch (Throwable t) {
            Window win = SwingUtilities.getWindowAncestor(this);
            BasicUtilities.showExceptionPopup(win, t, t.getMessage());
        }
    }

    public void allowColumnReordering(boolean f) {
        this.getTableHeader().setReorderingAllowed(f);
    }

    public void allowColumnResizing(boolean f) {
        this.getTableHeader().setResizingAllowed(f);
    }

    protected void fireActionEvent(ActionEvent e) {
        if (this.mgr != null) {
            this.mgr.forwardAction(e);
        }
        ActionListener[] lst = (ActionListener[])this.listenerList.getListeners(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = ITable.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener);
        for (int i = 0; i < lst.length; ++i) {
            try {
                lst[i].actionPerformed(e);
                continue;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
    }

    protected void initDefaultRenderers() {
        this.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = ITable.class$("java.lang.Object")) : class$java$lang$Object, new ITableCellRenderer());
        this.setDefaultRenderer(class$java$lang$Number == null ? (class$java$lang$Number = ITable.class$("java.lang.Number")) : class$java$lang$Number, new ITableCellRenderer(4));
        this.setDefaultRenderer(class$java$lang$Float == null ? (class$java$lang$Float = ITable.class$("java.lang.Float")) : class$java$lang$Float, new ITableCellRenderer(6));
        this.setDefaultRenderer(class$java$lang$Double == null ? (class$java$lang$Double = ITable.class$("java.lang.Double")) : class$java$lang$Double, new ITableCellRenderer(8));
        this.setDefaultRenderer(class$java$util$Date == null ? (class$java$util$Date = ITable.class$("java.util.Date")) : class$java$util$Date, new ITableCellRenderer(91));
        this.setDefaultRenderer(class$java$sql$Time == null ? (class$java$sql$Time = ITable.class$("java.sql.Time")) : class$java$sql$Time, new ITableCellRenderer(92));
        this.setDefaultRenderer(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = ITable.class$("java.sql.Timestamp")) : class$java$sql$Timestamp, new ITableCellRenderer(93));
        this.setDefaultRenderer(class$java$sql$Blob == null ? (class$java$sql$Blob = ITable.class$("java.sql.Blob")) : class$java$sql$Blob, new ITableCellRenderer(2004));
        this.setDefaultRenderer(class$java$sql$Clob == null ? (class$java$sql$Clob = ITable.class$("java.sql.Clob")) : class$java$sql$Clob, new ITableCellRenderer(2005));
        this.setDefaultRenderer(class$java$sql$Ref == null ? (class$java$sql$Ref = ITable.class$("java.sql.Ref")) : class$java$sql$Ref, new ITableCellRenderer(2006));
    }

    protected void initDefaultEditors() {
        this.setDefaultEditor(class$java$lang$Object == null ? (class$java$lang$Object = ITable.class$("java.lang.Object")) : class$java$lang$Object, new ITableCellEditor(1111));
        this.setDefaultEditor(class$java$util$Date == null ? (class$java$util$Date = ITable.class$("java.util.Date")) : class$java$util$Date, new ITableCellEditor(91));
        this.setDefaultEditor(class$java$sql$Time == null ? (class$java$sql$Time = ITable.class$("java.sql.Time")) : class$java$sql$Time, new ITableCellEditor(92));
        this.setDefaultEditor(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = ITable.class$("java.sql.Timestamp")) : class$java$sql$Timestamp, new ITableCellEditor(93));
    }

    protected void paintRow(Graphics2D g2, int[] columns, int row, boolean selected) {
        int isw = this.getIntercellSpacing().width + 4 * SortableHeaderRenderer.SORT_ICON_WIDTH;
        int x = 0;
        for (int i = 0; i < columns.length; ++i) {
            TableCellRenderer tcr = this.getCellRenderer(row, columns[i]);
            Object obj = this.getValueAt(row, columns[i]);
            Component view = tcr.getTableCellRendererComponent(this, obj, selected, false, row, columns[i]);
            TableColumn column = this.columnModel.getColumn(columns[i]);
            int headerWidth = column.getWidth() + isw;
            Dimension dim = new Dimension(headerWidth, view.getPreferredSize().height);
            view.setSize(dim);
            view.setLocation(0, 0);
            view.paint(g2);
            g2.translate(dim.width, 0);
            if ((x += dim.width) >= g2.getClipBounds().width) break;
        }
    }

    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        int lrow = this.getSelectedRow();
        boolean f = super.processKeyBinding(ks, e, condition, pressed);
        if (this.getModel() instanceof EnhancedTableModel) {
            EnhancedTableModel mdl = (EnhancedTableModel)this.getModel();
            if (mdl == null) {
                return f;
            }
            switch (e.getKeyCode()) {
                case 34: 
                case 40: {
                    if (lrow != this.getRowCount() - 1 || ks.isOnKeyRelease() || !mdl.pageDown()) break;
                    this.setRowSelectionInterval(0, 0);
                    this.scrollRectToVisible(this.getCellRect(0, 0, true));
                    break;
                }
                case 33: 
                case 38: {
                    if (lrow != 0 || ks.isOnKeyRelease() || !mdl.pageUp()) break;
                    this.setRowSelectionInterval(this.getRowCount() - 1, this.getRowCount() - 1);
                    this.scrollRectToVisible(this.getCellRect(0, 0, true));
                }
            }
        }
        return f;
    }

    public void setColumnSelectionAllowed(boolean f) {
        super.setColumnSelectionAllowed(f);
        if (f) {
            if (this.mgr != null) {
                Action a = this.mgr.getAction(20);
                this.getActionMap().put(DELETE_ACTION, a);
                this.getInputMap().put((KeyStroke)a.getValue("AcceleratorKey"), DELETE_ACTION);
            }
            if (this.selectionToggle) {
                super.setRowSelectionAllowed(false);
            }
        } else if (this.selectionToggle) {
            this.setRowSelectionAllowed(true);
        }
    }

    public void setRowSelectionAllowed(boolean f) {
        super.setRowSelectionAllowed(f);
        if (f) {
            if (this.mgr != null) {
                Action a = this.mgr.getAction(19);
                this.getActionMap().put(DELETE_ACTION, a);
                this.getInputMap().put((KeyStroke)a.getValue("AcceleratorKey"), DELETE_ACTION);
            }
            if (this.selectionToggle) {
                super.setColumnSelectionAllowed(false);
            }
        } else if (this.selectionToggle) {
            super.setColumnSelectionAllowed(true);
        }
    }

    public void setFont(Font fnt) {
        super.setFont(fnt);
        FontMetrics fm = this.getFontMetrics(fnt);
        this.setRowHeight(fm.getHeight());
    }

    public void setDragEnabled(boolean f) {
        if (f) {
            if (this.dndRecognizer == null) {
                this.dndRecognizer = dndDragSource.createDefaultDragGestureRecognizer(this, 3, this.dndHandler);
            }
        } else if (this.dndRecognizer != null) {
            this.dndRecognizer.resetRecognizer();
            this.dndRecognizer.removeDragGestureListener(this.dndHandler);
            this.dndRecognizer.setComponent(null);
            this.dndRecognizer = null;
        }
    }

    public boolean getDragEnabled() {
        return this.dndRecognizer == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setModel(TableModel mdl) {
        super.setModel(mdl);
        ITable iTable = this;
        synchronized (iTable) {
            if (mdl instanceof Sortable) {
                this.refreshSorted();
            }
        }
    }

    public void tableChanged(TableModelEvent event) {
        super.tableChanged(event);
        if (event.getFirstRow() == -1) {
            this.setColumnSizes(0, this.getColumnCount());
            try {
                boolean allowed = this.getTableHeader().getReorderingAllowed();
                this.allowColumnReordering(allowed && this.getColumnCount() >= 2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void columnAdded(TableColumnModelEvent event) {
        this.setColumnSizes(event.getToIndex(), event.getToIndex());
        super.columnAdded(event);
    }

    private void setColumnSizes(int fromIndex, int toIndex) {
        TableColumnModel cmodel = this.getColumnModel();
        int columnCount = cmodel.getColumnCount();
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (toIndex >= columnCount) {
            toIndex = columnCount - 1;
        }
        if (fromIndex > toIndex) {
            return;
        }
        TableModel model = this.getModel();
        int rowCount = this.getRowCount();
        TableCellRenderer headerRenderer = this.getTableHeader().getDefaultRenderer();
        int isw = this.getIntercellSpacing().width + 4 * SortableHeaderRenderer.SORT_ICON_WIDTH;
        for (int viewCol = fromIndex; viewCol <= toIndex; ++viewCol) {
            TableColumn column = cmodel.getColumn(viewCol);
            column.setPreferredWidth(0);
            int headerWidth = this.getHeaderWidth(headerRenderer, column) + isw;
            int cellWidth = rowCount == 0 ? 0 : this.getDataWidth(model, column, viewCol, rowCount);
            int pwidth = Math.max(headerWidth, cellWidth);
            column.setPreferredWidth(pwidth);
            column.setWidth(pwidth);
            if (this.getColumnClass(viewCol) != (class$java$lang$Boolean == null ? ITable.class$("java.lang.Boolean") : class$java$lang$Boolean) || this.getRowCount() < 1) continue;
            TableCellRenderer rend = this.getCellRenderer(0, viewCol);
            Object o = this.getValueAt(0, viewCol);
            Component comp = rend.getTableCellRendererComponent(this, o, false, false, 0, viewCol);
            this.setRowHeight(comp.getPreferredSize().height);
        }
    }

    private int getHeaderWidth(TableCellRenderer headerRenderer, TableColumn column) {
        Component comp = headerRenderer.getTableCellRendererComponent(null, column.getHeaderValue(), false, false, 0, 0);
        return comp.getPreferredSize().width;
    }

    private int getDataWidth(TableModel model, TableColumn column, int col, int rowCount) {
        Boolean b;
        int modelCol = this.convertColumnIndexToModel(col);
        TableCellRenderer renderer = column.getCellRenderer();
        if (renderer == null) {
            renderer = this.getDefaultRenderer(model.getColumnClass(modelCol));
            column.setCellRenderer(renderer);
        }
        b = (b = (Boolean)this.getClientProperty(CLIENT_PRINTING)) == null ? Boolean.FALSE : b;
        int maxWidth = 0;
        for (int row = 0; row < rowCount; ++row) {
            Object v = model.getValueAt(row, modelCol);
            Component comp = renderer.getTableCellRendererComponent(this, v, false, false, row, col);
            if (b.booleanValue()) {
                int current = this.getRowHeight(row);
                int preferred = comp.getPreferredSize().height;
                preferred = Math.max(preferred, current);
                this.setRowHeight(row, preferred);
            }
            int thisCellWidth = SortableHeaderRenderer.SORT_ICON_WIDTH;
            maxWidth = Math.max(maxWidth, thisCellWidth += comp.getPreferredSize().width + 2 * this.getIntercellSpacing().width);
        }
        return maxWidth;
    }

    private static int[] createIterativeArray(int size) {
        int[] result = new int[size];
        for (int i = 0; i < size; ++i) {
            result[i] = i;
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class DnDSupport
    implements DragGestureListener,
    DragSourceListener {
        private static final Point pt = new Point(2, 2);
        private static final int MAX_ROWS = 7;
        private ITable table = null;

        public void dragDropEnd(DragSourceDropEvent dsde) {
        }

        public void dragEnter(DragSourceDragEvent dsde) {
        }

        public void dragExit(DragSourceEvent dse) {
        }

        public void dragOver(DragSourceDragEvent dsde) {
        }

        public void dropActionChanged(DragSourceDragEvent dsde) {
        }

        public DnDSupport(ITable reference) {
            this.table = reference;
        }

        public void dragGestureRecognized(DragGestureEvent event) {
            DragGestureRecognizer dndRecognizer = event.getSourceAsDragGestureRecognizer();
            try {
                EnhancedTableModel selection = this.table.getSelectedSubModel();
                if (selection.isEmpty()) {
                    return;
                }
                int[] rows = null;
                rows = this.table.selectionToggle ? (this.table.getRowSelectionAllowed() ? this.table.getSelectedRows() : ITable.createIterativeArray(this.table.getRowCount())) : this.table.getSelectedRows();
                int[] columns = null;
                columns = this.table.selectionToggle ? (this.table.getColumnSelectionAllowed() ? this.table.getSelectedColumns() : ITable.createIterativeArray(this.table.getColumnCount())) : this.table.getSelectedRows();
                EnhancedTableModel data = selection;
                if (DragSource.isDragImageSupported()) {
                    GraphicsConfiguration gConfig = this.table.getGraphicsConfiguration();
                    Dimension dim = this.table.getVisibleRect().getSize();
                    int height = 0;
                    int min = Math.min(7, rows.length);
                    for (int i = 0; i < min; ++i) {
                        height += this.table.getRowHeight(rows[i]);
                    }
                    int width = 0;
                    for (int i = 0; i < columns.length; ++i) {
                        width += this.table.getColumnModel().getColumn(columns[i]).getPreferredWidth();
                    }
                    dim.setSize(Math.min(dim.width, width), height);
                    BufferedImage bi = gConfig.createCompatibleImage(dim.width, height);
                    int x = 0;
                    int y = 0;
                    Graphics2D g2 = bi.createGraphics();
                    g2.setColor(Color.WHITE);
                    g2.fillRect(0, 0, dim.width, dim.height);
                    for (int i = 0; i < rows.length; ++i) {
                        int rowHeight = this.table.getRowHeight(rows[i]);
                        Graphics2D subg = (Graphics2D)g2.create(x, y, dim.width, rowHeight);
                        this.table.paintRow(subg, columns, rows[i], false);
                        y += rowHeight;
                    }
                    g2.setColor(BasicUtilities.DND_HAZE);
                    g2.fillRect(0, 0, dim.width, dim.height);
                    g2.setColor(Color.BLACK);
                    g2.drawRect(0, 0, dim.width - 1, height - 1);
                    dndDragSource.startDrag(event, null, bi, pt, data, this);
                } else {
                    dndDragSource.startDrag(event, null, data, this);
                }
            }
            catch (Throwable t) {
                dndRecognizer.resetRecognizer();
                BasicUtilities.beep();
            }
        }
    }

    private static class TableMouseAdapter
    extends MouseInputAdapter {
        private ITable table = null;

        public TableMouseAdapter(ITable reference) {
            this.table = reference;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mousePressed(MouseEvent e) {
            JComponent c;
            Object src = e.getSource();
            if (src instanceof JComponent && this.handlePopup(e, c = (JComponent)src)) {
                return;
            }
            int mods = e.getModifiers();
            int row = this.table.rowAtPoint(e.getPoint());
            int col = this.table.columnAtPoint(e.getPoint());
            boolean isShft = (mods & 1) == 1;
            boolean isMeta = (mods & BasicUtilities.CMD_MASK) == BasicUtilities.CMD_MASK;
            boolean isAlt = (mods & 8) == 8;
            boolean isLeft = SwingUtilities.isLeftMouseButton(e);
            boolean isMiddle = SwingUtilities.isMiddleMouseButton(e);
            boolean isEdit = this.table.getModel().isCellEditable(row, col);
            int cc = e.getClickCount();
            if (src == this.table) {
                if (isLeft && cc == 2 && !isShft && !isMeta) {
                    if (!isEdit && this.table.selectionToggle) {
                        this.table.setRowSelectionAllowed(!this.table.getRowSelectionAllowed());
                        this.table.repaint();
                        ActionEvent evt = new ActionEvent(this.table, 511, "");
                        this.table.fireActionEvent(evt);
                    }
                } else if (cc == 1 && (isAlt || isMiddle) && row >= 0 && col >= 0) {
                    ActionEvent evt = new ActionEvent(src, 767, Integer.toString(col), row);
                    this.table.fireActionEvent(evt);
                }
                return;
            }
            if (this.table.getModel() instanceof Sortable) {
                UserPreferences prefs = SystemConfig.getInstance().getPreferences();
                int pcc = prefs.getBoolean("general.1clicksort-enabled") ? 1 : 2;
                JTableHeader th = (JTableHeader)src;
                if (th.getResizingColumn() != null) {
                    if (cc == 2) {
                        this.table.setColumnSizes(0, this.table.getColumnCount());
                    }
                    return;
                }
                Sortable mdl = (Sortable)((Object)this.table.getModel());
                int idx = th.columnAtPoint(e.getPoint());
                if (cc == pcc && isLeft && idx >= 0 && mdl != null) {
                    int sci = this.table.header.getRenderedSortedColumn();
                    boolean asc = this.table.header.isAscending();
                    if (!mdl.canSort(idx, asc)) {
                        BasicUtilities.beep();
                        return;
                    }
                    if (sci != idx) {
                        this.table.header.setSortedColumn(idx, this.table, false);
                    } else {
                        this.table.header.setSortedColumn(sci, this.table, !asc);
                    }
                    asc = this.table.header.isAscending();
                    idx = this.table.header.getSortedColumn();
                    Sortable sortable = mdl;
                    synchronized (sortable) {
                        mdl.sort(idx, asc);
                        th.repaint();
                    }
                }
                return;
            }
        }

        public void mouseReleased(MouseEvent e) {
            Object src = e.getSource();
            if (src instanceof JComponent) {
                JComponent c = (JComponent)src;
                this.handlePopup(e, c);
            }
        }

        private boolean handlePopup(MouseEvent e, JComponent jc) {
            JPopupMenu popup = null;
            if (e.isPopupTrigger()) {
                try {
                    popup = (JPopupMenu)jc.getClientProperty(ITable.CLIENT_JPOPUP_MENU);
                }
                catch (Throwable t) {
                    return false;
                }
                if (popup != null) {
                    int row = this.table.rowAtPoint(e.getPoint());
                    int[] selected = this.table.getSelectedRows();
                    boolean isSelected = false;
                    for (int i = 0; i < selected.length; ++i) {
                        if (selected[i] != row) continue;
                        isSelected = true;
                        break;
                    }
                    if (!isSelected) {
                        this.table.setRowSelectionInterval(row, row);
                    }
                    popup.show(jc, e.getX(), e.getY());
                    e.consume();
                    return true;
                }
                return false;
            }
            return false;
        }
    }

    private static class CellCopyAction
    extends AbstractAction {
        private ITable reference = null;

        public CellCopyAction(ITable table) {
            this.reference = table;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.reference != null) {
                if (!this.reference.getSelectionModel().isSelectionEmpty()) {
                    BasicUtilities.copySelectedCellsToClipBoard(this.reference);
                } else {
                    BasicUtilities.beep();
                }
            } else {
                BasicUtilities.beep();
            }
        }
    }
}

