/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing;

import java.awt.Component;
import java.io.PrintWriter;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.isqlviewer.core.model.SuggestionListModel;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.swing.text.SQLDocument;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringUtilities;

public class JDBCSuggestor
extends SuggestionListModel {
    private static final int METADATA_TYPE_TABLE = 0;
    private static final int METADATA_TYPE_COLUMN = 1;
    private ArrayList rootStore = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnection(DatabaseConnection cnx) {
        PrintWriter trace;
        MetaDataItem item;
        String activeSchema = null;
        String activeCatalog = null;
        this.rootStore.clear();
        this.clear();
        if (cnx == null || cnx.isClosed()) {
            return;
        }
        DatabaseMetaData md = cnx.getDatabaseInformation();
        activeSchema = cnx.getSchema();
        activeCatalog = cnx.getCatalog();
        ResultSet set = null;
        try {
            set = md.getTables(activeCatalog, null, "%", cnx.getTableTypes());
            while (set.next()) {
                item = new MetaDataItem();
                item.type = 0;
                item.table = set.getString("TABLE_NAME");
                item.schema = set.getString("TABLE_SCHEM");
                if (item.schema != null && item.schema.equals(activeSchema)) {
                    item.value = item.table;
                    item.label = item.value;
                    if (this.rootStore.size() >= 1) {
                        this.rootStore.add(0, item);
                        continue;
                    }
                    this.rootStore.add(item);
                    continue;
                }
                item.value = item.schema != null ? item.schema.concat(".".concat(item.table)) : item.table;
                item.label = item.value;
                this.rootStore.add(item);
            }
        }
        catch (SQLException sqle) {
            trace = DriverManager.getLogWriter();
            if (trace != null) {
                BasicUtilities.HandleException((Throwable)sqle, null, true, trace);
            }
        }
        catch (Throwable t) {
            if (cnx.getVerboseOn()) {
                BasicUtilities.HandleException(t, null, cnx.getDebugOn());
            }
        }
        finally {
            try {
                set.close();
            }
            catch (Throwable t) {}
            set = null;
        }
        try {
            set = md.getColumns(activeCatalog, activeSchema, "%", "%");
            while (set.next()) {
                item = new MetaDataItem();
                item.type = 1;
                item.table = set.getString("TABLE_NAME");
                item.schema = set.getString("TABLE_SCHEM");
                item.value = set.getString("COLUMN_NAME");
                item.label = item.table.concat(".").concat(item.value);
                this.rootStore.add(item);
            }
        }
        catch (SQLException sqle) {
            trace = DriverManager.getLogWriter();
            if (trace != null) {
                BasicUtilities.HandleException((Throwable)sqle, null, true, trace);
            }
        }
        catch (Throwable t) {
            if (cnx.getVerboseOn()) {
                BasicUtilities.HandleException(t, null, cnx.getDebugOn());
            }
        }
        finally {
            try {
                set.close();
            }
            catch (Throwable t) {}
            set = null;
        }
    }

    public void updateSuggestion(Document doc, int offset) throws BadLocationException {
        String word = BasicUtilities.getCurrentWord(doc, offset).toUpperCase();
        String prefix = null;
        SQLDocument sqlDoc = null;
        boolean withinTableAlias = false;
        if (doc instanceof SQLDocument) {
            sqlDoc = (SQLDocument)doc;
        }
        if (word.indexOf(46) >= 0) {
            prefix = word.substring(0, word.indexOf(46));
            word = StringUtilities.stripCharacters(word.substring(prefix.length()), ".");
            withinTableAlias = sqlDoc != null && sqlDoc.isAliased(prefix);
        }
        Iterator itr = this.rootStore.iterator();
        this.clear();
        while (itr.hasNext()) {
            MetaDataItem next = (MetaDataItem)itr.next();
            if (withinTableAlias) {
                String alias;
                if (next.type != 1 || !sqlDoc.isAliased(next.table) || !(alias = sqlDoc.getTableForAlias(prefix)).equalsIgnoreCase(next.table) || next.value.toUpperCase().indexOf(word) < 0) continue;
                this.addElement(next);
                continue;
            }
            if (next.label.toUpperCase().indexOf(word) < 0) continue;
            this.addElement(next);
        }
    }

    public int applySuggestion(Object suggestion, Document doc, int start, int position) throws BadLocationException {
        String word = BasicUtilities.getCurrentWord(doc, position);
        String prefix = null;
        MetaDataItem item = (MetaDataItem)suggestion;
        if (word.indexOf(46) >= 0) {
            prefix = word.substring(0, word.indexOf(46));
            word = StringUtilities.stripCharacters(word.substring(prefix.length()), ".");
        }
        this.clear();
        if (suggestion == null) {
            return -1;
        }
        String code = item.value;
        int len = word.length();
        doc.remove(position -= len, len);
        doc.insertString(position, code, null);
        return position + code.length();
    }

    public static class SuggestionRenderer
    extends DefaultListCellRenderer {
        private SQLDocument document = null;

        public SuggestionRenderer(SQLDocument doc) {
            this.document = doc;
        }

        public Component getListCellRendererComponent(JList l, Object val, int idx, boolean sel, boolean foc) {
            super.getListCellRendererComponent((JList<?>)l, val, idx, sel, foc);
            MetaDataItem item = (MetaDataItem)val;
            this.setText(item.label);
            switch (item.type) {
                case 1: {
                    this.setIcon(BasicUtilities.loadIconResource("TableInfo16"));
                    if (!this.document.isAliased(item.table)) break;
                    this.setFont(l.getFont().deriveFont(1));
                    break;
                }
                case 0: {
                    this.setIcon(BasicUtilities.loadIconResource("Table16"));
                    break;
                }
                default: {
                    this.setIcon(null);
                }
            }
            return this;
        }
    }

    private static class MetaDataItem {
        private int type = -1;
        private String table;
        private String schema;
        private String value;
        private String label;

        private MetaDataItem() {
        }
    }
}

