/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing;

import java.awt.Component;
import java.text.MessageFormat;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.isqlviewer.util.PropertyPage;

public class PropertyPageCellRenderer
extends DefaultTreeCellRenderer {
    private static final String LABEL_FORMAT = "({0}) {1}";

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean foc) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, foc);
        if (value instanceof PropertyPage) {
            try {
                PropertyPage page = (PropertyPage)value;
                if (!expanded && page.getChildren().length >= 1) {
                    Object[] params = new String[]{Integer.toString(page.getChildren().length), page.getPropertyPageName()};
                    String label = MessageFormat.format(LABEL_FORMAT, params);
                    this.setText(label);
                } else {
                    this.setText(page.getPropertyPageName());
                }
                this.setIcon(page.getUserIcon());
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return this;
    }
}

