/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing.print;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JComponent;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringUtilities;
import org.isqlviewer.util.UserPreferences;

public abstract class DefaultPaperComponent
extends JComponent
implements Printable,
Pageable {
    private static final int PAGE_MARGIN = 36;
    private final DateFormat df = DateFormat.getDateInstance(2);
    private final String TIMESTAMP = BasicUtilities.getString("Print_Timestamp", new String[]{this.df.format(new Date()), System.getProperty("user.name", "Nobody")});
    private final String SFOOTER = "iSQL-Viewer v.2.1.8";
    protected double mZoomLevel = 0.0;
    protected int mCurrentPage = 0;
    protected PageFormat mPageFormat = null;
    private Dimension mContentArea = null;
    private PrinterJob printerJob = null;
    private Paper pPaper = null;
    private boolean includeHeader = true;
    private boolean includeFooter = true;
    private boolean printInColor = true;
    private boolean isPrinting = false;
    protected boolean isValid = false;
    private Font fntHeader = new Font("Lucinda Sans", 1, 11);
    private Font fntSFooter = new Font("Lucinda Sans", 2, 8);
    private int h_HeaderBox = 0;
    private int w_HeaderBox = 0;
    private int h_FooterBox = 0;
    private int w_FooterBox = 0;
    private int h_PaperArea = 0;
    private int w_PaperArea = 0;
    private StringBuffer titleBuffer = new StringBuffer("");
    private String titleString = "No-Data to Print";

    public DefaultPaperComponent() {
        this.mPageFormat = new PageFormat();
        this.pPaper = new Paper();
        this.pPaper.setImageableArea(36.0, 36.0, this.pPaper.getWidth() - 72.0, this.pPaper.getHeight() - 72.0);
        this.mPageFormat.setPaper(this.pPaper);
        try {
            this.printerJob = PrinterJob.getPrinterJob();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setZoomLevel(1.0);
        this.setDoubleBuffered(true);
    }

    public abstract void setContent(Object var1);

    public void setZoomLevel(double zoom) {
        this.mZoomLevel = zoom;
        this.setPreferredSize(new Dimension((int)(this.mPageFormat.getWidth() * zoom), (int)(this.mPageFormat.getHeight() * zoom)));
        this.invalidate();
    }

    public double getZoomLevel() {
        return this.mZoomLevel;
    }

    public String getTitleString() {
        return this.titleString;
    }

    public void setTitleString(String s) {
        this.titleString = StringUtilities.oneLine(s);
    }

    public PageFormat getPageFormat() {
        return this.mPageFormat;
    }

    public void setPageFormat(PageFormat pf) {
        this.mPageFormat = pf;
    }

    public int getPageCount() {
        return 0;
    }

    public void setPageNumber(int pPageNumber) {
        this.mCurrentPage = this.getPageCount() <= pPageNumber ? this.getPageCount() - 1 : (pPageNumber < 0 ? 0 : pPageNumber);
        this.repaint();
    }

    public int getPage() {
        return this.mCurrentPage;
    }

    public void configure(UserPreferences properties) {
        this.includeHeader = properties.getBoolean("print.header-enabled");
        this.includeFooter = properties.getBoolean("print.footer-enabled");
        this.printInColor = properties.getBoolean("print.color-enabled");
        this.fntHeader = new Font("Default", 1, 11);
        this.isValid = false;
    }

    public final void print() {
        try {
            this.setDoubleBuffered(false);
            this.printerJob.setPageable(this);
            this.printerJob.setJobName("iSQL-Viewer[" + this.getTitleString() + "] PrintJob");
            if (this.printerJob.printDialog()) {
                this.isValid = false;
                this.isPrinting = true;
                this.printerJob.print();
            }
            this.setDoubleBuffered(true);
            this.isPrinting = false;
            this.isValid = false;
        }
        catch (Throwable t) {
            BasicUtilities.HandleException(t, BasicUtilities.getString("Print_Exception"));
        }
    }

    public void initialize(Graphics2D g2) {
        FontMetrics fm = g2.getFontMetrics(this.fntHeader);
        this.titleBuffer.setLength(0);
        this.titleBuffer.append(this.getTitleString());
        this.h_PaperArea = (int)this.mPageFormat.getImageableHeight() - (g2.getFontMetrics(this.fntSFooter).getHeight() + 2);
        this.w_PaperArea = (int)this.mPageFormat.getImageableWidth() - 2;
        this.h_HeaderBox = 2 * (fm.getHeight() + 4) - fm.getDescent();
        this.w_HeaderBox = this.w_PaperArea - 2;
        this.h_FooterBox = 1 * (fm.getHeight() + 4) - fm.getDescent();
        this.w_FooterBox = this.w_PaperArea - 2;
        int contentHieght = this.h_PaperArea - 2;
        int contentWidth = this.w_PaperArea - 2;
        if (this.includeHeader) {
            contentHieght -= this.h_HeaderBox;
        }
        if (this.includeFooter) {
            contentHieght -= this.h_FooterBox;
        }
        this.mContentArea = new Dimension(contentWidth, contentHieght);
        int maxWidth = (int)((double)this.getContentWidth() * 0.75);
        int w_TitleStr = fm.stringWidth(this.titleBuffer.toString()) + fm.getLeading();
        if (w_TitleStr >= maxWidth) {
            maxWidth -= fm.stringWidth("...");
            while (w_TitleStr >= maxWidth) {
                this.titleBuffer.deleteCharAt(this.titleBuffer.length() - 1);
                w_TitleStr = fm.stringWidth(this.titleBuffer.toString()) + fm.getLeading();
            }
            this.titleBuffer.append("...");
        }
        this.isValid = true;
    }

    public final int getNumberOfPages() {
        return this.getPageCount();
    }

    public final PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        return this.getPageFormat();
    }

    public final Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        return this;
    }

    public final void paint(Graphics g) {
        try {
            super.paint(g);
            if (this.isPrinting) {
                return;
            }
            g.setColor(Color.white);
            g.fillRect(0, 0, this.getPreferredSize().width, this.getPreferredSize().height);
            this.print(g, this.getPageFormat(), this.getPage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int print(Graphics g, PageFormat pageFormat, int pageIndex) {
        Graphics2D g2 = (Graphics2D)g;
        g2.scale(this.getZoomLevel(), this.getZoomLevel());
        try {
            if (!this.isValidated()) {
                if (!this.isPrinting) {
                    new Thread(new Initializer(g2)).start();
                    return 1;
                }
                new Initializer(g2).run();
            }
        }
        catch (Throwable t) {
            return 1;
        }
        if (pageIndex >= this.getPageCount()) {
            return 1;
        }
        g2.translate(36, 36);
        g2.setColor(Color.black);
        g2.drawRect(0, 0, this.w_PaperArea, this.h_PaperArea);
        FontMetrics fm = g.getFontMetrics(this.fntSFooter);
        g2.setFont(this.fntSFooter);
        g2.drawString("iSQL-Viewer v.2.1.8", this.w_PaperArea / 2 - fm.stringWidth("iSQL-Viewer v.2.1.8") / 2, this.h_PaperArea + fm.getHeight() + 1 - fm.getDescent());
        if (this.includeFooter) {
            this.drawPageFooter(g2, pageIndex);
        }
        if (this.includeHeader) {
            this.drawPageHeader(g2, pageIndex);
        }
        try {
            if (this.includeHeader) {
                g2.translate(1, this.h_HeaderBox + 2);
            } else {
                g2.translate(1, 0);
            }
            Graphics2D content = (Graphics2D)g2.create(0, 0, this.getContentWidth(), this.getContentHeight());
            this.drawPageContents(content, pageIndex);
            if (this.includeHeader) {
                g2.translate(-1, -(this.h_HeaderBox + 2));
            } else {
                g2.translate(-1, 0);
            }
        }
        catch (Throwable t) {
            BasicUtilities.HandleException(t, "DefaultPaperComponent::print(Grpahics,PageFormat,int)");
        }
        return 0;
    }

    protected final int getContentWidth() {
        return this.mContentArea.width;
    }

    protected final int getContentHeight() {
        return this.mContentArea.height;
    }

    protected final boolean useColor() {
        return this.printInColor;
    }

    protected String getHeaderString(int pageIndex) {
        return "[" + (pageIndex + 1) + " -- " + this.getPageCount() + "]";
    }

    protected String getFooterString(int pageIndex) {
        return "[" + (pageIndex + 1) + "/" + this.getPageCount() + "]";
    }

    protected boolean isValidated() {
        return this.isValid;
    }

    protected abstract void drawPageContents(Graphics2D var1, int var2);

    private void drawPageFooter(Graphics2D g, int pageIndex) {
        int fontHeight = g.getFontMetrics(this.fntHeader).getHeight();
        int fontDesent = g.getFontMetrics(this.fntHeader).getDescent();
        int tY = this.h_PaperArea - this.h_FooterBox;
        g.translate(1, tY);
        g.setColor(Color.lightGray);
        g.fillRect(0, 0, this.w_FooterBox, this.h_FooterBox);
        g.setColor(Color.black);
        g.drawRect(0, 0, this.w_FooterBox, this.h_FooterBox);
        String footerText = this.getFooterString(pageIndex);
        int y1 = 2 + (fontHeight - fontDesent);
        int sw = g.getFontMetrics(this.fntHeader).stringWidth(footerText);
        g.setFont(this.fntHeader);
        g.drawString(footerText, this.w_FooterBox - (sw + 2), y1);
        g.translate(-1, -tY);
    }

    private void drawPageHeader(Graphics2D g, int pageIndex) {
        FontMetrics fm = g.getFontMetrics(this.fntHeader);
        String pgNumber = BasicUtilities.getString("Page") + " : " + (pageIndex + 1) + "/" + this.getPageCount();
        String header = this.getHeaderString(pageIndex);
        int w_headerStr = fm.stringWidth(header) + fm.getLeading();
        int w_pageStr = fm.stringWidth(pgNumber) + fm.getLeading();
        int fontHeight = fm.getHeight();
        int fontDesent = fm.getDescent();
        g.translate(1, 1);
        g.setColor(Color.LIGHT_GRAY);
        g.fillRect(0, 0, this.w_HeaderBox, this.h_HeaderBox);
        g.setColor(Color.black);
        g.drawRect(0, 0, this.w_HeaderBox, this.h_HeaderBox);
        g.setFont(this.fntHeader);
        g.setColor(Color.black);
        int y1 = 2 + (fontHeight - fontDesent);
        int y2 = 2 * fontHeight + 2 - fontDesent;
        g.drawString(this.titleBuffer.toString(), 2 + fm.getLeading(), y1);
        g.drawString(this.TIMESTAMP, 2 + fm.getLeading(), y2);
        g.drawString(header, this.w_HeaderBox - (w_headerStr + 2), y1);
        g.drawString(pgNumber, this.w_HeaderBox - (w_pageStr + 2), y2);
        g.translate(-1, -1);
    }

    private class Initializer
    implements Runnable {
        Graphics2D g2;

        public Initializer(Graphics2D g) {
            this.g2 = g;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    DefaultPaperComponent.this.setCursor(Cursor.getPredefinedCursor(3));
                    DefaultPaperComponent.this.initialize(this.g2);
                    DefaultPaperComponent.this.isValid = true;
                }
                catch (Throwable t) {
                    BasicUtilities.HandleException(t, "Initializer::run()");
                    Object var3_2 = null;
                    DefaultPaperComponent.this.setZoomLevel(1.0);
                    DefaultPaperComponent.this.setPageNumber(0);
                    DefaultPaperComponent.this.setCursor(Cursor.getDefaultCursor());
                    DefaultPaperComponent.this.invalidate();
                    DefaultPaperComponent.this.repaint(50L);
                    DefaultPaperComponent.this.validateTree();
                    return;
                }
                Object var3_1 = null;
                DefaultPaperComponent.this.setZoomLevel(1.0);
                DefaultPaperComponent.this.setPageNumber(0);
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                DefaultPaperComponent.this.setZoomLevel(1.0);
                DefaultPaperComponent.this.setPageNumber(0);
                DefaultPaperComponent.this.setCursor(Cursor.getDefaultCursor());
                DefaultPaperComponent.this.invalidate();
                DefaultPaperComponent.this.repaint(50L);
                DefaultPaperComponent.this.validateTree();
                throw throwable;
            }
            DefaultPaperComponent.this.setCursor(Cursor.getDefaultCursor());
            DefaultPaperComponent.this.invalidate();
            DefaultPaperComponent.this.repaint(50L);
            DefaultPaperComponent.this.validateTree();
        }
    }
}

