/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.text.NumberFormat;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.isqlviewer.core.model.iSQLTableModel;
import org.isqlviewer.swing.ITable;
import org.isqlviewer.swing.print.PrinterPreview;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringUtilities;

public final class AboutBox
extends JDialog {
    private static final GridBagConstraints UI_CONSTRAINT = new GridBagConstraints(0, 0, 0, 0, 0.0, 0.0, 0, 0, new Insets(1, 1, 1, 1), 0, 0);
    private JLabel resourceLabel = new JLabel();
    private JLabel URLLabel = new JLabel(BasicUtilities.getString("Homepage_Label", "http://isqlviewer.com"));
    private JPanel infoPanel = new JPanel(new GridBagLayout());
    private ITable systemProperties = new ITable();
    private JButton printButton = new JButton(BasicUtilities.loadIconResource("Print16"));
    private JButton btnOK = new JButton(BasicUtilities.getString("Ok"));
    private JTabbedPane tabContainer = new JTabbedPane();
    private JEditorPane creditText = new JEditorPane("text/html", "<html></html>");
    private JProgressBar resourceMeter = new JProgressBar();
    private ResourceMonitor resourceMonitor = new ResourceMonitor();
    private Thread resourceThread = new Thread((Runnable)this.resourceMonitor, "iSQL-Viewer-ResourceMonitor");
    private ActionListener actionHandler = new ActionHandler();
    static /* synthetic */ Class class$java$lang$String;

    public static void showDialog(Frame Owner) {
        AboutBox box = new AboutBox(Owner);
        box.show();
        box = null;
    }

    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.cancel();
        }
        super.processWindowEvent(e);
    }

    private AboutBox(Frame parent) {
        super(parent, "", true);
        try {
            this.initUI();
            this.resourceThread.start();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        this.pack();
        this.setResizable(false);
        this.setSize(640, 500);
        this.setLocationRelativeTo(parent);
    }

    private void initUI() throws Exception {
        JScrollPane jsp = new JScrollPane(this.systemProperties);
        jsp.setCorner("UPPER_RIGHT_CORNER", this.printButton);
        this.printButton.setToolTipText(BasicUtilities.getString("Print_System_Properties"));
        this.printButton.addActionListener(this.actionHandler);
        this.btnOK.addActionListener(this.actionHandler);
        this.btnOK.setDefaultCapable(true);
        this.getRootPane().setDefaultButton(this.btnOK);
        this.systemProperties.setModel(new iSQLTableModel(System.getProperties()));
        this.systemProperties.allowColumnReordering(false);
        this.systemProperties.setDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = AboutBox.class$("java.lang.String")) : class$java$lang$String, new PropertyRenderer());
        this.systemProperties.setDragEnabled(true);
        this.resourceMeter.setStringPainted(!BasicUtilities.isMac());
        Object[] params = new String[]{BasicUtilities.getString("About_Tab_Label"), BasicUtilities.getString("Version"), "2.1.8"};
        this.setTitle(MessageFormat.format("{0} iSQL-Viewer {1} {2}", params));
        AboutBox.constrain(0, 0, 1, 1, 0.0, 0.0, 17, 0);
        this.infoPanel.add((Component)new JLabel(BasicUtilities.getString("Product")), UI_CONSTRAINT);
        AboutBox.constrain(1, 0, 1, 1, 0.0, 0.0, 17, 0);
        this.infoPanel.add((Component)new JLabel(" : iSQL-Viewer"), UI_CONSTRAINT);
        AboutBox.constrain(0, 1, 1, 1, 0.0, 0.0, 17, 0);
        this.infoPanel.add((Component)new JLabel(BasicUtilities.getString("Version")), UI_CONSTRAINT);
        AboutBox.constrain(1, 1, 1, 1, 0.0, 0.0, 17, 0);
        this.infoPanel.add((Component)new JLabel(" : ".concat("2.1.8")), UI_CONSTRAINT);
        AboutBox.constrain(2, 0, 1, 2, 1.0, 0.0, 10, 2);
        this.infoPanel.add((Component)this.resourceMeter, UI_CONSTRAINT);
        AboutBox.constrain(0, 2, 3, 1, 1.0, 0.0, 10, 0);
        this.infoPanel.add((Component)this.resourceLabel, UI_CONSTRAINT);
        AboutBox.constrain(0, 3, 3, 1, 0.0, 0.0, 10, 0);
        this.infoPanel.add((Component)new JLabel(BasicUtilities.getString("System_Properties")), UI_CONSTRAINT);
        AboutBox.constrain(0, 4, 3, 1, 1.0, 1.0, 10, 1);
        this.infoPanel.add((Component)jsp, UI_CONSTRAINT);
        AboutBox.constrain(0, 5, 3, 1, 0.0, 0.0, 10, 0);
        this.infoPanel.add((Component)this.URLLabel, UI_CONSTRAINT);
        try {
            this.creditText.setEditable(false);
            this.creditText.setPage(BasicUtilities.getResourceURL("credits.html"));
        }
        catch (Exception e) {
            // empty catch block
        }
        BasicUtilities.lockComponentToPerferredSize(this.resourceLabel);
        this.btnOK.setPreferredSize(new Dimension(2 * this.btnOK.getPreferredSize().width, this.btnOK.getPreferredSize().height));
        BasicUtilities.lockComponentToPerferredSize(this.btnOK);
        JPanel southPnl = new JPanel(new GridBagLayout());
        AboutBox.constrain(0, 0, 1, 1, 1.0, 0.0, 10, 2);
        southPnl.add(Box.createHorizontalGlue(), UI_CONSTRAINT);
        AboutBox.constrain(1, 0, 1, 1, 0.0, 0.0, 17, 0);
        southPnl.add((Component)this.btnOK, UI_CONSTRAINT);
        this.getContentPane().add((Component)southPnl, "South");
        this.getContentPane().add((Component)this.tabContainer, "Center");
        this.tabContainer.addTab(BasicUtilities.getString("Info_Tab_Label"), this.infoPanel);
        this.tabContainer.addTab(BasicUtilities.getString("Credit_Tab_Label"), new JScrollPane(this.creditText));
        this.resourceMeter.setToolTipText(BasicUtilities.getString("Resource_Meter_Tip"));
    }

    private static void constrain(int x, int y, int w, int h, double wx, double wy, int a, int f) {
        AboutBox.UI_CONSTRAINT.gridx = x;
        AboutBox.UI_CONSTRAINT.gridy = y;
        AboutBox.UI_CONSTRAINT.gridwidth = w;
        AboutBox.UI_CONSTRAINT.gridheight = h;
        AboutBox.UI_CONSTRAINT.weightx = wx;
        AboutBox.UI_CONSTRAINT.weighty = wy;
        AboutBox.UI_CONSTRAINT.anchor = a;
        AboutBox.UI_CONSTRAINT.fill = f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void cancel() {
        this.resourceMonitor.halt();
        try {
            this.resourceThread.join(5000L);
        }
        catch (Throwable throwable) {
        }
        finally {
            this.resourceThread = null;
        }
        System.runFinalization();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ResourceMonitor
    implements Runnable {
        final double MB = Math.pow(2.0, 20.0);
        final Runtime rt = Runtime.getRuntime();
        boolean stop = false;
        String[] strs = new String[2];
        NumberFormat Nf = NumberFormat.getNumberInstance();

        public ResourceMonitor() {
            this.Nf.setMaximumFractionDigits(2);
            this.Nf.setMinimumFractionDigits(2);
            this.Nf.setMaximumIntegerDigits(8);
            this.strs[1] = BasicUtilities.getString("MegaByte");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void halt() {
            ResourceMonitor resourceMonitor = this;
            synchronized (resourceMonitor) {
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!Thread.interrupted()) {
                long max = this.rt.maxMemory();
                long use = this.rt.totalMemory();
                AboutBox.this.resourceMeter.setMaximum((int)max);
                AboutBox.this.resourceMeter.setValue((int)use);
                AboutBox.this.resourceMeter.setString(StringUtilities.getHumanReadableSize(use));
                this.strs[0] = this.Nf.format((double)this.rt.totalMemory() / this.MB);
                AboutBox.this.resourceLabel.setText(BasicUtilities.getString("Resource_Label", this.strs));
                ResourceMonitor resourceMonitor = this;
                synchronized (resourceMonitor) {
                    try {
                        this.wait(2500L);
                    }
                    catch (InterruptedException ie) {
                        return;
                    }
                }
            }
        }
    }

    private class PropertyRenderer
    extends DefaultTableCellRenderer {
        private PropertyRenderer() {
        }

        public Component getTableCellRendererComponent(JTable t, Object o, boolean sel, boolean foc, int r, int c) {
            super.getTableCellRendererComponent(t, o, sel, foc, r, c);
            if (c == 0 && ((String)o).startsWith("isql.")) {
                this.setFont(this.getFont().deriveFont(1));
            }
            return this;
        }
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == AboutBox.this.printButton) {
                PrinterPreview.showPrintPreviewDialog((Frame)AboutBox.this.getParent(), (Object)AboutBox.this.systemProperties, BasicUtilities.getString("System_Properties"));
            } else if (e.getSource() == AboutBox.this.btnOK) {
                AboutBox.this.dispose();
            }
        }
    }
}

