/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.isqlviewer.core.ServiceDefinition;
import org.isqlviewer.core.ServiceProvider;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.core.model.EnhancedTableModel;
import org.isqlviewer.event.ProgressEvent;
import org.isqlviewer.event.ProgressListener;
import org.isqlviewer.sql.BatchRunner;
import org.isqlviewer.swing.ActionToolBar;
import org.isqlviewer.swing.ITable;
import org.isqlviewer.swing.ProgressListCellRenderer;
import org.isqlviewer.ui.AbstractPropertyPage;
import org.isqlviewer.ui.WizardContainer;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringTokenizer;

public final class BatchWizard
extends WizardContainer {
    private static final String STEP_SELECTION = "SELECT";
    private static final String STEP_CONFIGURE = "CONFIG";
    private static final String STEP_PREVIEWER = "PREVIEW";
    private static final String STEP_PROGRESS = "PROGRESS";
    private final ThreadGroup batch_procs = new ThreadGroup("SQL_BATCH_THREADS");
    private SystemConfig config = SystemConfig.getInstance();
    private ServiceProvider serviceProvider = this.config.getServiceProvider();
    private GridBagLayout gbl = new GridBagLayout();
    private PreferencesBatch prefs;
    private Selection selection;
    private Preview preview;
    private Progress progress;
    private BatchModel batchTableModel = new BatchModel();
    private ArrayList batchRunners = new ArrayList();
    private ArrayList services = new ArrayList();
    static /* synthetic */ Class class$org$isqlviewer$event$ProgressEvent;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$lang$String;

    public static final int showDialog(JFrame Owner) {
        BatchWizard dlg = new BatchWizard(Owner);
        dlg.show();
        return 0;
    }

    protected BatchWizard(JFrame parent) {
        super(parent);
        this.setTitle(BasicUtilities.getString("Batch_Runner_Title", ""));
        this.setComment("");
        try {
            this.initUI();
        }
        catch (Throwable t) {
            BasicUtilities.HandleException(t, "BatchWizard::InitUI()");
        }
        this.pack();
        this.setSize(new Dimension(524, 480));
        this.setLocationRelativeTo(parent);
    }

    protected void initUI() {
        this.selection = new Selection();
        this.addUserComponent(STEP_SELECTION, this.selection);
        this.prefs = new PreferencesBatch();
        this.addUserComponent(STEP_CONFIGURE, this.prefs);
        this.preview = new Preview();
        this.addUserComponent(STEP_PREVIEWER, this.preview);
        this.progress = new Progress();
        this.addUserComponent(STEP_PROGRESS, this.progress);
        this.setBanner(BasicUtilities.getString("Batch_Home_Label"));
        this.setComment(BasicUtilities.getString("Batch_Home_Comment"));
        this.setIcon(BasicUtilities.loadIconResource("Script24"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initBatch() {
        ArrayList arrayList = this.batchRunners;
        synchronized (arrayList) {
            this.batchRunners.clear();
        }
        this.setNextStepEnabled(false);
        for (int i = 0; i < this.batchTableModel.getRowCount(); ++i) {
            try {
                File f = (File)this.batchTableModel.getValueAt(i, 0);
                BatchRunner br = new BatchRunner(f, null);
                ArrayList arrayList2 = this.batchRunners;
                synchronized (arrayList2) {
                    this.batchRunners.add(br);
                    String service = this.batchTableModel.getValueAt(i, 1).toString();
                    this.services.add(this.serviceProvider.serviceForName(service));
                }
                this.preview.mPreviewModel.setValueAt(new Integer(br.getStatements().size()), i, 1);
                continue;
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t, "initAllBatchThreads(" + i + ")");
                this.preview.mPreviewModel.setValueAt(new Integer(0), i, 1);
            }
        }
        this.setNextStepEnabled(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeBatch() {
        this.setNextStepEnabled(false);
        this.setPreviousStepEnabled(false);
        this.setHomeAllowable(false);
        this.progress.mProgressModel.addTableModelListener(this.progress);
        ArrayList arrayList = this.batchRunners;
        synchronized (arrayList) {
            for (int i = 0; i < this.batchRunners.size(); ++i) {
                BatchRunner br = (BatchRunner)this.batchRunners.get(i);
                if (br == null) continue;
                BatchRunner batchRunner = br;
                synchronized (batchRunner) {
                    try {
                        ServiceDefinition sd = (ServiceDefinition)this.services.get(i);
                        br.setConnection(sd.createConnection());
                        br.setBatchParams((Boolean)this.batchTableModel.getValueAt(i, 2), (Boolean)this.batchTableModel.getValueAt(i, 3));
                        br.setBatchListener(this.progress);
                        Thread t = new Thread(this.batch_procs, br, br.getBatchFile().getAbsolutePath());
                        t.start();
                    }
                    catch (Throwable t) {
                        BasicUtilities.HandleException(t, "BatchWizard::executeBatch(" + i + ")");
                    }
                    continue;
                }
            }
        }
        System.runFinalization();
    }

    protected void haltBatch() {
        this.batch_procs.interrupt();
        Iterator itr = this.services.iterator();
        this.progress.mProgressModel.removeTableModelListener(this.progress);
        while (itr.hasNext()) {
            try {
                ServiceDefinition sd = (ServiceDefinition)itr.next();
                sd.close();
                itr.remove();
            }
            catch (Throwable throwable) {}
        }
        System.runFinalization();
    }

    protected void processStepChange(String s, boolean isFinal, String previous) {
        if (previous != null && previous.equals(STEP_CONFIGURE)) {
            this.prefs.saveProperties();
        }
        if (previous != null && previous.equalsIgnoreCase(STEP_PROGRESS)) {
            this.haltBatch();
        }
        if (s.equals(STEP_CONFIGURE)) {
            this.setBanner(BasicUtilities.getString("Batch_Configure_Label"));
            this.setComment(BasicUtilities.getString("Batch_Configure_Comment"));
            this.setIcon(BasicUtilities.loadIconResource("Script24"));
            this.prefs.loadProperties();
        }
        if (s.equals(STEP_SELECTION)) {
            this.setBanner(BasicUtilities.getString("Batch_Home_Label"));
            this.setComment(BasicUtilities.getString("Batch_Home_Comment"));
            this.setIcon(BasicUtilities.loadIconResource("Script24"));
        }
        if (s.equals(STEP_PREVIEWER)) {
            this.setBanner(BasicUtilities.getString("Batch_Preview_Label"));
            this.setComment(BasicUtilities.getString("Batch_Preview_Comment"));
            this.setIcon(BasicUtilities.loadIconResource("ZoomIn24"));
            this.preview.refreshall();
        }
        if (s.equals(STEP_PROGRESS)) {
            this.setBanner(BasicUtilities.getString("Batch_Progress_Label"));
            this.setComment(BasicUtilities.getString("Batch_Progress_Comment"));
            this.setIcon(BasicUtilities.loadIconResource("Batch24"));
            this.progress.initProgressTable();
            this.executeBatch();
        }
    }

    protected void processWindowEvent(WindowEvent e) {
        boolean done = this.progress.mProgressModel.isFinished();
        if (e.getID() == 201 && !done && this.getCurrentStep().equalsIgnoreCase("Progress")) {
            String title = BasicUtilities.getString("Batch_In_Progress");
            String msg = BasicUtilities.getString("Batch_Wait_Notice");
            JOptionPane.showMessageDialog(this, title, msg, 0);
            return;
        }
        super.processWindowEvent(e);
    }

    protected boolean isStepValid(String stepName) {
        if (stepName.equals(STEP_SELECTION) && this.batchTableModel.getRowCount() == 0) {
            JOptionPane.showMessageDialog(this, BasicUtilities.getString("Batch_Selection_Missing"));
            return false;
        }
        return super.isStepValid(stepName);
    }

    protected BatchModel creatFromFile(File f) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(f));
        BatchModel model = new BatchModel();
        StringTokenizer st = new StringTokenizer("", File.pathSeparator, false, false);
        int Column = 0;
        int Row = 0;
        block4: while (br.ready()) {
            st.setString(br.readLine());
            model.addNewRow();
            Row = model.getRowCount() - 1;
            Column = 0;
            while (st.hasMoreTokens()) {
                try {
                    String Tok = st.nextToken();
                    model.setValueAt(Tok, Row, Column++);
                }
                catch (Exception e) {
                    continue block4;
                }
            }
        }
        try {
            st = null;
            br.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return model;
    }

    static /* synthetic */ ServiceProvider access$200(BatchWizard x0) {
        return x0.serviceProvider;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ProgressModel
    extends EnhancedTableModel {
        private final String[] COLUMN_HEADERS = new String[]{BasicUtilities.getString("Batch_File"), BasicUtilities.getString("Batch_Progress")};

        public ProgressModel() {
            this.setColumns(this.COLUMN_HEADERS);
        }

        public boolean isFinished() {
            try {
                for (int i = 0; i < this.getRowCount(); ++i) {
                    ProgressEvent e = (ProgressEvent)this.getValueAt(i, 1);
                    if (e.getMaximum() == e.getProgress()) continue;
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }

        public Class getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return class$java$io$File == null ? (class$java$io$File = BatchWizard.class$("java.io.File")) : class$java$io$File;
                }
                case 1: {
                    return class$org$isqlviewer$event$ProgressEvent == null ? (class$org$isqlviewer$event$ProgressEvent = BatchWizard.class$("org.isqlviewer.event.ProgressEvent")) : class$org$isqlviewer$event$ProgressEvent;
                }
            }
            return class$java$lang$String == null ? (class$java$lang$String = BatchWizard.class$("java.lang.String")) : class$java$lang$String;
        }
    }

    private class BatchModel
    extends EnhancedTableModel {
        private final String[] ColumnHeaders = new String[]{BasicUtilities.getString("Batch_File"), BasicUtilities.getString("Batch_Service"), BasicUtilities.getString("Batch_Transaction"), BasicUtilities.getString("Batch_Support")};
        private StringBuffer sb = new StringBuffer("");

        public BatchModel() {
            this.setColumns(this.ColumnHeaders);
        }

        public String toRowString(int Row) {
            int j = 0;
            this.sb.setLength(0);
            Object obj = this.getValueAt(Row, j++);
            this.sb.append(obj == null ? "" : obj.toString());
            this.sb.append(File.pathSeparatorChar);
            obj = this.getValueAt(Row, j++);
            this.sb.append(obj == null ? "" : obj.toString());
            this.sb.append(File.pathSeparatorChar);
            obj = this.getValueAt(Row, j++);
            this.sb.append(obj == null ? "false" : obj.toString());
            this.sb.append(File.pathSeparatorChar);
            obj = this.getValueAt(Row, j++);
            this.sb.append(obj == null ? "false" : obj.toString());
            this.sb.append(File.pathSeparatorChar);
            return this.sb.toString();
        }

        public void addNewRow() {
            ArrayList<Object> row = new ArrayList<Object>();
            row.add(new File(""));
            row.add("");
            row.add(Boolean.FALSE);
            row.add(Boolean.FALSE);
            this.addRow(row);
            this.fireTableRowsInserted(this.getRowCount() - 1, this.getRowCount());
        }
    }

    private class Preview
    extends JPanel
    implements ActionListener {
        private final String[] COLUMN_HEADERS = new String[]{BasicUtilities.getString("Batch_File"), BasicUtilities.getString("Batch_Count")};
        private EnhancedTableModel mPreviewModel = new EnhancedTableModel(this.COLUMN_HEADERS);
        private ITable mPreviewList = new ITable(this.mPreviewModel);
        private JButton mRefreshAll = new JButton(BasicUtilities.loadIconResource("Refresh24"));
        private JButton mRefreshOne = new JButton(BasicUtilities.loadIconResource("Redo24"));

        public Preview() {
            try {
                this.initUI();
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t, "BatchWizard::Preview()");
            }
        }

        public void actionPerformed(ActionEvent parm1) {
            Object src = parm1.getSource();
            if (src.equals(this.mRefreshAll)) {
                this.refreshall();
                return;
            }
            if (src.equals(this.mRefreshOne)) {
                this.refreshselected();
                return;
            }
        }

        private void initUI() throws Exception {
            this.setLayout(new GridBagLayout());
            ActionToolBar tb = ActionToolBar.createNullInstance();
            tb.setOrientation(0);
            tb.setFloatable(false);
            ((Container)tb).add(this.mRefreshAll);
            ((Container)tb).add(this.mRefreshOne);
            ((Container)tb).add(Box.createHorizontalGlue());
            this.mPreviewList.setSelectionMode(2);
            this.mPreviewList.setRowSelectionAllowed(true);
            this.mPreviewList.allowColumnReordering(false);
            this.mRefreshOne.addActionListener(this);
            this.mRefreshAll.addActionListener(this);
            this.mRefreshOne.setToolTipText(BasicUtilities.getString("Batch_Refresh_Selected_Tip"));
            this.mRefreshAll.setToolTipText(BasicUtilities.getString("Batch_Refresh_All_Tip"));
            WizardContainer.constrain(0, 0, 1, 2, 0.0, 0.0, 10, 0);
            this.add(Box.createHorizontalStrut(12), WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(1, 0, 1, 1, 0.0, 0.0, 10, 0);
            this.add(Box.createVerticalStrut(6), WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(1, 1, 1, 1, 1.0, 0.0, 10, 2);
            this.add((Component)tb, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(1, 2, 1, 1, 1.0, 1.0, 10, 1);
            this.add((Component)new JScrollPane(this.mPreviewList), WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(2, 0, 1, 2, 0.0, 0.0, 10, 0);
            this.add(Box.createHorizontalStrut(12), WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(1, 3, 1, 1, 0.0, 0.0, 10, 0);
            this.add(Box.createVerticalStrut(6), WizardContainer.UI_CONSTRAINT);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refreshselected() {
            int[] rows = this.mPreviewList.getSelectedRows();
            for (int i = 0; i < rows.length; ++i) {
                try {
                    BatchRunner br;
                    int row = rows[i];
                    ArrayList arrayList = BatchWizard.this.batchRunners;
                    synchronized (arrayList) {
                        br = (BatchRunner)BatchWizard.this.batchRunners.get(row);
                        this.mPreviewModel.setValueAt(BasicUtilities.getString("Batch_Refreshing_Data"), row, 1);
                    }
                    this.mPreviewModel.setValueAt(new Integer(br.getStatements().size()), i, 1);
                    continue;
                }
                catch (Throwable t) {
                    this.mPreviewModel.setValueAt(new Integer(-1), i, 1);
                    BasicUtilities.HandleException(t, "BatchWizard::refreshSelected()");
                }
            }
            BasicUtilities.optimizeTableView(this.mPreviewList);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refreshall() {
            Preview preview = this;
            synchronized (preview) {
                this.mPreviewModel.clear();
                for (int i = 0; i < BatchWizard.this.batchTableModel.getRowCount(); ++i) {
                    ArrayList<Object> row = new ArrayList<Object>();
                    row.add(BatchWizard.this.batchTableModel.getValueAt(i, 0));
                    row.add(BasicUtilities.getString("Batch_Parsing_File"));
                    this.mPreviewModel.addRow(row);
                }
                BatchWizard.this.initBatch();
            }
            this.mPreviewModel.fireTableStructureChanged();
            BasicUtilities.optimizeTableView(this.mPreviewList);
        }
    }

    private class Progress
    extends JPanel
    implements ActionListener,
    ProgressListener,
    TableModelListener {
        ProgressModel mProgressModel;
        JButton btn;
        JToolBar mProgressToolBox;
        ITable mProgressTable;

        public Progress() {
            this.mProgressModel = new ProgressModel();
            this.btn = new JButton(BasicUtilities.loadToolbarIconResource("Stop"));
            this.mProgressToolBox = new JToolBar(0);
            this.mProgressTable = new ITable(this.mProgressModel);
            try {
                this.initUI();
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t, "BatchWizard::Progress()");
            }
        }

        public void progressUpdated(ProgressEvent evt) {
            Object src = evt.getSource();
            BatchRunner br = (BatchRunner)src;
            int idx = BatchWizard.this.batchRunners.indexOf(br);
            this.mProgressModel.setValueAt(evt, idx, 1);
        }

        public void actionPerformed(ActionEvent evt) {
            BatchWizard.this.haltBatch();
            this.mProgressModel.clear();
            BatchWizard.this.setNextStepEnabled(true);
            BatchWizard.this.setPreviousStepEnabled(true);
            BatchWizard.this.setHomeAllowable(true);
        }

        protected void initProgressTable() {
            this.mProgressModel.setRowCount(0);
            for (int i = 0; i < BatchWizard.this.batchTableModel.getRowCount(); ++i) {
                ArrayList<Object> row = new ArrayList<Object>();
                row.add(BatchWizard.this.batchTableModel.getValueAt(i, 0));
                row.add(null);
                this.mProgressModel.addRow(row);
            }
            this.mProgressModel.fireTableStructureChanged();
        }

        protected void initUI() throws Exception {
            this.setLayout(new BorderLayout());
            this.mProgressTable.setDefaultRenderer(class$org$isqlviewer$event$ProgressEvent == null ? (class$org$isqlviewer$event$ProgressEvent = BatchWizard.class$("org.isqlviewer.event.ProgressEvent")) : class$org$isqlviewer$event$ProgressEvent, new ProgressListCellRenderer());
            this.btn.setToolTipText(BasicUtilities.getString("Batch_Halt_All_Batch_Jobs"));
            this.btn.addActionListener(this);
            this.mProgressToolBox.add(this.btn);
            this.mProgressToolBox.add(Box.createHorizontalGlue());
            this.mProgressToolBox.setFloatable(false);
            this.add((Component)this.mProgressToolBox, "North");
            this.add((Component)new JScrollPane(this.mProgressTable), "Center");
        }

        public void tableChanged(TableModelEvent e) {
            BatchWizard.this.setNextStepEnabled(this.mProgressModel.isFinished());
        }
    }

    private class Selection
    extends JPanel
    implements ListSelectionListener,
    ActionListener {
        private static final int MASK_SERVICE = 1;
        private static final int MASK_BATCH = 2;
        private static final int MASK_TRANS = 4;
        private File mCurrentScript = null;
        private ITable tabScript = new ITable();
        private JLabel lblFileNme = new JLabel(BasicUtilities.getString("Batch_Select_Batch_File"));
        private JLabel lblService = new JLabel(BasicUtilities.getString("Batch_Select_Service"));
        private JButton btnBrws = new JButton(BasicUtilities.getString("Elipsis"));
        private JButton btnOpen = new JButton(BasicUtilities.loadToolbarIconResource("Open"));
        private JButton btnSave = new JButton(BasicUtilities.loadToolbarIconResource("Save"));
        private JButton btnSvAs = new JButton(BasicUtilities.loadToolbarIconResource("SaveAs"));
        private JButton btnAdd = new JButton(BasicUtilities.loadToolbarIconResource("Add"));
        private JButton btnDel = new JButton(BasicUtilities.loadToolbarIconResource("Delete"));
        private JButton btnNew = new JButton(BasicUtilities.loadToolbarIconResource("New"));
        private JTextField txtBatchFile = new JTextField(16);
        private JCheckBox chkUseTrans = new JCheckBox();
        private JCheckBox chkOverride = new JCheckBox();
        private JComboBox cmbServices = new JComboBox<Object>(BatchWizard.access$200(BatchWizard.this).getRegisteredServices().toArray());

        public Selection() {
            try {
                this.initUI();
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t, "BatchWizard.Selection::()");
                return;
            }
        }

        public void valueChanged(ListSelectionEvent evt) {
            boolean singleSelection = this.tabScript.getSelectedRows().length == 1;
            this.txtBatchFile.setEnabled(singleSelection);
            this.btnBrws.setEnabled(singleSelection);
            if (singleSelection) {
                int row = this.tabScript.getSelectedRow();
                this.txtBatchFile.setText(BatchWizard.this.batchTableModel.getValueAt(row, 0).toString());
                this.cmbServices.setSelectedItem(BatchWizard.this.batchTableModel.getValueAt(row, 1));
                this.chkOverride.setSelected((Boolean)BatchWizard.this.batchTableModel.getValueAt(row, 3));
                this.chkUseTrans.setSelected((Boolean)BatchWizard.this.batchTableModel.getValueAt(row, 2));
            } else if (this.tabScript.getRowCount() >= 1) {
                int row = -1;
                try {
                    row = this.tabScript.getSelectedRows()[0];
                }
                catch (Throwable t) {
                    row = 0;
                }
                this.txtBatchFile.setText("");
                this.cmbServices.setSelectedItem(BatchWizard.this.batchTableModel.getValueAt(row, 1));
                this.chkOverride.setSelected((Boolean)BatchWizard.this.batchTableModel.getValueAt(row, 2));
                this.chkUseTrans.setSelected((Boolean)BatchWizard.this.batchTableModel.getValueAt(row, 3));
            }
        }

        public void actionPerformed(ActionEvent evt) {
            boolean hasSelection;
            Object src = evt.getSource();
            boolean bl = hasSelection = this.tabScript.getSelectedRows().length >= 1;
            if (src == this.btnAdd || src == this.btnBrws) {
                this.browseForFile(src == this.btnAdd);
                return;
            }
            if (src == this.chkOverride && hasSelection) {
                this.updateServiceAssignments(2);
                return;
            }
            if (src == this.chkUseTrans && hasSelection) {
                this.updateServiceAssignments(4);
                return;
            }
            if (src == this.cmbServices && hasSelection) {
                this.updateServiceAssignments(1);
                return;
            }
            if (src == this.btnDel) {
                this.removeFileFromScript();
                return;
            }
            if (src == this.btnNew) {
                this.createNewScript();
                return;
            }
            if (src == this.btnOpen) {
                try {
                    this.openScript(null);
                }
                catch (IOException e) {
                    // empty catch block
                }
                return;
            }
            if (src == this.btnSave || src == this.btnSvAs) {
                try {
                    this.saveScript(null, src == this.btnSvAs);
                }
                catch (IOException e) {
                    // empty catch block
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void openScript(File f) throws IOException {
            Selection selection = this;
            synchronized (selection) {
                BatchWizard.this.batchTableModel = BatchWizard.this.creatFromFile(f);
                BatchWizard.this.setTitle(BasicUtilities.getString("Batch_Title", f.getName()));
                this.tabScript.setModel(BatchWizard.this.batchTableModel);
                BasicUtilities.optimizeTableView(this.tabScript);
            }
            System.runFinalization();
        }

        private void browseForFile(boolean add) {
            File f = null;
            int currentRow = this.tabScript.getSelectedRow();
            if (currentRow != -1) {
                f = (File)BatchWizard.this.batchTableModel.getValueAt(currentRow, 0);
            }
            if ((f = f != null ? BasicUtilities.getSystemFile(this, 0) : BasicUtilities.getSystemFile(this, 0)) != null) {
                if (add || currentRow < 0) {
                    BatchWizard.this.batchTableModel.addNewRow();
                    currentRow = this.tabScript.getSelectedRow();
                    currentRow = currentRow < 0 && !add ? 0 : BatchWizard.this.batchTableModel.getRowCount() - 1;
                    BatchWizard.this.batchTableModel.setValueAt(f, add ? BatchWizard.this.batchTableModel.getRowCount() - 1 : currentRow, 0);
                    BatchWizard.this.batchTableModel.fireTableStructureChanged();
                    this.tabScript.getSelectionModel().setSelectionInterval(currentRow, currentRow);
                    BasicUtilities.optimizeTableView(this.tabScript);
                } else {
                    BatchWizard.this.batchTableModel.setValueAt(f, currentRow, 0);
                    this.tabScript.getSelectionModel().setSelectionInterval(currentRow, currentRow);
                    BasicUtilities.optimizeTableView(this.tabScript);
                }
                this.txtBatchFile.setText(f.getAbsolutePath());
            }
        }

        private void removeFileFromScript() {
            int[] rows = this.tabScript.getSelectedRows();
            for (int i = rows.length - 1; i >= 0; --i) {
                BatchWizard.this.batchTableModel.removeRow(rows[i]);
            }
            if (BatchWizard.this.batchTableModel.getRowCount() >= 1) {
                try {
                    this.tabScript.setRowSelectionInterval(0, 0);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            BatchWizard.this.batchTableModel.fireTableStructureChanged();
            BasicUtilities.optimizeTableView(this.tabScript);
        }

        private void createNewScript() {
            BatchWizard.this.batchTableModel.setRowCount(0);
            BatchWizard.this.batchTableModel.fireTableStructureChanged();
            BasicUtilities.optimizeTableView(this.tabScript);
            this.mCurrentScript = null;
            this.browseForFile(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void saveScript(File f, boolean saveAs) throws IOException {
            if (saveAs || f == null) {
                f = BasicUtilities.saveSystemFile(this);
                if (f == null) {
                    return;
                }
                String s = f.toString();
                if (!s.endsWith(".script")) {
                    s = s.concat(".script");
                    f = this.mCurrentScript = new File(s);
                }
            }
            Selection selection = this;
            synchronized (selection) {
                if (!f.exists()) {
                    f.createNewFile();
                }
                BatchWizard.this.setTitle(BasicUtilities.getString("Batch_Title", f.getName()));
                BufferedWriter bw = new BufferedWriter(new FileWriter(f));
                for (int i = 0; i < this.tabScript.getRowCount(); ++i) {
                    bw.write(BatchWizard.this.batchTableModel.toRowString(i));
                    if (i == this.tabScript.getRowCount() - 1) continue;
                    bw.newLine();
                }
                try {
                    bw.flush();
                    bw.close();
                    bw = null;
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
        }

        private void initUI() throws Exception {
            this.setLayout(BatchWizard.this.gbl);
            this.txtBatchFile.setToolTipText(BasicUtilities.getString("Batch_Batch_Name_Tip"));
            this.chkUseTrans.setToolTipText(BasicUtilities.getString("Batch_Use_Transaction_Tip"));
            this.chkUseTrans.setText(BasicUtilities.getString("Batch_Use_Transaction_Text"));
            this.chkOverride.setToolTipText(BasicUtilities.getString("Batch_Override_Support_Tip"));
            this.chkOverride.setText(BasicUtilities.getString("Batch_Override_Support_Text"));
            this.cmbServices.setToolTipText(BasicUtilities.getString("Batch_Service_Select_Tip"));
            this.btnBrws.setToolTipText(BasicUtilities.getString("Browse_File_System"));
            this.btnSave.setToolTipText(BasicUtilities.getString("Batch_Save_Script_Tip"));
            this.btnOpen.setToolTipText(BasicUtilities.getString("Batch_Open_Script_Tip"));
            this.btnSvAs.setToolTipText(BasicUtilities.getString("Batch_Save_Script_As_Tip"));
            this.btnAdd.setToolTipText(BasicUtilities.getString("Batch_Add_Batch_Tip"));
            this.btnDel.setToolTipText(BasicUtilities.getString("Batch_Remove_Batch_Tip"));
            this.btnNew.setToolTipText(BasicUtilities.getString("Batch_New_Script_Tip"));
            this.btnSave.addActionListener(this);
            this.btnOpen.addActionListener(this);
            this.btnSvAs.addActionListener(this);
            this.btnBrws.addActionListener(this);
            this.btnAdd.addActionListener(this);
            this.btnDel.addActionListener(this);
            this.btnNew.addActionListener(this);
            this.txtBatchFile.addActionListener(this);
            this.cmbServices.addActionListener(this);
            this.chkUseTrans.addActionListener(this);
            this.chkOverride.addActionListener(this);
            ActionToolBar toolbar = ActionToolBar.createNullInstance();
            toolbar.setOrientation(0);
            toolbar.setFloatable(false);
            ((Container)toolbar).add(this.btnNew);
            ((Container)toolbar).add(this.btnOpen);
            ((Container)toolbar).add(this.btnSave);
            ((Container)toolbar).add(this.btnSvAs);
            toolbar.addSeparator();
            ((Container)toolbar).add(this.btnAdd);
            ((Container)toolbar).add(this.btnDel);
            JPanel pnlOptions = new JPanel(new GridLayout(2, 1, 0, 2));
            pnlOptions.setBorder(new TitledBorder(BasicUtilities.getString("Batch_Options_Title")));
            pnlOptions.add(this.chkUseTrans);
            pnlOptions.add(this.chkOverride);
            JScrollPane jspScript = new JScrollPane(this.tabScript);
            this.tabScript.setModel(BatchWizard.this.batchTableModel);
            this.tabScript.allowColumnReordering(false);
            this.tabScript.setRowSelectionAllowed(true);
            this.tabScript.getSelectionModel().addListSelectionListener(this);
            BasicUtilities.optimizeTableView(this.tabScript);
            WizardContainer.constrain(0, 0, 1, 5, 0.0, 0.0, 10, 0);
            this.add(Box.createHorizontalStrut(6), WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(1, 0, 1, 1, 0.0, 0.0, 13, 0);
            this.add((Component)this.lblFileNme, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(2, 0, 2, 1, 0.1, 0.0, 10, 2);
            this.add((Component)this.txtBatchFile, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(4, 0, 1, 1, 0.0, 0.0, 10, 0);
            this.add((Component)this.btnBrws, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(1, 1, 1, 1, 0.0, 0.0, 13, 0);
            this.add((Component)this.lblService, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(2, 1, 2, 1, 0.0, 0.0, 10, 2);
            this.add((Component)this.cmbServices, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(3, 2, 2, 2, 1.0, 0.0, 13, 0);
            this.add((Component)pnlOptions, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(1, 3, 2, 1, 1.0, 0.0, 16, 2);
            this.add((Component)toolbar, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(1, 4, 4, 1, 1.0, 1.0, 10, 1);
            this.add((Component)jspScript, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(5, 0, 1, 5, 0.0, 0.0, 10, 0);
            this.add(Box.createHorizontalStrut(6), WizardContainer.UI_CONSTRAINT);
        }

        private void updateServiceAssignments(int mask) {
            int i;
            int[] rows = this.tabScript.getSelectedRows();
            if ((mask & 1) == 1) {
                for (i = 0; i < rows.length; ++i) {
                    BatchWizard.this.batchTableModel.setValueAt(this.cmbServices.getSelectedItem(), rows[i], 1);
                }
            }
            if ((mask & 4) == 4) {
                for (i = 0; i < rows.length; ++i) {
                    BatchWizard.this.batchTableModel.setValueAt(new Boolean(this.chkUseTrans.isSelected()), rows[i], 2);
                }
            }
            if ((mask & 2) == 2) {
                for (i = 0; i < rows.length; ++i) {
                    BatchWizard.this.batchTableModel.setValueAt(new Boolean(this.chkOverride.isSelected()), rows[i], 3);
                }
            }
        }
    }

    static class PreferencesBatch
    extends AbstractPropertyPage
    implements ActionListener {
        private ButtonGroup[] groups = new ButtonGroup[]{new ButtonGroup(), new ButtonGroup(), new ButtonGroup()};
        private JPanel mCommentOptions = new JPanel();
        private JPanel mQuoteOptions = new JPanel();
        private JPanel pnlGenOpts = new JPanel();
        private JTextField txtSeperator = new JTextField(6);
        private JTextField txtComment = new JTextField(6);
        private JTextField txtLiteral = new JTextField(6);
        private JRadioButton rdoLitNone = new JRadioButton();
        private JRadioButton rdoLitSingle = new JRadioButton();
        private JRadioButton rdoLitDouble = new JRadioButton();
        private JRadioButton rdoLitCustom = new JRadioButton();
        private JRadioButton rdoSepEOL = new JRadioButton();
        private JRadioButton rdoSepCustom = new JRadioButton();
        private JCheckBox chkForceLow = new JCheckBox();
        private JRadioButton rdoCommentC = new JRadioButton();
        private JRadioButton rdoCommentCpp = new JRadioButton();
        private JRadioButton rdoCommentSingle = new JRadioButton();
        private JRadioButton rdoCommentNone = new JRadioButton();

        protected PreferencesBatch() {
            try {
                this.initUI();
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t, "PreferencesBatch::initUI()");
            }
        }

        public void actionPerformed(ActionEvent evt) {
            this.txtComment.setEnabled(this.rdoCommentSingle.isSelected());
            this.txtSeperator.setEnabled(this.rdoSepCustom.isSelected());
            this.txtLiteral.setEnabled(this.rdoLitCustom.isSelected());
        }

        protected void initUI() {
            this.setLayout(new GridBagLayout());
            this.rdoLitDouble.addActionListener(this);
            this.rdoLitCustom.addActionListener(this);
            this.rdoSepEOL.addActionListener(this);
            this.rdoCommentNone.addActionListener(this);
            this.rdoLitNone.addActionListener(this);
            this.rdoCommentSingle.addActionListener(this);
            this.rdoLitSingle.addActionListener(this);
            this.rdoCommentC.addActionListener(this);
            this.rdoCommentCpp.addActionListener(this);
            this.rdoSepCustom.addActionListener(this);
            this.chkForceLow.addActionListener(this);
            this.groups[0].add(this.rdoCommentC);
            this.groups[0].add(this.rdoCommentNone);
            this.groups[0].add(this.rdoCommentCpp);
            this.groups[0].add(this.rdoCommentSingle);
            this.groups[1].add(this.rdoLitNone);
            this.groups[1].add(this.rdoLitDouble);
            this.groups[1].add(this.rdoLitSingle);
            this.groups[1].add(this.rdoLitCustom);
            this.groups[2].add(this.rdoSepEOL);
            this.groups[2].add(this.rdoSepCustom);
            this.addButtonGroupProperty(this.groups[0], "batch.comment-style");
            this.addButtonGroupProperty(this.groups[1], "batch.literal-style");
            this.addButtonGroupProperty(this.groups[2], "batch.seperator-style");
            this.rdoSepCustom.setActionCommand(Integer.toString(0));
            this.rdoSepEOL.setActionCommand(Integer.toString(1));
            this.rdoCommentC.setActionCommand(Integer.toString(2));
            this.rdoCommentCpp.setActionCommand(Integer.toString(3));
            this.rdoCommentNone.setActionCommand(Integer.toString(1));
            this.rdoCommentSingle.setActionCommand(Integer.toString(0));
            this.rdoLitDouble.setActionCommand(Integer.toString(0));
            this.rdoLitSingle.setActionCommand(Integer.toString(2));
            this.rdoLitNone.setActionCommand(Integer.toString(1));
            this.rdoLitCustom.setActionCommand(Integer.toString(3));
            this.setPropertyForComponent(this.chkForceLow, "batch.lowercase-enable");
            this.setPropertyForComponent(this.txtComment, "batch.comment-char");
            this.setPropertyForComponent(this.txtSeperator, "batch.seperator-char");
            this.setPropertyForComponent(this.txtLiteral, "batch.literal-char");
            this.mCommentOptions.setLayout(new GridLayout(5, 1, 2, 2));
            this.mCommentOptions.setBorder(new TitledBorder(BasicUtilities.getString("Batch_Select_Comment_Style")));
            this.mCommentOptions.add(this.rdoCommentNone);
            this.mCommentOptions.add(this.rdoCommentC);
            this.mCommentOptions.add(this.rdoCommentCpp);
            this.mCommentOptions.add(this.rdoCommentSingle);
            this.mCommentOptions.add(this.txtComment);
            this.mQuoteOptions.setLayout(new GridLayout(5, 1, 2, 2));
            this.mQuoteOptions.setBorder(new TitledBorder(BasicUtilities.getString("Batch_Select_Quote_Style")));
            this.mQuoteOptions.add(this.rdoLitNone);
            this.mQuoteOptions.add(this.rdoLitSingle);
            this.mQuoteOptions.add(this.rdoLitDouble);
            this.mQuoteOptions.add(this.rdoLitCustom);
            this.mQuoteOptions.add(this.txtLiteral);
            this.pnlGenOpts.setLayout(new GridBagLayout());
            this.pnlGenOpts.setBorder(new TitledBorder(BasicUtilities.getString("Batch_General_Properties")));
            PreferencesBatch.constrain(0, 0, 1, 3, 0.0, 0.0, 17, 0);
            this.pnlGenOpts.add(Box.createHorizontalStrut(16), UI_CONSTRAINT);
            PreferencesBatch.constrain(0, 0, 2, 1, 0.0, 0.0, 17, 0);
            this.pnlGenOpts.add((Component)this.chkForceLow, UI_CONSTRAINT);
            PreferencesBatch.constrain(0, 1, 2, 1, 0.0, 0.0, 17, 0);
            this.pnlGenOpts.add((Component)this.rdoSepEOL, UI_CONSTRAINT);
            PreferencesBatch.constrain(0, 2, 2, 1, 0.0, 1.0, 17, 0);
            this.pnlGenOpts.add((Component)this.rdoSepCustom, UI_CONSTRAINT);
            PreferencesBatch.constrain(1, 3, 1, 1, 1.0, 0.0, 17, 2);
            this.pnlGenOpts.add((Component)this.txtSeperator, UI_CONSTRAINT);
            PreferencesBatch.constrain(3, 0, 1, 3, 0.0, 0.0, 17, 0);
            this.pnlGenOpts.add(Box.createHorizontalStrut(16), UI_CONSTRAINT);
            PreferencesBatch.constrain(0, 0, 1, 4, 0.0, 0.0, 17, 0);
            this.add(Box.createHorizontalStrut(12), UI_CONSTRAINT);
            PreferencesBatch.constrain(1, 0, 2, 1, 0.0, 0.0, 17, 0);
            this.add(Box.createHorizontalStrut(6), UI_CONSTRAINT);
            PreferencesBatch.constrain(1, 1, 2, 1, 1.0, 0.0, 10, 2);
            this.add((Component)this.pnlGenOpts, UI_CONSTRAINT);
            PreferencesBatch.constrain(1, 2, 1, 1, 1.0, 0.0, 10, 2);
            this.add((Component)this.mCommentOptions, UI_CONSTRAINT);
            PreferencesBatch.constrain(2, 2, 1, 1, 1.0, 0.0, 10, 2);
            this.add((Component)this.mQuoteOptions, UI_CONSTRAINT);
            PreferencesBatch.constrain(3, 0, 1, 4, 0.0, 0.0, 17, 0);
            this.add(Box.createHorizontalStrut(12), UI_CONSTRAINT);
            PreferencesBatch.constrain(1, 3, 2, 1, 0.0, 1.0, 17, 3);
            this.add(Box.createVerticalGlue(), UI_CONSTRAINT);
            this.txtSeperator.setToolTipText(BasicUtilities.getString("Batch_Custom_Char_Tip"));
            this.txtComment.setToolTipText(this.txtSeperator.getToolTipText());
            this.txtLiteral.setToolTipText(this.txtSeperator.getToolTipText());
            this.rdoLitDouble.setText(BasicUtilities.getString("Batch_Double_Quote_Text"));
            this.rdoLitDouble.setToolTipText(BasicUtilities.getString("Batch_Double_Quote_Tip"));
            this.rdoLitSingle.setText(BasicUtilities.getString("Batch_Single_Quote_Text"));
            this.rdoLitSingle.setToolTipText(BasicUtilities.getString("Batch_Single_Quote_Tip"));
            this.rdoLitCustom.setText(BasicUtilities.getString("Batch_Custom_Quote_Text"));
            this.rdoLitCustom.setToolTipText(BasicUtilities.getString("Batch_Custom_Quote_Tip"));
            this.rdoSepEOL.setText(BasicUtilities.getString("Batch_EOL_Statement_Text"));
            this.rdoSepEOL.setToolTipText(BasicUtilities.getString("Batch_EOL_Statement_Tip"));
            this.rdoSepCustom.setText(BasicUtilities.getString("Batch_Custom_Delim_Text"));
            this.rdoSepCustom.setToolTipText(BasicUtilities.getString("Batch_Custom_Delim_Tip"));
            this.rdoCommentCpp.setText(BasicUtilities.getString("Batch_Slash_Star_Text"));
            this.rdoCommentCpp.setToolTipText(BasicUtilities.getString("Batch_Slash_Star_Tip"));
            this.rdoCommentC.setText(BasicUtilities.getString("Batch_Slash_Slash_Text"));
            this.rdoCommentC.setToolTipText(BasicUtilities.getString("Batch_Slash_Slash_Tip"));
            this.rdoCommentNone.setText(BasicUtilities.getString("Batch_No_Comment_Text"));
            this.rdoCommentNone.setToolTipText(BasicUtilities.getString("Batch_No_Comment_Tip"));
            this.rdoLitNone.setText(BasicUtilities.getString("Batch_No_Quote_Text"));
            this.rdoLitNone.setToolTipText(BasicUtilities.getString("Batch_No_Quote_Tip"));
            this.rdoCommentSingle.setText(BasicUtilities.getString("Batch_Single_Line_Comment_Text"));
            this.rdoCommentSingle.setToolTipText(BasicUtilities.getString("Batch_Single_Line_Comment_Tip"));
            this.chkForceLow.setText(BasicUtilities.getString("Batch_Force_Lower_Text"));
            this.chkForceLow.setToolTipText(BasicUtilities.getString("Batch_Force_Lower_Tip"));
        }

        public String getPropertyPageName() {
            return BasicUtilities.getString("Batch_Property_Page");
        }

        public Icon getUserIcon() {
            return BasicUtilities.loadIconResource("Batch16");
        }

        public void loadProperties() {
            super.loadProperties();
            this.actionPerformed(null);
        }
    }
}

