/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.PrintStream;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import org.isqlviewer.core.SQLBookmark;
import org.isqlviewer.core.ServiceDefinition;
import org.isqlviewer.core.ServiceProvider;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.core.jetfire.ImportConfig;
import org.isqlviewer.core.jetfire.ImportRunner;
import org.isqlviewer.core.model.BookmarkTreeModel;
import org.isqlviewer.core.model.EnhancedTableModel;
import org.isqlviewer.core.model.ResultSetTableModel;
import org.isqlviewer.event.ProgressEvent;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.sql.ResultSetViewer;
import org.isqlviewer.swing.ActionPanel;
import org.isqlviewer.swing.BookmarkTreeCellRenderer;
import org.isqlviewer.swing.ImportEditor;
import org.isqlviewer.swing.ProgressPanel;
import org.isqlviewer.ui.AppController;
import org.isqlviewer.ui.SQLEditor;
import org.isqlviewer.ui.WizardContainer;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringUtilities;

public class DataMigrator
extends WizardContainer {
    private static final String STEP_SERVICE_PICK = "services";
    private static final String STEP_TYPE_PICK = "type-pick";
    private static final String STEP_IMPORT_MAP = "import-map";
    private static final String STEP_PROGRESS = "progress";
    private static final int TYPE_BOOKMARK = 0;
    private static final int TYPE_MANUAL = 1;
    private static final int TYPE_TABLE = 2;
    private static final String KEY_SRC_SERVICE = "source-service";
    private static final String KEY_DST_SERVICE = "dest-service";
    private static final String KEY_SRC_CATALOG = "source-catalog";
    private static final String KEY_SRC_TYPE = "source-type";
    private static final String KEY_SRC_VALUE = "source-value";
    private static final String KEY_DATASOURCE_MODEL = "datasource-model";
    private static final String KEY_IMPORT_CONFIG = "import-config";
    private ServiceSelection serviceSelection = new ServiceSelection();
    private MigTypeSelection typeSelection = new MigTypeSelection();
    private ImportEditor importEditor = null;
    private HashMap migrateConfig = new HashMap();
    private Thread importThread;
    private ProgressPanel progressPanel = new ProgressPanel();

    public DataMigrator(JFrame owner, AppController controller) {
        super(owner);
        this.addUserComponent(STEP_SERVICE_PICK, this.serviceSelection);
        this.addUserComponent(STEP_TYPE_PICK, this.typeSelection);
        this.addUserComponent(STEP_PROGRESS, this.progressPanel);
        this.startWizard();
    }

    protected void processWindowEvent(WindowEvent evt) {
        if (evt.getID() == 200) {
            this.setSize(new Dimension(800, 600));
            this.setLocationRelativeTo(this.getOwner());
        } else if (evt.getID() == 201) {
            // empty if block
        }
        super.processWindowEvent(evt);
    }

    protected boolean isStepValid(String stepName) {
        if (stepName.equals(STEP_SERVICE_PICK)) {
            return this.serviceSelection.isConfigured();
        }
        if (stepName.equals(STEP_TYPE_PICK)) {
            return this.typeSelection.isConfigured();
        }
        return super.isStepValid(stepName);
    }

    protected void processStepChange(String stepName, boolean isFinal, String lastStep) {
        if (!isFinal) {
            if (stepName.equals(STEP_PROGRESS)) {
                int mode;
                this.typeSelection.saveState(this.migrateConfig);
                this.setPreviousStepEnabled(false);
                this.setBanner(BasicUtilities.getString("Jetfire_Progress_Banner"));
                this.setComment(BasicUtilities.getString("Jetfire_Progress_Comment"));
                this.setIcon(BasicUtilities.loadIconResource("JetFire24"));
                int n = mode = lastStep.equals(STEP_TYPE_PICK) ? 1 : 2;
                if (this.importEditor != null) {
                    this.migrateConfig.put(KEY_IMPORT_CONFIG, this.importEditor.getImportConfig());
                }
                ImportWorker worker = new ImportWorker(mode);
                this.importThread = new Thread((Runnable)worker, "jetfire");
                this.importThread.start();
            } else if (stepName.equals(STEP_SERVICE_PICK)) {
                this.setIcon(BasicUtilities.loadIconResource("WebComponent24"));
                this.setBanner(BasicUtilities.getString("Jetfire_Service_Banner"));
                this.setComment(BasicUtilities.getString("Jetfire_Service_Comment"));
            } else if (stepName.equals(STEP_TYPE_PICK)) {
                this.serviceSelection.saveState(this.migrateConfig);
                try {
                    String catalog;
                    ServiceDefinition sd = (ServiceDefinition)this.migrateConfig.get(KEY_DST_SERVICE);
                    DatabaseConnection dbc = sd.createConnection();
                    dbc.initialize();
                    sd = (ServiceDefinition)this.migrateConfig.get(KEY_SRC_SERVICE);
                    dbc = sd.createConnection();
                    dbc.initialize();
                    if (this.migrateConfig.containsKey(KEY_SRC_CATALOG) && (catalog = (String)this.migrateConfig.get(KEY_SRC_CATALOG)) != null && catalog.trim().length() >= 1) {
                        dbc.changeCatalog(catalog);
                    }
                    this.typeSelection.setService(dbc, this);
                }
                catch (Throwable t) {
                    BasicUtilities.showExceptionPopup(this, t, t.getMessage());
                }
                this.setIcon(BasicUtilities.loadIconResource("Import24"));
                this.setBanner(BasicUtilities.getString("QBuild_Where_Select_Banner"));
                this.setComment(BasicUtilities.getString("QBuild_Where_Select_Comment"));
            } else if (stepName.equals(STEP_IMPORT_MAP)) {
                this.setIcon(BasicUtilities.loadIconResource("WebComponent24"));
                this.setBanner(BasicUtilities.getString("Jetfire_Service_Banner"));
                this.setComment(BasicUtilities.getString("Jetfire_Service_Comment"));
                this.removeUserComponent(STEP_PROGRESS);
                this.progressPanel.reset();
                this.addUserComponent(STEP_PROGRESS, this.progressPanel);
            }
        }
    }

    private class ImportWorker
    implements Runnable,
    ResultSetViewer {
        public static final int MODE_DATA_LOAD = 1;
        public static final int MODE_DATA_IMPORT = 2;
        private int opMode = 0;
        private PrintStream err = DataMigrator.access$000(DataMigrator.this).getErrStream();
        private PrintStream out = DataMigrator.access$000(DataMigrator.this).getOutStream();

        public ImportWorker(int mode) {
            if (mode != 1 && mode != 2) {
                throw new IllegalArgumentException();
            }
            this.opMode = mode;
        }

        public void run() {
            DataMigrator.this.setPreviousStepEnabled(false);
            DataMigrator.this.setNextStepEnabled(false);
            switch (this.opMode) {
                case 1: {
                    try {
                        this.runFilter();
                    }
                    catch (Throwable t) {
                        BasicUtilities.HandleException(t, "ImportProcess:runFilter()", true, this.err);
                    }
                    break;
                }
                case 2: {
                    ServiceDefinition destination = (ServiceDefinition)DataMigrator.this.migrateConfig.get(DataMigrator.KEY_DST_SERVICE);
                    try {
                        ImportConfig config = (ImportConfig)DataMigrator.this.migrateConfig.get(DataMigrator.KEY_IMPORT_CONFIG);
                        EnhancedTableModel dataSource = (EnhancedTableModel)DataMigrator.this.migrateConfig.get(DataMigrator.KEY_DATASOURCE_MODEL);
                        DatabaseConnection service = destination.createConnection();
                        ImportRunner runner = new ImportRunner(config, service);
                        runner.setSourceData(dataSource);
                        runner.setStdErr(this.err);
                        runner.setStdOut(this.out);
                        runner.runImport();
                    }
                    catch (Throwable t) {
                        BasicUtilities.HandleException(t, "ImportProcess:runImport()");
                    }
                    this.out.println(BasicUtilities.getString("Import_Finish_Info"));
                    break;
                }
            }
            DataMigrator.this.progressPanel.progressUpdated(new ProgressEvent(this, 1, 1));
            DataMigrator.this.setPreviousStepEnabled(true);
            DataMigrator.this.setNextStepEnabled(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleSQLException(ResultSet set, SQLException e) {
            String msg = BasicUtilities.getString("JetFire_Query_Error", e.getMessage());
            BasicUtilities.HandleException((Throwable)e, msg, false, this.err);
            this.out.println(msg);
            ProgressEvent event = new ProgressEvent(this, 1, 1);
            event.setNote(msg);
            DataMigrator.this.progressPanel.progressUpdated(event);
            ImportWorker importWorker = this;
            synchronized (importWorker) {
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleStatementInterrupted(String stmtID) {
            BasicUtilities.HandleException(new Throwable());
            String msg = BasicUtilities.getString("JetFire_Query_Cancelled", stmtID);
            this.out.println(msg);
            ProgressEvent event = new ProgressEvent(this, 1, 1);
            event.setNote(msg);
            DataMigrator.this.progressPanel.progressUpdated(event);
            ImportWorker importWorker = this;
            synchronized (importWorker) {
                this.notify();
            }
        }

        public void processGeneratedKeys(String stmtID, ResultSet keys, String nativeSQL) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processResultSet(String stmtID, ResultSet set, String nativeSQL, int count) {
            String[] p = new String[]{stmtID, nativeSQL, Integer.toString(count)};
            this.out.println(BasicUtilities.getString("JetFire_Processing_Results", p));
            ResultSetTableModel model = new ResultSetTableModel(set, this, true);
            DataMigrator.this.migrateConfig.put(DataMigrator.KEY_DATASOURCE_MODEL, model);
            p = new String[]{Integer.toString(model.getRowCount()), Integer.toString(model.getColumnCount())};
            this.out.println(BasicUtilities.getString("JetFire_Processing_Finished", p));
            ImportWorker importWorker = this;
            synchronized (importWorker) {
                this.notify();
            }
        }

        public void processRowUpdates(String stmtID, int updateCount, String nativeSQL) {
        }

        public void recieveResultsetWarnings(ResultSet set, SQLWarning warnings) {
            BasicUtilities.HandleException(new Throwable(), "ResultSet Warnings", true, this.err);
        }

        public void recieveStatementWarnings(Statement stmt, SQLWarning warnings) {
            BasicUtilities.HandleException(new Throwable(), "Statement Warnings", true, this.err);
        }

        public void statementInitialized(String stmtID) {
            String msg = BasicUtilities.getString("JetFire_Query_Initialized", stmtID);
            this.out.println(msg);
            ProgressEvent event = new ProgressEvent(this, -1, 1);
            event.setNote(msg);
            DataMigrator.this.progressPanel.progressUpdated(event);
        }

        public boolean supportsGeneratedKeys() {
            return false;
        }

        public boolean supportsUpdateableResultSets() {
            return false;
        }

        protected void executeBookmark(SQLBookmark bmark, DatabaseConnection connection) {
            if (bmark != null) {
                SQLBookmark copy = (SQLBookmark)bmark.clone();
                String sql = this.processSQLParameters(copy.getSQL());
                if (sql == null) {
                    return;
                }
                copy.setSQL(sql);
                if (bmark.hasParameters()) {
                    try {
                        PreparedStatement ps = copy.toPreparedStatement(connection);
                        bmark.updateLastAcessTime();
                        bmark.updateUseCount();
                        connection.executeStatement(ps, copy.getSQL(), this);
                    }
                    catch (Throwable t) {
                        BasicUtilities.HandleException(t);
                    }
                } else {
                    bmark.updateLastAcessTime();
                    bmark.updateUseCount();
                    connection.executeStaticRequest(copy.getSQL(), this);
                }
                Object var3_3 = null;
            } else {
                BasicUtilities.beep();
            }
        }

        protected String processSQLParameters(String sql) {
            String[] p = StringUtilities.getSQLParameters(sql);
            HashMap<String, String> map = new HashMap<String, String>();
            for (int i = 0; i < p.length; ++i) {
                String key = p[i];
                String val = JOptionPane.showInputDialog(DataMigrator.this, (Object)BasicUtilities.getString("SQL_Param_Prompt", key));
                if (val == null) {
                    System.out.println(BasicUtilities.getString("Query_Cancelled"));
                    map.clear();
                    map = null;
                    p = null;
                    return null;
                }
                map.put(key, val);
            }
            String command = StringUtilities.applySQLParameters(map, sql);
            map.clear();
            map = null;
            p = null;
            return command;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void runFilter() throws Exception {
            ServiceDefinition dataSource = (ServiceDefinition)DataMigrator.this.migrateConfig.get(DataMigrator.KEY_SRC_SERVICE);
            DatabaseConnection dbc = dataSource.createConnection();
            String type = (String)DataMigrator.this.migrateConfig.get(DataMigrator.KEY_SRC_TYPE);
            int importSrc = Integer.parseInt(type);
            switch (importSrc) {
                case 0: {
                    SQLBookmark bm = (SQLBookmark)DataMigrator.this.migrateConfig.get(DataMigrator.KEY_SRC_VALUE);
                    this.executeBookmark(bm, dbc);
                    break;
                }
                case 1: {
                    String sql = (String)DataMigrator.this.migrateConfig.get(DataMigrator.KEY_SRC_VALUE);
                    dbc.executeStaticRequest(sql, this);
                    break;
                }
                case 2: {
                    String table = (String)DataMigrator.this.migrateConfig.get(DataMigrator.KEY_SRC_VALUE);
                    String sql = MessageFormat.format("SELECT * FROM {0}", table);
                    dbc.executeStaticRequest(sql, this);
                }
            }
            ImportWorker importWorker = this;
            synchronized (importWorker) {
                this.wait();
            }
            dataSource = null;
            if (DataMigrator.this.migrateConfig.containsKey(DataMigrator.KEY_DATASOURCE_MODEL)) {
                dataSource = (ServiceDefinition)DataMigrator.this.migrateConfig.get(DataMigrator.KEY_DST_SERVICE);
                dbc = dataSource.createConnection();
                DataMigrator.this.importEditor = new ImportEditor(dbc);
                DataMigrator.this.importEditor.setData((EnhancedTableModel)DataMigrator.this.migrateConfig.get(DataMigrator.KEY_DATASOURCE_MODEL));
                DataMigrator.this.addUserComponent(DataMigrator.STEP_IMPORT_MAP, DataMigrator.this.importEditor);
            }
            this.out.println(BasicUtilities.getString("Jetfire_DataLoad_Finished", dbc.getConnectionName()));
        }
    }

    private static class MigTypeSelection
    extends ActionPanel {
        private DefaultComboBoxModel mdlTables = null;
        private DefaultComboBoxModel mdlSchemas = null;
        private JComboBox jcbSchemas = null;
        private JComboBox jcbTables = null;
        private ButtonGroup choice = new ButtonGroup();
        private JRadioButton jrbBookmark = new JRadioButton(BasicUtilities.getString("JetFire_Bookmark_Type"));
        private JRadioButton jrbManual = new JRadioButton(BasicUtilities.getString("JetFire_Manual_Type"));
        private JRadioButton jrbTable = new JRadioButton(BasicUtilities.getString("JetFire_Table_Type"));
        private JTextField txtSchema = new JTextField();
        private JTextField txtTable = new JTextField();
        private JTree jtrBookmarks = new JTree();
        private SQLEditor editor = new SQLEditor();
        private HashMap tableMappings = new HashMap();

        public MigTypeSelection() {
            this.initUI();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setService(DatabaseConnection dbc, Window owner) {
            try {
                this.editor.configureWithConnection(dbc);
                this.editor.createContextHelp(owner);
                this.loadTables(dbc);
            }
            catch (Throwable t) {
                String msg = BasicUtilities.getString("JetFire_Test_Failed", dbc.getConnectionName());
                BasicUtilities.showExceptionPopup(this, t, msg);
            }
            finally {
                this.invalidate();
                this.repaint();
            }
        }

        public void saveState(HashMap config) {
            String type = this.choice.getSelection().getActionCommand();
            config.put(DataMigrator.KEY_SRC_TYPE, type);
            switch (Integer.parseInt(type)) {
                case 0: {
                    config.put(DataMigrator.KEY_SRC_VALUE, this.jtrBookmarks.getLastSelectedPathComponent());
                    break;
                }
                case 1: {
                    config.put(DataMigrator.KEY_SRC_VALUE, this.editor.getText());
                    break;
                }
                case 2: {
                    String table;
                    String schema = this.jcbSchemas == null ? this.txtSchema.getText().trim() : (String)this.jcbSchemas.getSelectedItem();
                    String string = table = this.jcbTables == null ? this.txtTable.getText().trim() : (String)this.jcbTables.getSelectedItem();
                    if (schema == null || schema.length() == 0) {
                        config.put(DataMigrator.KEY_SRC_VALUE, table);
                        break;
                    }
                    table = schema.concat(".").concat(table);
                    config.put(DataMigrator.KEY_SRC_VALUE, table);
                }
            }
        }

        public boolean isConfigured() {
            String type = this.choice.getSelection().getActionCommand();
            boolean configured = false;
            String msg = null;
            switch (Integer.parseInt(type)) {
                case 0: {
                    Object selection = this.jtrBookmarks.getLastSelectedPathComponent();
                    msg = BasicUtilities.getString("JetFire_Please_Select_a_Bookmark");
                    configured = selection instanceof SQLBookmark;
                    break;
                }
                case 1: {
                    configured = this.editor.getText().trim().length() >= 1;
                    msg = BasicUtilities.getString("JetFire_Please_Enter_a_Valid_SQL_Query");
                    break;
                }
                case 2: {
                    String table;
                    String schema = this.jcbSchemas == null ? this.txtSchema.getText().trim() : (String)this.jcbSchemas.getSelectedItem();
                    String string = table = this.jcbTables == null ? this.txtTable.getText().trim() : (String)this.jcbTables.getSelectedItem();
                    if (schema != null && schema.length() >= 1) {
                        table = schema.concat(".").concat(table);
                    }
                    msg = BasicUtilities.getString("JetFire_Please_Enter_a_Valid_Table_Name");
                    boolean bl = configured = table.length() >= 1;
                }
            }
            if (!configured) {
                JOptionPane.showMessageDialog(this, msg);
            }
            return configured;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void processActionEvent(ActionEvent event) {
            Object src = event.getSource();
            if (src instanceof JRadioButton) {
                this.jtrBookmarks.setEnabled(this.jrbBookmark.isSelected());
                this.editor.setEnabled(this.jrbManual.isSelected());
                boolean chk = this.jrbTable.isSelected();
                if (this.jcbSchemas != null && this.mdlSchemas.getSize() >= 1) {
                    this.jcbSchemas.setEnabled(chk);
                } else if (this.jcbSchemas == null) {
                    this.txtSchema.setEnabled(chk);
                }
                if (this.jcbTables != null && this.mdlTables.getSize() >= 1) {
                    this.jcbTables.setEnabled(chk);
                } else if (this.jcbSchemas == null) {
                    this.txtTable.setEnabled(chk);
                }
            } else if (this.jcbSchemas != null && this.jcbSchemas.getSelectedIndex() >= 0) {
                String schema = (String)this.jcbSchemas.getSelectedItem();
                DefaultComboBoxModel defaultComboBoxModel = this.mdlTables;
                synchronized (defaultComboBoxModel) {
                    this.mdlTables.removeAllElements();
                    ArrayList tables = (ArrayList)this.tableMappings.get(schema);
                    Iterator itr = tables.iterator();
                    while (itr.hasNext()) {
                        try {
                            this.mdlTables.addElement(itr.next());
                        }
                        catch (ConcurrentModificationException cme) {
                            // empty catch block
                            break;
                        }
                    }
                }
                boolean enabled = this.mdlTables.getSize() >= 1 && this.jrbTable.isSelected();
                this.jcbTables.setEnabled(enabled);
            }
        }

        private void initUI() {
            this.setLayout(new GridBagLayout());
            JLabel lbl = null;
            WizardContainer.constrain(0, 0, 2, 1, 0.0, 0.0, 17, 0);
            lbl = new JLabel(BasicUtilities.getString("JetFire_Select_Load_Type"));
            this.add((Component)lbl, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(0, 1, 2, 1, 0.0, 0.0, 17, 0);
            this.add((Component)this.jrbBookmark, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(1, 2, 2, 1, 0.5, 0.5, 17, 1);
            this.add((Component)new JScrollPane(this.jtrBookmarks), WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(0, 3, 2, 1, 0.0, 0.0, 17, 0);
            this.add((Component)this.jrbManual, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(1, 4, 2, 1, 0.5, 0.5, 17, 1);
            this.add((Component)this.editor, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(0, 5, 2, 1, 0.0, 0.0, 17, 0);
            this.add((Component)this.jrbTable, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(1, 6, 1, 1, 0.0, 0.0, 17, 0);
            this.add((Component)new JLabel(BasicUtilities.getString("JetFire_Select_Schema")), WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(2, 6, 1, 1, 0.1, 0.0, 17, 2);
            this.add((Component)this.txtSchema, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(1, 7, 1, 1, 0.0, 0.0, 17, 0);
            this.add((Component)new JLabel(BasicUtilities.getString("JetFire_Select_Table")), WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(2, 7, 1, 1, 0.1, 0.0, 17, 2);
            this.add((Component)this.txtTable, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(0, 0, 1, 8, 0.0, 0.0, 17, 0);
            this.add(Box.createHorizontalStrut(16), WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(0, 8, 3, 1, 0.0, 1.0, 17, 3);
            this.add(Box.createVerticalGlue(), WizardContainer.UI_CONSTRAINT);
            this.choice.add(this.jrbBookmark);
            this.choice.add(this.jrbManual);
            this.choice.add(this.jrbTable);
            this.jrbBookmark.setActionCommand(Integer.toString(0));
            this.jrbManual.setActionCommand(Integer.toString(1));
            this.jrbTable.setActionCommand(Integer.toString(2));
            this.jrbBookmark.addActionListener(this);
            this.jrbManual.addActionListener(this);
            this.jrbTable.addActionListener(this);
            BookmarkTreeCellRenderer rndr = new BookmarkTreeCellRenderer();
            BookmarkTreeModel model = SystemConfig.getInstance().getBookmarks();
            this.jtrBookmarks.setModel(model);
            this.jtrBookmarks.setEditable(false);
            this.jtrBookmarks.setCellRenderer(rndr);
            this.jtrBookmarks.setRootVisible(false);
            this.jtrBookmarks.setDragEnabled(false);
            if (!model.isEmpty()) {
                this.jrbBookmark.setSelected(true);
            } else {
                this.jrbBookmark.setEnabled(false);
                this.jtrBookmarks.setEnabled(false);
                this.jrbManual.setEnabled(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void loadTables(DatabaseConnection dbc) {
            if (this.mdlSchemas == null) {
                this.mdlSchemas = new DefaultComboBoxModel();
                this.jcbSchemas = new JComboBox(this.mdlSchemas);
                this.jcbSchemas.addActionListener(this);
            }
            if (this.mdlTables == null) {
                this.mdlTables = new DefaultComboBoxModel();
                this.jcbTables = new JComboBox(this.mdlTables);
            }
            if (dbc.isClosed()) {
                throw new IllegalStateException(BasicUtilities.getString("No_Database_Connection_Available"));
            }
            this.mdlTables.removeAllElements();
            ResultSet set = null;
            DatabaseMetaData md = dbc.getDatabaseInformation();
            set = md.getTables(dbc.getCatalog(), "%", "%", dbc.getTableTypes());
            while (set.next()) {
                ArrayList tables;
                String schema = set.getString("TABLE_SCHEM");
                String table = set.getString("TABLE_NAME");
                if (!this.tableMappings.containsKey(schema)) {
                    tables = new ArrayList();
                    tables.add(table);
                    this.tableMappings.put(schema, tables);
                    this.mdlSchemas.addElement(schema);
                    continue;
                }
                tables = (ArrayList)this.tableMappings.get(schema);
                tables.add(table);
            }
            this.jcbSchemas.setEnabled(false);
            this.jcbTables.setEnabled(false);
            this.jcbSchemas.setSelectedItem(dbc.getSchema());
            if (this.mdlTables.getSize() >= 1) {
                this.jcbTables.setSelectedIndex(0);
            }
            this.remove(this.txtSchema);
            WizardContainer.constrain(2, 6, 1, 1, 0.1, 0.0, 17, 2);
            this.add((Component)this.jcbSchemas, WizardContainer.UI_CONSTRAINT);
            this.remove(this.txtTable);
            WizardContainer.constrain(2, 7, 1, 1, 0.1, 0.0, 17, 2);
            this.add((Component)this.jcbTables, WizardContainer.UI_CONSTRAINT);
            Object var8_9 = null;
            if (set == null) return;
            try {
                set.close();
                return;
            }
            catch (Throwable t2) {}
            return;
            {
                catch (Throwable t) {
                    this.remove(this.jcbTables);
                    WizardContainer.constrain(2, 7, 1, 1, 0.1, 0.0, 17, 2);
                    this.add((Component)this.txtTable, WizardContainer.UI_CONSTRAINT);
                    String msg = BasicUtilities.getString("JetFire_Tables_Failed");
                    BasicUtilities.showExceptionPopup(this, t, msg);
                    this.jcbTables = null;
                    this.mdlTables = null;
                    Object var8_10 = null;
                    if (set == null) return;
                    try {
                        set.close();
                        return;
                    }
                    catch (Throwable t2) {}
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                if (set == null) throw throwable;
                try {
                    set.close();
                    throw throwable;
                }
                catch (Throwable t2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private static class ToggleRenderer
    extends DefaultListCellRenderer {
        private DefaultComboBoxModel other = null;

        public Component getListCellRendererComponent(JList l, Object v, int idx, boolean sel, boolean foc) {
            super.getListCellRendererComponent((JList<?>)l, v, idx, sel, foc);
            if (v != null && v.equals(this.other.getSelectedItem())) {
                this.setFont(l.getFont().deriveFont(1));
            }
            this.setIcon(BasicUtilities.loadIconResource("Server16"));
            return this;
        }

        public ToggleRenderer(DefaultComboBoxModel other) {
            this.other = other;
        }
    }

    private static class ServiceSelection
    extends ActionPanel
    implements ActionListener {
        private DefaultComboBoxModel mdlSources = new DefaultComboBoxModel();
        private DefaultComboBoxModel mdlDest = new DefaultComboBoxModel();
        private DefaultComboBoxModel mdlCatalogs = null;
        private ServiceProvider serviceProvider = SystemConfig.getInstance().getServiceProvider();
        private JComboBox jcbSourceService = new JComboBox(this.mdlSources);
        private JComboBox jcbDestService = new JComboBox(this.mdlDest);
        private JComboBox jcbCatalogs = new JComboBox();
        private JTextField txtCatalog = new JTextField();
        private JCheckBox chkCatalog = new JCheckBox(BasicUtilities.getString("JetFire_Select_Src_Catalog"));
        private JButton btnLoadCatalogs = new JButton(BasicUtilities.getString("JetFire_Load_Catalogs"));
        private JButton btnTestSrc = new JButton(BasicUtilities.getString("JetFire_Test_Service"));
        private JButton btnTestDst = new JButton(BasicUtilities.getString("JetFire_Test_Service"));

        public ServiceSelection() {
            this.initUI();
        }

        public void saveState(HashMap config) {
            String item = null;
            item = this.jcbDestService.getSelectedItem().toString();
            config.put(DataMigrator.KEY_DST_SERVICE, this.serviceProvider.serviceForName(item));
            item = this.jcbSourceService.getSelectedItem().toString();
            config.put(DataMigrator.KEY_SRC_SERVICE, this.serviceProvider.serviceForName(item));
            if (this.chkCatalog.isSelected()) {
                if (this.jcbCatalogs != null) {
                    config.put(DataMigrator.KEY_SRC_CATALOG, this.jcbCatalogs.getSelectedItem());
                } else {
                    config.put(DataMigrator.KEY_SRC_CATALOG, this.txtCatalog.getText().trim());
                }
            } else {
                config.remove(DataMigrator.KEY_SRC_CATALOG);
            }
        }

        public boolean isConfigured() {
            Object src = this.jcbSourceService.getSelectedItem();
            Object dst = this.jcbDestService.getSelectedItem();
            return src != null && dst != null;
        }

        protected void processActionEvent(ActionEvent event) {
            Object src = event.getSource();
            if (src == this.btnLoadCatalogs) {
                this.loadCatalogs();
            } else if (src == this.btnTestDst) {
                this.testService(this.jcbDestService.getSelectedItem().toString(), true);
            } else if (src == this.btnTestSrc) {
                this.testService(this.jcbSourceService.getSelectedItem().toString(), true);
            } else if (src == this.chkCatalog) {
                boolean e = this.chkCatalog.isSelected();
                if (this.jcbCatalogs != null) {
                    this.jcbCatalogs.setEnabled(e);
                } else {
                    this.txtCatalog.setEnabled(e);
                }
                this.btnLoadCatalogs.setEnabled(e);
            } else if (src == this.jcbSourceService) {
                this.chkCatalog.setSelected(false);
                this.txtCatalog.setEnabled(false);
                this.btnLoadCatalogs.setEnabled(false);
                this.txtCatalog.setText("");
                if (this.jcbCatalogs != null) {
                    this.remove(this.jcbCatalogs);
                    WizardContainer.constrain(2, 2, 1, 1, 0.1, 0.0, 17, 2);
                    this.add((Component)this.txtCatalog, WizardContainer.UI_CONSTRAINT);
                    this.jcbCatalogs = null;
                    this.mdlCatalogs = null;
                }
            }
        }

        private void initUI() {
            this.setLayout(new GridBagLayout());
            JLabel lbl = null;
            WizardContainer.constrain(0, 0, 2, 1, 0.0, 0.0, 17, 0);
            lbl = new JLabel(BasicUtilities.getString("JetFire_Select_Src_Service"));
            this.add((Component)lbl, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(1, 1, 2, 1, 0.0, 0.0, 17, 2);
            this.add((Component)this.jcbSourceService, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(3, 1, 1, 1, 0.0, 0.0, 17, 0);
            this.add((Component)this.btnTestSrc, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(1, 2, 1, 1, 0.0, 0.0, 13, 0);
            this.add((Component)this.chkCatalog, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(2, 2, 1, 1, 0.5, 0.0, 17, 2);
            this.add((Component)this.txtCatalog, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(3, 2, 1, 1, 0.0, 0.0, 17, 0);
            this.add((Component)this.btnLoadCatalogs, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(0, 3, 4, 1, 0.0, 0.0, 17, 0);
            this.add(Box.createVerticalStrut(22), WizardContainer.UI_CONSTRAINT);
            lbl = new JLabel(BasicUtilities.getString("JetFire_Select_Dst_Service"));
            WizardContainer.constrain(0, 4, 2, 1, 0.0, 0.0, 17, 0);
            this.add((Component)lbl, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(1, 5, 2, 1, 0.0, 0.0, 17, 2);
            this.add((Component)this.jcbDestService, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(3, 5, 1, 1, 0.0, 0.0, 17, 0);
            this.add((Component)this.btnTestDst, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(0, 0, 1, 6, 0.0, 0.0, 17, 0);
            this.add(Box.createHorizontalStrut(16), WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(0, 6, 4, 1, 0.0, 1.0, 17, 3);
            this.add(Box.createVerticalGlue(), WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(4, 0, 1, 7, 1.0, 0.0, 17, 2);
            this.add(Box.createHorizontalGlue(), WizardContainer.UI_CONSTRAINT);
            Collection services = this.serviceProvider.getRegisteredServices(true);
            Iterator itr = services.iterator();
            while (itr.hasNext()) {
                Object next = itr.next();
                this.mdlSources.addElement(next);
                this.mdlDest.addElement(next);
            }
            this.jcbDestService.setRenderer(new ToggleRenderer(this.mdlSources));
            this.jcbSourceService.setRenderer(new ToggleRenderer(this.mdlDest));
            this.btnLoadCatalogs.setToolTipText(BasicUtilities.getString("JetFire_Load_Catalogs_Tip"));
            this.chkCatalog.setToolTipText(BasicUtilities.getString("JetFire_Use_Catalogs_Tip"));
            this.btnTestDst.setToolTipText(BasicUtilities.getString("JetFire_Test_Service_Tip"));
            this.btnTestSrc.setToolTipText(BasicUtilities.getString("JetFire_Test_Service_Tip"));
            this.jcbSourceService.setToolTipText(BasicUtilities.getString("JetFire_Select_Service_Tip"));
            this.jcbDestService.setToolTipText(BasicUtilities.getString("JetFire_Select_Service_Tip"));
            this.txtCatalog.setToolTipText(BasicUtilities.getString("JetFire_Catalog_Edit_Tip"));
            this.btnLoadCatalogs.addActionListener(this);
            this.btnTestSrc.addActionListener(this);
            this.btnTestDst.addActionListener(this);
            this.chkCatalog.addActionListener(this);
            this.jcbSourceService.addActionListener(this);
            this.configureCombobox(this.jcbDestService);
            this.configureCombobox(this.jcbSourceService);
        }

        private void configureCombobox(JComboBox box) {
            box.setMaximumRowCount(4);
            box.setSelectedIndex(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private boolean testService(String service, boolean showOK) {
            ServiceDefinition sd;
            block15: {
                sd = null;
                sd = this.serviceProvider.serviceForName(service);
                DatabaseConnection dbc = sd.createConnection();
                if (!dbc.initialize()) break block15;
                if (showOK) {
                    String msg = BasicUtilities.getString("JetFire_Test_OK", service);
                    JOptionPane.showMessageDialog(this, msg, "", 1);
                }
                boolean msg = true;
                try {
                    sd.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
                return msg;
            }
            String msg = BasicUtilities.getString("JetFire_Test_Failed", service);
            JOptionPane.showMessageDialog(this, msg, "", 0);
            boolean bl = false;
            try {
                sd.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
            return bl;
            catch (Throwable t) {
                try {
                    msg = BasicUtilities.getString("JetFire_Test_Failed", service);
                    BasicUtilities.showExceptionPopup(this, t, msg);
                    boolean bl2 = false;
                    return bl2;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        sd.close();
                    }
                    catch (Throwable t2) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadCatalogs() {
            block14: {
                if (this.mdlCatalogs == null) {
                    this.mdlCatalogs = new DefaultComboBoxModel();
                    this.jcbCatalogs = new JComboBox(this.mdlCatalogs);
                }
                String service = this.jcbSourceService.getSelectedItem().toString();
                ServiceDefinition sd = null;
                try {
                    sd = this.serviceProvider.serviceForName(service);
                    DatabaseConnection dbc = sd.createConnection();
                    if (dbc.initialize()) {
                        Object[] catalogs = dbc.getAvailableCatalogs();
                        for (int i = 0; i < catalogs.length; ++i) {
                            this.mdlCatalogs.addElement(catalogs[i]);
                        }
                        this.jcbCatalogs.setEnabled(this.mdlCatalogs.getSize() >= 1);
                        this.remove(this.txtCatalog);
                        WizardContainer.constrain(2, 2, 1, 1, 0.1, 0.0, 17, 2);
                        this.add((Component)this.jcbCatalogs, WizardContainer.UI_CONSTRAINT);
                        break block14;
                    }
                    throw new IllegalStateException();
                }
                catch (Throwable t) {
                    this.remove(this.jcbCatalogs);
                    WizardContainer.constrain(2, 2, 1, 1, 0.1, 0.0, 17, 2);
                    this.add((Component)this.txtCatalog, WizardContainer.UI_CONSTRAINT);
                    String msg = BasicUtilities.getString("JetFire_Catalogs_Failed", service);
                    BasicUtilities.showExceptionPopup(this, t, msg);
                    this.jcbCatalogs = null;
                    this.mdlCatalogs = null;
                }
                finally {
                    try {
                        sd.close();
                    }
                    catch (Throwable t) {}
                }
            }
        }
    }
}

