/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.isqlviewer.core.model.AbstractTreeModel;
import org.isqlviewer.swing.PropertyPageCellRenderer;
import org.isqlviewer.swing.WizardPanel;
import org.isqlviewer.ui.BatchWizard;
import org.isqlviewer.ui.prefs.AdvancedPropertyPage;
import org.isqlviewer.ui.prefs.GeneralPropertyPage;
import org.isqlviewer.ui.prefs.I18NPropertyPage;
import org.isqlviewer.ui.prefs.ScriptManagerPropertyPage;
import org.isqlviewer.ui.prefs.ServiceManagerPropertyPage;
import org.isqlviewer.ui.prefs.WorkbenchPropertyPage;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.PropertyPage;
import org.isqlviewer.util.StringUtilities;

public final class PreferencesEditor
extends JDialog
implements ActionListener {
    public static final int UI_PAGE = -1;
    public static final int FONT_PAGE = -1;
    public static final int SM_PAGE = -1;
    public static final int GENERAL_PAGE = 0;
    public static final int WORKBENCH_PAGE = 1;
    public static final int ADVANCED_PAGE = 2;
    public static final int SERVICE_PAGE = 3;
    public static final int EDITOR_PAGE = 4;
    public static final int SCRIPT_PAGE = 5;
    public static final int I18N_PAGE = 6;
    private final PropertyPage[] ppages = new PropertyPage[7];
    private PropertyTreeModel configTree = null;
    private JTree configView = null;
    private JScrollPane propertyView = new JScrollPane();
    private JSplitPane rootView = new JSplitPane(1, true);
    private JPanel SouthPanel = new JPanel(new FlowLayout());
    private JButton btnOK = new JButton(BasicUtilities.getString("Ok"));
    private JButton btnApply = new JButton(BasicUtilities.getString("Apply"));
    private JButton btnCANCEL = new JButton(BasicUtilities.getString("Cancel"));

    private PreferencesEditor(JDialog owner) {
        super(owner, BasicUtilities.getString("iSQLPrefrences_Title"), true);
        try {
            this.loadPages();
            this.initUI();
        }
        catch (Throwable t) {
            BasicUtilities.HandleException(t, "PreferencesEditor(Frame)");
        }
    }

    private PreferencesEditor(JFrame frm) {
        super(frm, BasicUtilities.getString("iSQLPrefrences_Title"), true);
        try {
            this.loadPages();
            this.initUI();
        }
        catch (Throwable t) {
            BasicUtilities.HandleException(t, "PreferencesEditor(Frame)");
        }
    }

    private void loadPages() {
        this.ppages[0] = new GeneralPropertyPage();
        this.ppages[1] = new WorkbenchPropertyPage();
        this.ppages[2] = new AdvancedPropertyPage(this);
        this.ppages[4] = new BatchWizard.PreferencesBatch();
        this.ppages[3] = new ServiceManagerPropertyPage();
        this.ppages[5] = new ScriptManagerPropertyPage();
        this.ppages[6] = new I18NPropertyPage();
        for (int i = 0; i < this.ppages.length; ++i) {
            PropertyPage page = this.ppages[i];
            if (page == null) continue;
            page.loadProperties();
        }
    }

    public void resetPages() {
        for (int i = 0; i < this.ppages.length; ++i) {
            PropertyPage Page2 = this.ppages[i];
            Page2.revertProperties();
            Page2.saveProperties();
        }
        this.dispose();
    }

    public void savePages() {
        for (int i = 0; i < this.ppages.length; ++i) {
            PropertyPage page = this.ppages[i];
            if (!page.hasChangedProperties()) continue;
            page.saveProperties();
            page.revertChangedState();
        }
        this.getRootPane().putClientProperty("windowModified", Boolean.FALSE);
    }

    protected void processWindowEvent(WindowEvent e) {
        switch (e.getID()) {
            case 200: {
                this.getRootPane().putClientProperty("windowModified", Boolean.FALSE);
                break;
            }
            case 201: {
                String title;
                Boolean modified = (Boolean)this.getRootPane().getClientProperty("windowModified");
                if (modified == null || !modified.booleanValue()) break;
                String msg = BasicUtilities.getString("Preference_Edit_Warning");
                int res = JOptionPane.showConfirmDialog(this, msg = StringUtilities.formatBreak(80, "<html>".concat(msg), "", true), title = BasicUtilities.getString("Warning"), 0);
                if (res != 1) break;
                return;
            }
        }
        super.processWindowEvent(e);
    }

    private void initUI() {
        this.SouthPanel.add(Box.createHorizontalGlue());
        this.SouthPanel.add(this.btnOK);
        this.SouthPanel.add(this.btnCANCEL);
        this.SouthPanel.add(this.btnApply);
        this.SouthPanel.add(Box.createHorizontalGlue());
        this.btnOK.addActionListener(this);
        this.btnCANCEL.addActionListener(this);
        this.btnApply.addActionListener(this);
        this.configTree = new PropertyTreeModel();
        this.configView = new JTree(this.configTree);
        this.configView.setRootVisible(false);
        this.configView.setExpandsSelectedPaths(true);
        this.configView.setCellRenderer(new PropertyPageCellRenderer());
        this.configView.setScrollsOnExpand(true);
        this.configView.setSelectionRow(0);
        this.configView.expandRow(0);
        PropertyPageSelectionListener listener = new PropertyPageSelectionListener();
        this.configView.addTreeSelectionListener(listener);
        this.rootView.setLeftComponent(new JScrollPane(this.configView));
        this.rootView.setRightComponent(this.propertyView);
        WizardPanel panel = new WizardPanel();
        JPanel pnl = new JPanel(new BorderLayout());
        pnl.add((Component)this.rootView, "Center");
        pnl.add((Component)this.SouthPanel, "South");
        panel.showCard(pnl);
        this.setContentPane(panel);
        this.configView.setSelectionRow(0);
        listener.valueChanged(null);
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.btnOK || src == this.btnApply) {
            this.savePages();
            if (src == this.btnApply) {
                return;
            }
        }
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    public static final int showDialog(JDialog owner, int page) {
        PreferencesEditor dlg = new PreferencesEditor(owner);
        dlg.pack();
        dlg.setSize(640, 365);
        dlg.setLocationRelativeTo(owner);
        dlg.configView.collapseRow(0);
        dlg.configView.setSelectionRow(page);
        dlg.configView.expandRow(page);
        dlg.show();
        return 0;
    }

    public static final int showDialog(JFrame frame) {
        PreferencesEditor dlg = new PreferencesEditor(frame);
        dlg.pack();
        dlg.setSize(640, 365);
        dlg.setLocationRelativeTo(frame);
        dlg.show();
        return 0;
    }

    private class PropertyTreeModel
    extends AbstractTreeModel {
        private final Object ROOT = new Object();
        private final TreeModelEvent EVENT_RELOAD = new TreeModelEvent((Object)this, new Object[]{this.ROOT}, null, null);

        private PropertyTreeModel() {
        }

        public void reload() {
            this.fireTreeStructureChanged(this.EVENT_RELOAD);
        }

        public Object getChild(Object parent, int index) {
            if (parent == this.getRoot()) {
                return PreferencesEditor.this.ppages[index];
            }
            if (parent instanceof PropertyPage) {
                return ((PropertyPage)parent).getChildren()[index];
            }
            return "";
        }

        public int getChildCount(Object parent) {
            if (parent == this.getRoot()) {
                return PreferencesEditor.this.ppages.length;
            }
            if (parent instanceof PropertyPage) {
                return ((PropertyPage)parent).getChildren().length;
            }
            return 0;
        }

        public int getIndexOfChild(Object parent, Object child) {
            if (parent == this.getRoot()) {
                for (int i = 0; i < PreferencesEditor.this.ppages.length; ++i) {
                    if (!PreferencesEditor.this.ppages[i].getPropertyPageName().equals(child)) continue;
                    return i;
                }
                return -1;
            }
            if (parent instanceof PropertyPage) {
                PropertyPage[] pages = ((PropertyPage)parent).getChildren();
                String page = ((PropertyPage)child).getPropertyPageName();
                for (int i = 0; i < pages.length; ++i) {
                    if (!pages[i].getPropertyPageName().equals(page)) continue;
                    return i;
                }
                return -1;
            }
            return 0;
        }

        public Object getRoot() {
            return this.ROOT;
        }

        public boolean isLeaf(Object node) {
            return this.getChildCount(node) == 0;
        }

        public void valueForPathChanged(TreePath path, Object newValue) {
        }
    }

    private class PropertyPageSelectionListener
    implements TreeSelectionListener {
        private PropertyPageSelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent evt) {
            try {
                PropertyPage page = (PropertyPage)PreferencesEditor.this.configView.getSelectionPath().getLastPathComponent();
                PreferencesEditor.this.setTitle(BasicUtilities.getString("iSQLPrefrences_Title", page.getPropertyPageName()));
                PreferencesEditor.this.propertyView.setViewportView(page.getPageComponent());
                SwingUtilities.updateComponentTreeUI(PreferencesEditor.this.propertyView);
                int sz = ((PreferencesEditor)PreferencesEditor.this).configView.getPreferredSize().width + 2 * PreferencesEditor.this.rootView.getDividerSize() + 2;
                if (PreferencesEditor.this.rootView.getDividerLocation() < sz) {
                    PreferencesEditor.this.rootView.setDividerLocation(sz);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

