/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import org.isqlviewer.core.IPCListener;
import org.isqlviewer.core.IPCService;
import org.isqlviewer.core.SQLBookmark;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.swing.ActionManager;
import org.isqlviewer.swing.JDBCSuggestor;
import org.isqlviewer.swing.SuggestionWindow;
import org.isqlviewer.swing.WindowWillShowListener;
import org.isqlviewer.swing.text.SQLDocument;
import org.isqlviewer.ui.AppController;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringUtilities;
import org.isqlviewer.util.UserPreferences;

public class SQLEditor
extends JPanel {
    private SQLDocument document = new SQLDocument();
    private JTextPane editor = new JTextPane(this.document);
    private JLabel lblCaret = new JLabel();
    private JLabel lblMode = new JLabel();
    private JDBCSuggestor metaSuggestor = new JDBCSuggestor();
    private ListCellRenderer metaRenderer = new JDBCSuggestor.SuggestionRenderer(this.document);
    private EditorSupport support = new EditorSupport(this);
    private UndoManager undoManager = new UndoManager();
    private SuggestionWindow inline = null;

    public SQLEditor() {
        this((AppController)null);
    }

    public SQLEditor(AppController controller) {
        super(new BorderLayout());
        try {
            if (controller != null) {
                Window owner = controller.getRootWindow();
                this.createContextHelp(owner);
                this.setActionManager(controller.getActionManager());
                controller.setDefaultTextComponent(this.editor);
            }
            this.initUI();
        }
        catch (Throwable t) {
            BasicUtilities.HandleException(t, "SQLEditor::<init>", true);
        }
    }

    public String getText() {
        return this.editor.getText().trim();
    }

    public String getSelectedText() {
        String text = this.editor.getSelectedText();
        return text == null ? "" : text.trim();
    }

    public void createContextHelp(Window owner) {
        if (this.inline != null) {
            this.inline.dispose();
        }
        this.inline = null;
        this.inline = new SuggestionWindow(owner);
        this.inline.setModel(this.metaSuggestor);
        this.inline.setRenderer(new JDBCSuggestor.SuggestionRenderer(this.document));
        this.inline.setWindowListener(this.support);
        this.inline.setTextComponent(this.editor);
        if (BasicUtilities.isMac()) {
            this.inline.addKeyBinding(BasicUtilities.createKeyStroke(27, 512));
            this.inline.addKeyBinding(BasicUtilities.createKeyStroke(27, 9));
        }
        this.inline.addKeyBinding(BasicUtilities.createKeyStroke(32, 2));
        this.inline.addKeyBinding(BasicUtilities.createKeyStroke(32, 3));
    }

    public void setText(String text) {
        this.document.setStylesEnabled(false);
        this.editor.setText(text);
        this.document.setStylesEnabled(true);
        this.document.validateStyles();
    }

    public JTextComponent getEditor() {
        return this.editor;
    }

    public SQLDocument getDocument() {
        return this.document;
    }

    public String toHTML(String sql) {
        try {
            return this.document.toHTML(sql, true);
        }
        catch (Throwable t) {
            return sql;
        }
    }

    public String toHTML() {
        return this.toHTML(this.editor.getText());
    }

    public void requestFocus() {
        this.editor.requestFocus();
        this.support.caretUpdate(null);
    }

    public void setEnabled(boolean f) {
        super.setEnabled(f);
        this.editor.setEnabled(f);
        this.editor.setEditable(f);
        this.lblCaret.setEnabled(f);
        this.lblMode.setEnabled(f);
    }

    public void setEditable(boolean f) {
        this.editor.setEditable(f);
    }

    public void setCaretPosition(int i) {
        try {
            this.editor.setCaretPosition(i);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void configureWithConnection(DatabaseConnection connection) {
        this.updateConnection(connection);
    }

    private void initUI() throws Exception {
        JPanel subpane = new JPanel(new BorderLayout());
        subpane.add((Component)new JScrollPane(this.editor), "Center");
        subpane.add((Component)this.createStatusBar(), "South");
        this.add((Component)subpane, "Center");
        this.setPreferredSize(new Dimension(320, 120));
        this.editor.setDropTarget(new DropTarget(this.editor, this.support));
        this.editor.setDragEnabled(true);
        BasicUtilities.localizeTextComponent(this.editor, this.undoManager);
        Keymap map = this.editor.getKeymap();
        KeyStroke ks = null;
        OverwriteToggleAction a = null;
        a = new OverwriteToggleAction(this.document, this.lblMode);
        if (a != null && (ks = BasicUtilities.isMac() ? KeyStroke.getKeyStroke(73, BasicUtilities.CMD_MASK, true) : KeyStroke.getKeyStroke(155, 0, false)) != null) {
            map.addActionForKeyStroke(ks, a);
        }
    }

    private JComponent createStatusBar() {
        JPanel bar = new JPanel(new GridBagLayout());
        Border bdr = BorderFactory.createEtchedBorder();
        this.lblCaret.setBorder(bdr);
        this.lblMode.setBorder(bdr);
        this.lblCaret.setVerticalAlignment(0);
        this.lblMode.setVerticalAlignment(0);
        this.lblCaret.setHorizontalAlignment(0);
        this.lblMode.setHorizontalAlignment(0);
        Insets i = new Insets(0, 0, 0, 0);
        bar.add(Box.createHorizontalGlue(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, i, 0, 0));
        bar.add((Component)this.lblMode, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, i, 0, 0));
        bar.add(Box.createHorizontalStrut(2), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, i, 0, 0));
        bar.add((Component)this.lblCaret, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, i, 0, 0));
        boolean mode = this.document.getOverwriteEnabled();
        String m = mode ? BasicUtilities.getString("Editor_Overwrite_Mode") : BasicUtilities.getString("Editor_Insert_Mode");
        this.lblMode.setText(" ".concat(m).concat(" "));
        return bar;
    }

    private void setActionManager(ActionManager manager) {
        Keymap map = this.editor.getKeymap();
        KeyStroke ks = null;
        Action a = null;
        if (manager == null) {
            return;
        }
        IPCService ipc = SystemConfig.getInstance().getIPCService();
        ipc.subscribe(this.support, "isql-service-change");
        ipc.subscribe(this.support, "isql-sql-message");
        a = manager.getAction(15);
        if (a != null && (ks = (KeyStroke)a.getValue("AcceleratorKey")) != null) {
            map.addActionForKeyStroke(ks, a);
        }
        if ((a = manager.getAction(47)) != null && (ks = (KeyStroke)a.getValue("AcceleratorKey")) != null) {
            map.addActionForKeyStroke(ks, a);
        }
        if ((a = manager.getAction(17)) != null && (ks = (KeyStroke)a.getValue("AcceleratorKey")) != null) {
            map.addActionForKeyStroke(ks, a);
        }
        if ((a = manager.getAction(18)) != null && (ks = (KeyStroke)a.getValue("AcceleratorKey")) != null) {
            map.addActionForKeyStroke(ks, a);
        }
    }

    private void updateConnection(DatabaseConnection cnx) {
        UserPreferences prefs = SystemConfig.getInstance().getPreferences();
        boolean color = prefs.getBoolean("editor.syntax-help.enabled");
        boolean help = prefs.getBoolean("editor.context-help.enabled");
        long epoch = System.currentTimeMillis();
        if (color) {
            this.document.updateConnection(cnx);
        }
        if (help) {
            this.metaSuggestor.setConnection(cnx);
        }
        epoch = System.currentTimeMillis() - epoch;
        if (color || help) {
            System.out.println(BasicUtilities.getString("MetaDataLoad_Info", Long.toString(epoch)));
        }
    }

    private static class EditorSupport
    extends DropTargetAdapter
    implements CaretListener,
    FocusListener,
    IPCListener,
    PreferenceChangeListener,
    UndoableEditListener,
    WindowWillShowListener {
        UserPreferences preferences = SystemConfig.getInstance().getPreferences();
        private SQLEditor owner = null;
        private NumberFormat nfmt = NumberFormat.getIntegerInstance();

        public EditorSupport(SQLEditor editor) {
            this.owner = editor;
            this.owner.editor.addFocusListener(this);
            this.owner.editor.addCaretListener(this);
            this.owner.document.addUndoableEditListener(this);
            this.preferences.addPreferenceChangeListener(this);
            this.nfmt.setMinimumIntegerDigits(3);
        }

        public void focusGained(FocusEvent e) {
            this.owner.setCaretPosition(Math.max(0, this.owner.editor.getCaretPosition()));
            this.caretUpdate(null);
        }

        public void focusLost(FocusEvent e) {
        }

        public void caretUpdate(CaretEvent e) {
            Object src = e == null ? this.owner.editor : e.getSource();
            int dot = e == null ? this.owner.editor.getCaretPosition() : e.getDot();
            try {
                if (src instanceof JTextComponent) {
                    int row = 0;
                    int col = 0;
                    JTextComponent txt = (JTextComponent)src;
                    row = BasicUtilities.getCaretRow(dot, txt) + 1;
                    col = BasicUtilities.getCaretCol(dot, txt) + 1;
                    String str = this.nfmt.format(row).concat(" : ").concat(this.nfmt.format(col));
                    if (this.preferences.getBoolean("editor.caretoffset-enabled")) {
                        str = str.concat(", ").concat(this.nfmt.format(dot + 1));
                    }
                    this.owner.lblCaret.setText(" ".concat(str).concat(" "));
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }

        public void undoableEditHappened(UndoableEditEvent e) {
            if (e == null || e.getEdit() == null) {
                return;
            }
            UndoableEdit edit = e.getEdit();
            String name = edit.getPresentationName();
            if (name != null && edit.canUndo()) {
                if (name.indexOf("style") < 0) {
                    this.owner.undoManager.addEdit(e.getEdit());
                } else {
                    edit.die();
                }
            } else {
                edit.die();
            }
        }

        public void preferenceChange(PreferenceChangeEvent event) {
            if (event == null) {
                return;
            }
            String key = event.getKey();
            String val = event.getNewValue();
            SQLDocument doc = this.owner.document;
            JTextPane txt = this.owner.editor;
            if (val == null) {
                try {
                    val = SystemConfig.getInstance().getPreferences().get(key);
                }
                finally {
                    return;
                }
            }
            if (key.equals("editor.background-color")) {
                Color c = Color.decode(val);
                txt.setBackground(c);
                doc.getStylizer().updateDefaultBackground(c);
                doc.validateStyles();
            }
            if (key.equals("editor.default-color")) {
                Color c = Color.decode(val);
                txt.setForeground(c);
                doc.getStylizer().updateDefaultForeground(c);
                doc.validateStyles();
            }
            if (key.equals("editor.font")) {
                Font f = StringUtilities.parseFontString(val);
                txt.setFont(f);
                doc.getStylizer().updateDefaultFont(f);
                doc.validateStyles();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void drop(DropTargetDropEvent event) {
            try {
                Transferable transferable = event.getTransferable();
                JTextPane txt = this.owner.editor;
                SQLDocument doc = this.owner.document;
                int offset = txt.viewToModel(event.getLocation());
                int action = event.getDropAction();
                if (event.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    event.acceptDrop(action);
                    this.doFileDrop(event, transferable);
                } else if (event.isDataFlavorSupported(BasicUtilities.bookmarkFlavour)) {
                    event.acceptDrop(action);
                    SQLBookmark s = (SQLBookmark)transferable.getTransferData(BasicUtilities.bookmarkFlavour);
                    if (action == 1) {
                        doc.insertString(offset, s.getSQL(), null);
                        doc.validateStyles();
                        txt.requestFocus();
                    } else {
                        this.owner.setText(s.getSQL());
                        txt.requestFocus();
                    }
                    s.updateLastAcessTime();
                    SystemConfig.getInstance().getBookmarks().setModified();
                } else if (event.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    event.acceptDrop(action);
                    String s = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                    if (action == 1) {
                        doc.insertString(offset, s, null);
                        doc.validateStyles();
                        txt.requestFocus();
                    } else {
                        this.owner.setText(s);
                        txt.requestFocus();
                    }
                } else {
                    event.rejectDrop();
                }
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t, "SQLEditor::drop()");
                event.rejectDrop();
            }
            finally {
                event.dropComplete(true);
            }
        }

        public void receiveMessage(Object src, String topic, Object msg) {
            if (topic.equals("isql-sql-message")) {
                if (msg != null) {
                    this.owner.setText(msg.toString());
                }
            } else if (topic.equals("isql-service-change")) {
                this.owner.configureWithConnection((DatabaseConnection)msg);
            }
        }

        public void windowWillShow(SuggestionWindow window, InputEvent event) throws Exception {
            int mods = event.getModifiersEx();
            boolean isShift = (mods & 0x40) == 64;
            SQLDocument doc = this.owner.document;
            if (isShift) {
                window.setTitle("Functions");
                window.setModel(doc.getStylizer().getFunctions());
                window.setRenderer(null);
            } else {
                window.setTitle("Objects");
                window.setModel(this.owner.metaSuggestor);
                window.setRenderer(this.owner.metaRenderer);
            }
        }

        private void doFileDrop(DropTargetDropEvent event, Transferable transferable) throws UnsupportedFlavorException, IOException {
            Object txData = transferable.getTransferData(DataFlavor.javaFileListFlavor);
            if (!(txData instanceof List)) {
                BasicUtilities.beep();
                event.rejectDrop();
                return;
            }
            List lst = (List)txData;
            Iterator itr = lst.iterator();
            if (itr.hasNext()) {
                Object next = itr.next();
                if (next instanceof File) {
                    File f = (File)next;
                    try {
                        this.owner.document.loadFromFile(f);
                    }
                    catch (Throwable t) {
                        BasicUtilities.beep();
                        BasicUtilities.HandleException(t);
                    }
                } else {
                    BasicUtilities.beep();
                    event.rejectDrop();
                    return;
                }
            }
        }
    }

    private static class OverwriteToggleAction
    extends AbstractAction {
        private SQLDocument doc = null;
        private JLabel lbl = null;

        public OverwriteToggleAction(SQLDocument doc, JLabel view) {
            this.doc = doc;
            this.lbl = view;
        }

        public void actionPerformed(ActionEvent e) {
            boolean mode = !this.doc.getOverwriteEnabled();
            this.doc.setOverwriteEnabled(mode);
            String m = mode ? BasicUtilities.getString("Editor_Overwrite_Mode") : BasicUtilities.getString("Editor_Insert_Mode");
            this.lbl.setText(" ".concat(m).concat(" "));
        }
    }
}

