/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.isqlviewer.core.ServiceDefinition;
import org.isqlviewer.core.ServiceProvider;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.core.model.MovableListModel;
import org.isqlviewer.swing.ActionToolBar;
import org.isqlviewer.swing.ClassListCellRenderer;
import org.isqlviewer.swing.JFileList;
import org.isqlviewer.swing.JListUISupport;
import org.isqlviewer.swing.JNumberEditor;
import org.isqlviewer.swing.WizardPanel;
import org.isqlviewer.ui.DriverPropertyEditor;
import org.isqlviewer.ui.LoginOptionPane;
import org.isqlviewer.ui.PreferencesEditor;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.UserPreferences;

public final class ServiceManager
extends JDialog {
    private static final int ACTION_OK = 0;
    private static final int ACTION_MOVE_UP = 1;
    private static final int ACTION_MOVE_DOWN = 2;
    private static final int ACTION_TEST = 3;
    private static final int ACTION_APPLY = 4;
    private static final int ACTION_CANCEL = 5;
    private static final int ACTION_COPY = 6;
    private static final int ACTION_DELETE = 7;
    private static final int ACTION_NEW = 8;
    private static final int ACTION_UNDELETE = 9;
    private static final int ACTION_CONFIG = 10;
    private static final int ACTION_SCAN = 11;
    private static final int ACTION_REFRESH = 12;
    private static final int ACTION_EDIT_PROPERTY = 13;
    private static final GridBagConstraints UI_CONSTRAINT = new GridBagConstraints(0, 0, 0, 0, 0.0, 0.0, 0, 0, new Insets(1, 1, 1, 1), 0, 0);
    private static final Random SEED = new Random(System.currentTimeMillis());
    private SystemConfig systemConfig = SystemConfig.getInstance();
    private ServiceProvider provider = this.systemConfig.getServiceProvider();
    private UserPreferences prefs = this.systemConfig.getPreferences();
    private MovableListModel mdlServices = new MovableListModel();
    private ServiceSupport inputSupport = new ServiceSupport();
    private Vector toBeDeleted = new Vector();
    private Vector toBeSaved = new Vector();
    private Vector newServices = new Vector();
    private Hashtable lazyCache = new Hashtable();
    private JTabbedPane jtpServiceEditor = new JTabbedPane(1);
    private JToolBar jtbActions = ActionToolBar.createNullInstance();
    private JList jlsServices = new JList(this.mdlServices);
    private JButton btnOK = new JButton(BasicUtilities.getString("Ok"));
    private JButton btnTest = new JButton(BasicUtilities.getString("Test"));
    private JButton btnApply = new JButton(BasicUtilities.getString("Save_Apply"));
    private JButton btnCancel = new JButton(BasicUtilities.getString("Cancel"));
    private JButton btnCreate = new JButton(BasicUtilities.loadIconResource("New16"));
    private JButton btnMoveUp = new JButton(BasicUtilities.loadIconResource("Up16"));
    private JButton btnCopy = new JButton(BasicUtilities.loadIconResource("Copy16"));
    private JButton btnMoveDn = new JButton(BasicUtilities.loadIconResource("Down16"));
    private JButton btnDeleteSv = new JButton(BasicUtilities.loadIconResource("Delete16"));
    private JButton btnConfig = new JButton(BasicUtilities.loadIconResource("Preferences16"));
    private JButton btnUndelete = new JButton(BasicUtilities.loadIconResource("Rollback16"));
    private JButton btnScan = new JButton(BasicUtilities.loadIconResource("WebCheck16"));
    private LocalServiceEditor localEditor = new LocalServiceEditor();
    private RemoteServiceEditor remoteEditor = new RemoteServiceEditor();
    private AdvancedServiceEditor advancedEditor = new AdvancedServiceEditor();
    private JFileList jflResources = new JFileList();
    private WizardPanel pnlEditor = new WizardPanel();
    private boolean isLoadingService = false;
    static /* synthetic */ Class class$java$awt$Frame;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showDialog(Frame owner) {
        ServiceManager mgr = null;
        try {
            mgr = new ServiceManager(owner);
            mgr.setLocationRelativeTo(owner);
            mgr.show();
        }
        catch (Throwable t) {
            BasicUtilities.HandleException(t, "ServiceManager::showDialog(Frame)");
        }
        finally {
            mgr = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Iterator<Object> itr;
        if (!this.toBeSaved.isEmpty()) {
            itr = this.toBeSaved.iterator();
            while (itr.hasNext()) {
                Object next = itr.next();
                String serviceName = next.toString().trim().toUpperCase();
                ServiceDefinition sd = (ServiceDefinition)this.lazyCache.get(serviceName);
                if (sd == null) continue;
                try {
                    if (Boolean.getBoolean("isql.debug")) {
                        String msg = BasicUtilities.getString("Saving_Service", serviceName);
                        System.out.println(msg);
                    }
                    this.provider.saveService(sd);
                }
                catch (Throwable t) {
                    String msg = BasicUtilities.getString("Error_Saving_Service", serviceName);
                    BasicUtilities.showExceptionPopup(this, t, msg);
                }
                finally {
                    sd.close();
                }
            }
        }
        if (!this.toBeDeleted.isEmpty()) {
            itr = this.toBeDeleted.iterator();
            while (itr.hasNext()) {
                String svc = (String)itr.next();
                try {
                    this.provider.removeService(svc);
                }
                catch (Throwable t) {
                    BasicUtilities.HandleException(t, "ServiceManager::dispose()");
                }
            }
        }
        if (!this.lazyCache.isEmpty()) {
            itr = this.lazyCache.values().iterator();
            while (itr.hasNext()) {
                try {
                    ServiceDefinition sd = (ServiceDefinition)itr.next();
                    sd.close();
                    itr.remove();
                }
                catch (Throwable throwable) {}
            }
            this.lazyCache.clear();
        }
        super.dispose();
    }

    private ServiceManager(Frame owner) {
        super(owner, "", true);
        try {
            this.initUI();
        }
        catch (Throwable t) {
            throw new RuntimeException("ServiceManager::initUI()", t);
        }
        this.pack();
    }

    protected void processWindowEvent(WindowEvent e) {
        switch (e.getID()) {
            case 200: {
                this.loadServiceList();
                break;
            }
            case 201: {
                if (this.toBeDeleted.isEmpty() && this.toBeSaved.isEmpty()) break;
                int res = JOptionPane.showConfirmDialog(this, BasicUtilities.getString("Service_Cancel_Confirm"));
                if (res == 2) {
                    return;
                }
                if (res != 0) break;
                this.cancel(false);
            }
        }
        super.processWindowEvent(e);
    }

    private void initUI() {
        JPanel contentPane = (JPanel)this.getContentPane();
        JPanel userContent = new JPanel(new GridBagLayout());
        JPanel buttonBar = new JPanel(new GridLayout(1, 5));
        this.jtbActions.setOrientation(0);
        this.jtbActions.setFloatable(false);
        this.jtbActions.add(this.btnConfig);
        this.jtbActions.add(this.btnScan);
        this.jtbActions.add(this.btnCreate);
        this.jtbActions.add(this.btnCopy);
        this.jtbActions.add(this.btnUndelete);
        this.jtbActions.add(this.btnDeleteSv);
        this.btnApply.addActionListener(this.inputSupport);
        this.btnApply.setActionCommand(Integer.toString(4));
        this.btnApply.setToolTipText(BasicUtilities.getString("Save_Apply_Tip"));
        this.btnOK.addActionListener(this.inputSupport);
        this.btnOK.setActionCommand(Integer.toString(0));
        this.btnOK.setToolTipText(BasicUtilities.getString("OK_Tip"));
        this.btnCancel.addActionListener(this.inputSupport);
        this.btnCancel.setActionCommand(Integer.toString(5));
        this.btnCancel.setToolTipText(BasicUtilities.getString("Cancel_Tip"));
        this.btnCopy.addActionListener(this.inputSupport);
        this.btnCopy.setActionCommand(Integer.toString(6));
        this.btnCopy.setToolTipText(BasicUtilities.getString("Copy_Tip"));
        this.btnUndelete.addActionListener(this.inputSupport);
        this.btnUndelete.setActionCommand(Integer.toString(9));
        this.btnUndelete.setToolTipText(BasicUtilities.getString("Service_Undelete_Tip"));
        this.btnTest.addActionListener(this.inputSupport);
        this.btnTest.setActionCommand(Integer.toString(3));
        this.btnTest.setToolTipText(BasicUtilities.getString("Test_Tip"));
        this.btnDeleteSv.addActionListener(this.inputSupport);
        this.btnDeleteSv.setActionCommand(Integer.toString(7));
        this.btnDeleteSv.setToolTipText(BasicUtilities.getString("Delete_Tip"));
        this.btnCreate.addActionListener(this.inputSupport);
        this.btnCreate.setActionCommand(Integer.toString(8));
        this.btnCreate.setToolTipText(BasicUtilities.getString("New_Tip"));
        this.btnConfig.addActionListener(this.inputSupport);
        this.btnConfig.setActionCommand(Integer.toString(10));
        this.btnConfig.setToolTipText(BasicUtilities.getString("Service_Option_Tip"));
        this.btnScan.addActionListener(this.inputSupport);
        this.btnScan.setActionCommand(Integer.toString(11));
        this.btnScan.setToolTipText(BasicUtilities.getString("Service_Scan_Tip"));
        this.jlsServices.setCellRenderer(new ServiceRenderer());
        this.jlsServices.setSelectionMode(0);
        this.jlsServices.addListSelectionListener(this.inputSupport);
        JListUISupport.install(this.jlsServices, false);
        ServiceManager.constrain(0, 0, 1, 1, 0.0, 0.0, 17, 0);
        userContent.add((Component)this.jtbActions, UI_CONSTRAINT);
        ServiceManager.constrain(0, 1, 1, 1, 0.0, 1.0, 10, 1);
        userContent.add((Component)new JScrollPane(this.jlsServices), UI_CONSTRAINT);
        ServiceManager.constrain(1, 0, 1, 2, 1.0, 1.0, 11, 1);
        userContent.add((Component)this.jtpServiceEditor, UI_CONSTRAINT);
        this.pnlEditor.add((Component)this.localEditor, "local");
        this.pnlEditor.add((Component)this.remoteEditor, "remote");
        this.pnlEditor.showCard(this.localEditor);
        this.localEditor.registerChangeListeners(this.inputSupport);
        this.remoteEditor.registerChangeListeners(this.inputSupport);
        this.advancedEditor.registerChangeListeners(this.inputSupport);
        buttonBar.add(Box.createHorizontalGlue());
        buttonBar.add(this.btnOK);
        buttonBar.add(this.btnApply);
        buttonBar.add(this.btnTest);
        buttonBar.add(this.btnCancel);
        buttonBar.add(Box.createHorizontalGlue());
        JPanel pnlResources = new JPanel(new GridBagLayout());
        ServiceManager.constrain(0, 0, 1, 3, 0.0, 0.0, 17, 0);
        pnlResources.add(Box.createHorizontalStrut(12), UI_CONSTRAINT);
        ServiceManager.constrain(1, 0, 1, 1, 0.0, 0.0, 17, 0);
        pnlResources.add(Box.createVerticalStrut(6), UI_CONSTRAINT);
        ServiceManager.constrain(1, 1, 1, 1, 1.0, 1.0, 10, 1);
        pnlResources.add((Component)this.jflResources, UI_CONSTRAINT);
        ServiceManager.constrain(2, 0, 1, 3, 0.0, 0.0, 17, 0);
        pnlResources.add(Box.createHorizontalStrut(12), UI_CONSTRAINT);
        ServiceManager.constrain(1, 2, 1, 1, 0.0, 0.0, 17, 0);
        pnlResources.add(Box.createVerticalStrut(6), UI_CONSTRAINT);
        JLabel lbl = new JLabel(BasicUtilities.getString("Resource_List_Tip"));
        this.jflResources.add((Component)lbl, "South");
        this.jflResources.addChangeListener(this.inputSupport);
        this.jtpServiceEditor.addTab(BasicUtilities.getString("General_Property_Page"), this.pnlEditor);
        this.jtpServiceEditor.addTab(BasicUtilities.getString("Advanced_Tab_Label"), this.advancedEditor);
        this.jtpServiceEditor.addTab(BasicUtilities.getString("Resources_Tab_Label"), pnlResources);
        this.jtpServiceEditor.addChangeListener(this.inputSupport);
        contentPane.add((Component)userContent, "Center");
        contentPane.add((Component)buttonBar, "South");
    }

    private void storeServiceList() {
        ArrayList<String> newOrder = new ArrayList<String>();
        for (int i = 0; i < this.mdlServices.getSize(); ++i) {
            Object obj = this.mdlServices.get(i);
            String key = null;
            key = obj instanceof ServiceDefinition ? ((ServiceDefinition)obj).getName() : (String)obj;
            newOrder.add(key);
        }
        this.provider.setPreferredServiceOrder(newOrder);
        newOrder.clear();
        newOrder = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void cancel(boolean dispatch) {
        if (dispatch) {
            this.dispatchEvent(new WindowEvent(this, 201));
            return;
        }
        if (!this.newServices.isEmpty()) {
            Iterator itr = this.newServices.iterator();
            while (itr.hasNext()) {
                Object next = itr.next();
                String serviceName = next.toString().trim().toUpperCase();
                try {
                    if (this.provider.deregisterService(serviceName)) continue;
                }
                catch (IllegalArgumentException iae) {
                    BasicUtilities.HandleException(iae, BasicUtilities.getString("Service_Register_Error"));
                }
            }
        }
        this.newServices.clear();
        this.toBeSaved.clear();
        this.toBeDeleted.clear();
    }

    private void addNewService(boolean isCopy, String defaultAlias) {
        Object obj = this.jlsServices.getSelectedValue();
        ServiceDefinition service = null;
        if (obj instanceof ServiceDefinition) {
            service = (ServiceDefinition)obj;
        }
        if (isCopy && service != null) {
            service = (ServiceDefinition)service.clone();
        } else {
            Object[] values = new String[]{BasicUtilities.getString("SM_LocalService"), BasicUtilities.getString("SM_RemoteService")};
            Object o = JOptionPane.showInputDialog(this, BasicUtilities.getString("SM_Create_New_Service"), BasicUtilities.getString("SM_Choose_Service_Type"), 1, null, values, null);
            if (o == null) {
                return;
            }
            service = new ServiceDefinition(this.systemConfig.getJDBCDefaults(), true);
            if (o == values[1]) {
                service.setRemoteEnabled(true, "");
            }
        }
        String alias = defaultAlias;
        boolean isRecovering = false;
        if (isCopy) {
            alias = this.createUniqueName(defaultAlias);
        } else if (alias == null) {
            alias = Long.toHexString(SEED.nextLong()).toUpperCase();
            while (this.lazyCache.containsKey(alias)) {
                alias = Long.toHexString(SEED.nextLong()).toUpperCase();
            }
        } else {
            isRecovering = true;
        }
        service.setName(alias);
        try {
            if (this.provider.registerService(service, null)) {
                String serviceKey = alias.toUpperCase();
                this.lazyCache.put(serviceKey, service);
                this.toBeSaved.add(serviceKey);
                this.newServices.add(serviceKey);
                if (!isRecovering) {
                    this.mdlServices.addElement(service);
                    this.mdlServices.reload();
                    this.jlsServices.setSelectedIndex(this.mdlServices.size() - 1);
                } else {
                    int index = this.mdlServices.indexOf(obj);
                    this.mdlServices.setElementAt(service, index);
                    this.jlsServices.setSelectedIndex(index);
                }
            } else {
                JOptionPane.showMessageDialog(this, BasicUtilities.getString("Service_Register_Error"));
            }
        }
        catch (IllegalArgumentException iae) {
            BasicUtilities.showExceptionPopup(this, iae, iae.getMessage());
        }
    }

    private void loadServiceList() {
        this.mdlServices.clear();
        Collection services = this.provider.getRegisteredServices(true);
        Iterator itr = services.iterator();
        while (itr.hasNext()) {
            Object next = itr.next();
            if (next == null) continue;
            String svc = next.toString();
            this.mdlServices.addElement(svc);
        }
        boolean isEmpty = this.mdlServices.isEmpty();
        if (isEmpty) {
            this.jlsServices.clearSelection();
        } else {
            this.jlsServices.setSelectedIndex(0);
        }
        this.toggleActions();
        this.getRootPane().putClientProperty("windowModified", Boolean.FALSE);
    }

    private void processActionEvent(int id) {
        int index = this.jlsServices.getSelectedIndex();
        Object obj = this.jlsServices.getSelectedValue();
        ServiceDefinition service = null;
        String serviceName = null;
        if (obj instanceof ServiceDefinition) {
            service = (ServiceDefinition)obj;
            serviceName = service.getName().toUpperCase();
        } else {
            serviceName = obj != null ? ((String)obj).toUpperCase() : "";
        }
        switch (id) {
            case 10: {
                PreferencesEditor.showDialog(this, 3);
                break;
            }
            case 7: {
                if (this.toBeDeleted.contains(serviceName)) break;
                this.toBeDeleted.add(serviceName);
                this.jtpServiceEditor.setSelectedIndex(0);
                break;
            }
            case 2: {
                this.mdlServices.moveDown(index);
                this.jlsServices.setSelectedIndex(Math.min(index + 1, this.mdlServices.getSize()));
                break;
            }
            case 1: {
                this.mdlServices.moveUP(index);
                this.jlsServices.setSelectedIndex(Math.max(index - 1, 0));
                break;
            }
            case 9: {
                if (!this.toBeDeleted.contains(serviceName)) break;
                this.toBeDeleted.remove(serviceName);
                break;
            }
            case 11: {
                this.cancel(false);
                try {
                    this.provider.detectServices();
                }
                catch (Throwable t) {
                    BasicUtilities.showExceptionPopup(this, t, t.getMessage());
                }
                this.loadServiceList();
            }
            case 4: {
                this.applyChanges(service, true);
                break;
            }
            case 6: 
            case 8: {
                String alias = id == 6 ? serviceName : null;
                this.addNewService(id == 6, alias);
                break;
            }
            case 5: {
                this.dispatchEvent(new WindowEvent(this, 201));
                break;
            }
            case 0: {
                if (service != null) {
                    this.applyChanges(service, true);
                }
                this.dispose();
                this.storeServiceList();
                break;
            }
            case 13: {
                this.showPropertyEditor();
                break;
            }
            case 3: {
                this.applyChanges(service, false);
                this.testService();
                break;
            }
            default: {
                this.markChanged();
            }
        }
        this.toggleActions();
        this.mdlServices.reload(index);
    }

    private void toggleActions() {
        int index = this.jlsServices.getSelectedIndex();
        Object obj = this.jlsServices.getSelectedValue();
        String serviceName = null;
        if (obj == null || index < 0) {
            this.btnUndelete.setEnabled(false);
            this.btnDeleteSv.setEnabled(false);
            this.btnCopy.setEnabled(false);
            this.btnMoveUp.setEnabled(false);
            this.btnMoveDn.setEnabled(false);
            this.btnApply.setEnabled(false);
            this.btnTest.setEnabled(false);
            this.localEditor.setEditable(false);
            this.remoteEditor.setEditable(false);
            this.jtpServiceEditor.setEnabledAt(0, false);
            this.jtpServiceEditor.setEnabledAt(1, false);
            this.jtpServiceEditor.setEnabledAt(2, false);
        } else {
            serviceName = obj instanceof ServiceDefinition ? ((ServiceDefinition)obj).getName().toUpperCase() : ((String)obj).toUpperCase();
            this.btnUndelete.setEnabled(this.toBeDeleted.contains(serviceName));
            this.btnDeleteSv.setEnabled(!this.btnUndelete.isEnabled());
            boolean canDelete = this.btnDeleteSv.isEnabled();
            boolean isEdited = canDelete ? this.toBeSaved.contains(serviceName) : false;
            int size = this.mdlServices.getSize();
            this.btnCopy.setEnabled(index >= 0 && index < size && canDelete);
            this.btnMoveUp.setEnabled(index >= 1 && canDelete);
            this.btnMoveDn.setEnabled(index < size - 1 && canDelete);
            this.btnApply.setEnabled(isEdited && canDelete);
            this.btnTest.setEnabled(canDelete);
            this.localEditor.setEditable(canDelete);
            this.remoteEditor.setEditable(canDelete);
            this.jtpServiceEditor.setEnabledAt(0, canDelete);
            this.jtpServiceEditor.setEnabledAt(1, canDelete);
            this.jtpServiceEditor.setEnabledAt(2, canDelete);
        }
    }

    private void applyChanges(ServiceDefinition service, boolean persist) {
        URL[] x;
        if (service == null) {
            BasicUtilities.beep();
            return;
        }
        String before = service.getName().trim().toUpperCase();
        if (service.isRemote()) {
            this.remoteEditor.applyChange(service);
            x = this.jflResources.getResources();
            service.setRemoteProperty("local-resources", new ArrayList<URL>(Arrays.asList(x)));
        } else {
            this.localEditor.applyChange(service);
            this.advancedEditor.applyChanges(service);
            x = this.jflResources.getResources();
            service.setResourceList(new ArrayList<URL>(Arrays.asList(x)));
        }
        String name = service.getName();
        this.setTitle(BasicUtilities.getString("Service_Manager_Title", name));
        this.jflResources.setBorder(new TitledBorder(BasicUtilities.getString("Resource_Pane_Title", name)));
        if (persist) {
            try {
                this.toBeSaved.remove(before);
                this.newServices.remove(before);
                if (!this.provider.saveService(service)) {
                    String msg = BasicUtilities.getString("Service_Failed_to_Save");
                    BasicUtilities.beep();
                    JOptionPane.showMessageDialog(this, msg, "", 2);
                }
            }
            catch (Throwable t) {
                BasicUtilities.showExceptionPopup(this, t, t.getMessage());
            }
        }
    }

    private ServiceDefinition loadService(String svc) {
        if (this.lazyCache.containsKey(svc = svc.toUpperCase())) {
            return (ServiceDefinition)this.lazyCache.get(svc);
        }
        try {
            ServiceDefinition lservice = this.provider.serviceForName(svc, false);
            this.lazyCache.put(svc.toUpperCase(), lservice);
            return lservice;
        }
        catch (Throwable t) {
            int x = JOptionPane.showConfirmDialog(this, BasicUtilities.getString("Service_Load_Error_Auto_Make", svc), "", 0, 3);
            if (x == 0) {
                this.addNewService(false, svc);
                return (ServiceDefinition)this.lazyCache.get(svc.toUpperCase());
            }
            this.provider.deregisterService(svc);
            return null;
        }
    }

    private void showPropertyEditor() {
        if (this.isLoadingService) {
            return;
        }
        Object o = this.jlsServices.getSelectedValue();
        if (o == null) {
            return;
        }
        ServiceDefinition service = null;
        if (!(o instanceof ServiceDefinition)) {
            return;
        }
        service = (ServiceDefinition)o;
        if (service != null) {
            this.applyChanges(service, false);
            if (DriverPropertyEditor.showDialog(this, service)) {
                this.markChanged();
            }
        } else {
            BasicUtilities.beep();
        }
    }

    private String createUniqueName(String name) {
        if (!this.lazyCache.containsKey(name.toUpperCase()) && !this.mdlServices.contains(name)) {
            return name;
        }
        int i = 0;
        String alias = BasicUtilities.getString("Service_Copy_Template", new String[]{name, ""});
        while (this.lazyCache.containsKey(alias)) {
            alias = BasicUtilities.getString("Service_Copy_Template", new String[]{name, "(" + ++i + ")"});
        }
        return alias.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markChanged() {
        if (this.isLoadingService) {
            return;
        }
        int index = this.jlsServices.getSelectedIndex();
        Object o = this.jlsServices.getSelectedValue();
        if (o == null) {
            return;
        }
        ServiceDefinition service = null;
        String serviceName = null;
        if (o instanceof ServiceDefinition) {
            service = (ServiceDefinition)o;
            serviceName = service.getName().trim().toUpperCase();
        } else {
            serviceName = o.toString().trim().toUpperCase();
        }
        if (!this.toBeSaved.contains(serviceName)) {
            Vector vector = this.toBeSaved;
            synchronized (vector) {
                this.toBeSaved.add(serviceName);
                this.mdlServices.reload(index);
                this.toggleActions();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void testService() {
        block24: {
            block23: {
                block22: {
                    service = (ServiceDefinition)this.jlsServices.getSelectedValue();
                    if (service == null) {
                        BasicUtilities.beep();
                        return;
                    }
                    db = null;
                    p = null;
                    service.close();
                    try {
                        db = service.createConnection();
                    }
                    catch (ClassNotFoundException cnfe) {
                        p = new String[]{service.getDriverClass()};
                        err = BasicUtilities.getString("Driver_Registration_Error", p);
                        BasicUtilities.showExceptionPopup(this, cnfe, err);
                        return;
                    }
                    catch (SQLException sqle) {
                        p = new String[]{service.getDriverClass(), service.getURL()};
                        err = BasicUtilities.getString("Service_URL_Error", p);
                        BasicUtilities.showExceptionPopup(this, sqle, err);
                        if (db != null && db.getVerboseOn()) {
                            BasicUtilities.HandleException(sqle, err, db.getDebugOn());
                        }
                        return;
                    }
                    catch (Throwable t) {
                        p = new String[]{service.getName()};
                        err = BasicUtilities.getString("Service_Creation_Error", p);
                        BasicUtilities.showExceptionPopup(this, t, err);
                        BasicUtilities.HandleException(t, err);
                        return;
                    }
                    if (db == null) {
                        return;
                    }
                    if (!service.isPromptRequired()) ** GOTO lbl46
                    frm = (Frame)SwingUtilities.getAncestorOfClass(ServiceManager.class$java$awt$Frame == null ? (ServiceManager.class$java$awt$Frame = ServiceManager.class$("java.awt.Frame")) : ServiceManager.class$java$awt$Frame, this);
                    res = LoginOptionPane.showDialog(frm);
                    if (res != null) break block22;
                    JOptionPane.showMessageDialog(this, BasicUtilities.getString("Service_Creation_Failed", service.getName()));
                    try {
                        db.disconnect();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    return;
                }
                db.updateAutheticationTokens(res[0], res[1]);
lbl46:
                // 2 sources

                if (db.initialize()) {
                    JOptionPane.showMessageDialog(this, BasicUtilities.getString("Service_Created", service.getName()));
                    break block23;
                }
                JOptionPane.showMessageDialog(this, BasicUtilities.getString("Service_Creation_Failed", service.getName()));
            }
            try {
                db.disconnect();
            }
            catch (Throwable t) {}
            break block24;
            catch (Throwable t) {
                try {
                    p = new String[]{service.getName()};
                    err = BasicUtilities.getString("Service_Creation_Error", p);
                    BasicUtilities.showExceptionPopup(this, t, err);
                    return;
                }
                catch (Throwable var7_16) {
                    throw var7_16;
                }
                finally {
                    try {
                        db.disconnect();
                    }
                    catch (Throwable t) {}
                }
            }
        }
        service = null;
    }

    private static void constrain(int x, int y, int w, int h, double wx, double wy, int a, int f) {
        ServiceManager.UI_CONSTRAINT.gridx = x;
        ServiceManager.UI_CONSTRAINT.gridy = y;
        ServiceManager.UI_CONSTRAINT.gridwidth = w;
        ServiceManager.UI_CONSTRAINT.gridheight = h;
        ServiceManager.UI_CONSTRAINT.weightx = wx;
        ServiceManager.UI_CONSTRAINT.weighty = wy;
        ServiceManager.UI_CONSTRAINT.anchor = a;
        ServiceManager.UI_CONSTRAINT.fill = f;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class AdvancedServiceEditor
    extends JPanel
    implements ActionListener,
    FocusListener {
        private ButtonGroup grpJdbcOpts = new ButtonGroup();
        private JRadioButton rdoGlobalOpt = new JRadioButton(BasicUtilities.getString("Use_Global_Setting"));
        private JRadioButton rdoEnableOpt = new JRadioButton(BasicUtilities.getString("Enable"));
        private JRadioButton rdoDisableOpt = new JRadioButton(BasicUtilities.getString("Disable"));
        private JCheckBox chkCustProps = new JCheckBox(BasicUtilities.getString("Use_Global_JDBC_Settings"));
        private JCheckBox chkAutoCmt = new JCheckBox();
        private JCheckBox chkIsSecure = new JCheckBox();
        private JTextField txtSchema = new JTextField();
        private JComboBox cmbJdbcOpts = new JComboBox<String>(new String[]{BasicUtilities.getString("Enable_Auto_Connect_Text"), BasicUtilities.getString("Enabled_Generated_Keys"), BasicUtilities.getString("Enable_Verbose_Text"), BasicUtilities.getString("Enable_Debug_Text"), BasicUtilities.getString("Log_Queries_Text"), BasicUtilities.getString("Echo_Result_Text"), BasicUtilities.getString("Allow_Escape_Text"), BasicUtilities.getString("Enable_Reverse_Fetch_Text"), BasicUtilities.getString("Enable_JDBC_Trace_Text"), BasicUtilities.getString("LoginTimeout"), BasicUtilities.getString("QueryTimeout"), BasicUtilities.getString("MaxFldSz"), BasicUtilities.getString("MaxRows")});
        private static final String[] prefsKeys = new String[]{"jdbc.keepalive-enabled", "jdbc.resultsetkeys-enabled", "jdbc.verbose-enabled", "jdbc.debug-enabled", "jdbc.echo-query", "jdbc.echo-rowcount", "jdbc.escapeProc-enabled", "jdbc.reverseFetch-enabled", "jdbc.trace-enabled", "jdbc.timeout-login", "jdbc.timeout-query", "jdbc.max-fieldsize", "jdbc.max-rows"};
        private JNumberEditor optionEditor = new JNumberEditor(0, 6);
        private Properties currentPrefs = null;

        private AdvancedServiceEditor() {
            super(new GridBagLayout());
            this.initUI();
        }

        public void setService(ServiceDefinition service) {
            this.currentPrefs = service.getPreferences();
            if (service != null && !service.isRemote()) {
                this.txtSchema.setText(service.getPreferredSchema());
                this.chkCustProps.setEnabled(true);
                this.txtSchema.setEnabled(true);
                this.chkCustProps.setSelected(this.currentPrefs == null || this.currentPrefs.isEmpty());
                this.setAdvancedOptionEnabled(!this.chkCustProps.isSelected());
                if (!this.chkCustProps.isSelected() && this.currentPrefs != null) {
                    String s = this.currentPrefs.getProperty("jdbc.autocommit-enabled");
                    boolean b = Boolean.valueOf(s);
                    this.chkAutoCmt.setSelected(b);
                    s = this.currentPrefs.getProperty("jdbc.autocommit-enabled");
                    b = Boolean.valueOf(s);
                    this.chkAutoCmt.setSelected(b);
                    this.chkIsSecure.setSelected(service.isSecure());
                } else {
                    UserPreferences prefs = SystemConfig.getInstance().getPreferences();
                    this.chkIsSecure.setSelected(prefs.getBoolean("general.security-enabled"));
                    this.chkAutoCmt.setSelected(prefs.getBoolean("jdbc.autocommit-enabled"));
                }
            } else {
                this.setAdvancedOptionEnabled(false);
                this.chkCustProps.setEnabled(false);
                this.txtSchema.setEnabled(false);
            }
        }

        public void registerChangeListeners(ServiceSupport support) {
            this.rdoDisableOpt.addActionListener(support);
            this.rdoEnableOpt.addActionListener(support);
            this.chkCustProps.addActionListener(support);
            this.rdoGlobalOpt.addActionListener(support);
            this.chkAutoCmt.addActionListener(support);
            this.chkIsSecure.addActionListener(support);
            this.optionEditor.getDocument().addDocumentListener(support);
            this.txtSchema.getDocument().addDocumentListener(support);
        }

        public void applyChanges(ServiceDefinition service) {
            if (service != null) {
                service.setPreferredSchema(this.txtSchema.getText());
                if (this.chkCustProps.isSelected()) {
                    service.setPreferences(null);
                    SystemConfig sysConfig = SystemConfig.getInstance();
                    UserPreferences prefs = sysConfig.getPreferences();
                    service.setSecurityEnabled(prefs.getBoolean("general.security-enabled"));
                } else {
                    if (this.currentPrefs == null) {
                        this.currentPrefs = new Properties(null);
                    }
                    String value = Boolean.toString(this.chkAutoCmt.isSelected());
                    this.currentPrefs.setProperty("jdbc.autocommit-enabled", value);
                    service.setPreferences(this.currentPrefs);
                    service.setSecurityEnabled(this.chkIsSecure.isSelected());
                }
            }
        }

        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            int index = this.cmbJdbcOpts.getSelectedIndex();
            if (src == this.chkCustProps) {
                this.setAdvancedOptionEnabled(!this.chkCustProps.isSelected());
            } else if (src == this.cmbJdbcOpts) {
                if (this.currentPrefs == null) {
                    this.currentPrefs = new Properties(null);
                }
                boolean isBooleanOpt = index <= prefsKeys.length - 4;
                String property = prefsKeys[index];
                this.rdoDisableOpt.setEnabled(isBooleanOpt);
                if (!this.currentPrefs.containsKey(property)) {
                    this.rdoGlobalOpt.setSelected(true);
                    this.optionEditor.setEnabled(false);
                    this.optionEditor.setText("0");
                } else if (isBooleanOpt) {
                    this.optionEditor.setEnabled(false);
                    boolean value = Boolean.valueOf(this.currentPrefs.getProperty(property));
                    if (value) {
                        this.rdoEnableOpt.setSelected(true);
                    } else {
                        this.rdoDisableOpt.setSelected(true);
                    }
                    this.optionEditor.setEnabled(false);
                    this.optionEditor.setText("0");
                } else {
                    this.rdoEnableOpt.setSelected(true);
                    this.optionEditor.setEnabled(true);
                    this.optionEditor.setText(this.currentPrefs.getProperty(property, ""));
                }
            } else if (src == this.rdoGlobalOpt) {
                if (this.currentPrefs != null) {
                    String property = prefsKeys[index];
                    this.currentPrefs.remove(property);
                    this.optionEditor.setEnabled(false);
                    this.optionEditor.setText("0");
                }
            } else if (src == this.rdoEnableOpt) {
                if (this.currentPrefs == null) {
                    this.currentPrefs = new Properties(null);
                }
                boolean isBooleanOpt = index <= prefsKeys.length - 4;
                String property = prefsKeys[index];
                if (isBooleanOpt) {
                    this.currentPrefs.setProperty(property, Boolean.toString(true));
                } else {
                    this.optionEditor.setEnabled(true);
                }
            } else if (src == this.rdoDisableOpt) {
                if (this.currentPrefs == null) {
                    this.currentPrefs = new Properties(null);
                }
                boolean isBooleanOpt = index <= prefsKeys.length - 4;
                String property = prefsKeys[index];
                if (isBooleanOpt) {
                    this.currentPrefs.setProperty(property, Boolean.toString(false));
                } else {
                    this.optionEditor.setEnabled(false);
                    this.optionEditor.setText("0");
                    this.currentPrefs.setProperty(property, "0");
                }
            } else if (src == this.chkAutoCmt || src == this.chkIsSecure) {
                // empty if block
            }
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            if (this.currentPrefs == null) {
                this.currentPrefs = new Properties(null);
            }
            int index = this.cmbJdbcOpts.getSelectedIndex();
            String property = prefsKeys[index];
            this.currentPrefs.setProperty(property, this.optionEditor.getText());
        }

        private void setAdvancedOptionEnabled(boolean f) {
            this.rdoGlobalOpt.setEnabled(f);
            this.rdoEnableOpt.setEnabled(f);
            this.rdoDisableOpt.setEnabled(f);
            this.cmbJdbcOpts.setEnabled(f);
            this.chkIsSecure.setEnabled(f);
            this.chkAutoCmt.setEnabled(f);
            this.optionEditor.setEnabled(false);
        }

        private void initUI() {
            this.chkAutoCmt.addActionListener(this);
            this.chkAutoCmt.setText(BasicUtilities.getString("Auto_Commit_On_Close"));
            this.chkAutoCmt.setToolTipText(BasicUtilities.getString("Auto_Commit_On_Close_Tip"));
            this.chkIsSecure.addActionListener(this);
            this.chkIsSecure.setText(BasicUtilities.getString("Is_Service_Secure"));
            this.chkIsSecure.setToolTipText(BasicUtilities.getString("Is_Service_Secure_Tip"));
            this.txtSchema.setToolTipText(BasicUtilities.getString("Choose_Preffered_Schema_Tip"));
            this.rdoGlobalOpt.addActionListener(this);
            this.rdoEnableOpt.addActionListener(this);
            this.rdoDisableOpt.addActionListener(this);
            this.cmbJdbcOpts.addActionListener(this);
            this.chkCustProps.addActionListener(this);
            this.grpJdbcOpts.add(this.rdoGlobalOpt);
            this.grpJdbcOpts.add(this.rdoEnableOpt);
            this.grpJdbcOpts.add(this.rdoDisableOpt);
            this.optionEditor.setEnabled(false);
            this.optionEditor.addFocusListener(this);
            JLabel lbl = null;
            ServiceManager.constrain(0, 0, 1, 10, 0.0, 0.0, 17, 0);
            this.add(Box.createHorizontalStrut(12), UI_CONSTRAINT);
            ServiceManager.constrain(1, 0, 3, 1, 0.0, 0.0, 17, 0);
            this.add(Box.createVerticalStrut(6), UI_CONSTRAINT);
            lbl = new JLabel(BasicUtilities.getString("Choose_Preffered_Schema"));
            ServiceManager.constrain(1, 1, 1, 1, 0.0, 0.0, 17, 2);
            this.add((Component)lbl, UI_CONSTRAINT);
            ServiceManager.constrain(2, 1, 2, 1, 1.0, 0.0, 17, 2);
            this.add((Component)this.txtSchema, UI_CONSTRAINT);
            ServiceManager.constrain(1, 2, 3, 1, 1.0, 0.0, 17, 0);
            this.add((Component)this.chkCustProps, UI_CONSTRAINT);
            ServiceManager.constrain(1, 3, 1, 1, 0.0, 0.0, 17, 0);
            lbl = new JLabel(BasicUtilities.getString("Select_JDBC_Option"));
            this.add((Component)lbl, UI_CONSTRAINT);
            ServiceManager.constrain(1, 4, 2, 1, 0.0, 0.0, 17, 0);
            this.add((Component)this.cmbJdbcOpts, UI_CONSTRAINT);
            ServiceManager.constrain(1, 5, 1, 1, 0.0, 0.0, 17, 0);
            this.add((Component)this.rdoGlobalOpt, UI_CONSTRAINT);
            ServiceManager.constrain(2, 5, 1, 1, 0.0, 0.0, 17, 0);
            this.add((Component)this.rdoEnableOpt, UI_CONSTRAINT);
            ServiceManager.constrain(3, 5, 1, 1, 0.0, 0.0, 17, 0);
            this.add((Component)this.rdoDisableOpt, UI_CONSTRAINT);
            ServiceManager.constrain(2, 6, 1, 1, 1.0, 0.0, 17, 2);
            this.add((Component)this.optionEditor, UI_CONSTRAINT);
            ServiceManager.constrain(1, 7, 2, 1, 0.0, 0.0, 17, 0);
            this.add((Component)this.chkIsSecure, UI_CONSTRAINT);
            ServiceManager.constrain(1, 8, 2, 1, 0.0, 0.0, 17, 0);
            this.add((Component)this.chkAutoCmt, UI_CONSTRAINT);
            ServiceManager.constrain(1, 9, 3, 1, 0.0, 1.0, 17, 3);
            this.add(Box.createVerticalGlue(), UI_CONSTRAINT);
            ServiceManager.constrain(4, 0, 1, 10, 1.0, 0.0, 17, 2);
            this.add(Box.createHorizontalGlue(), UI_CONSTRAINT);
        }
    }

    private static class LocalServiceEditor
    extends JPanel
    implements ActionListener,
    DocumentListener {
        private DefaultComboBoxModel mdlDrivers = new DefaultComboBoxModel();
        private JComboBox cmbDrivers = new JComboBox(this.mdlDrivers);
        private JTextField txtAlias = new JTextField();
        private JTextField txtURL = new JTextField();
        private JTextField txtUser = new JTextField();
        private JTextField txtDriver = (JTextField)this.cmbDrivers.getEditor().getEditorComponent();
        private JTextField txtURLExample = new JTextField();
        private JPasswordField txtPassword = new JPasswordField(16);
        private JCheckBox chkUseXProps = new JCheckBox("", false);
        private JCheckBox chkUsePrompt = new JCheckBox("", false);
        private JButton btnXtendEdit = new JButton(BasicUtilities.getString("Elipsis"));
        private ClassListCellRenderer classRenderer = new ClassListCellRenderer();
        private Properties drivers = SystemConfig.getInstance().getDriverDefinitions();
        private boolean passwordUpdated = false;
        private boolean isInitializing = false;

        public LocalServiceEditor() {
            super(new GridBagLayout());
            try {
                this.initUI();
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t, "LocalServiceEditor::initUI()");
            }
        }

        public void setEditable(boolean f) {
            this.txtAlias.setEnabled(f);
            this.cmbDrivers.setEnabled(f);
            this.txtURL.setEnabled(f);
            this.txtUser.setEnabled(f);
            this.txtPassword.setEnabled(f);
            this.chkUseXProps.setEnabled(f);
            this.chkUsePrompt.setEnabled(f);
            this.btnXtendEdit.setEnabled(f);
            if (f) {
                this.txtPassword.setEnabled(!this.chkUsePrompt.isSelected());
                this.txtUser.setEnabled(!this.chkUsePrompt.isSelected());
                this.btnXtendEdit.setEnabled(this.chkUseXProps.isSelected());
            }
        }

        public void applyResourceChanges(ServiceDefinition service) {
            if (service != null) {
                SystemConfig sysConfig = SystemConfig.getInstance();
                UserPreferences prefs = sysConfig.getPreferences();
                ClassLoader classLoader = service.getClassLoader();
                this.classRenderer.setClassLoader(service.getClassLoader());
                if (prefs.getBoolean("general.alldrivers-visible")) {
                    boolean doSort = prefs.getBoolean("general.driversort-enabled");
                    Iterator<Object> itr = this.drivers.keySet().iterator();
                    Object[] keys = doSort ? new Object[this.mdlDrivers.getSize()] : null;
                    this.mdlDrivers.removeAllElements();
                    int i = 0;
                    while (itr.hasNext()) {
                        Object next = itr.next();
                        String clazz = next.toString();
                        try {
                            Class.forName(clazz, false, classLoader);
                        }
                        catch (ClassNotFoundException cnfe) {
                            continue;
                        }
                        if (doSort) {
                            keys[i++] = clazz;
                        }
                        this.mdlDrivers.addElement(clazz);
                    }
                    if (doSort) {
                        Arrays.sort(keys, String.CASE_INSENSITIVE_ORDER);
                    }
                    this.drivers = null;
                    itr = null;
                    classLoader = null;
                    for (i = 0; i < keys.length; ++i) {
                        this.mdlDrivers.addElement(keys[i]);
                    }
                    keys = null;
                }
            }
        }

        public void updateAuthentication() {
            this.txtUser.setEnabled(!this.chkUsePrompt.isSelected());
            this.txtPassword.setEnabled(!this.chkUsePrompt.isSelected());
        }

        public void registerChangeListeners(ServiceSupport support) {
            this.btnXtendEdit.addActionListener(support);
            this.chkUsePrompt.addActionListener(support);
            this.chkUseXProps.addActionListener(support);
            this.cmbDrivers.addActionListener(support);
            this.txtAlias.addFocusListener(support);
            this.txtUser.getDocument().addDocumentListener(support);
            this.txtURL.getDocument().addDocumentListener(support);
            this.txtPassword.getDocument().addDocumentListener(support);
            this.txtDriver.getDocument().addDocumentListener(support);
            this.txtAlias.getDocument().addDocumentListener(support);
        }

        public void applyChange(ServiceDefinition service) {
            service.setDriverClass((String)this.cmbDrivers.getSelectedItem());
            service.setURL(this.txtURL.getText());
            if (this.chkUsePrompt.isSelected()) {
                service.setUserName(null);
                service.setPassword(null);
            } else {
                service.setUserName(this.txtUser.getText());
                if (this.passwordUpdated) {
                    String password = new String(this.txtPassword.getPassword());
                    service.setPassword(password);
                }
            }
            if (!this.chkUseXProps.isSelected()) {
                service.setProperties(null);
            }
        }

        public void setService(ServiceDefinition service) {
            this.isInitializing = true;
            if (service == null) {
                if (this.mdlDrivers.getSize() >= 1) {
                    this.cmbDrivers.setSelectedIndex(0);
                }
                this.txtAlias.setText("");
                this.txtURL.setText("");
                this.chkUsePrompt.setSelected(false);
                this.txtUser.setText("");
                this.txtPassword.setText("");
                this.txtPassword.setEnabled(true);
                this.txtUser.setEnabled(true);
                this.chkUseXProps.setSelected(false);
                this.passwordUpdated = false;
            } else {
                this.txtAlias.setText(service.getName());
                this.txtURL.setText(service.getURL());
                this.chkUsePrompt.setSelected(service.isPromptRequired());
                this.cmbDrivers.setSelectedItem(service.getDriverClass());
                if (this.chkUsePrompt.isSelected()) {
                    this.txtUser.setText("");
                } else {
                    this.txtUser.setText(service.getUserName());
                }
                this.txtPassword.setText("");
                this.txtPassword.setEnabled(!this.chkUsePrompt.isSelected());
                this.txtUser.setEnabled(!this.chkUsePrompt.isSelected());
                Properties p = service.getProperties();
                this.chkUseXProps.setSelected(p != null && !p.isEmpty());
                this.btnXtendEdit.setEnabled(this.chkUseXProps.isSelected());
                this.passwordUpdated = false;
            }
            this.isInitializing = false;
        }

        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            this.txtUser.setEnabled(!this.chkUsePrompt.isSelected());
            this.txtPassword.setEnabled(!this.chkUsePrompt.isSelected());
            this.btnXtendEdit.setEnabled(this.chkUseXProps.isSelected());
            if (src == this.cmbDrivers) {
                String driver = (String)this.cmbDrivers.getSelectedItem();
                this.txtURLExample.setText(this.drivers.getProperty(driver == null ? "" : driver, ""));
                this.txtURLExample.setCaretPosition(0);
            }
        }

        public void changedUpdate(DocumentEvent event) {
            this.checkPasswordUpdate(event);
        }

        public void insertUpdate(DocumentEvent event) {
            this.checkPasswordUpdate(event);
        }

        public void removeUpdate(DocumentEvent event) {
            this.checkPasswordUpdate(event);
        }

        private void checkPasswordUpdate(DocumentEvent evt) {
            Document doc = evt.getDocument();
            if (this.isInitializing) {
                return;
            }
            if (doc == this.txtPassword.getDocument()) {
                this.passwordUpdated = true;
            }
        }

        private void initUI() {
            this.chkUseXProps.setText(BasicUtilities.getString("Extended_Properties"));
            this.chkUseXProps.setToolTipText(BasicUtilities.getString("Extended_Properties_Tip"));
            this.chkUsePrompt.setText(BasicUtilities.getString("SERV_Auth_Prompt"));
            this.chkUsePrompt.setToolTipText(BasicUtilities.getString("SERV_Auth_Prompt_Tip"));
            this.btnXtendEdit.setToolTipText(BasicUtilities.getString("Extended_Properties_Tip"));
            this.txtURLExample.setEditable(false);
            this.txtPassword.getDocument().addDocumentListener(this);
            this.btnXtendEdit.setPreferredSize(new Dimension(16, 16));
            BasicUtilities.lockComponentToPerferredSize(this.btnXtendEdit);
            this.btnXtendEdit.setEnabled(false);
            this.btnXtendEdit.setActionCommand(Integer.toString(13));
            this.cmbDrivers.setEditable(true);
            this.cmbDrivers.setRenderer(this.classRenderer);
            this.cmbDrivers.setMaximumRowCount(5);
            this.cmbDrivers.addActionListener(this);
            BasicUtilities.localizeTextComponent(this.txtAlias, null);
            BasicUtilities.localizeTextComponent(this.txtDriver, null);
            BasicUtilities.localizeTextComponent(this.txtURLExample, null);
            BasicUtilities.localizeTextComponent(this.txtURL, null);
            BasicUtilities.localizeTextComponent(this.txtUser, null);
            BasicUtilities.localizeTextComponent(this.txtPassword, null);
            this.txtAlias.addActionListener(this);
            this.chkUsePrompt.addActionListener(this);
            this.chkUseXProps.addActionListener(this);
            this.btnXtendEdit.addActionListener(this);
            ServiceManager.constrain(0, 0, 1, 10, 0.0, 0.0, 10, 0);
            this.add(Box.createHorizontalStrut(12), UI_CONSTRAINT);
            ServiceManager.constrain(1, 0, 3, 1, 0.0, 0.0, 10, 0);
            this.add(Box.createVerticalStrut(6), UI_CONSTRAINT);
            JLabel lbl = new JLabel(BasicUtilities.getString("SERV_Name_Label"));
            ServiceManager.constrain(1, 1, 2, 1, 0.0, 0.0, 13, 0);
            this.add((Component)lbl, UI_CONSTRAINT);
            lbl = new JLabel(BasicUtilities.getString("SERV_Driver_Label"));
            ServiceManager.constrain(1, 2, 1, 1, 0.0, 0.0, 13, 0);
            this.add((Component)lbl, UI_CONSTRAINT);
            lbl = new JLabel(BasicUtilities.getString("SERV_Ex_URL_Label"));
            ServiceManager.constrain(1, 3, 1, 1, 0.0, 0.0, 13, 0);
            this.add((Component)lbl, UI_CONSTRAINT);
            lbl = new JLabel(BasicUtilities.getString("SERV_URL_Label"));
            ServiceManager.constrain(1, 4, 1, 1, 0.0, 0.0, 13, 0);
            this.add((Component)lbl, UI_CONSTRAINT);
            lbl = new JLabel(BasicUtilities.getString("SERV_User_Label"));
            ServiceManager.constrain(1, 5, 1, 1, 0.0, 0.0, 13, 0);
            this.add((Component)lbl, UI_CONSTRAINT);
            lbl = new JLabel(BasicUtilities.getString("SERV_Pass_Label"));
            ServiceManager.constrain(1, 6, 1, 1, 0.0, 0.0, 13, 0);
            this.add((Component)lbl, UI_CONSTRAINT);
            ServiceManager.constrain(3, 1, 2, 1, 1.0, 0.0, 10, 2);
            this.add((Component)this.txtAlias, UI_CONSTRAINT);
            ServiceManager.constrain(2, 2, 3, 1, 1.0, 0.0, 10, 2);
            this.add((Component)this.cmbDrivers, UI_CONSTRAINT);
            ServiceManager.constrain(2, 3, 3, 1, 1.0, 0.0, 10, 2);
            this.add((Component)this.txtURLExample, UI_CONSTRAINT);
            ServiceManager.constrain(2, 4, 3, 1, 1.0, 0.0, 10, 2);
            this.add((Component)this.txtURL, UI_CONSTRAINT);
            ServiceManager.constrain(2, 5, 3, 1, 1.0, 0.0, 10, 2);
            this.add((Component)this.txtUser, UI_CONSTRAINT);
            ServiceManager.constrain(2, 6, 3, 1, 1.0, 0.0, 10, 2);
            this.add((Component)this.txtPassword, UI_CONSTRAINT);
            ServiceManager.constrain(4, 7, 1, 1, 0.0, 0.0, 17, 0);
            this.add((Component)this.btnXtendEdit, UI_CONSTRAINT);
            ServiceManager.constrain(2, 7, 2, 1, 0.0, 0.0, 17, 0);
            this.add((Component)this.chkUseXProps, UI_CONSTRAINT);
            ServiceManager.constrain(2, 8, 2, 1, 0.0, 0.0, 17, 0);
            this.add((Component)this.chkUsePrompt, UI_CONSTRAINT);
            ServiceManager.constrain(5, 0, 1, 10, 0.0, 1.0, 10, 0);
            this.add(Box.createHorizontalStrut(12), UI_CONSTRAINT);
            ServiceManager.constrain(1, 9, 4, 1, 1.0, 0.0, 10, 0);
            this.add(Box.createVerticalStrut(6), UI_CONSTRAINT);
            SystemConfig sysConfig = SystemConfig.getInstance();
            UserPreferences prefs = sysConfig.getPreferences();
            if (!prefs.getBoolean("general.alldrivers-visible")) {
                boolean doSort = prefs.getBoolean("general.driversort-enabled");
                Object[] keys = this.drivers.keySet().toArray();
                this.mdlDrivers.removeAllElements();
                if (doSort) {
                    Arrays.sort(keys, String.CASE_INSENSITIVE_ORDER);
                }
                for (int i = 0; i < keys.length; ++i) {
                    this.mdlDrivers.addElement(keys[i]);
                }
                keys = null;
            }
            sysConfig = null;
            prefs = null;
        }
    }

    private static class RemoteServiceEditor
    extends JPanel {
        private JLabel lblVersion = new JLabel();
        private JTextField lblURL = new JTextField();
        private JTextField txtURL = new JTextField();
        private JTextField txtAlias = new JTextField();
        private JButton btnLocalize = new JButton(BasicUtilities.loadIconResource("Server16"));
        private JButton btnRefresh = new JButton(BasicUtilities.loadIconResource("Refresh16"));
        private DateFormat fmt = DateFormat.getDateTimeInstance(2, 3);

        public RemoteServiceEditor() {
            super(new GridBagLayout());
            try {
                this.initUI();
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t, "RemoteServiceEditor::initUI()");
            }
        }

        public void registerChangeListeners(ServiceSupport support) {
            this.txtAlias.addFocusListener(support);
            this.txtAlias.getDocument().addDocumentListener(support);
            this.txtURL.getDocument().addDocumentListener(support);
        }

        public void setEditable(boolean f) {
            this.txtAlias.setEnabled(f);
            this.txtURL.setEnabled(f);
            this.btnLocalize.setEnabled(f);
            this.btnRefresh.setEnabled(f);
        }

        public void setService(ServiceDefinition service) {
            if (service == null || !service.isRemote()) {
                BasicUtilities.beep();
            }
            this.txtAlias.setText(service.getName());
            this.lblURL.setText(service.getURL());
            try {
                long l = Long.parseLong((String)service.getRemoteConfig("version"));
                this.lblVersion.setText(this.fmt.format(new Date(l)));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.txtURL.setText((String)service.getRemoteConfig("url"));
        }

        public void applyChange(ServiceDefinition service) {
            if (service == null || !service.isRemote()) {
                BasicUtilities.beep();
            }
            String alias = this.txtAlias.getText().trim();
            String name = service.getName();
            if (!name.equalsIgnoreCase(alias)) {
                ServiceProvider provider = SystemConfig.getInstance().getServiceProvider();
                try {
                    if (provider.removeService(name)) {
                        provider.registerService(alias, null);
                    }
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }
            service.setName(alias);
            service.setRemoteProperty("url", this.txtURL.getText());
        }

        private void initUI() {
            BasicUtilities.localizeTextComponent(this.txtAlias, null);
            BasicUtilities.localizeTextComponent(this.txtURL, null);
            BasicUtilities.localizeTextComponent(this.lblURL, null);
            this.lblURL.setEditable(false);
            this.btnRefresh.setToolTipText(BasicUtilities.getString("Service_Refresh_Tip"));
            this.btnRefresh.setHorizontalAlignment(0);
            this.btnRefresh.setFocusPainted(false);
            this.btnRefresh.setActionCommand(Integer.toString(12));
            this.btnLocalize.setToolTipText(BasicUtilities.getString("Service_Localize_Tip"));
            this.btnLocalize.setHorizontalAlignment(0);
            this.btnLocalize.setFocusPainted(false);
            ServiceManager.constrain(0, 0, 1, 10, 0.0, 0.0, 10, 0);
            this.add(Box.createHorizontalStrut(12), UI_CONSTRAINT);
            ServiceManager.constrain(1, 0, 3, 1, 0.0, 0.0, 10, 0);
            this.add(Box.createVerticalStrut(6), UI_CONSTRAINT);
            JLabel lbl = new JLabel(BasicUtilities.getString("Service_Version"));
            ServiceManager.constrain(1, 1, 1, 1, 0.0, 0.0, 13, 0);
            this.add((Component)lbl, UI_CONSTRAINT);
            lbl = new JLabel(BasicUtilities.getString("SERV_URL_Label"));
            ServiceManager.constrain(1, 2, 1, 1, 0.0, 0.0, 13, 0);
            this.add((Component)lbl, UI_CONSTRAINT);
            lbl = new JLabel(BasicUtilities.getString("Service_URL"));
            ServiceManager.constrain(1, 3, 1, 1, 0.0, 0.0, 13, 0);
            this.add((Component)lbl, UI_CONSTRAINT);
            lbl = new JLabel(BasicUtilities.getString("SERV_Name_Label"));
            ServiceManager.constrain(1, 4, 1, 1, 0.0, 0.0, 13, 0);
            this.add((Component)lbl, UI_CONSTRAINT);
            ServiceManager.constrain(2, 1, 1, 1, 1.0, 0.0, 17, 2);
            this.add((Component)this.lblVersion, UI_CONSTRAINT);
            ServiceManager.constrain(3, 1, 1, 1, 0.0, 0.0, 17, 0);
            this.add((Component)this.btnLocalize, UI_CONSTRAINT);
            ServiceManager.constrain(2, 2, 1, 1, 1.0, 0.0, 17, 2);
            this.add((Component)this.lblURL, UI_CONSTRAINT);
            ServiceManager.constrain(3, 2, 1, 1, 0.0, 0.0, 17, 0);
            this.add((Component)this.btnRefresh, UI_CONSTRAINT);
            ServiceManager.constrain(2, 3, 2, 1, 1.0, 0.0, 17, 2);
            this.add((Component)this.txtURL, UI_CONSTRAINT);
            ServiceManager.constrain(2, 4, 2, 1, 1.0, 0.0, 17, 2);
            this.add((Component)this.txtAlias, UI_CONSTRAINT);
            ServiceManager.constrain(1, 9, 4, 1, 1.0, 0.0, 10, 0);
            this.add(Box.createVerticalStrut(6), UI_CONSTRAINT);
            ServiceManager.constrain(4, 0, 1, 10, 0.0, 1.0, 10, 0);
            this.add(Box.createHorizontalStrut(12), UI_CONSTRAINT);
        }
    }

    private class ServiceSupport
    implements ActionListener,
    FocusListener,
    ChangeListener,
    DocumentListener,
    ListSelectionListener {
        private int lastSelection = -1;
        private boolean resourcesChanged = false;

        private ServiceSupport() {
        }

        public void syncScreen(ServiceDefinition service) {
            if (service == null) {
                BasicUtilities.beep();
            } else {
                ServiceManager.this.jflResources.setResources(service.getResourceURLs());
                ServiceManager.this.advancedEditor.setService(service);
                if (service.isRemote()) {
                    ServiceManager.this.remoteEditor.setService(service);
                    ServiceManager.this.pnlEditor.showCard(ServiceManager.this.remoteEditor);
                } else {
                    ServiceManager.this.localEditor.setService(service);
                    ServiceManager.this.localEditor.applyResourceChanges(service);
                    ServiceManager.this.pnlEditor.showCard(ServiceManager.this.localEditor);
                }
            }
            String name = service == null ? "" : service.getName();
            ServiceManager.this.setTitle(BasicUtilities.getString("Service_Manager_Title", name));
            ServiceManager.this.jflResources.setBorder(new TitledBorder(BasicUtilities.getString("Resource_Pane_Title", name)));
            ServiceManager.this.jtpServiceEditor.setEnabled(service != null);
            if (ServiceManager.this.toBeDeleted.contains(name.toUpperCase()) || ServiceManager.this.prefs.getBoolean("servicemanager.switchtab-enabled")) {
                ServiceManager.this.jtpServiceEditor.setSelectedIndex(0);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void valueChanged(ListSelectionEvent e) {
            ServiceDefinition service;
            int index;
            block8: {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                index = ServiceManager.this.jlsServices.getSelectedIndex();
                Object o = null;
                service = null;
                if (this.lastSelection >= 0 && index != this.lastSelection) {
                    try {
                        service = (ServiceDefinition)ServiceManager.this.mdlServices.get(this.lastSelection);
                        ServiceManager.this.applyChanges(service, false);
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                o = ServiceManager.this.jlsServices.getSelectedValue();
                ServiceManager.this.isLoadingService = true;
                if (o instanceof String) {
                    String alias = o;
                    service = ServiceManager.this.loadService(alias);
                    if (service != null) {
                        ServiceManager.this.mdlServices.setElementAt(service, index);
                        break block8;
                    } else {
                        ServiceManager.this.mdlServices.removeElement(o);
                        ServiceManager.this.mdlServices.reload();
                        if (!ServiceManager.this.mdlServices.isEmpty()) {
                            ServiceManager.this.jlsServices.setSelectedIndex(0);
                            return;
                        }
                        ServiceManager.this.jlsServices.clearSelection();
                        return;
                    }
                }
                service = o;
            }
            this.syncScreen(service);
            this.lastSelection = index;
            ServiceManager.this.isLoadingService = false;
            ServiceManager.this.toggleActions();
        }

        public void actionPerformed(ActionEvent e) {
            try {
                int code = -1;
                try {
                    code = Integer.parseInt(e.getActionCommand());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ServiceManager.this.processActionEvent(code);
            }
            catch (Throwable t) {
                BasicUtilities.showExceptionPopup(ServiceManager.this, t, t.getMessage());
            }
        }

        public void changedUpdate(DocumentEvent e) {
            ServiceManager.this.markChanged();
        }

        public void insertUpdate(DocumentEvent e) {
            ServiceManager.this.markChanged();
        }

        public void removeUpdate(DocumentEvent e) {
            ServiceManager.this.markChanged();
        }

        public void stateChanged(ChangeEvent e) {
            Object src = e.getSource();
            if (src == ServiceManager.this.jtpServiceEditor) {
                if (!ServiceManager.this.isLoadingService) {
                    ServiceDefinition service = (ServiceDefinition)ServiceManager.this.jlsServices.getSelectedValue();
                    if (this.resourcesChanged) {
                        if (ServiceManager.this.jtpServiceEditor.getSelectedIndex() != 2 && !service.isRemote()) {
                            URL[] x = ServiceManager.this.jflResources.getResources();
                            service.setResourceList(new ArrayList<URL>(Arrays.asList(x)));
                            ServiceManager.this.localEditor.applyResourceChanges(service);
                        }
                        this.resourcesChanged = false;
                    }
                }
            } else {
                if (src == ServiceManager.this.jflResources) {
                    this.resourcesChanged = true;
                }
                ServiceManager.this.markChanged();
            }
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            JTextComponent txt = (JTextComponent)e.getComponent();
            String alias = txt.getText().trim();
            Object o = ServiceManager.this.mdlServices.get(this.lastSelection);
            if (!(o instanceof ServiceDefinition)) {
                return;
            }
            ServiceDefinition service = (ServiceDefinition)o;
            String name = service.getName();
            if (!name.equals(alias)) {
                try {
                    if (ServiceManager.this.provider.removeService(name)) {
                        ServiceManager.this.provider.registerService(alias, null);
                        service.setName(alias);
                        String key = name.trim().toUpperCase();
                        ServiceManager.this.toBeSaved.remove(key);
                        ServiceManager.this.toBeSaved.add(alias.toUpperCase());
                        if (ServiceManager.this.newServices.contains(key)) {
                            ServiceManager.this.newServices.remove(key);
                            ServiceManager.this.newServices.add(alias.trim().toUpperCase());
                        }
                    }
                }
                catch (Throwable t) {
                    txt.setText(name);
                    service.setName(name);
                    BasicUtilities.showExceptionPopup(ServiceManager.this, t, t.getMessage());
                }
                name = service.getName();
                ServiceManager.this.setTitle(BasicUtilities.getString("Service_Manager_Title", name));
                ServiceManager.this.jflResources.setBorder(new TitledBorder(BasicUtilities.getString("Resource_Pane_Title", name)));
                ServiceManager.this.mdlServices.reload(ServiceManager.this.jlsServices.getSelectedIndex());
            }
        }
    }

    private class ServiceRenderer
    extends DefaultListCellRenderer {
        private ServiceRenderer() {
        }

        public Component getListCellRendererComponent(JList lst, Object obj, int idx, boolean sel, boolean foc) {
            ServiceDefinition service = null;
            if (obj instanceof ServiceDefinition) {
                service = (ServiceDefinition)obj;
                obj = service.getName();
            }
            super.getListCellRendererComponent((JList<?>)lst, obj, idx, sel, foc);
            obj = ((String)obj).trim().toUpperCase();
            if (service == null || !service.isRemote()) {
                this.setIcon(BasicUtilities.loadIconResource("Server16"));
            } else {
                this.setIcon(BasicUtilities.loadIconResource("WebComponent16"));
            }
            this.setEnabled(!ServiceManager.this.toBeDeleted.contains(obj));
            if (ServiceManager.this.toBeSaved.contains(obj)) {
                this.setFont(lst.getFont().deriveFont(1));
            }
            if (ServiceManager.this.newServices.contains(obj)) {
                this.setForeground(lst.getSelectionForeground());
            }
            return this;
        }
    }
}

