/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.ui.prefs;

import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import org.isqlviewer.ui.AbstractPropertyPage;
import org.isqlviewer.util.BasicUtilities;

public final class BookmarkPropertyPage
extends AbstractPropertyPage {
    private String[] locations = new String[]{BasicUtilities.getString("Bookmark_Pref_Loc_Left"), BasicUtilities.getString("Bookmark_Pref_Loc_Right")};
    private JComboBox jcbLocation = new JComboBox<String>(this.locations);
    private JCheckBox chkActivate = new JCheckBox(BasicUtilities.getString("Bookmark_Activate_Txt"));
    private JCheckBox chkWarnings = new JCheckBox(BasicUtilities.getString("Bookmark_Warning_Txt"));

    public BookmarkPropertyPage() {
        try {
            this.initUI();
        }
        catch (Throwable t) {
            BasicUtilities.HandleException(t, "PropertiesBookmarks::initUI()");
        }
    }

    public String getPropertyPageName() {
        return BasicUtilities.getString("Bookmark_Property_Page");
    }

    public Icon getUserIcon() {
        return BasicUtilities.loadIconResource("Bookmarks16");
    }

    protected void initUI() {
        this.setLayout(new GridBagLayout());
        this.chkActivate.setToolTipText(BasicUtilities.getString("Bookmark_Activate_Tip"));
        this.chkWarnings.setToolTipText(BasicUtilities.getString("Bookmark_Warning_Tip"));
        this.jcbLocation.setToolTipText(BasicUtilities.getString("Bookmark_Pref_Loc_Tip"));
        this.setPropertyForComponent(this.chkActivate, "bookmark.activation-style");
        this.setPropertyForComponent(this.jcbLocation, "bookmark.location");
        this.setPropertyForComponent(this.chkWarnings, "bookmarks.deletewarning-enabled");
        BookmarkPropertyPage.constrain(1, 0, 2, 1, 0.0, 0.0, 10, 0);
        this.add(Box.createVerticalStrut(6), UI_CONSTRAINT);
        BookmarkPropertyPage.constrain(0, 0, 1, 5, 0.0, 0.0, 10, 0);
        this.add(Box.createHorizontalStrut(12), UI_CONSTRAINT);
        BookmarkPropertyPage.constrain(1, 1, 1, 1, 0.0, 0.0, 10, 0);
        this.add((Component)BasicUtilities.createLocalizedLabel("Bookmark_Pref_Loc", null), UI_CONSTRAINT);
        BookmarkPropertyPage.constrain(2, 1, 1, 1, 0.0, 0.0, 17, 0);
        this.add((Component)this.jcbLocation, UI_CONSTRAINT);
        BookmarkPropertyPage.constrain(1, 2, 2, 1, 0.0, 0.0, 17, 0);
        this.add((Component)this.chkActivate, UI_CONSTRAINT);
        BookmarkPropertyPage.constrain(1, 3, 2, 1, 0.0, 0.0, 17, 0);
        this.add((Component)this.chkWarnings, UI_CONSTRAINT);
        BookmarkPropertyPage.constrain(1, 4, 1, 2, 0.0, 1.0, 10, 3);
        this.add(Box.createVerticalGlue(), UI_CONSTRAINT);
        BookmarkPropertyPage.constrain(3, 0, 1, 5, 1.0, 0.0, 10, 2);
        this.add(Box.createHorizontalGlue(), UI_CONSTRAINT);
    }
}

