/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.ui.prefs;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.UIManager;
import org.isqlviewer.core.ServiceProvider;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.ui.AbstractPropertyPage;
import org.isqlviewer.ui.prefs.BookmarkPropertyPage;
import org.isqlviewer.ui.prefs.ConsolePropertyPage;
import org.isqlviewer.ui.prefs.HistoryPropertyPage;
import org.isqlviewer.ui.prefs.PrintPropertyPage;
import org.isqlviewer.util.BasicUtilities;

public final class GeneralPropertyPage
extends AbstractPropertyPage
implements ActionListener {
    private final Object[] locations = new Object[]{"North", "South", "East", "West"};
    private DefaultComboBoxModel mdlLooksFeel = new DefaultComboBoxModel();
    private ServiceProvider serviceProvider = SystemConfig.getInstance().getServiceProvider();
    private JComboBox cmbMainTbLoc = new JComboBox<Object>(this.locations);
    private JComboBox cmbCmdConLoc = new JComboBox<Object>(this.locations);
    private JComboBox cmbResultLoc = new JComboBox<Object>(this.locations);
    private JComboBox cmbLooksFeel = new JComboBox(this.mdlLooksFeel);
    private JComboBox cmbAutoService = new JComboBox<Object>(this.serviceProvider.getRegisteredServices().toArray());
    private JCheckBox chkUseLgIcon = new JCheckBox(BasicUtilities.getString("Use_Large_Icons"));
    private JCheckBox chkUseMetric = new JCheckBox(BasicUtilities.getString("User_Metric"));
    private JCheckBox chkHideFiles = new JCheckBox(BasicUtilities.getString("Show_Hidden_Files"));
    private JCheckBox chkAutoService = new JCheckBox(BasicUtilities.getString("Enable_Def_Service_Text"));
    private String[] plaf_names;
    private String[] plaf_vals;

    public GeneralPropertyPage() {
        String cLAF = UIManager.getLookAndFeel().getClass().getName();
        UIManager.LookAndFeelInfo[] lafs = UIManager.getInstalledLookAndFeels();
        this.plaf_names = new String[lafs.length];
        this.plaf_vals = new String[lafs.length];
        for (int i = 0; i < lafs.length; ++i) {
            this.plaf_names[i] = lafs[i].getName();
            this.plaf_vals[i] = lafs[i].getClassName();
            this.mdlLooksFeel.addElement(this.plaf_names[i]);
            if (!cLAF.equals(this.plaf_vals[i])) continue;
            this.mdlLooksFeel.setSelectedItem(this.plaf_names[i]);
        }
        cLAF = null;
        lafs = null;
        try {
            this.initUI();
            this.addChild(new BookmarkPropertyPage());
            this.addChild(new ConsolePropertyPage());
            this.addChild(new HistoryPropertyPage());
            this.addChild(new PrintPropertyPage());
        }
        catch (Throwable t) {
            BasicUtilities.HandleException(t, "PropertiesGeneral::init()");
        }
    }

    public String getPropertyPageName() {
        return BasicUtilities.getString("General_Property_Page");
    }

    public void actionPerformed(ActionEvent e) {
        this.cmbAutoService.setEnabled(this.chkAutoService.isSelected());
        this.setModified(true);
    }

    protected void applyChanges() {
        String selection = this.plaf_vals[this.cmbLooksFeel.getSelectedIndex()];
        prefs.put("general.plaf-class", selection);
    }

    protected void initUI() {
        this.setLayout(new GridBagLayout());
        this.chkUseLgIcon.setToolTipText(BasicUtilities.getString("Use_Large_Icons_Tip"));
        this.chkHideFiles.setToolTipText(BasicUtilities.getString("Show_Hidden_Files_Tip"));
        this.chkUseMetric.setToolTipText(BasicUtilities.getString("User_Metric_Tip"));
        this.chkAutoService.setToolTipText(BasicUtilities.getString("Enable_Def_Service_Tip"));
        this.cmbAutoService.setToolTipText(BasicUtilities.getString("Enable_Def_Service_Tip"));
        this.cmbLooksFeel.addActionListener(this);
        this.chkAutoService.addActionListener(this);
        this.chkAutoService.setSelected(prefs.containsKey("jdbc.auto-service"));
        this.cmbAutoService.setEnabled(this.chkAutoService.isSelected());
        this.setPropertyForComponent(this.cmbAutoService, "jdbc.auto-service");
        this.setPropertyForComponent(this.cmbMainTbLoc, "toolbar.file-dock");
        this.setPropertyForComponent(this.cmbCmdConLoc, "toolbar.history-dock");
        this.setPropertyForComponent(this.cmbResultLoc, "toolbar.resultset-dock");
        this.setPropertyForComponent(this.chkUseLgIcon, "general.large-icons");
        this.setPropertyForComponent(this.chkHideFiles, "general.hiddenfiles-enabled");
        this.setPropertyForComponent(this.chkUseMetric, "general.metrics-enabled");
        GeneralPropertyPage.constrain(1, 0, 2, 1, 0.0, 0.0, 17, 0);
        this.add(Box.createVerticalStrut(6), UI_CONSTRAINT);
        GeneralPropertyPage.constrain(0, 0, 1, 15, 0.0, 0.0, 10, 0);
        this.add(Box.createHorizontalStrut(12), UI_CONSTRAINT);
        GeneralPropertyPage.constrain(1, 1, 1, 1, 0.0, 0.0, 17, 0);
        this.add((Component)BasicUtilities.createLocalizedLabel("Choose_LAF", null), UI_CONSTRAINT);
        GeneralPropertyPage.constrain(1, 2, 1, 1, 0.0, 0.0, 17, 0);
        this.add((Component)BasicUtilities.createLocalizedLabel("Main_Toolbar", null), UI_CONSTRAINT);
        GeneralPropertyPage.constrain(1, 3, 1, 1, 0.0, 0.0, 17, 0);
        this.add((Component)BasicUtilities.createLocalizedLabel("Query_ToolBar", null), UI_CONSTRAINT);
        GeneralPropertyPage.constrain(1, 4, 1, 1, 0.0, 0.0, 17, 0);
        this.add((Component)BasicUtilities.createLocalizedLabel("Result_ToolBar", null), UI_CONSTRAINT);
        GeneralPropertyPage.constrain(1, 5, 1, 1, 0.0, 0.0, 17, 0);
        this.add((Component)this.chkAutoService, UI_CONSTRAINT);
        GeneralPropertyPage.constrain(2, 1, 1, 1, 0.0, 0.0, 17, 2);
        this.add((Component)this.cmbLooksFeel, UI_CONSTRAINT);
        GeneralPropertyPage.constrain(2, 2, 1, 1, 0.0, 0.0, 17, 2);
        this.add((Component)this.cmbMainTbLoc, UI_CONSTRAINT);
        GeneralPropertyPage.constrain(2, 3, 1, 1, 0.0, 0.0, 17, 2);
        this.add((Component)this.cmbCmdConLoc, UI_CONSTRAINT);
        GeneralPropertyPage.constrain(2, 4, 1, 1, 0.0, 0.0, 17, 2);
        this.add((Component)this.cmbResultLoc, UI_CONSTRAINT);
        GeneralPropertyPage.constrain(2, 5, 1, 1, 0.0, 0.0, 17, 2);
        this.add((Component)this.cmbAutoService, UI_CONSTRAINT);
        GeneralPropertyPage.constrain(1, 5, 2, 1, 0.0, 0.0, 10, 2);
        this.add(GeneralPropertyPage.createHorizSeperator(), UI_CONSTRAINT);
        GeneralPropertyPage.constrain(1, 5, 2, 1, 0.0, 0.0, 10, 2);
        this.add(Box.createVerticalStrut(32), UI_CONSTRAINT);
        GeneralPropertyPage.constrain(1, 9, 2, 1, 0.0, 0.0, 17, 0);
        this.add((Component)this.chkUseLgIcon, UI_CONSTRAINT);
        GeneralPropertyPage.constrain(1, 10, 2, 1, 0.0, 0.0, 17, 0);
        this.add((Component)this.chkUseMetric, UI_CONSTRAINT);
        GeneralPropertyPage.constrain(1, 11, 2, 1, 0.0, 0.0, 17, 0);
        this.add((Component)this.chkHideFiles, UI_CONSTRAINT);
        GeneralPropertyPage.constrain(3, 0, 1, 15, 1.0, 0.0, 10, 2);
        this.add(Box.createHorizontalGlue(), UI_CONSTRAINT);
        GeneralPropertyPage.constrain(1, 14, 2, 1, 0.0, 1.0, 10, 3);
        this.add(Box.createVerticalGlue(), UI_CONSTRAINT);
    }
}

