/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.Utilities;
import javax.swing.undo.UndoManager;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.core.model.EnhancedTableModel;
import org.isqlviewer.swing.JConsole;
import org.isqlviewer.swing.JTextPopup;
import org.isqlviewer.util.ExtensionFileFilter;
import org.isqlviewer.util.StringTokenizer;
import org.isqlviewer.util.StringUtilities;
import org.isqlviewer.util.UserPreferences;

public abstract class BasicUtilities {
    private static Toolkit tk = Toolkit.getDefaultToolkit();
    public static final DataFlavor bookmarkFlavour = new DataFlavor(class$org$isqlviewer$core$SQLBookmark == null ? (class$org$isqlviewer$core$SQLBookmark = BasicUtilities.class$("org.isqlviewer.core.SQLBookmark")) : class$org$isqlviewer$core$SQLBookmark, "SQL-Bookmark");
    public static final DataFlavor serviceFlavour = new DataFlavor(class$org$isqlviewer$core$ServiceDefinition == null ? (class$org$isqlviewer$core$ServiceDefinition = BasicUtilities.class$("org.isqlviewer.core.ServiceDefinition")) : class$org$isqlviewer$core$ServiceDefinition, "iSQL-Service");
    public static final DataFlavor BOOKMARK_PARAMETER_FLAVOR = new DataFlavor(class$org$isqlviewer$core$SQLBookmark$Parameter == null ? (class$org$isqlviewer$core$SQLBookmark$Parameter = BasicUtilities.class$("org.isqlviewer.core.SQLBookmark$Parameter")) : class$org$isqlviewer$core$SQLBookmark$Parameter, "isql.bookmark.parameter");
    public static final String WINDOW_MODIFIED = "windowModified";
    public static final int CMD_MASK = tk.getMenuShortcutKeyMask();
    public static final Color DND_HAZE = new Color(255, 255, 255, 112);
    private static ResourceBundle res = ResourceBundle.getBundle("org.isqlviewer.resource.ResourceStrings");
    private static final JTextPopup textPopup = new JTextPopup();
    private static ModifierKeyword[] modifierKeywords = new ModifierKeyword[]{new ModifierKeyword("shift", 1), new ModifierKeyword("control", 2), new ModifierKeyword("ctrl", 2), new ModifierKeyword("meta", CMD_MASK), new ModifierKeyword("alt", 8), new ModifierKeyword("button1", 16), new ModifierKeyword("button2", 8), new ModifierKeyword("button3", 4)};
    static /* synthetic */ Class class$org$isqlviewer$core$SQLBookmark;
    static /* synthetic */ Class class$org$isqlviewer$core$ServiceDefinition;
    static /* synthetic */ Class class$org$isqlviewer$core$SQLBookmark$Parameter;
    static /* synthetic */ Class class$org$isqlviewer$core$Launcher;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Void;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$awt$event$KeyEvent;

    public static void setLookAndFeel(String classname) {
        SystemConfig config = SystemConfig.getInstance();
        try {
            Class<?> c = Class.forName(classname, true, config.getRuntimeClassLoader());
            LookAndFeel laf = (LookAndFeel)c.newInstance();
            if (UIManager.getLookAndFeel() instanceof MetalLookAndFeel) {
                MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
            }
            UIManager.setLookAndFeel(laf);
        }
        catch (Throwable t) {
            BasicUtilities.HandleException(t, BasicUtilities.getString("LAF_Error", classname));
            try {
                classname = UIManager.getSystemLookAndFeelClassName();
                UIManager.setLookAndFeel(classname);
            }
            catch (Throwable t2) {
                BasicUtilities.HandleException(t2, BasicUtilities.getString("LAF_Error", classname));
                System.exit(-1);
            }
        }
    }

    public static KeyStroke getLocalKeyStroke(String str) {
        return BasicUtilities.getLocalKeyStroke(res, str);
    }

    public static String getString(String str, String params) {
        return BasicUtilities.getString(res, str, params);
    }

    public static String getString(String str, String[] params) {
        return BasicUtilities.getString(res, str, params);
    }

    public static String getString(String str) {
        return BasicUtilities.getString(res, str);
    }

    public static JLabel createLocalizedLabel(String txt, String[] params) {
        JLabel label = new JLabel();
        label.setText(BasicUtilities.getString(txt, params));
        return label;
    }

    public static boolean is1dot4Runtime() {
        return System.getProperty("java.specification.version", "").startsWith("1.4");
    }

    public static final URL getResourceURL(String item) {
        return (class$org$isqlviewer$core$Launcher == null ? (class$org$isqlviewer$core$Launcher = BasicUtilities.class$("org.isqlviewer.core.Launcher")) : class$org$isqlviewer$core$Launcher).getResource("/org/isqlviewer/resource/".concat(item));
    }

    public static final Icon loadToolbarIconResource(String img) {
        UserPreferences prefs = SystemConfig.getInstance().getPreferences();
        int size = prefs.getBoolean("general.large-icons") ? 24 : 16;
        return BasicUtilities.loadIconResource(img + size);
    }

    public static final Icon loadIconResource(String img) {
        try {
            return new ImageIcon(BasicUtilities.getResourceURL("icons/" + img + ".png"));
        }
        catch (Throwable t) {
            System.err.println(BasicUtilities.getString("Image_Load_Error", img));
            return UIManager.getIcon("InternalFrame.icon");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void optimizeTableView(JTable Table) {
        if (Table == null) {
            return;
        }
        if (!(Table.getParent() instanceof JViewport)) {
            return;
        }
        JViewport jvp = (JViewport)Table.getParent();
        TableModel ref = Table.getModel();
        Table.setAutoResizeMode(0);
        Table.setModel(ref);
        for (int i = 0; i < Table.getColumnCount(); ++i) {
            Table.getColumnModel().getColumn(i).sizeWidthToFit();
        }
        JTable jTable = Table;
        synchronized (jTable) {
            if (Table.getPreferredSize().getWidth() <= jvp.getPreferredSize().getWidth()) {
                Table.setAutoResizeMode(4);
            }
        }
    }

    public static void removeSelectedColumns(JTable table) {
        if (table != null) {
            EnhancedTableModel model = (EnhancedTableModel)table.getModel();
            int[] cols = table.getSelectedColumns();
            for (int i = cols.length - 1; i >= 0; --i) {
                model.removeColumn(cols[i]);
            }
            cols = null;
            model = null;
            BasicUtilities.optimizeTableView(table);
        }
    }

    public static File saveSystemFile(Component owner) {
        return BasicUtilities.saveSystemFile(owner, null);
    }

    public static File saveSystemFile(Component owner, FileFilter[] filters) {
        UserPreferences prefs = SystemConfig.getInstance().getPreferences();
        JFileChooser jfc = new JFileChooser(prefs.get("session.last-location"));
        jfc.setFileHidingEnabled(!prefs.getBoolean("general.hiddenfiles-enabled"));
        jfc.setAcceptAllFileFilterUsed(true);
        if (filters != null) {
            for (int i = 0; i < filters.length; ++i) {
                jfc.addChoosableFileFilter(filters[i]);
            }
            if (filters.length >= 1) {
                jfc.setFileFilter(filters[0]);
            }
        }
        int result = jfc.showSaveDialog(owner);
        prefs.put("session.last-location", jfc.getCurrentDirectory().getAbsolutePath());
        if (result == 0) {
            File selection = jfc.getSelectedFile();
            FileFilter filter = jfc.getFileFilter();
            if (filter != null && filter instanceof ExtensionFileFilter) {
                ExtensionFileFilter eff = (ExtensionFileFilter)filter;
                if (!filter.accept(selection)) {
                    selection = eff.applyExtension(selection);
                }
            }
            if (selection.exists()) {
                String title;
                String msg = BasicUtilities.getString("File_Overwrite_Message", selection.getName());
                int response = JOptionPane.showConfirmDialog(owner, msg, title = BasicUtilities.getString("Warning"), 0);
                if (response == 0) {
                    return selection;
                }
            } else {
                try {
                    if (selection.createNewFile()) {
                        return selection;
                    }
                }
                catch (IOException ioe) {
                    BasicUtilities.HandleException(ioe, "File::createNewFile()");
                }
            }
        }
        return null;
    }

    public static File getSystemFile(Component owner, int mode) {
        return BasicUtilities.getSystemFile(owner, mode, null);
    }

    public static File getSystemFile(Component owner, int mode, FileFilter[] filters) {
        UserPreferences prefs = SystemConfig.getInstance().getPreferences();
        JFileChooser jfc = new JFileChooser(prefs.get("session.last-location"));
        jfc.setFileSelectionMode(mode);
        jfc.setFileHidingEnabled(!prefs.getBoolean("general.hiddenfiles-enabled"));
        jfc.setAcceptAllFileFilterUsed(true);
        if (filters != null) {
            for (int i = 0; i < filters.length; ++i) {
                jfc.addChoosableFileFilter(filters[i]);
            }
            if (filters.length >= 1) {
                jfc.setFileFilter(filters[0]);
            }
        }
        int result = jfc.showOpenDialog(owner);
        prefs.put("session.last-location", jfc.getCurrentDirectory().getAbsolutePath());
        if (result == 0) {
            return jfc.getSelectedFile();
        }
        return null;
    }

    public static File[] saveSystemFiles(Component owner) {
        UserPreferences prefs = SystemConfig.getInstance().getPreferences();
        JFileChooser jfc = new JFileChooser(prefs.get("session.last-location"));
        jfc.setFileHidingEnabled(!prefs.getBoolean("general.hiddenfiles-enabled"));
        jfc.setMultiSelectionEnabled(true);
        int result = jfc.showSaveDialog(owner);
        prefs.put("session.last-location", jfc.getCurrentDirectory().getAbsolutePath());
        if (result == 0) {
            return jfc.getSelectedFiles();
        }
        return new File[0];
    }

    public static File[] getSystemFiles(Component owner, int mode) {
        return BasicUtilities.getSystemFiles(owner, mode, null);
    }

    public static File[] getSystemFiles(Component owner, int mode, FileFilter[] filters) {
        UserPreferences prefs = SystemConfig.getInstance().getPreferences();
        JFileChooser jfc = new JFileChooser(prefs.get("session.last-location"));
        jfc.setFileSelectionMode(mode);
        jfc.setFileHidingEnabled(!prefs.getBoolean("general.hiddenfiles-enabled"));
        jfc.setMultiSelectionEnabled(true);
        jfc.setAcceptAllFileFilterUsed(true);
        if (filters != null) {
            for (int i = 0; i < filters.length; ++i) {
                jfc.addChoosableFileFilter(filters[i]);
            }
            if (filters.length >= 1) {
                jfc.setFileFilter(filters[0]);
            }
        }
        int result = jfc.showOpenDialog(owner);
        prefs.put("session.last-location", jfc.getCurrentDirectory().getAbsolutePath());
        if (result == 0) {
            return jfc.getSelectedFiles();
        }
        return new File[0];
    }

    public static void removeSelectedRows(JTable table) {
        if (table != null) {
            try {
                EnhancedTableModel model = (EnhancedTableModel)table.getModel();
                int[] rows = table.getSelectedRows();
                for (int i = rows.length - 1; i >= 0; --i) {
                    model.removeRow(rows[i]);
                }
                rows = null;
                model = null;
            }
            catch (Throwable t) {
                BasicUtilities.beep();
            }
        }
    }

    public static void showExceptionPopup(Component owner, Throwable t, String Message) {
        ThrowableOptionPane msg = new ThrowableOptionPane(t, Message);
        JOptionPane.showMessageDialog(owner, msg, BasicUtilities.getString("Error"), 0);
    }

    public static KeyStroke createKeyStroke(int VK, int Mask) {
        return KeyStroke.getKeyStroke(VK, Mask, false);
    }

    public static void copySelectedCellsToClipBoard(JTable table) {
        if (table != null) {
            try {
                table.getCellEditor().cancelCellEditing();
            }
            catch (Throwable t) {
                // empty catch block
            }
            StringBuffer buff = new StringBuffer("");
            StringBuffer row = new StringBuffer("");
            for (int r = 0; r < table.getRowCount(); ++r) {
                for (int c = 0; c < table.getColumnCount(); ++c) {
                    if (!table.isCellSelected(r, c)) continue;
                    row.append(table.getValueAt(r, c) + "\t");
                }
                if (row.toString().trim().length() >= 1) {
                    buff.append(row);
                    buff.append(System.getProperty("line.seperator", "\n"));
                }
                row.setLength(0);
            }
            Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection ss = new StringSelection(buff.toString().trim());
            cb.setContents(ss, ss);
        }
    }

    public static void restoreSystemOut() {
        PrintStream out = new PrintStream(new FileOutputStream(FileDescriptor.out));
        System.setOut(out);
    }

    public static void restoreSystemErr() {
        PrintStream out = new PrintStream(new FileOutputStream(FileDescriptor.err));
        System.setErr(out);
    }

    public static String getString(ResourceBundle bundle, String str) {
        try {
            return bundle.getString(str);
        }
        catch (Throwable t) {
            System.out.println("** Warning ** Resource String [" + str + "] is not available.");
            return str;
        }
    }

    public static boolean isMac() {
        return System.getProperty("mrj.version") != null;
    }

    public static void beep() {
        tk.beep();
    }

    public static String createSafeFilename(String fqFilename) {
        fqFilename = fqFilename.replace(File.pathSeparatorChar, '_');
        fqFilename = fqFilename.replace(File.separatorChar, '_');
        fqFilename = fqFilename.replace('*', '_');
        fqFilename = fqFilename.replace(' ', '_');
        fqFilename = fqFilename.replace('(', '_');
        fqFilename = fqFilename.replace(')', '_');
        fqFilename = fqFilename.replace('\'', '_');
        fqFilename = fqFilename.replace('|', '_');
        fqFilename = fqFilename.replace('\"', '_');
        fqFilename = fqFilename.replace(';', '_');
        fqFilename = fqFilename.replace(':', '_');
        fqFilename = fqFilename.replace('>', '_');
        fqFilename = fqFilename.replace('<', '_');
        fqFilename = fqFilename.replace('[', '_');
        fqFilename = fqFilename.replace(']', '_');
        fqFilename = fqFilename.replace('&', '_');
        fqFilename = fqFilename.replace('#', '_');
        fqFilename = fqFilename.replace('@', '_');
        fqFilename = fqFilename.replace('$', '_');
        fqFilename = fqFilename.replace('%', '_');
        fqFilename = fqFilename.replace('^', '_');
        return fqFilename;
    }

    public static void lockComponentToPerferredSize(JComponent c) {
        Dimension prefSize = c.getPreferredSize();
        c.setPreferredSize(prefSize);
        c.setMaximumSize(prefSize);
        c.setMinimumSize(prefSize);
    }

    public static KeyStroke getLocalKeyStroke(ResourceBundle bundle, String str) {
        try {
            return BasicUtilities.getKeyStroke(bundle.getString(str));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getString(ResourceBundle bundle, String str, String params) {
        return BasicUtilities.getString(bundle, str, new String[]{params});
    }

    public static String getString(ResourceBundle bundle, String str, String[] params) {
        return MessageFormat.format(BasicUtilities.getString(bundle, str), params);
    }

    public static void HandleException(Throwable t) {
        BasicUtilities.HandleException(t, null, Boolean.getBoolean("isql.debug"));
    }

    public static void HandleException(Throwable t, String msg) {
        BasicUtilities.HandleException(t, msg, Boolean.getBoolean("isql.debug"));
    }

    public static void HandleException(Throwable t, String msg, boolean debug) {
        BasicUtilities.HandleException(t, msg, debug, System.err);
    }

    public static void HandleException(Throwable t, String msg, boolean debug, PrintStream err) {
        BasicUtilities.HandleException(t, msg, debug, new PrintWriter(err, true));
    }

    public static void HandleException(Throwable t, String msg, boolean debug, PrintWriter err) {
        if (err == null) {
            err = new PrintWriter(System.err, true);
        }
        if (msg != null) {
            err.println(msg);
        }
        if (t != null) {
            String n = t.getClass().getName();
            n = n.substring(n.lastIndexOf(46) + 1);
            String s = "Error";
            if (t instanceof Error) {
                s = "Error";
            } else {
                if (t instanceof SQLException) {
                    SystemConfig sysConfig = SystemConfig.getInstance();
                    UserPreferences prefs = sysConfig.getPreferences();
                    SQLException se = (SQLException)t;
                    String[] p = new String[]{se.getMessage() != null ? se.getMessage().trim() : "null", Integer.toString(se.getErrorCode()), se.getSQLState() == null ? "null" : se.getSQLState()};
                    err.println(BasicUtilities.getString("SQL_Exception", p));
                    int max = prefs.getInt("jdbc.max-warnings");
                    se = se.getNextException();
                    for (int i = 0; i < max && se != null; se = se.getNextException(), ++i) {
                        p = new String[]{Integer.toString(i), se.getMessage() != null ? se.getMessage().trim() : "null", Integer.toString(se.getErrorCode()), se.getSQLState() == null ? "null" : se.getSQLState()};
                        err.println(BasicUtilities.getString("Chained_SQL_Exception", p));
                    }
                    if (debug) {
                        t.printStackTrace(err);
                    }
                    p = null;
                    return;
                }
                if (t instanceof RuntimeException) {
                    s = "Runtime Exception";
                } else if (t instanceof Exception) {
                    s = "Exception";
                }
            }
            String fmt = "{0}::({1})";
            String lmsg = t.getLocalizedMessage();
            Object[] params = new String[]{s, lmsg == null ? t.getMessage() : lmsg};
            err.println(MessageFormat.format(fmt, params));
            if (debug) {
                t.printStackTrace(err);
            }
        }
    }

    public static int getCaretCol(int idx, JTextComponent comp) throws Exception {
        return Math.abs(Utilities.getRowStart(comp, idx) - idx);
    }

    public static int getCaretRow(int idx, JTextComponent comp) throws Exception {
        return BasicUtilities.getLineOfOffset(idx, comp.getDocument());
    }

    public static String getCurrentWord(Document doc, int offset) throws BadLocationException {
        String txt = doc.getText(0, doc.getLength());
        String delims = "\r\t\n ,=<>?{}[]|`~;&+-/*@%";
        int delta = Math.max(0, offset - 1);
        int count = txt.length();
        int min = 0;
        int lastIdx = -1;
        int fromIndex = delta;
        char[] v = txt.toCharArray();
        for (int i = min + (fromIndex >= count ? count - 1 : fromIndex); i >= min; --i) {
            if (delims.indexOf(v[i]) < 0) continue;
            lastIdx = i + 1;
            break;
        }
        int idx = Math.max(0, lastIdx);
        return txt.substring(idx, Math.min(offset, doc.getLength())).trim();
    }

    public static int getCurrentWordOffset(Document doc, int offset) throws BadLocationException {
        String txt = doc.getText(0, doc.getLength());
        String delims = "\r\t\n ,=<>?{}[]|`~;&+-/*@%";
        int delta = Math.max(0, offset - 1);
        int count = txt.length();
        int min = 0;
        int lastIdx = -1;
        int fromIndex = delta;
        char[] v = txt.toCharArray();
        for (int i = min + (fromIndex >= count ? count - 1 : fromIndex); i >= min; --i) {
            if (delims.indexOf(v[i]) < 0) continue;
            lastIdx = i + 1;
            break;
        }
        return Math.max(0, lastIdx);
    }

    public static void setPreferredGeometry(JFrame frame, Dimension frameSize, String id) {
        Dimension screenSize = tk.getScreenSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        Point p = new Point((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        Rectangle rect = new Rectangle(p, frameSize);
        UserPreferences prefs = SystemConfig.getInstance().getPreferences();
        Rectangle pref = prefs.getRect("session.".concat(id));
        if (pref.width * pref.height >= 1) {
            rect.setBounds(pref);
        }
        frame.setBounds(rect);
    }

    public static Class getClassForPrimative(Class c) {
        if (c.isPrimitive()) {
            if (c == Boolean.TYPE) {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = BasicUtilities.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
            if (c == Float.TYPE) {
                return class$java$lang$Float == null ? (class$java$lang$Float = BasicUtilities.class$("java.lang.Float")) : class$java$lang$Float;
            }
            if (c == Integer.TYPE) {
                return class$java$lang$Integer == null ? (class$java$lang$Integer = BasicUtilities.class$("java.lang.Integer")) : class$java$lang$Integer;
            }
            if (c == Short.TYPE) {
                return class$java$lang$Short == null ? (class$java$lang$Short = BasicUtilities.class$("java.lang.Short")) : class$java$lang$Short;
            }
            if (c == Long.TYPE) {
                return class$java$lang$Long == null ? (class$java$lang$Long = BasicUtilities.class$("java.lang.Long")) : class$java$lang$Long;
            }
            if (c == Double.TYPE) {
                return class$java$lang$Double == null ? (class$java$lang$Double = BasicUtilities.class$("java.lang.Double")) : class$java$lang$Double;
            }
            if (c == Character.TYPE) {
                return class$java$lang$Character == null ? (class$java$lang$Character = BasicUtilities.class$("java.lang.Character")) : class$java$lang$Character;
            }
            if (c == Byte.TYPE) {
                return class$java$lang$Byte == null ? (class$java$lang$Byte = BasicUtilities.class$("java.lang.Byte")) : class$java$lang$Byte;
            }
            if (c == Void.TYPE) {
                return class$java$lang$Void == null ? (class$java$lang$Void = BasicUtilities.class$("java.lang.Void")) : class$java$lang$Void;
            }
        } else if (c == (class$java$lang$String == null ? (class$java$lang$String = BasicUtilities.class$("java.lang.String")) : class$java$lang$String)) {
            return class$java$lang$String == null ? (class$java$lang$String = BasicUtilities.class$("java.lang.String")) : class$java$lang$String;
        }
        return null;
    }

    protected static int getLineOfOffset(int offset, Document doc) throws BadLocationException {
        if (offset < 0 || doc == null) {
            throw new BadLocationException("", -1);
        }
        if (offset > doc.getLength()) {
            throw new BadLocationException("", doc.getLength() + 1);
        }
        Element map = doc.getDefaultRootElement();
        return map.getElementIndex(offset);
    }

    protected static KeyStroke getKeyStroke(String s) {
        String token;
        if (s == null || s.length() == 0) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(s);
        int mask = 0;
        boolean released = false;
        boolean typed = false;
        while ((token = st.nextToken()) != null) {
            int keycode;
            int tokenMask = 0;
            for (int i = 0; tokenMask == 0 && i < modifierKeywords.length; ++i) {
                tokenMask = modifierKeywords[i].getModifierMask(token);
            }
            if (tokenMask != 0) {
                mask |= tokenMask;
                continue;
            }
            if (token.equals("released")) {
                released = true;
                continue;
            }
            if (token.equals("pressed")) continue;
            if (token.equals("typed")) {
                typed = true;
                continue;
            }
            if (typed) {
                if (token.length() != 1) {
                    return null;
                }
                return KeyStroke.getKeyStroke(token.charAt(0));
            }
            String keycodeName = "VK_" + token;
            try {
                keycode = (class$java$awt$event$KeyEvent == null ? (class$java$awt$event$KeyEvent = BasicUtilities.class$("java.awt.event.KeyEvent")) : class$java$awt$event$KeyEvent).getField(keycodeName).getInt(class$java$awt$event$KeyEvent == null ? (class$java$awt$event$KeyEvent = BasicUtilities.class$("java.awt.event.KeyEvent")) : class$java$awt$event$KeyEvent);
            }
            catch (Throwable t) {
                return null;
            }
            return KeyStroke.getKeyStroke(keycode, mask, released);
        }
        return null;
    }

    public static void unlocalizeTextComponent(JTextComponent txt, UndoManager mgr) {
        textPopup.removeJTextComponent(txt);
        if (mgr != null) {
            Keymap map = txt.getKeymap();
            map.removeKeyStrokeBinding(BasicUtilities.createKeyStroke(90, CMD_MASK));
            map.removeKeyStrokeBinding(BasicUtilities.createKeyStroke(89, CMD_MASK));
        }
    }

    public static void localizeTextComponent(JTextComponent txt, UndoManager mgr) {
        ActionMap am = txt.getActionMap();
        Keymap map = txt.getKeymap();
        Action a = null;
        a = am.get("cut-to-clipboard");
        map.addActionForKeyStroke(BasicUtilities.createKeyStroke(88, CMD_MASK), a);
        a = am.get("copy-to-clipboard");
        map.addActionForKeyStroke(BasicUtilities.createKeyStroke(67, CMD_MASK), a);
        a = am.get("paste-from-clipboard");
        map.addActionForKeyStroke(BasicUtilities.createKeyStroke(86, CMD_MASK), a);
        a = am.get("select-all");
        map.addActionForKeyStroke(BasicUtilities.createKeyStroke(65, CMD_MASK), a);
        textPopup.addJTextComponent(txt, true);
        if (mgr != null) {
            a = new UndoTextAction(mgr);
            map.addActionForKeyStroke(BasicUtilities.createKeyStroke(90, CMD_MASK), a);
            a = new RedoTextAction(mgr);
            map.addActionForKeyStroke(BasicUtilities.createKeyStroke(89, CMD_MASK), a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        InputStream inputStream = in;
        synchronized (inputStream) {
            OutputStream outputStream = out;
            synchronized (outputStream) {
                int bytesRead;
                byte[] buffer = new byte[256];
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyReader(Reader in, Writer out) throws IOException {
        Reader reader = in;
        synchronized (reader) {
            Writer writer = out;
            synchronized (writer) {
                int charsRead;
                char[] buffer = new char[256];
                while ((charsRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, charsRead);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class RedoTextAction
    extends AbstractAction {
        private UndoManager um = null;

        public RedoTextAction(UndoManager mgr) {
            this.um = mgr;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                this.um.redo();
            }
            catch (Throwable t) {
                BasicUtilities.beep();
            }
        }
    }

    public static class UndoTextAction
    extends AbstractAction {
        private UndoManager um = null;

        public UndoTextAction(UndoManager mgr) {
            this.um = mgr;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                this.um.undo();
            }
            catch (Throwable t) {
                BasicUtilities.beep();
            }
        }
    }

    private static class ModifierKeyword {
        final String keyword;
        final int mask;

        ModifierKeyword(String keyword, int mask) {
            this.keyword = keyword;
            this.mask = mask;
        }

        int getModifierMask(String s) {
            return s.equals(this.keyword) ? this.mask : 0;
        }
    }

    private static class ThrowableOptionPane
    extends JPanel
    implements ActionListener {
        private JToggleButton tog = new JToggleButton(BasicUtilities.loadIconResource("StepForward24"));
        private JConsole txt = new JConsole("");

        public ThrowableOptionPane(Throwable t, String message) {
            super(new BorderLayout());
            this.txt.setVisible(false);
            this.tog.setText(BasicUtilities.getString("Error_Details"));
            this.tog.setSelectedIcon(BasicUtilities.loadIconResource("Down24"));
            this.tog.setHorizontalTextPosition(2);
            this.tog.addActionListener(this);
            this.txt.configure(SystemConfig.getInstance().getPreferences());
            PrintStream ps = new PrintStream(this.txt.toOutputStream(), true);
            this.txt.setPreferredSize(new Dimension(400, 300));
            BasicUtilities.HandleException(t, message, true, ps);
            this.add((Component)this.tog, "North");
            message = "<html>".concat(StringUtilities.formatBreak(80, message, " ", true));
            this.add((Component)new JLabel(message), "South");
        }

        public void actionPerformed(ActionEvent e) {
            this.txt.setVisible(!this.txt.isVisible());
            Window win = SwingUtilities.getWindowAncestor(this);
            if (!this.txt.isVisible()) {
                this.remove(this.txt);
            } else {
                this.add((Component)this.txt, "Center");
            }
            this.validateTree();
            win.pack();
        }
    }
}

