/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.util;

import java.util.NoSuchElementException;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringTokenizer;

public class SQLTokenizer
extends StringTokenizer {
    private static final String DEFAULTS = "\t\r\n ";
    private static final String OPS = "'\"+-*/=<>!()%@,.;";
    private String marker = null;

    public SQLTokenizer(String sql) {
        super(sql, DEFAULTS, false, false);
        this.setQuotesEnabled(true);
    }

    protected String nextForwardToken() {
        String token;
        int start;
        block14: {
            this.skipForwardDelimiters();
            if (this.currentPosition >= this.maxPosition) {
                throw new NoSuchElementException();
            }
            start = this.currentPosition;
            this.lastQuoteIdx = -1;
            while (this.currentPosition < this.maxPosition && !this.isDelimiterAtIndex(this.currentPosition)) {
                ++this.currentPosition;
            }
            token = null;
            try {
                boolean isOp;
                char c = this.str.charAt(start);
                boolean isDelim = this.delimiters.indexOf(c) >= 0;
                boolean bl = isOp = OPS.indexOf(c) >= 0;
                if (start == this.currentPosition && !isDelim) {
                    token = this.checkOps(start);
                    if (token == null) {
                        if (isOp) {
                            ++this.currentPosition;
                        }
                        return Character.toString(c);
                    }
                    if (this.retTokens) {
                        ++this.currentPosition;
                        return Character.toString(c);
                    }
                    break block14;
                }
                if (this.currentPosition >= this.maxPosition) {
                    token = this.str.substring(start);
                    break block14;
                }
                if (!isDelim) {
                    token = this.str.substring(start, this.currentPosition);
                    break block14;
                }
                ++this.currentPosition;
                return "";
            }
            catch (RuntimeException e) {
                BasicUtilities.HandleException(e);
                return null;
            }
        }
        if (token.startsWith("--") && this.marker == null) {
            if (this.hasMoreForwardTokens()) {
                this.marker = "--";
                token = token.concat(this.nextToken("\r\n"));
                this.delimiters = DEFAULTS;
                this.marker = null;
            }
            this.tokenIndex = start;
            return token;
        }
        if (token.startsWith("/*") && this.marker == null) {
            token = token.concat(Character.toString(this.getLastDelimiter()));
            int cindex = this.str.indexOf("*/", this.currentPosition);
            if (cindex >= 0) {
                this.tokenIndex = start;
                this.currentPosition = cindex + 2;
                return this.str.substring(this.tokenIndex, this.currentPosition);
            }
            this.tokenIndex = start;
            this.currentPosition = this.str.length() - 1;
            return this.str.substring(this.tokenIndex, this.currentPosition);
        }
        return token;
    }

    public synchronized void reset() {
        super.reset();
        this.delimiters = DEFAULTS;
        this.marker = null;
    }

    protected boolean isDelimiterAtIndex(int index) {
        if (index >= 0 && index < this.str.length()) {
            boolean isOp;
            boolean isQuote = this.isQuoteIdentiferAtIndex(index);
            boolean isDelim = this.delimiters.indexOf(this.str.charAt(index)) >= 0;
            boolean bl = isOp = OPS.indexOf(this.str.charAt(index)) >= 0;
            if (isQuote) {
                return false;
            }
            if (this.marker != null) {
                isOp = false;
            }
            return isDelim || isOp;
        }
        return false;
    }

    protected char peek(int index) {
        try {
            return this.str.charAt(index + 1);
        }
        catch (Throwable t) {
            return '\u0000';
        }
    }

    protected String checkOps(int index) {
        char c = this.str.charAt(index);
        char n = this.peek(index);
        if (OPS.indexOf(c) >= 0) {
            switch (c) {
                case '@': {
                    if (n != '@') break;
                    this.currentPosition += 2;
                    return "@@";
                }
                case '<': {
                    switch (n) {
                        case '=': 
                        case '>': {
                            this.currentPosition += 2;
                            return Character.toString(c).concat(Character.toString(n));
                        }
                    }
                    break;
                }
                case '>': {
                    if (n != '=') break;
                    this.currentPosition += 2;
                    return ">=";
                }
                case '!': {
                    if (n == '=') {
                        this.currentPosition += 2;
                        return "!=";
                    }
                }
                case '/': {
                    if (n != '*') break;
                    this.currentPosition += 2;
                    return "/*";
                }
                case '*': {
                    if (n != '/') break;
                    this.currentPosition += 2;
                    return "*/";
                }
                case '-': {
                    if (n != c) break;
                    this.currentPosition += 2;
                    return "--";
                }
            }
            ++this.currentPosition;
            return Character.toString(c);
        }
        return null;
    }
}

