/*
 * Decompiled with CFR 0.152.
 */
package demo.pkcs.pkcs11;

import demo.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.Module;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.TokenInfo;
import iaik.pkcs.pkcs11.objects.DES3SecretKey;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.parameters.DesCbcEncryptDataParameters;
import iaik.pkcs.pkcs11.parameters.Parameters;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;

public class DeriveKeyDemo {
    static BufferedReader input_;
    static PrintWriter output_;

    static {
        try {
            output_ = new PrintWriter(System.out, true);
            input_ = new BufferedReader(new InputStreamReader(System.in));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            output_ = new PrintWriter(System.out, true);
            input_ = new BufferedReader(new InputStreamReader(System.in));
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            DeriveKeyDemo.printUsage();
            System.exit(1);
        }
        try {
            DES3SecretKey dES3SecretKey;
            Module module = Module.getInstance((String)stringArray[0]);
            module.initialize(null);
            Token token = Util.selectToken(module, output_, input_);
            TokenInfo tokenInfo = token.getTokenInfo();
            output_.println("################################################################################");
            output_.println("Using token:");
            output_.println(tokenInfo);
            output_.println("################################################################################");
            Session session = Util.openAuthorizedSession(token, false, output_, input_);
            Mechanism mechanism = (Mechanism)Mechanism.DES3_KEY_GEN.clone();
            DES3SecretKey dES3SecretKey2 = new DES3SecretKey();
            dES3SecretKey2.getDerive().setBooleanValue(Boolean.TRUE);
            dES3SecretKey2.getToken().setBooleanValue(Boolean.FALSE);
            dES3SecretKey2.getSensitive().setBooleanValue(Boolean.FALSE);
            dES3SecretKey2.getExtractable().setBooleanValue(Boolean.TRUE);
            SecretKey secretKey = (SecretKey)session.generateKey(mechanism, (iaik.pkcs.pkcs11.objects.Object)dES3SecretKey2);
            System.out.println("Base key: ");
            System.out.println(secretKey.toString());
            output_.println("################################################################################");
            output_.println("derive key");
            DES3SecretKey dES3SecretKey3 = dES3SecretKey = new DES3SecretKey();
            dES3SecretKey3.getSensitive().setBooleanValue(Boolean.FALSE);
            dES3SecretKey3.getExtractable().setBooleanValue(Boolean.TRUE);
            byte[] byArray = new byte[8];
            byte[] byArray2 = new byte[24];
            DesCbcEncryptDataParameters desCbcEncryptDataParameters = new DesCbcEncryptDataParameters(byArray, byArray2);
            Mechanism mechanism2 = Mechanism.DES3_CBC_ENCRYPT_DATA;
            mechanism2.setParameters((Parameters)desCbcEncryptDataParameters);
            System.out.println("Derivation Mechanism: ");
            output_.println(mechanism2.toString());
            output_.println("--------------------------------------------------------------------------------");
            Key key = session.deriveKey(mechanism2, (Key)secretKey, (Key)dES3SecretKey3);
            if (key == null) {
                output_.println("Found NO key that can be used for encryption.");
                output_.flush();
                System.exit(0);
            }
            System.out.println("Derived key: ");
            output_.println(key.toString());
            output_.println("################################################################################");
            output_.println("finished");
            session.closeSession();
            module.finalize(null);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void printUsage() {
        output_.println("Usage: TestDeriveParams <PKCS#11 module>");
        output_.println(" e.g.: TestDeriveParams cryptoki.dll");
        output_.println("The given DLL must be in the search path of the system.");
    }
}

