/*
 * Decompiled with CFR 0.152.
 */
package demo.pkcs.pkcs11;

import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs7.EnvelopedDataStream;
import iaik.pkcs.pkcs7.RecipientInfo;
import iaik.security.provider.IAIK;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;

public class EncryptPKCS7EnvelopedData {
    public static void main(String[] stringArray) {
        if (stringArray.length != 3) {
            EncryptPKCS7EnvelopedData.printUsage();
            System.exit(1);
        }
        try {
            Security.addProvider((Provider)new IAIK());
            System.out.println("Encrypting data from file: " + stringArray[0]);
            FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
            EnvelopedDataStream envelopedDataStream = new EnvelopedDataStream((InputStream)fileInputStream, AlgorithmID.des_EDE3_CBC);
            System.out.println("using recipient certificate from: " + stringArray[1]);
            FileInputStream fileInputStream2 = new FileInputStream(stringArray[1]);
            iaik.x509.X509Certificate x509Certificate = new iaik.x509.X509Certificate((InputStream)fileInputStream2);
            System.out.println("which is: ");
            System.out.println(x509Certificate.toString(true));
            RecipientInfo recipientInfo = new RecipientInfo((X509Certificate)x509Certificate, AlgorithmID.rsaEncryption);
            envelopedDataStream.setRecipientInfos(new RecipientInfo[]{recipientInfo});
            System.out.println("writing enveloped data to: " + stringArray[2]);
            FileOutputStream fileOutputStream = new FileOutputStream(stringArray[2]);
            envelopedDataStream.writeTo((OutputStream)fileOutputStream);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void printUsage() {
        System.out.println("Usage: EncryptPKCS7EnvelopedData <data to encrypt file> <recipient certificate> <PKCS#7 enveloped data file>");
        System.out.println(" e.g.: EncryptPKCS7EnvelopedData contentData.dat recipientCertificte.der envelopedData.p7");
    }
}

