/*
 * Decompiled with CFR 0.152.
 */
package demo.pkcs.pkcs11;

import iaik.pkcs.pkcs11.Module;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.Slot;
import iaik.pkcs.pkcs11.Token;
import java.io.FileOutputStream;

public class GenerateRandom {
    public static void main(String[] stringArray) {
        if (stringArray.length != 2 && stringArray.length != 3) {
            GenerateRandom.printUsage();
            System.exit(1);
        }
        int n = -1;
        try {
            n = Integer.parseInt(stringArray[1]);
        }
        catch (Exception exception) {
            GenerateRandom.printUsage();
            System.exit(1);
        }
        try {
            Module module = Module.getInstance((String)stringArray[0]);
            module.initialize(null);
            Slot[] slotArray = module.getSlotList(true);
            if (slotArray.length == 0) {
                System.out.println("No slot with present token found!");
                System.exit(0);
            }
            Slot slot = slotArray[0];
            Token token = slot.getToken();
            Session session = token.openSession(true, false, null, null);
            System.out.println("################################################################################");
            System.out.print("generating " + n + " bytes of random data... ");
            byte[] byArray = session.generateRandom(n);
            System.out.println("finished");
            System.out.println("################################################################################");
            if (stringArray.length == 3) {
                System.out.println("################################################################################");
                System.out.println("writing random data to file : " + stringArray[2]);
                FileOutputStream fileOutputStream = new FileOutputStream(stringArray[2]);
                fileOutputStream.write(byArray);
                fileOutputStream.flush();
                fileOutputStream.close();
                System.out.println("################################################################################");
            }
            session.closeSession();
            module.finalize(null);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void printUsage() {
        System.out.println("Usage: GenerateRandom <PKCS#11 module> <number of bytes> [<output file>]");
        System.out.println(" e.g.: GenerateRandom pk2priv.dll 128 random.dat");
        System.out.println("The given DLL must be in the search path of the system.");
    }
}

