/*
 * Decompiled with CFR 0.152.
 */
package demo.pkcs.pkcs11;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.Module;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.Slot;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.RSAPrivateKey;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.math.BigInteger;

public class HashAndSign {
    static PrintWriter output_;

    static {
        try {
            output_ = new PrintWriter(System.out, true);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            output_ = new PrintWriter(System.out, true);
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 3 && stringArray.length != 4) {
            HashAndSign.printUsage();
            System.exit(1);
        }
        try {
            try {
                int n;
                Module module = Module.getInstance((String)stringArray[0]);
                module.initialize(null);
                Slot[] slotArray = module.getSlotList(true);
                if (slotArray.length == 0) {
                    output_.println("No slot with present token found!");
                    System.exit(0);
                }
                Slot slot = slotArray[0];
                Token token = slot.getToken();
                Session session = token.openSession(true, false, null, null);
                session.login(true, stringArray[1].toCharArray());
                output_.println("################################################################################");
                output_.println("find private signature key");
                RSAPrivateKey rSAPrivateKey = new RSAPrivateKey();
                rSAPrivateKey.getSign().setBooleanValue(Boolean.TRUE);
                session.findObjectsInit((iaik.pkcs.pkcs11.objects.Object)rSAPrivateKey);
                iaik.pkcs.pkcs11.objects.Object[] objectArray = session.findObjects(1);
                RSAPrivateKey rSAPrivateKey2 = null;
                if (objectArray.length > 0) {
                    rSAPrivateKey2 = (RSAPrivateKey)objectArray[0];
                    output_.println("________________________________________________________________________________");
                    output_.println(rSAPrivateKey2);
                    output_.println("________________________________________________________________________________");
                } else {
                    output_.println("No RSA private key found that can sign!");
                    System.exit(0);
                }
                session.findObjectsFinal();
                output_.println("################################################################################");
                output_.println("################################################################################");
                output_.println("signing data from file: " + stringArray[2]);
                FileInputStream fileInputStream = new FileInputStream(stringArray[2]);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(128);
                Mechanism mechanism = Mechanism.SHA1_RSA_PKCS;
                session.signInit(mechanism, (Key)rSAPrivateKey2);
                byte[] byArray = new byte[1024];
                while ((n = ((InputStream)fileInputStream).read(byArray)) >= 0) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                byte[] byArray2 = byteArrayOutputStream.toByteArray();
                byte[] byArray3 = session.sign(byArray2);
                output_.println("The siganture value is: " + new BigInteger(1, byArray3).toString(16));
                if (stringArray.length == 4) {
                    output_.println("Writing signature to file: " + stringArray[3]);
                    FileOutputStream fileOutputStream = new FileOutputStream(stringArray[3]);
                    ((OutputStream)fileOutputStream).write(byArray3);
                    fileOutputStream.flush();
                    ((OutputStream)fileOutputStream).close();
                }
                output_.println("################################################################################");
                session.closeSession();
                module.finalize(null);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            Object var2_18 = null;
            output_.close();
        }
        catch (Throwable throwable) {
            Object var2_19 = null;
            output_.close();
            throw throwable;
        }
    }

    public static void printUsage() {
        output_.println("Usage: HashAndSign <PKCS#11 module> <userPIN> <file to be signed> [<signature value file>]");
        output_.println(" e.g.: HashAndSign pk2priv.dll password data.dat signature.bin");
        output_.println("The given DLL must be in the search path of the system.");
    }
}

