/*
 * Decompiled with CFR 0.152.
 */
package demo.pkcs.pkcs11;

import iaik.pkcs.pkcs11.Module;
import iaik.pkcs.pkcs11.Slot;
import iaik.pkcs.pkcs11.Token;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;

public class InitPIN {
    static PrintWriter output_;
    static BufferedReader input_;

    static {
        try {
            output_ = new PrintWriter(System.out, true);
            input_ = new BufferedReader(new InputStreamReader(System.in));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            output_ = new PrintWriter(System.out, true);
            input_ = new BufferedReader(new InputStreamReader(System.in));
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 3) {
            InitPIN.printUsage();
            System.exit(1);
        }
        try {
            String string;
            Slot slot;
            Module module = Module.getInstance((String)stringArray[0]);
            module.initialize(null);
            Slot[] slotArray = module.getSlotList(true);
            if (slotArray.length == 0) {
                output_.println("No slot with present token found!");
                System.exit(0);
            }
            Token token = null;
            if (slotArray.length == 1) {
                slot = slotArray[0];
                token = slot.getToken();
            } else {
                output_.println("Found several tokens: ");
                int n = 0;
                while (n < slotArray.length) {
                    token = slotArray[n].getToken();
                    output_.println("________________________________________________________________________________");
                    output_.print("Info of Token number ");
                    output_.println(n);
                    output_.println(token.getTokenInfo());
                    output_.println("________________________________________________________________________________");
                    ++n;
                }
                output_.println();
                output_.print("For which token do you want to set the PIN? Please enter its number [0..");
                output_.print(slotArray.length);
                output_.print("]: ");
                output_.flush();
                string = input_.readLine();
                int n2 = Integer.parseInt(string);
                token = slotArray[n2].getToken();
            }
            slot = token.getTokenInfo();
            output_.println("################################################################################");
            output_.println("Information of selsected Token:");
            output_.println(slot);
            output_.println("################################################################################");
            output_.println("################################################################################");
            output_.print("initializing user-PIN... ");
            string = token.openSession(true, true, null, null);
            string.login(false, stringArray[1].toCharArray());
            string.initPIN(stringArray[2].toCharArray());
            output_.println("FINISHED");
            output_.println("################################################################################");
            module.finalize(null);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void printUsage() {
        output_.println("Usage: InitPIN <PKCS#11 module> <SO-PIN> <user-PIN>");
        output_.println(" e.g.: InitPIN pk2priv.dll 12345678 1234");
        output_.println("The given DLL must be in the search path of the system.");
    }
}

