/*
 * Decompiled with CFR 0.152.
 */
package demo.pkcs.pkcs11;

import demo.pkcs.pkcs11.TokenPrivateKey;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs7.DigestInfo;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;

public class PKCS11SignatureEngine
extends Signature {
    protected Session session_;
    protected Mechanism signatureMechanism_;
    protected Key signatureKey_;
    protected AlgorithmID hashAlgorithm_;
    protected MessageDigest digestEngine_;

    public PKCS11SignatureEngine(String string, Session session, Mechanism mechanism, AlgorithmID algorithmID) throws NoSuchAlgorithmException {
        super(string);
        this.session_ = session;
        this.signatureMechanism_ = mechanism;
        this.hashAlgorithm_ = algorithmID;
        this.digestEngine_ = this.hashAlgorithm_.getMessageDigestInstance();
    }

    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new UnsupportedOperationException();
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof TokenPrivateKey)) {
            throw new InvalidKeyException("Private key must be of instance InvalidKeyException");
        }
        this.signatureKey_ = ((TokenPrivateKey)privateKey).getTokenPrivateKey();
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        throw new UnsupportedOperationException();
    }

    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new UnsupportedOperationException();
    }

    protected byte[] engineSign() throws SignatureException {
        byte[] byArray = this.digestEngine_.digest();
        DigestInfo digestInfo = new DigestInfo(AlgorithmID.sha1, byArray);
        byte[] byArray2 = digestInfo.toByteArray();
        byte[] byArray3 = null;
        try {
            this.session_.signInit(this.signatureMechanism_, this.signatureKey_);
            byArray3 = this.session_.sign(byArray2);
        }
        catch (TokenException tokenException) {
            throw new SignatureException(tokenException.toString());
        }
        return byArray3;
    }

    protected void engineUpdate(byte by) throws SignatureException {
        this.digestEngine_.update(by);
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        this.digestEngine_.update(byArray, n, n2);
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        throw new UnsupportedOperationException();
    }
}

